#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.4cvs on Mon Feb  6 00:01:16 2006

import wx

class Pref_Connection_Base(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: Pref_Connection_Base.__init__
        kwds["style"] = wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.OOo_Settings = wx.Panel(self, -1)
        self.sizer_3_staticbox = wx.StaticBox(self.OOo_Settings, -1, _("OpenOffice.org connection settings"))
        self.label_1 = wx.StaticText(self, -1, _("Word Processor"))
        self.choiceWP = wx.Choice(self, -1, choices=[_("None"), _("OpenOffice.org"), _("MS Word")])
        self.radio_btn_Pipe = wx.RadioButton(self.OOo_Settings, -1, _("Use a pipe"), style=wx.RB_GROUP)
        self.label_2 = wx.StaticText(self.OOo_Settings, -1, _("Pipe name"))
        self.Pipe_name = wx.TextCtrl(self.OOo_Settings, -1, _("OOo_pipe"))
        self.radio_btn_TCP = wx.RadioButton(self.OOo_Settings, -1, _("Use TCP/IP"))
        self.label_3 = wx.StaticText(self.OOo_Settings, -1, _("Port"))
        self.Port_value = wx.SpinCtrl(self.OOo_Settings, -1, "8100", min=1, max=50000)
        self.label_4 = wx.StaticText(self.OOo_Settings, -1, _("Host"), style=wx.ALIGN_RIGHT)
        self.Host_name = wx.TextCtrl(self.OOo_Settings, -1, _("localhost"))

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_CHOICE, self.onWPchoice, self.choiceWP)
        self.Bind(wx.EVT_RADIOBUTTON, self.onRadioPipe, self.radio_btn_Pipe)
        self.Bind(wx.EVT_RADIOBUTTON, self.onRadioTCP, self.radio_btn_TCP)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: Pref_Connection_Base.__set_properties
        self.choiceWP.SetSelection(0)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: Pref_Connection_Base.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_3 = wx.StaticBoxSizer(self.sizer_3_staticbox, wx.HORIZONTAL)
        grid_sizer_1 = wx.FlexGridSizer(3, 3, 3, 3)
        sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_2.Add(self.label_1, 0, wx.LEFT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_2.Add(self.choiceWP, 0, wx.LEFT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 10)
        sizer_1.Add(sizer_2, 0, wx.BOTTOM|wx.EXPAND, 10)
        grid_sizer_1.Add(self.radio_btn_Pipe, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 20)
        grid_sizer_1.Add(self.label_2, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.Pipe_name, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.radio_btn_TCP, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.label_3, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.Port_value, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add((1, 1), 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.label_4, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.Host_name, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.AddGrowableCol(2)
        sizer_3.Add(grid_sizer_1, 1, wx.EXPAND, 0)
        self.OOo_Settings.SetAutoLayout(True)
        self.OOo_Settings.SetSizer(sizer_3)
        sizer_3.Fit(self.OOo_Settings)
        sizer_3.SetSizeHints(self.OOo_Settings)
        sizer_1.Add(self.OOo_Settings, 1, wx.EXPAND, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        sizer_1.SetSizeHints(self)
        # end wxGlade

    def onWPchoice(self, event): # wxGlade: Pref_Connection_Base.<event_handler>
        print "Event handler `onWPchoice' not implemented!"
        event.Skip()

    def onRadioPipe(self, event): # wxGlade: Pref_Connection_Base.<event_handler>
        print "Event handler `onRadioPipe' not implemented!"
        event.Skip()

    def onRadioTCP(self, event): # wxGlade: Pref_Connection_Base.<event_handler>
        print "Event handler `onRadioTCP' not implemented!"
        event.Skip()

# end of class Pref_Connection_Base


class Pref_Connection(Pref_Connection_Base):
	def __init__(self, parent , id, (wp_type,oo_con_type,oo_pipe,oo_host,oo_port)):
		Pref_Connection_Base.__init__(self, parent , id)
		# setting values according to current settings
		if wp_type == 'OOo':
			self.choiceWP.SetSelection(1)
		elif wp_type == 'mswDoc':
			self.choiceWP.SetSelection(2)
			self.OOo_Settings.Enable(False)
		else:
			self.choiceWP.SetSelection(0)	# None
			self.OOo_Settings.Enable(False)
		#
		self.radio_btn_Pipe.SetValue(oo_con_type)
		self.radio_btn_TCP.SetValue(not oo_con_type)
		self.Pipe_name.SetValue(oo_pipe)
		self.Port_value.SetValue(oo_port)
		self.Host_name.SetValue(oo_host)

	def onWPchoice(self, event): # wxGlade: Pref_Connection.<event_handler>
		"""Activate/inactivate OOo settings panel"""
		self.OOo_Settings.Enable( event.GetString() == "OpenOffice.org" )

	def onRadioPipe(self, event): # wxGlade: Pref_Connection.<event_handler>
		self.Pipe_name.Enable()
		self.Port_value.Enable(False)
		self.Host_name.Enable(False)

	def onRadioTCP(self, event): # wxGlade: Pref_Connection.<event_handler>
		self.Pipe_name.Enable(False)
		self.Port_value.Enable()
		self.Host_name.Enable()
		
	def getSettings(self):
		if self.choiceWP.GetSelection() == 1:
			wp_type = 'OOo'
		elif self.choiceWP.GetSelection() == 2:
			wp_type = 'mswDoc'
		else:
			wp_type =''
		oo_con_type = int(self.radio_btn_Pipe.GetValue())
		oo_pipe = self.Pipe_name.GetValue()
		oo_port = self.Port_value.GetValue()
		oo_host = self.Host_name.GetValue()
		return wp_type,oo_con_type,oo_pipe,oo_host,oo_port

# end of class Pref_Connection


