#include <glib.h>
#include <gio/gio.h>

#include <bognor-regis/br-queue.h>

GMainLoop *mainloop;

static void
list_uris_cb (BrQueue *queue,
              char   **uris,
              GError  *error,
              gpointer userdata)
{
    int i;

    if (error != NULL) {
        g_warning ("Error listing uris: %s", error->message);
        g_error_free (error);
    }

    if (uris == NULL || uris[0] == NULL) {
        g_print ("No tracks queued\n");
        g_main_loop_quit (mainloop);

        return;
    }

    for (i = 0; uris[i]; i++) {
        g_print ("   [%d] - %s\n", i, uris[i]);
    }

    g_main_loop_quit (mainloop);
}

int
main (int    argc,
      char **argv)
{
    BrQueue *local_queue;
    GError *error = NULL;
    int i;

    g_type_init ();

    local_queue = br_queue_new_local ();

    if (argv[1] == NULL) {
        g_print ("Usage: bognor-regis <uri | play | stop | ls | list-queues | remove>\n");
        /* probably also print current list */
        return -1;
    }

    if (g_str_equal (argv[1], "play")) {
        br_queue_play (local_queue);
    } else if (g_str_equal (argv[1], "stop")) {
        br_queue_stop (local_queue);
    } else if (g_str_equal (argv[1], "ls")) {
        char **uris;

        br_queue_list_uris (local_queue, list_uris_cb, NULL);

        /* Run a mainloop to get a response */
        mainloop = g_main_loop_new (NULL, FALSE);
        g_main_loop_run (mainloop);

        return 0;
    } else if (g_str_equal (argv[1], "list-queues")) {
        g_print ("**FIXME**\n");
    } else if (g_str_equal (argv[1], "next")) {
        br_queue_next (local_queue);
    } else if (g_str_equal (argv[1], "remove")) {
        int index;

        if (argc != 3) {
            g_print ("Usage: %s remove <index>\n", argv[0]);
            return 0;
        }

        index = atoi (argv[2]);
        br_queue_remove (local_queue, index);
    } else if (g_str_equal (argv[1], "insert")) {
        GFile *f;
        GFileInfo *info;
        GError *error = NULL;

        if (argc != 4) {
            g_print ("Usage: %s insert <position> <uri>\n", argv[0]);
            return 0;
        }

        f = g_file_new_for_uri (argv[3]);
        info = g_file_query_info (f, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE,
                                  G_FILE_QUERY_INFO_NONE, NULL, &error);
        if (info == NULL) {
            g_warning ("Error finding mimetype for %s: %s", argv[i],
                       error->message);
            g_error_free (error);
            g_object_unref (f);
        }

        br_queue_insert_uri (local_queue, argv[3],
                             g_file_info_get_content_type (info),
                             atoi (argv[2]));
    } else {
        for (i = 1; i < argc; i++) {
            GFile *f = g_file_new_for_uri (argv[i]);
            GFileInfo *info;
            GError *error = NULL;

            info = g_file_query_info (f, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE,
                                      G_FILE_QUERY_INFO_NONE, NULL, &error);
            if (info == NULL) {
                g_warning ("Error finding mimetype for %s: %s", argv[i],
                           error->message);
                g_error_free (error);
                g_object_unref (f);
                continue;
            }

            br_queue_add_uri (local_queue, argv[i],
                              g_file_info_get_content_type (info));

            g_object_unref (info);
            g_object_unref (f);
        }
    }

    return 0;
}
