
char *helptext = "\nA synthesiser emulation package.\n\
\n\
    You should start this package with the startBristol script. This script\n\
    will start up the bristol synthesiser binaries evaluating the correct\n\
    library paths and executable paths. There are emulation, synthesiser,\n\
    operational and GUI parameters:\n\
\n\
    Emulation:\n\
\n\
        -mini              - moog mini\n\
        -explorer          - moog voyager\n\
        -voyager           - moog voyager electric blue\n\
        -memory            - moog memory\n\
        -sonic6            - moog sonic 6\n\
        -mg1               - moog/realistic mg-1 concertmate\n\
        -hammond           - hammond module (deprecated, use -b3)\n\
        -b3                - hammond B3 (default)\n\
        -prophet           - sequential circuits prophet-5\n\
        -pro52             - sequential circuits prophet-5 with chorus\n\
        -pro10             - sequential circuits prophet-10\n\
        -pro1              - sequential circuits pro-one\n\
        -rhodes            - fender rhodes mark-I stage 73\n\
        -rhodesbass        - fender rhodes bass piano\n\
        -roadrunner        - crumar roadrunner electric piano\n\
        -bitone            - crumar bit 01\n\
        -bit99             - crumar bit 99\n\
        -bit100            - crumar bit + mods\n\
        -stratus           - crumar stratus synth/organ combo\n\
        -trilogy           - crumar trilogy synth/organ/string combo\n\
        -obx               - oberheim OB-X\n\
        -obxa              - oberheim OB-Xa\n\
        -axxe              - arp axxe\n\
        -odyssey           - arp odyssey\n\
        -arp2600           - arp 2600\n\
        -solina            - arp/solina string ensemble\n\
        -polysix           - korg polysix (previously -poly)\n\
        -poly800           - korg poly-800\n\
        -monopoly          - korg mono/poly (previously -mono)\n\
        -ms20              - korg ms20 (-libtest only)\n\
        -vox               - vox continental\n\
        -voxM2             - vox continental super/300/II\n\
        -juno              - roland juno-60\n\
        -jupiter           - roland jupiter-8\n\
        -bme700            - baumann bme-700\n\
        -bm                - bristol bassmaker sequencer (unfinished)\n\
        -dx                - yamaha dx-7\n\
        -cs80              - yamaha cs-80 (unfinished)\n\
        -sid               - commodore-64 SID chip synth\n\
        -granular          - granular synthesiser (unfinished)\n\
        -aks               - ems synthi-a (unfinished)\n\
        -mixer             - 16 track mixer (-libtest only)\n\
\n\
    Synthesiser:\n\
\n\
        -voices <n>        - operate with a total of 'n' voices (32)\n\
        -mono              - operate with a single voice (-voices 1)\n\
        -lnp               - low note preference (-mono)\n\
        -hnp               - high note preference (-mono)\n\
        -nnp               - no/last note preference (-mono)\n\
        -retrig            - monophonic note logic legato trigger (-mono)\n\
        -lvel              - monophonic note logic legato velocity (-mono)\n\
        -channel <c>       - initial midi channel selected to 'c' (default 1)\n\
        -detune <%>        - temperature 'sensitivity' of emulation (0)\n\
        -gain <gn>         - emulator output signal gain (default 1)\n\
        -pwd <s>           - pitch wheel depth (2 semitones)\n\
        -velocity <v>      - MIDI velocity mapping curve (510) (-mvc)\n\
        -glide <s>         - MIDI glide duration (5)\n\
        -emulate <name>    - search for the named synth or exit\n\
        -lwf               - emulator lightweight filters\n\
        -glwf              - global lightweight filters\n\
        -blo <h>           - bandwidth limited oscillators with h harmonics\n\
        -scala <file>      - read the scala .scl tonal mapping table\n\
\n\
    User Interface:\n\
\n\
        -quality <n>       - color cache depth (bbp 2..8) (6)\n\
        -grayscale <n>     - color or BW display (0..5) (0 = color)\n\
        -antialias <n>     - antialias depth (0..100%) (30)\n\
        -aliastype <s>     - antialias type (pre/texture/all)\n\
        -opacity <n>       - opacity of the patch layer 20..100% (50)\n\
        -scale <s>         - initial windowsize, antialiased (1.0)\n\
        -pixmap            - use the pixmap interface rather than ximage\n\
        -dct <ms>          - double click timeout (250 ms)\n\
        -tracking          - disable MIDI keyboard tracking in GUI\n\
        -load <m>          - load memory number 'm' (default 0)\n\
        -mbi <m>           - master bank index (0)\n\
        -activesense <m>   - active sense rate (1000 ms)\n\
        -ast <m>           - active sense timeout (3000 ms)\n\
        -mct <m>           - midi cycle timeout (50 ms)\n\
        -ar|-aspect        - ignore emulator requested aspect ratio\n\
        -libtest           - only display a GUI, engine not invoked\n\
\n\
        Gui key strokes:\n\
\n\
            <Ctrl> 't'     - toggle opacity\n\
            <Ctrl> 'o'     - decrease opacity of patch layer\n\
            <Ctrl> 'O'     - increase opacity of patch layer\n\
            <Ctrl> 'p'     - screendump to /tmp/<synth>.xpm\n\
            'UpArrow'      - controller motion up (shift key accelerator)\n\
            'DownArrow'    - controller motion down (shift key accelerator)\n\
\n\
    Operational:\n\
\n\
        General:\n\
\n\
            -engine        - don't start engine (connect to current invocation)\n\
            -port <p>      - connect to engine on TCP port 'p' (default 5028)\n\
            -quiet         - redirect diagnostic output to /dev/null\n\
            -oss           - use OSS defaults for audio and MIDI\n\
            -alsa          - use ALSA defaults for audio and MIDI (default)\n\
            -jack          - use Jack for audio, ALSA SEQ for MIDI\n\
            -o <filename>  - Duplicate raw audio output data to file\n\
\n\
        Audio driver:\n\
\n\
            -audio [oss|alsa|jack] - audio driver selection (-alsa)\n\
            -audiodev <dev>        - audio device selection\n\
            -count <samples>       - sample period count (256)\n\
            -outgain <gn>          - digital output signal gain (default 4)\n\
            -ingain <gn>           - digital input signal gain (default 4)\n\
            -preload <buffers>     - configure preload buffer count (default 8)\n\
            -rate <hz>             - sample rate (44100)\n\
            -priority <p>          - audio RT priority, 0=no realtime (75)\n\
            -autoconn              - attempt jack port auto-connect\n\
\n\
        Midi driver:\n\
\n\
            -midi [oss|alsa|seq|jack] - midi driver selection (seq)\n\
            -mididev <dev>            - midi device selection\n\
            -seq                      - use the ALSA SEQ interface (default)\n\
            -mididbg                  - midi debug enable\n\
\n\
    Audio drivers are PCM/PCM_plug or Jack. Midi drivers are either OSS/ALSA\n\
    rawmidi interface, or ALSA SEQ. Multiple GUIs can connect to the single\n\
    audio engine which then operates multitimbrally.\n\
\n\
    Examples:\n\
\n\
    startBristol\n\
\n\
        Print a terse help message.\n\
\n\
    startBristol -v -h\n\
\n\
        Hm, if you're reading this you found these switches already.\n\
\n\
    startBristol -mini\n\
\n\
        Run a minimoog using ALSA interface for audio and midi seq. This is\n\
        equivalent to all the following options:\n\
        -mini -alsa -audiodev plughw:0,0 -midi seq -count 256 -preload 8 \n\
        -port 5028 -voices 32 -channel 1 -rate 44100 -gain 4 -ingain 4\n\
\n\
    startBristol -alsa -mini\n\
\n\
        Run a minimoog using ALSA interface for audio and midi. This is\n\
        equivalent to all the following options:\n\
        -mini -audio alsa -audiodev plughw:0,0 -midi alsa -mididev hw:0\n\
        -count 256 -preload 8 -port 5028 -voices 32 -channel 1 -rate 44100\n\
\n\
    startBristol -explorer -voices 1 -oss\n\
\n\
        Run a moog explorer as a monophonic instrument, using OSS interface for\n\
        audio and midi.\n\
\n\
    startBristol -prophet -channel 3\n\
\n\
        Run a prophet-5 using ALSA for audio and midi on channel 3.\n\
\n\
    startBristol -b3 -count 512 -preload 2\n\
\n\
        Run a hammond b3 with a buffer size of 512 samples, and preload two \n\
        such buffers before going active. Some Live! cards need this larger\n\
        buffer size with ALSA drivers.\n\
\n\
    startBristol -oss -audiodev /dev/dsp1 -vox -voices 8\n\
\n\
        Run a vox continental using OSS device 1, and default midi device\n\
        /dev/midi0. Operate with just 8 voices.\n\
\n\
    startBristol -b3 -audio alsa -audiodev plughw:0,0 -seq -mididev 128.0\n\
\n\
        Run a B3 emulation over the ALSA PCM plug interface, using the ALSA\n\
        sequencer over client 128, port 0.\n\
\n\
    startBristol -juno &\n\
    startBristol -prophet -channel 2 -engine\n\
\n\
        Start two synthesisers, a juno and a prophet. Both synthesisers will\n\
        will be executed on one engine (multitimbral) with 32 voices between \n\
        them. The juno will be on default midi channel (1), and the prophet on\n\
        channel 2. Output over the same default ALSA audio device.\n\
\n\
    startBristol -juno &\n\
    startBristol -port 5029 -audio oss -audiodev /dev/dsp1 -mididev /dev/midi1\n\
\n\
        Start two synthesisers, a juno on the first ALSA soundcard, and a\n\
        mini on the second OSS soundcard. Each synth is totally independant\n\
        and runs with 32 voice polyphony (looks nice, not been tested).\n\
\n\
The location of the bristol binaries can be specified in the BRISTOL\n\
environment variable. Private memory and MIDI controller mapping files can\n\
be found in the directory BRISTOL_CACHE and defaults to $HOME/.bristol\n\
\n\
Korg Inc. of Japan is the rightful owner of the Korg and Vox tradenames, and\n\
the Polysix, Mono/Poly, MS-20 and Continental trademarks. Their own Vintage\n\
Collection provides emulations for a selection of their own classic synthesiser\n\
range, this product is in no manner related to Korg other than giving homage\n\
to their great instruments.\n\
\n\
Bristol is in no manner associated with any of the original manufacturers of\n\
any of the emulated instruments. All names and trademarks are property of\n\
their respective owners.\n\
\n\
    author:   Nick Copeland\n\
    email:    nickycopeland@hotmail.com\n\
\n\
    http://bristol.sourceforge.net\n\
\n\
";

