
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nickycopeland@hotmail.com> 1996,2009
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "bristolsid.h"

int
main()
{
	int id, i;
	int fd;
	unsigned short s;

	id = sid_IO(-1, B_SID_INIT, 44100);

	sid_register(id, B_SID_CONTROL,
//		B_SID_C_DEBUG_D|B_SID_C_DEBUG_A);
		B_SID_C_MULTI_V|B_SID_C_LPF|B_SID_C_DEBUG_D|B_SID_C_DEBUG_A);

	sid_IO(id, B_SID_SN_LEAKAGE, 0.1);
	sid_IO(id, B_SID_SN_RATIO, 0.3);
	sid_IO(id, B_SID_DETUNE, 0.04);
	sid_IO(id, B_SID_DC_BIAS, 0.0);
	sid_IO(id, B_SID_OBERHEIM, 0.3);

	sid_register(id, B_SID_V1_FREQ_LO, phasemap[60][FREQ_LO]);
	sid_register(id, B_SID_V1_FREQ_HI, phasemap[60][FREQ_HI]);
	sid_register(id, B_SID_V1_CONTROL, B_SID_V_TRI);

	sid_register(id, B_SID_V2_FREQ_LO, phasemap[69][FREQ_LO]);
	sid_register(id, B_SID_V2_FREQ_HI, phasemap[69][FREQ_HI]);
	sid_register(id, B_SID_V2_ATT_DEC, 0xb8);
	sid_register(id, B_SID_V2_SUS_REL, 0x88);

	sid_register(id, B_SID_FILT_HI, 0x18);
	sid_register(id, B_SID_FILT_LO, 0x07);
	sid_register(id, B_SID_FILT_RES_F, 0xe0|0);
	sid_register(id, B_SID_FILT_M_VOL, B_SID_F_LP|0x0c);

	/* Test some sample generation. */
	fd = open("/tmp/output.raw", O_WRONLY|O_CREAT|O_TRUNC, 0644);
	for (i = 0; i < 44100*10; i++)
	{
		if (i == 44100) {
			/* Set gate */
			sid_register(id, B_SID_V2_CONTROL, B_SID_V_SQUARE|B_SID_V_TRI|B_SID_V_RAMP|B_SID_V_GATE);
		}

		if (i == 44100 * 7) {
			/* Clear gate */
			sid_register(id, B_SID_V2_CONTROL, B_SID_V_SQUARE|B_SID_V_TRI|B_SID_V_RAMP);
		}

		s = (unsigned short) (sid_IO(id, B_SID_ANALOGUE_IO, 0) * 16383);
		write(fd, &s, 2);
	}
	close(fd);

//	sid_register(id, B_SID_CONTROL, B_SID_C_PRINT);

	id = sid_IO(id, B_SID_DESTROY, 44100);

	exit(0);
}

