/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_SELECTION_H
#define INCLUDED_SELECTION_H

class Selection
{
public:
	Selection()
	: d_dir( "" )
	, d_fname( "" )
	{}
	Selection( const QString& in_dir, const QString& in_fname )
	: d_dir( in_dir )
	, d_fname( in_fname )
	{}
	Selection( const Selection& rhs )
	{
		d_dir = rhs.d_dir;
		d_fname = rhs.d_fname;
	}
	virtual ~Selection()
	{}

//------- METHODS -------
public:
	Selection& operator=( const Selection& rhs )
	{
		if( this != &rhs ) {
			d_dir = rhs.d_dir;
			d_fname = rhs.d_fname;
		}
		return *this;
	}
	void setDir  ( const QString& in_dir   ) { d_dir = in_dir;     }
	void setFname( const QString& in_fname ) { d_fname = in_fname; }
	void getName ( QString& out_dir        ) { out_dir = d_dir;     }
	void getFname( QString& out_fname      ) { out_fname = d_fname; }
	
//------- MEMBERS -------
private:
	QString d_dir;
	QString d_fname;
};

#endif // INCLUDED_SELECTION_H
