/******************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BSCommander; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "StartDir.h"
#include "Shared.h"
#include <qlayout.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qdir.h>

/*------- local constants:
-------------------------------------------------------------------*/
const QString StartDir::Caption        = QT_TR_NOOP( "Start directory selection" );
const QString StartDir::RootDirTitle   = QT_TR_NOOP( "Root directory" );
const QString StartDir::HomeDirTitle   = QT_TR_NOOP( "Your home directory" );
const QString StartDir::SelectDirTitle = QT_TR_NOOP( "Select a directory" );
const QString StartDir::EditDirTitle   = QT_TR_NOOP( "Type a directory" );
const QString StartDir::SelectLabel    = QT_TR_NOOP( "top directory" );

//*******************************************************************
// StartDir                                              CONSTRUCTOR
//*******************************************************************
StartDir::StartDir( QWidget* const in_parent )
: QDialog( in_parent )
, d_root_gbox  ( new QGroupBox( 2, Qt::Horizontal, tr(RootDirTitle)  , this ))
, d_home_gbox  ( new QGroupBox( 2, Qt::Horizontal, tr(HomeDirTitle)  , this ))
, d_select_gbox( new QGroupBox( 2, Qt::Horizontal, tr(SelectDirTitle), this ))
, d_edit_gbox  ( new QGroupBox( 2, Qt::Horizontal, tr(EditDirTitle)  , this ))
, d_root_cb    ( new QCheckBox( "/", d_root_gbox ))
, d_home_cb    ( new QCheckBox( QDir::homeDirPath(), d_home_gbox ))
, d_select_cb  ( new QCheckBox( tr(SelectLabel), d_select_gbox ))
, d_edit_cb    ( new QCheckBox( d_edit_gbox ))
, d_selector   ( new QComboBox( d_select_gbox ))
, d_edit       ( new QLineEdit( d_edit_gbox ))
, d_select_btn ( new QPushButton( tr(Shared::SelectBtnLabel), this ))
, d_return_btn ( new QPushButton( tr(Shared::CloseBtnLabel), this ))
, d_wait       ( FALSE )
{
	setCaption( tr(Caption) );
	
	d_root_cb->setChecked( TRUE );
	d_selector->setEnabled( FALSE );
	d_edit->setEnabled( FALSE );
	QDir dir( "/", QString::null, (QDir::Name | QDir::IgnoreCase), QDir::Dirs  );
	const QFileInfoList* const file_list = dir.entryInfoList();
	if( file_list ) {
		QFileInfoListIterator it( *file_list );
		while( it.current() ) {
			if( Shared::is_regular_file( it.current()->fileName() )) {
				if( it.current()->isExecutable() && it.current()->isReadable() ) {
					d_selector->insertItem( it.current()->fileName() );
				}
			}
			++it;
		}
	}

	QHBoxLayout* const main_layout = new QHBoxLayout( this );
	main_layout->setMargin( Shared::LayoutMargin  );
	main_layout->setSpacing( Shared::LayoutSpacing );
	
	{
		QVBoxLayout* const sel_layout = new QVBoxLayout;
		sel_layout->addWidget( d_root_gbox );
		sel_layout->addWidget( d_home_gbox );
		sel_layout->addWidget( d_select_gbox );
		sel_layout->addWidget( d_edit_gbox );
		main_layout->addLayout( sel_layout );
	}
	
	{
		QVBoxLayout* const btn_layout = new QVBoxLayout;
		btn_layout->addStretch( Shared::OverStretch );
		btn_layout->addWidget( d_select_btn );
		btn_layout->addWidget( d_return_btn );
		main_layout->addLayout( btn_layout );
	}

	connect( d_root_cb   , SIGNAL( toggled( bool )), this, SLOT( slot_root( bool ) ));
	connect( d_home_cb   , SIGNAL( toggled( bool )), this, SLOT( slot_home( bool ) ));
	connect( d_select_cb , SIGNAL( toggled( bool )), this, SLOT( slot_select( bool ) ));
	connect( d_edit_cb   , SIGNAL( toggled( bool )), this, SLOT( slot_edit( bool ) ));
	connect( d_select_btn, SIGNAL( clicked() ), this, SLOT( slot_select() ));
	connect( d_return_btn, SIGNAL( clicked() ), this, SLOT( slot_return() ));
}
// end of StartDir

//*******************************************************************
// get_from_dir                                               PUBLIC
//*******************************************************************
void StartDir::get_from_dir( QString& out_from_dir )
{
	out_from_dir = QString::null;
	
	if( d_root_cb->isChecked() ) {
		out_from_dir= "/";
	}
	else if( d_home_cb->isChecked() ) {
		out_from_dir = QDir::homeDirPath();
	}
	else if( d_select_cb->isChecked() ) {
		out_from_dir = "/" + d_selector->currentText();
	}
	else if( d_edit_cb->isChecked() ) {
		out_from_dir = d_edit->text();
	}
}
// end of get_from_dir

//*******************************************************************
// slot_select                                          PRIVATE slot
//*******************************************************************
void StartDir::slot_select()
{
	accept();
}
// end of slot_select

//*******************************************************************
// slot_return                                          PRIVATE slot
//*******************************************************************
void StartDir::slot_return()
{
	reject();
}
// end of slot_return

//*******************************************************************
// slot_root                                            PRIVATE slot
//*******************************************************************
void StartDir::slot_root( const bool in_is_on )
{
	if( FALSE == d_wait ) {
		if( in_is_on ) {
			d_wait = TRUE;
			deselect_all();
			d_root_cb->setChecked( TRUE );
			d_edit->setEnabled( FALSE );
			d_selector->setEnabled( FALSE );
			d_wait = FALSE;
		}
	}
}
// end of slot_root

//*******************************************************************
// slot_home                                            PRIVATE slot
//*******************************************************************
void StartDir::slot_home( const bool in_is_on )
{
	if( FALSE == d_wait ) {
		if( in_is_on ) {
			d_wait = TRUE;
			deselect_all();
			d_home_cb->setChecked( TRUE );
			d_edit->setEnabled( FALSE );
			d_selector->setEnabled( FALSE );
			d_wait = FALSE;
		}
	}
}
// end of slot_home

//*******************************************************************
// slot_select                                          PRIVATE slot
//*******************************************************************
void StartDir::slot_select( const bool in_is_on )
{
	if( FALSE == d_wait ) {
		if( in_is_on ) {
			d_wait = TRUE;
			deselect_all();
			d_select_cb->setChecked( TRUE );
			d_edit->setEnabled( FALSE );
			d_selector->setEnabled( TRUE );
			d_selector->setFocus();
			d_wait = FALSE;
		}
	}
}
// end of slot_select

//*******************************************************************
// slot_edit                                            PRIVATE slot
//*******************************************************************
void StartDir::slot_edit( const bool in_is_on )
{
	if( FALSE == d_wait ) {
		if( in_is_on ) {
			d_wait = TRUE;
			deselect_all();
			d_edit_cb->setChecked( TRUE );
			d_selector->setEnabled( FALSE );
			d_edit->setEnabled( TRUE );
			d_edit->setFocus();
			d_wait = FALSE;
		}
	}
}
// end of slot_select

//*******************************************************************
// deselect_all                                              PRIVATE
//*******************************************************************
void StartDir::deselect_all()
{
	d_root_cb->setChecked( FALSE );
	d_home_cb->setChecked( FALSE );
	d_select_cb->setChecked( FALSE );
	d_edit_cb->setChecked( FALSE );
}
// end of deselct_all
