/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/********************************************************************
 * Klasa ta zostala utworzona tylko i wylacznie rozwiazania
 * powiazan vyklicznych pomiedzy Workspace i LeftView/RightView.
 *******************************************************************/
 
/*------- include files:
-------------------------------------------------------------------*/
#include "ViewUtil.h"

/*------- static variables:
-------------------------------------------------------------------*/
LeftView* ViewUtil::s_left_view   = 0;
RightView* ViewUtil::s_right_view = 0;

//*******************************************************************
// set_left_view
//*******************************************************************
void ViewUtil::set_left_view( LeftView* const in_left_view )
{
	s_left_view = in_left_view;
}
// end of set_left_view
	
//*******************************************************************
// set_right_view
//*******************************************************************
void ViewUtil::set_right_view( RightView* const in_right_view )
{
	s_right_view = in_right_view;
}
// end of set_right_view
	
//*******************************************************************
// left_view
//*******************************************************************
LeftView* ViewUtil::left_view()
{
	return s_left_view;
}
// end of left_view
	
//*******************************************************************
// right_view
//*******************************************************************
RightView* ViewUtil::right_view()
{
	return s_right_view;
}
// end of right_view
