# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

import sys

class StyleNotFound(Exception):
    def __init__(self, style):
        self.value = "Style '%s' not found" %style

    def __str__(self):
        return repr(self.value)

class Output(object):
    def __init__(self,tool,format,file):
        self.format = format
        self.tool = tool
        self.file = file
        if self.file:
            #clear existing file
            fsock = open(self.file, 'w')
            fsock.close()

        try:
            mod = __import__("bugHelper.format." + self.format)
            modname = getattr(mod, "format")
            classname = getattr(modname, self.format)
        except ImportError:
            try:
                mod = __import__("bugHelper.format.plain")
                modname = getattr(mod, "format")
                classname = getattr(modname, "plain")
                print >> sys.stderr, "failed to open '%s', using 'plain' instead" %self.format
            except:
                raise StyleNotFound, self.format
        try:
            self.style = getattr(classname, self.tool)()
        except AttributeError:
            raise StyleNotFound, '.'.join([self.tool,self.format])

    def print_item(self, content, template="data"):
        try:
            out = getattr(self.style,template)(content)
        except AttributeError:
            self.error("no function '%s' found in '%s.%s'" %(template,self.format,self.tool))
            return

        if self.file:
            fsock = open(self.file, 'a')
            fsock.write(out + "\n")
            fsock.close()
        else:
            print out

    def info(self,msg):
        print >> sys.stderr, msg

    def error(self,msg):
        print >> sys.stderr, msg

    def print_header(self,content={}):
        if hasattr(self.style,"header"):
            self.print_item(content,"header")

    def print_footer(self,content={}):
        if hasattr(self.style,"footer"):
            self.print_item(content,"footer")

