# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Rick Spencer rick.spencer@canonical.com
#This program is free software: you can redistribute it and/or modify it 
#under the terms of the GNU General Public License version 3, as published 
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but 
#WITHOUT ANY WARRANTY; without even the implied warranties of 
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along 
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import sys
import os
import gtk
import urllib

from bughugger.bughuggerconfig import getdatapath
from desktopcouch.records.server import CouchDatabase
from desktopcouch.records.record import Record as CouchRecord

class UrlsearchDialog(gtk.Dialog):
    __gtype_name__ = "UrlsearchDialog"

    def __init__(self):
        """__init__ - This function is typically not called directly.
        Creation of a UrlsearchDialog requires redeading the associated ui
        file and parsing the ui definition extrenally, 
        and then calling UrlsearchDialog.finish_initializing().
    
        Use the convenience function NewUrlsearchDialog to create 
        a UrlsearchDialog object.
    
        """
        pass

    def finish_initializing(self, builder):
        """finish_initalizing should be called after parsing the ui definition
        and creating a UrlsearchDialog object with it in order to finish
        initializing the start of the new UrlsearchDialog instance.
    
        """
        #get a reference to the builder and set up the signals
        self.builder = builder
        self.builder.connect_signals(self)

    def ok(self, widget, data=None):
        """ok - The user has elected to save the changes.
        Called before the dialog returns gtk.RESONSE_OK from run().

        """
        error_box = self.builder.get_object("hbox_error")
        error_box.hide()

        search_exists = False

        self.url = self.builder.get_object("entry_url").get_text()
        self.search_name = self.builder.get_object("entry_searchname").get_text()
        if (len(self.search_name) == 0) or (len(self.url) == 0):
            return

        try:
            f = urllib.urlopen(self.url)
            txt = f.read()
            if len(txt) > 0:
                search_exists = True
            #TODO: do some validation that the response is something useful
        except:
            pass

        if search_exists:       
            #store the title and URL in couchdb
            rt = "http://wiki.ubuntu.com/Quickly/BughuggerUrlSearch"
            db = CouchDatabase("bughugger", create=True)
            record = CouchRecord(
            {"url": self.url, "search_name": self.search_name}, record_type=rt)
            db.put_record(record)

            #issue the response        
            self.response(gtk.RESPONSE_OK)

        else:
            error_box.show()

    def cancel(self, widget, data=None):
        """cancel - The user has elected cancel changes.
        Called before the dialog returns gtk.RESPONSE_CANCEL for run()

        """         
        pass

def NewUrlsearchDialog():
    """NewUrlsearchDialog - returns a fully instantiated
    dialog-camel_case_nameDialog object. Use this function rather than
    creating UrlsearchDialog instance directly.
    
    """

    #look for the ui file that describes the ui
    ui_filename = os.path.join(getdatapath(), 'ui', 'UrlsearchDialog.ui')
    if not os.path.exists(ui_filename):
        ui_filename = None

    builder = gtk.Builder()
    builder.add_from_file(ui_filename)    
    dialog = builder.get_object("urlsearch_dialog")
    dialog.finish_initializing(builder)
    return dialog

if __name__ == "__main__":
    dialog = NewUrlsearchDialog()
    dialog.show()
    gtk.main()

