#Plugins must start with "Plugin"
#Put them in ~/.bughugger/plugins
#
# Author: Brian Murray <brian@canonical.com>
# Copyright (C) 2009 Canonical, Ltd.
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# This plugin will prompt for a master bug number and mark bugs as a duplicate of it

import gtk
class PluginDuplicate():
    def __init__(self, launchpad):
        print "initializing PluginDuplicate"
        self.launchpad = launchpad

    @property
    def buttontext(self):
        return "_Mark Duplicate"

    def action(self, bug_tasks):
        dialog = gtk.Dialog("Master Bug",None,gtk.DIALOG_MODAL,(gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT, gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
        content_area = dialog.get_content_area()
        hbox = gtk.HBox(2, 5)
        label = gtk.Label("Master bug number:")
        entry = gtk.Entry()
        hbox.pack_start(label,False, False)
        hbox.pack_end(entry, False, True)
        content_area.pack_start(hbox)
        hbox.show()
        label.show()
        entry.show()

        result = dialog.run()

        master = entry.get_text()
        print master
        
        if not result == gtk.RESPONSE_ACCEPT:
            return

        dialog.destroy()

        #set status to confirmed and add a comment regarding duplicity
        comment = "Thank you for taking the time to report this bug and helping to make Ubuntu better. This particular bug has already been reported and is a duplicate of bug %s, so it is being marked as such. Please look at the other bug report to see if there is any missing information that you can provide, or to see if there is a workaround for the bug.  Additionally, any further discussion regarding the bug should occur in the other report.  Please continue to report any other bugs you may find." % (master)

        for bug_task in bug_tasks:
            bug = self.launchpad.bugs[bug_task.bug.id]
        # not for each task of a bug but the list of tasks passed to the Plugin
            # need to check if the bug being marked as a duplicate has duplicates
            # this could be handled better
            if bug.duplicate_of:
                print "Skipping bug LP: #%s as it is a duplicate already" % (bug.id)
                continue
            if bug.duplicates:
                print "Skipping bug LP: #%s as it has duplicates itself" % (bug.id)
                continue
            bug.newMessage(content=comment, subject="Marking as a duplicate")

            master_bug = self.launchpad.bugs[master]
            bug.duplicate_of = master_bug
            bug_task.status = "Confirmed"
            bug.lp_save()
    
    @property
    def hide(self):
        return False

def InitializePlugin(launchpad):
    inst = PluginDuplicate(launchpad)
    return inst
