#
#    Copyright (C) 2009 Francesco Marella <francesco.marella@gmail.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import gtk, webkit
import os
from lib.common import *
from lib import resources

from statuslistener import StatusListener

UI_FILE = resources.get_data_file("unreadmail_dialog.ui")

class UnreadMailDialog(StatusListener):
	def __init__(self, crunner):
		StatusListener.__init__(self, crunner)

		gtk.window_set_default_icon_from_file(NOMAIL_ICON)

		self.builder = gtk.Builder()
		self.builder.add_from_file(UI_FILE)
		self.builder.set_translation_domain("cgmail")

		self.dialog = self.builder.get_object("dialog1")

		self.filename = None

		self.editor = webkit.WebView()
		self.editor.set_editable(False)
		self.editor.show()

		scroll = self.builder.get_object("scrolledwindow1")
		scroll.add(self.editor)
		scroll.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		
		self.dialog.connect("response", lambda dialog, response: dialog.destroy())
	
	def run(self):
		result = self.dialog.run()

	def fill(self, mess):
		self.editor.load_html_string("TODO", "file:///")

	def on_status_changed(self, crunner, checker):
		pass
