/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class FileIncompatibleExceptionTestCase : Db4oUnit.ITestLifeCycle
	{
		private static readonly string DB = "OpenErrorTest.db4o";

		public static void Main(string[] args)
		{
			new Db4oUnit.TestRunner(typeof(Db4objects.Db4o.Tests.Common.Assorted.FileIncompatibleExceptionTestCase)
				).Run();
		}

		public virtual void SetUp()
		{
			Db4objects.Db4o.Foundation.IO.File4.Delete(DB);
			Db4objects.Db4o.IO.IoAdapter adapter = new Db4objects.Db4o.IO.RandomAccessFileAdapter
				();
			try
			{
				adapter = adapter.Open(DB, false, 0);
				byte[] buf = new byte[256];
				adapter.Write(buf, buf.Length);
			}
			finally
			{
				adapter.Close();
			}
		}

		public virtual void Test()
		{
			Db4oUnit.Assert.Expect(typeof(Db4objects.Db4o.Ext.Db4oException), new _AnonymousInnerClass31
				(this));
			Db4objects.Db4o.Foundation.IO.File4.Delete(DB);
			Db4objects.Db4o.IO.RandomAccessFileAdapter adapter = new Db4objects.Db4o.IO.RandomAccessFileAdapter
				();
			Db4oUnit.Assert.IsFalse(adapter.Exists(DB));
		}

		private sealed class _AnonymousInnerClass31 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass31(FileIncompatibleExceptionTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				Db4objects.Db4o.Db4oFactory.OpenFile(Db4objects.Db4o.Tests.Common.Assorted.FileIncompatibleExceptionTestCase
					.DB);
			}

			private readonly FileIncompatibleExceptionTestCase _enclosing;
		}

		public virtual void TearDown()
		{
			Db4objects.Db4o.Foundation.IO.File4.Delete(DB);
		}
	}
}
