/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Config
{
	public class NonStaticConfigurationTestCase : Db4oUnit.ITestCase
	{
		public class Data
		{
			public int id;

			public Data(int id)
			{
				this.id = id;
			}
		}

		private static readonly string FILENAME = "nonstaticcfg.yap";

		public virtual void TestOpenWithNonStaticConfiguration()
		{
			new Sharpen.IO.File(FILENAME).Delete();
			Db4objects.Db4o.Config.IConfiguration cfg = Db4objects.Db4o.Db4oFactory.NewConfiguration
				();
			cfg.ReadOnly(true);
			Db4objects.Db4o.IObjectContainer db = Db4objects.Db4o.Db4oFactory.OpenFile(cfg, FILENAME
				);
			try
			{
				db.Set(new Db4objects.Db4o.Tests.Common.Config.NonStaticConfigurationTestCase.Data
					(1));
			}
			finally
			{
				db.Close();
			}
			cfg = Db4objects.Db4o.Db4oFactory.NewConfiguration();
			db = Db4objects.Db4o.Db4oFactory.OpenFile(cfg, FILENAME);
			try
			{
				db.Set(new Db4objects.Db4o.Tests.Common.Config.NonStaticConfigurationTestCase.Data
					(2));
				Db4oUnit.Assert.AreEqual(1, db.Query(typeof(Db4objects.Db4o.Tests.Common.Config.NonStaticConfigurationTestCase.Data)
					).Size());
			}
			finally
			{
				db.Close();
			}
		}

		public virtual void TestIndependentObjectConfigs()
		{
			Db4objects.Db4o.Config.IConfiguration config = Db4objects.Db4o.Db4oFactory.NewConfiguration
				();
			Db4objects.Db4o.Config.IObjectClass objectConfig = config.ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Config.NonStaticConfigurationTestCase.Data)
				);
			objectConfig.Translate(new Db4objects.Db4o.Config.TNull());
			Db4objects.Db4o.Config.IConfiguration otherConfig = Db4objects.Db4o.Db4oFactory.NewConfiguration
				();
			Db4oUnit.Assert.AreNotSame(config, otherConfig);
			Db4objects.Db4o.Internal.Config4Class otherObjectConfig = (Db4objects.Db4o.Internal.Config4Class
				)otherConfig.ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Config.NonStaticConfigurationTestCase.Data)
				);
			Db4oUnit.Assert.AreNotSame(objectConfig, otherObjectConfig);
			Db4oUnit.Assert.IsNull(otherObjectConfig.GetTranslator());
		}
	}
}
