/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Soda
{
	public class SortMultipleTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public static void Main(string[] arguments)
		{
			new Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase().RunSolo();
		}

		public class IntHolder
		{
			public int _value;

			public IntHolder(int value)
			{
				this._value = value;
			}

			public override bool Equals(object obj)
			{
				if (this == obj)
				{
					return true;
				}
				if (obj == null || GetType() != obj.GetType())
				{
					return false;
				}
				Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.IntHolder intHolder = (Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.IntHolder
					)obj;
				return _value == intHolder._value;
			}

			public override int GetHashCode()
			{
				return _value;
			}

			public override string ToString()
			{
				return _value.ToString();
			}
		}

		public class Data
		{
			public int _first;

			public int _second;

			public Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.IntHolder _third;

			public Data(int first, int second, int third)
			{
				this._first = first;
				this._second = second;
				this._third = new Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.IntHolder
					(third);
			}

			public override bool Equals(object obj)
			{
				if (this == obj)
				{
					return true;
				}
				if (obj == null || GetType() != obj.GetType())
				{
					return false;
				}
				Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data data = (Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data
					)obj;
				return _first == data._first && _second == data._second && _third.Equals(data._third
					);
			}

			public override int GetHashCode()
			{
				int hc = _first;
				hc *= 29 + _second;
				hc *= 29 + _third.GetHashCode();
				return hc;
			}

			public override string ToString()
			{
				return _first + "/" + _second + "/" + _third;
			}
		}

		private static readonly Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data[]
			 DATA = { new Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data(1, 2, 
			4), new Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data(1, 4, 3), new 
			Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data(2, 4, 2), new Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data
			(3, 1, 4), new Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data(4, 3, 
			1), new Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data(4, 1, 3) };

		protected override void Store()
		{
			for (int dataIdx = 0; dataIdx < DATA.Length; dataIdx++)
			{
				Store(DATA[dataIdx]);
			}
		}

		public virtual void TestSortFirstThenSecond()
		{
			Db4objects.Db4o.Query.IQuery query = NewQuery(typeof(Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data)
				);
			query.Descend("_first").OrderAscending();
			query.Descend("_second").OrderAscending();
			AssertSortOrder(query, new int[] { 0, 1, 2, 3, 5, 4 });
		}

		public virtual void TestSortSecondThenFirst()
		{
			Db4objects.Db4o.Query.IQuery query = NewQuery(typeof(Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data)
				);
			query.Descend("_second").OrderAscending();
			query.Descend("_first").OrderAscending();
			AssertSortOrder(query, new int[] { 3, 5, 0, 4, 1, 2 });
		}

		public virtual void TestSortThirdThenFirst()
		{
			Db4objects.Db4o.Query.IQuery query = NewQuery(typeof(Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data)
				);
			query.Descend("_third").Descend("_value").OrderAscending();
			query.Descend("_first").OrderAscending();
			AssertSortOrder(query, new int[] { 4, 2, 1, 5, 0, 3 });
		}

		public virtual void TestSortThirdThenSecond()
		{
			Db4objects.Db4o.Query.IQuery query = NewQuery(typeof(Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data)
				);
			query.Descend("_third").Descend("_value").OrderAscending();
			query.Descend("_second").OrderAscending();
			AssertSortOrder(query, new int[] { 4, 2, 5, 1, 3, 0 });
		}

		public virtual void TestSortSecondThenThird()
		{
			Db4objects.Db4o.Query.IQuery query = NewQuery(typeof(Db4objects.Db4o.Tests.Common.Soda.SortMultipleTestCase.Data)
				);
			query.Descend("_second").OrderAscending();
			query.Descend("_third").Descend("_value").OrderAscending();
			AssertSortOrder(query, new int[] { 5, 3, 0, 4, 2, 1 });
		}

		private void AssertSortOrder(Db4objects.Db4o.Query.IQuery query, int[] expectedIndexes
			)
		{
			Db4objects.Db4o.IObjectSet result = query.Execute();
			Db4oUnit.Assert.AreEqual(expectedIndexes.Length, result.Size());
			for (int i = 0; i < expectedIndexes.Length; i++)
			{
				Db4oUnit.Assert.AreEqual(DATA[expectedIndexes[i]], result.Next());
			}
		}
	}
}
