/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.CS.Messages
{
	public abstract class MsgQuery : Db4objects.Db4o.Internal.CS.Messages.MsgObject
	{
		private const int ID_AND_SIZE = 2;

		private static int nextID;

		protected void WriteQueryResult(Db4objects.Db4o.Internal.Query.Result.AbstractQueryResult
			 queryResult, Db4objects.Db4o.Internal.CS.ServerMessageDispatcher serverThread, 
			Db4objects.Db4o.Config.QueryEvaluationMode evaluationMode)
		{
			int queryResultId = 0;
			int maxCount = 0;
			if (evaluationMode == Db4objects.Db4o.Config.QueryEvaluationMode.IMMEDIATE)
			{
				maxCount = queryResult.Size();
			}
			else
			{
				queryResultId = GenerateID();
				maxCount = Config().PrefetchObjectCount();
			}
			Db4objects.Db4o.Internal.CS.Messages.MsgD message = QUERY_RESULT.GetWriterForLength
				(Transaction(), BufferLength(maxCount));
			Db4objects.Db4o.Internal.StatefulBuffer writer = message.PayLoad();
			writer.WriteInt(queryResultId);
			Db4objects.Db4o.Foundation.IIntIterator4 idIterator = queryResult.IterateIDs();
			writer.WriteIDs(idIterator, maxCount);
			if (queryResultId > 0)
			{
				serverThread.MapQueryResultToID(new Db4objects.Db4o.Internal.CS.LazyClientObjectSetStub
					(queryResult, idIterator), queryResultId);
			}
			serverThread.Write(message);
		}

		private int BufferLength(int maxCount)
		{
			return Db4objects.Db4o.Internal.Const4.INT_LENGTH * (maxCount + ID_AND_SIZE);
		}

		private static int GenerateID()
		{
			lock (typeof(MsgQuery))
			{
				nextID++;
				if (nextID < 0)
				{
					nextID = 1;
				}
				return nextID;
			}
		}

		protected virtual Db4objects.Db4o.Internal.Query.Result.AbstractQueryResult NewQueryResult
			(Db4objects.Db4o.Config.QueryEvaluationMode mode)
		{
			return Stream().NewQueryResult(Transaction(), mode);
		}
	}
}
