/*!

\if MANPAGES
\page dcmcjpeg Encode DICOM file to JPEG transfer syntax
\else
\page dcmcjpeg dcmcjpeg: Encode DICOM file to JPEG transfer syntax
\endif

\section synopsis SYNOPSIS

\verbatim
dcmcjpeg [options] dcmfile-in dcmfile-out
\endverbatim

\section description DESCRIPTION

The \b dcmcjpeg utility reads an uncompressed DICOM image (\e dicomfile-in),
performs a JPEG compression (i. e. conversion to an encapsulated DICOM transfer
syntax) and writes the converted image to an output file (\e dicomfile-out).

\section parameters PARAMETERS

\verbatim
dcmfile-in   DICOM input filename to be converted

dcmfile-out  DICOM output filename
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

  -v    --verbose
          verbose mode, print processing details

  -d    --debug
          debug mode, print debug information
\endverbatim

\subsection input_options input options
\verbatim
input file format:

  +f    --read-file
          read file format or data set (default)

  +fo   --read-file-only
          read file format only

  -f    --read-dataset
          read data set without file meta information

input transfer syntax:

  -t=   --read-xfer-auto
          use TS recognition (default)

  -td   --read-xfer-detect
          ignore TS specified in the file meta header

  -te   --read-xfer-little
          read with explicit VR little endian TS

  -tb   --read-xfer-big
          read with explicit VR big endian TS

  -ti   --read-xfer-implicit
          read with implicit VR little endian TS

compatibility options (ignored by +tl):

  +Ma   --accept-acr-nema
          accept ACR-NEMA images without photometric interpretation

  # Enables compatibility for old ACR-NEMA images without photometric
  # information (only pseudo lossless encoder)

  +Mp   --accept-palettes
          accept incorrect palette attribute tags (0028,111x) and (0028,121x)

  # If enabled, incorrect palette attribute tags are accepted
  # (only pseudo lossless encoder)
\endverbatim

\subsection JPEG_encoding_options JPEG enconding options
\verbatim
JPEG process options:

  +e1   --encode-lossless-sv1
          encode lossless sv1 (default)

  # This option selects the JPEG Lossless, Non-Hierarchical, First-Order
  # Prediction (Process 14 Selection Value 1) Transfer Syntax for
  # Lossless JPEG Image Compression.

  +el   --encode-lossless
          encode lossless

  # This option selects the JPEG Lossless, Non-Hierarchical (Process 14)
  # Transfer Syntax for Lossless JPEG Image Compression.

  +eb   --encode-baseline
          encode baseline

  # This option selects the JPEG Baseline (Process 1) Transfer Syntax for
  # Lossy JPEG 8 Bit Image Compression.

  +ee   --encode-extended
          encode extended sequential

  # This option selects the JPEG Extended (Process 2 & 4) Transfer Syntax
  # for Lossy JPEG Image Compression.

  +es   --encode-spectral
          encode spectral selection

  # This option selects the JPEG Spectral Selection, Non-Hierarchical
  # (Process 6 & 8) Transfer Syntax for Lossy JPEG Image Compression.

  +ep   --encode-progressive
          encode progressive

  # This option selects the JPEG Full Progression, Non-Hierarchical
  # (Process 10 & 12) Transfer Syntax for Lossy JPEG Image Compression.

lossless JPEG codec selection:

  +tl   --true-lossless
          true lossless codec (default)

  # This option selects an encoder, that guarantees truely lossless
  # image compression. See NOTES for further information.

  +pl   --pseudo-lossless
          old pseudo-lossless codec

  # Old encoder, that uses lossless compression algorithms, but can
  # cause lossy images because of internal color space transformations
  # etc. Higher compression ratio than --true-lossless in most cases.

lossless JPEG representation options:

  +sv   --selection-value  [sv]: integer (1..7, default: 6)
          use selection value sv only with --encode-lossless

  # This option selects the selection value for lossless JPEG.

  +pt   --point-transform  [pt]: integer (0..15, default: 0)
          use point transform pt

  # This option selects the point transform for lossless JPEG.
  # WARNING: Using this option with a value other than zero causes
  # a loss of precision, i. e. makes the compression "lossy".

lossy JPEG representation options:

  +q    --quality  [q]: integer (0..100, default: 90)
          use quality factor q

  # This option selects the quality factor used to determine the
  # quantization table inside the JPEG compressor, which affects
  # compression ratio and image quality in lossy JPEG.  See documentation
  # of the Independent JPEG Group for details.

  +sm   --smooth  [s]: integer (0..100, default: 0)
          use smoothing factor s

  # This option enables a smoothing (low-pass filter) of the image data
  # prior to compression. Increases the compression ratio at the expense
  # of image quality.

other JPEG options:

  +ho   --huffman-optimize
          optimize huffman tables (default)

  # This option enables an optimization of the huffman tables during
  # image compression. It results in a slightly smaller image at a small
  # increase of CPU time. Always on if bits/sample is larger than 8.

  -ho   --huffman-standard
          use standard huffman tables if 8 bits/sample

  # This option disables an optimization of the huffman tables during
  # image compression.

compressed bits per sample options (always +ba with +tl):

  +ba   --bits-auto
          choose bits/sample automatically (default)

  +be   --bits-force-8
          force 8 bits/sample

  +bt   --bits-force-12
          force 12 bits/sample (not with baseline)

  +bs   --bits-force-16
          force 16 bits/sample (lossless only)

compression color space conversion options (overriden by +tl):

  +cy   --color-ybr
          use YCbCr for color images if lossy (default)

  # This option enables a transformation of the color space to YCbCr
  # prior to image compression for color images in lossy JPEG.

  +cr   --color-rgb
          use RGB for color images if lossy

  # This option prevents the transformation of the color space to YCbCr
  # prior to image compression for color images in lossy JPEG. It causes
  # lossy image compression in the RGB color space which is not
  # recommendable.

  +cm   --monochrome
          convert color images to monochrome

  # This option forces a conversion of color images to monochrome
  # prior to compression.

decompr. color space conversion (if input is compressed; always +cn with +tl):

  +cp   --conv-photometric
          convert if YCbCr photom. interpr. (default)

  # This option describes the behavior of dcmcjpeg when a compressed
  # image is read and decompressed prior to re-compression.  If the
  # compressed image uses YBR_FULL or YBR_FULL_422 photometric
  # interpretation, it is converted to RGB during decompression.

  +cl   --conv-lossy
          convert YCbCr to RGB if lossy JPEG

  # If the compressed image is encoded in lossy JPEG, assume YCbCr
  # color model and convert to RGB.

  +ca   --conv-always
          always convert YCbCr to RGB

  # If the compressed image is a color image, assume YCbCr color model
  # and convert to RGB.

  +cn   --conv-never
          never convert color space

  # Never convert color space during decompression.

standard YCbCr component subsampling options (not with +tl):

  +s4   --sample-444
          4:4:4 sampling with YBR_FULL (default)

  # This option disables color component subsampling for compression in
  # the YCbCr color space. The DICOM photometric interpretation is
  # encoded as YBR_FULL.

  +s2   --sample-422
          4:2:2 subsampling with YBR_FULL_422

  # This option enables a 4:2:2 color component subsampling for
  # compression in the YCbCr color space. The DICOM photometric
  # interpretation is encoded as YBR_FULL.

non-standard YCbCr component subsampling options (not with +tl):

  +n2   --nonstd-422-full
          4:2:2 subsampling with YBR_FULL

  # This option enables a 4:2:2 color component subsampling for
  # compression in the YCbCr color space. The DICOM photometric
  # interpretation is encoded as YBR_FULL which violates DICOM rules.

  +n1   --nonstd-411-full
          4:1:1 subsampling with YBR_FULL

  # This option enables a 4:1:1 color component subsampling for
  # compression in the YCbCr color space. The DICOM photometric
  # interpretation is encoded as YBR_FULL which violates DICOM rules.

  +np   --nonstd-411
          4:1:1 subsampling with YBR_FULL_422

  # This option enables a 4:1:1 color component subsampling for
  # compression in the YCbCr color space. The DICOM photometric
  # interpretation is encoded as YBR_FULL_422 which violates DICOM rules.
\endverbatim

\subsection enc_pix_data_fragm_opt encapsulated pixel data fragmentation options
\verbatim
  +ff   --fragment-per-frame
          encode each frame as one fragment (default)

  # This option causes the creation of one compressed fragment for each
  # frame (recommended).

  +fs   --fragment-size  [s]ize: integer
          limit fragment size to s kbytes

  # This option limits the fragment size which may cause the creation of
  # multiple fragments per frame.

basic offset table encoding options:

  +ot   --offset-table-create
          create offset table (default)

  # This option causes the creation of a valid offset table for the
  # compressed JPEG fragments.

  -ot   --offset-table-empty
          leave offset table empty

  # This option causes the creation of an empty offset table
  # for the compressed JPEG fragments.

VOI windowing options for monochrome images (not with +tl):

  -W    --no-windowing
          no VOI windowing (default)

  # No window level/width is "burned" into monochrome images prior to
  # compression.  See notes below on pixel scaling and rescale slope
  # and intercept encoding.

  +Wi   --use-window  [n]umber : integer
          use the n-th VOI window from image file

  # Apply the n-th window center/width encoded in the image data prior
  # to compression.

  +Wl   --use-voi-lut  [n]umber : integer
          use the n-th VOI look up table from image file

  # Apply the n-th VOI LUT encoded in the image data prior
  # to compression.

  +Wm   --min-max-window
          compute VOI window using min-max algorithm

  # Compute and apply a window center and width that covers the
  # range from the smallest to the largest occuring pixel value.

  +Wn   --min-max-window-n
          compute VOI window using min-max algorithm,
          ignoring extreme values

  # Compute and apply a window center and width that covers the
  # range from the second smallest to the second largest occuring
  # pixel value. This is useful if the background is set to an
  # artificial black (padding value) or if white overlays are burned
  # into the image data which should not be considered for the window
  # computation.

  +Wr   --roi-min-max-window  [l]eft [t]op [w]idth [h]eight : integer
          compute ROI window using min-max algorithm,
          region of interest is specified by l,t,w,h

  # This option works like --min-max-window but only considers the given
  # region of interest inside the image.

  +Wh   --histogram-window  [n]umber: integer
          compute VOI window using Histogram algorithm,
          ignoring n percent

  # Compute a histogram of the image data and apply window center
  # and width such than n% of the image data are ignored for the window
  # computation

  +Ww   --set-window  [c]enter [w]idth : float
          compute VOI window using center c and width w

  # Apply the given window center/width prior to compression.

pixel scaling for monochrome images (--no-windowing; ignored by +tl):

  +sp   --scaling-pixel
          scale using min/max pixel value (default)

  # Monochrome image pixel values are always scaled to make use of the
  # pixel range available with the selected JPEG process as good as
  # possible. This option selects a scaling based on the minimum and
  # maximum pixel value occuring in the image.  This often leads to
  # significantly better image quality, but may cause different
  # compressed images within one series to have different values for
  # rescale slope and intercept, which is a problem if a presentation
  # state for one series is to be created.

  +sr   --scaling-range
          scale using min/max range

  # This options selects a scaling based on the pixel range as defined
  # by the stored bits, pixel representation and modality transform,
  # without consideration of the minimum and maximum value really
  # used within the image.

rescale slope/intercept encoding for monochrome (-W; ignored by +tl):

  +ri   --rescale-identity
          encode identity modality rescale (default)
          Never used for CT images

  # This options prevents the creation of a modality transformation
  # other than an identity transformation (which is required for
  # many DICOM IODs).  Window center/width settings encoded
  # in the image are adapted, VOI LUTs are removed.

  +rm   --rescale-map
          use modality rescale to scale pixel range
          Never used for XA/RF/XA Biplane images

  # This option causes the creation of a modality rescale slope and
  # intercept that maps the decompressed image data back to their
  # original range.  This keeps all VOI transformations valid but
  # requires that the DICOM IOD supports a modality rescale slope
  # and intercept transformation other than identity.

SOP Class UID options:

  +cd   --class-default
          keep SOP Class UID (default)

  # Keep the SOP Class UID of the source image.

  +cs   --class-sc
          convert to Secondary Capture Image
          (implies --uid-always)

  # Convert the image to Secondary Capture.  In addition to the SOP Class
  # UID, all attributes required for a valid secondary capture image are
  # added. A new SOP instance UID is always assigned.

SOP Instance UID options:
  +ud   --uid-default
          assign new UID if lossy compression (default)

  # Assigns a new SOP instance UID if the compression is lossy JPEG.

  +ua   --uid-always
          always assign new UID

  # Unconditionally assigns a new SOP instance UID.

  +un   --uid-never
          never assign new UID

  # Never assigns a new SOP instance UID.
\endverbatim

\subsection output_options output options
\verbatim
post-1993 value representations:

  +u    --enable-new-vr
          enable support for new VRs (UN/UT) (default)

  -u    --disable-new-vr
          disable support for new VRs, convert to OB

group length encoding:

  +g=   --group-length-recalc
          recalculate group lengths if present (default)

  +g    --group-length-create
          always write with group length elements

  -g    --group-length-remove
          always write without group length elements

length encoding in sequences and items:

  +e    --length-explicit
          write with explicit lengths (default)

  -e    --length-undefined
          write with undefined lengths

data set trailing padding:

  -p=   --padding-retain
          do not change padding (default)

  -p    --padding-off
          no padding

  +p    --padding-create  [f]ile-pad [i]tem-pad: integer
          align file on multiple of f bytes
          and items on multiple of i bytes
\endverbatim

\section notes NOTES

The \b dcmcjpeg utility compresses DICOM images of all SOP classes.  Special
handling has been implemented for CT images (where the modality transformation
is required to create Hounsfield units) and the XA/RF/Biplane SOP classes
(where the modality transformation has "inversed" semantics).  However,
\b dcmcjpeg does not attempt to ensure that the compressed image still complies
with all restrictions of the object's IOD.

A few examples:

\li MR images are required to have BitsAllocated=16.
\li NM Images can only be encoded with MONOCHROME2 or PALETTE COLOR photometric
    interpretation but not with RGB or YBR_FULL (which effectively prevents
    compression).
\li Hardcopy Color images must have RGB color model which is a problem if lossy
    compression is to be performed.

The user is responsible for making sure that the compressed images he creates
are compliant with the DICOM standard.  If in question, the \b dcmcjpeg utility
allows to convert an image to secondary capture - this SOP class does not pose
restrictions as the ones mentioned above.

With version DCMTK 3.5.4 a new encoder for truely lossless JPEG compression was
added (--true-lossless). Compared to the old (--pseudo-lossless) encoder, that
creates sligtly lossy images caused from internal color space conversions,
windowing etc., there are a some issues to consider:

\li Only source images with Bits Allocated 8 or 16 are supported
\li Options for color space conversions, windowing or pixel scaling are
    ignored or overriden
\li Photometric Interpretations YBR_FULL_422, YBR_PARTIAL_422, YBR_PARTIAL_420,
    YBR_ICT, YBR_RCT are not supported
\li The encoder changes automatically Planar Configuration from 1 to 0 if
    necessary
\li The compression ratio can be lower than in --pseudo-lossless mode

However, when using the new encoder (default), you can be sure, that compression
does not affect image quality.

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmcjpeg utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section see_also SEE ALSO

<b>dcmdjpeg</b>(1)

\section copyright COPYRIGHT

Copyright (C) 2001-2005 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/
