#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# displayconfig.py - description                                          #
# ------------------------------                                          #
# begin     : Fri Mar 02 2007                                             #
# copyright : (C) 2007 Canonical
# email     : michael.vogt@ubuntu.com                                     #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

import string
import os
import select
import sys
import csv
import time
import signal
import shutil

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import gobject
import pango

from displayconfiggtk.SimpleGladeApp import SimpleGladeApp

from displayconfigabstraction import *

import gettext
from gettext import gettext as _

from displayconfiggtk.information import VIDEODRIVERS

def get_screen_name(screen):
    screen_name = _("Unknown")
    if screen.getMonitorModel():
        screen_name = screen.getMonitorModel().getName()
    if screen.getMonitorAspect()==ModeLine.ASPECT_16_9:
        screen_name = "%s %s" % (screen_name, _("(widescreen)"))
    return screen_name

class DeviceChooser(gtk.Button):
    def __init__(self, device=None):
        gtk.Button.__init__(self)
        self.device = None
        # setup the widget
        self.img = gtk.Image()
        self.label = gtk.Label()
        self.label.set_ellipsize(pango.ELLIPSIZE_END)
        self.label.set_alignment(0, 0.5)
        hbox = gtk.HBox()
        hbox.set_spacing(6)
        hbox.pack_start(self.label,
                        expand=True, fill=True)
        hbox.pack_start(gtk.VSeparator(),
                        expand=False, fill=False)
        hbox.pack_start(self.img, expand=False, fill=True)
        self.add(hbox)
        # load the device information
        if not device == None:
            self.set_device(device)
        self.show_all()

    def set_device(self, device):
        self.device = device
        driver = ""
        if isinstance(device, Screen):
            icon_name = "video-display"
            self.model_name = get_screen_name(device)
        elif isinstance(device, GfxCard):
            icon_name = "device-gfxcard"
            if device.isProprietaryDriver():
                driver = device.getGfxCardModel().getProprietaryDriver()
            else:
                driver = device.getGfxCardModel().getDriver()
            if VIDEODRIVERS.has_key(driver):
                self.model_name = "%s - %s" % (driver, VIDEODRIVERS[driver])
            else:
                self.model_name = str(driver)
        self.img.set_from_icon_name(icon_name, gtk.ICON_SIZE_BUTTON)
        self.label.set_label(self.model_name)

    def get_device(self):
        return self.device

class GfxCardFrame(gtk.Frame, gobject.GObject):
    """A frame widget that provides information about a corresponding
       graphics card and that allows to configure the driver and
       connected monitors."""
    __gsignals__ = {'configure-clicked':(gobject.SIGNAL_RUN_FIRST,
                                         gobject.TYPE_NONE,
                                         (gobject.TYPE_PYOBJECT,))}

    def __init__(self, xsetup, card):
        class DetailsLabel(gtk.Label):
            """A label widget that is used in the details table."""
            def __init__(self, str=""):
                gtk.Label.__init__(self, str)
                self.set_alignment(0, 0.5)
        gtk.Frame.__init__(self)
        self.card = card
        self.xsetup = xsetup
        self.card_model = card.getGfxCardModel()
        self.set_shadow_type(gtk.SHADOW_NONE)
        label_frame = gtk.Label()
        label_frame.set_markup("<b>%s (%s)</b>" % (_("Graphics card"),
                                                   self.card.detected_model))
        self.set_label_widget(label_frame)
        self.alignment = gtk.Alignment()
        self.alignment.set_padding(6, 0, 12, 0)
        self.alignment.set(0, 0, 1, 0)
        self.details = gtk.Table(1, 2, False)
        self.details.set_row_spacings(6)
        self.details.set_col_spacings(12)
        # Video RAM widgets
        self.store_videoram = gtk.ListStore(gobject.TYPE_STRING,
                                            gobject.TYPE_INT)
        self.combobox_videoram = gtk.ComboBox()
        self.combobox_videoram.set_model(self.store_videoram)
        renderer = gtk.CellRendererText()
        self.combobox_videoram.pack_start(renderer)
        self.combobox_videoram.add_attribute(renderer, "text", 0)
        if self.card_model.getNeedVideoRam():
            for size in [256, 512]:
                self.store_videoram.append((_("%s KByte") % size, size))
            for size in [1, 2 ,4 ,8, 16, 32]:
                self.store_videoram.append((_("%s MByte") % size,
                                           size * 1024))
            self.store_videoram.append((_("64 MByte and more"), 65536))
            self.combobox_videoram.connect("changed",
                                           self.on_videoram_changed)
            self.combobox_videoram.set_active(self.card.getVideoRam())
        else:
            self.store_videoram.append((_("Automatic"), 0))
            self.combobox_videoram.set_sensitive(False)
            self.combobox_videoram.set_active(0)

        
        # Add driver widgets
        if self.card_model is not None:
            self.details.attach(DetailsLabel(str=_("Driver:")),
                                0, 1, 0, 1, 
                                xoptions=gtk.FILL, yoptions=gtk.FILL)
            button = DeviceChooser(self.card)
            button.connect("clicked", lambda b: self.emit("configure-clicked",
                                      self.card))
            self.details.attach(button, 1, 2, 0, 1, 
                                xoptions=gtk.FILL|gtk.EXPAND, 
                                yoptions=gtk.EXPAND)
            self.details.attach(DetailsLabel(str=_("Video Memory:")),
                                0, 1, 1, 2,
                                xoptions=gtk.FILL, yoptions=gtk.FILL)
            self.details.attach(self.combobox_videoram, 1, 2, 1, 2, 
                                xoptions=gtk.FILL|gtk.EXPAND, 
                                yoptions=gtk.EXPAND)
        self.alignment.add(self.details)
        self.add(self.alignment)
        # Show what we have!
        self.show_all()

    def on_videoram_changed(self, combobox):
        self.card.setVideoRam(combobox.get_active())

# vim:ts=4:sw=4:et
