#include "jacklow.h"
#include <stdio.h>
#include <stdlib.h>
#include "cfgfile.h"
#include <qstringlist.h>

Client::Client()
{
	j_client=0;
}

Client::Client(QString n, QString p)
{
	init(n, p);
}

bool Client::init(QString n, QString p)
{
	Name=n;
#if 0
	if(p != QString::null and p != "")
	{
		jack_set_server_dir((const char *)p);
	}
#endif

	j_client=jack_client_new(n);
	if(!j_client)
	{
		printf("Could not get Jack client\n");
		return false;
	}
	
	jack_set_process_callback(j_client, process, (void *)this);
	const char **portlist=jack_get_ports(j_client, NULL, NULL, 0);
	if(portlist)
	{
		int i;
		
		for(i=0;portlist[i];++i)
		{
			printf("Port %s\n", portlist[i]);
			jack_port_t *port=jack_port_by_name(j_client, portlist[i]);
			if(!jack_port_is_mine(j_client, port))
			{
				Portinfo info;
				info.id=(jack_port_id_t)-1;
				info.name=portlist[i];
				if(jack_port_flags(port) & JackPortIsInput)
					in_ports.append(info);
				else
					out_ports.append(info);
			}
		}
		free(portlist);
	}
	jack_set_port_registration_callback(j_client, port_registration_callback, (void *)this);
	j_rate=jack_get_sample_rate(j_client);
	jack_activate(j_client);
	return true;
}

Client::~Client()
{
	QValueList<Port *>::Iterator it;

	for(it=ports.begin();it != ports.end();++it)
	{
		const char **conns=jack_port_get_connections((*it)->port);
		if(conns)
		{
			int idx=0;
			while(conns[idx])
			{
				jack_disconnect(j_client, (*it)->name(), conns[idx]);
				++idx;
			}
			free(conns);
		}
		jack_port_unregister(j_client, (*it)->port);
	}

	if(j_client)
	{
		jack_deactivate(j_client);
		jack_client_close(j_client);
		j_client=0;
	}
}

QString Client::name()
{
	return Name;
}

int Client::process(jack_nframes_t frames, void *arg)
{
	QValueList<Port *>::Iterator ip;
	Client *cl=(Client *)arg;
	for(ip=cl->ports.begin();ip != cl->ports.end();++ip)
	{
		if((*ip)->j_flags && Port::Clear)
			memset((char *)(*ip)->buffer(frames), 0, sizeof(float)*frames);
	}
	QValueList<Processor *>::Iterator it;

	for(it=cl->processors.begin();it != cl->processors.end();++it)
		if((*it)->process(frames, (*it)) != 0)
			return 1;
	return 0;
}

int Client::rate()
{
	return (int)j_rate;
}

jack_client_t *Client::client()
{
	return j_client;
}

void Client::addProcessor(Processor *p)
{
	if(processors.find(p) != processors.end())
		return;
	processors.append(p);
}

void Client::removeProcessor(Processor *p)
{
	if(processors.find(p) == processors.end())
		return;
	processors.remove(processors.find(p));
}

void Client::addPort(Port *p)
{
	if(ports.find(p) == ports.end())
		ports.append(p);
	checkPortConnections();
}

void Client::removePort(Port *p)
{
	QValueList<Port *>::Iterator it=ports.find(p);
	if(it == ports.end())
		return;
	ports.remove(it);
}

Port::Port(Client *c, QString base, int num, Type t, Flags f)
{
	j_client=c;
	j_type=t;
	j_flags=f;
	static char name[128];

	QString ShortName;
	if(num != -1)
		ShortName.sprintf("%s%d", (const char *)base, num);
	else
		ShortName=base;
	int flags=0;
	switch(t)
	{
	case Null:
		break;
	case Input:
		flags=JackPortIsInput;
		break;
	case Output:
		flags=JackPortIsOutput;
		break;
	default:
		break;
	}
	if(!flags)
		return;
	
	strcpy(name, ShortName);
	port=jack_port_register(j_client->client(), name, JACK_DEFAULT_AUDIO_TYPE, flags, 0);

	if(!port)
		printf("Could not allocate port\n");
	else
		j_client->addPort(this);
}

Port::~Port()
{
	if(port)
		jack_port_unregister(j_client->client(), port);
	j_client->removePort(this);
}

Port::Type Port::type()
{
	return j_type;
}

QString Port::name()
{
	return (QString)jack_port_name(port);
}

Client *Port::client()
{
	return j_client;
}

void Port::connect(Port *p)
{
	connect(p->name());
}

void Port::connect(QString to)
{
	switch(j_type)
	{
	case Output:
		jack_connect(j_client->client(), name(), to);
		break;
	case Input:
		jack_connect(j_client->client(), to, name());
		break;
	default:
		break;
	}
}

void Port::disconnect(QString to)
{
	switch(j_type)
	{
	case Output:
		jack_disconnect(j_client->client(), name(), to);
		break;
	case Input:
		jack_disconnect(j_client->client(), to, name());
		break;
	default:
		break;
	}
}

void *Port::buffer(jack_nframes_t frames)
{
	return jack_port_get_buffer(port, frames);
}

Processor::Processor()
{
}

Processor::~Processor()
{
}

int Processor::process(jack_nframes_t frames, void *arg)
{
	return 1;
}

void Client::port_registration_callback(jack_port_id_t i_port, int add, void *arg)
{
	Client *client=(Client *)arg;

	if(add)
	{
		jack_port_t *port=jack_port_by_id(client->j_client, i_port);
		if(jack_port_is_mine(client->j_client, port))
			return;
		Portinfo info;
		info.id=i_port;
		info.name=jack_port_name(port);
		if(jack_port_flags(port) & JackPortIsInput)
		{
			client->in_ports.append(info);
		}
		else
		{
			client->out_ports.append(info);
		}
		client->checkPortConnections();
	}
	else
	{
		jack_port_t *port=jack_port_by_id(client->j_client, i_port);
		const char *name=jack_port_name(port);
		QValueList<Portinfo>::Iterator it;
		for(it=client->in_ports.begin();it!=client->in_ports.end();++it)
			if((*it).id == i_port)
				client->in_ports.remove(it);
		for(it=client->out_ports.begin();it!=client->out_ports.end();++it)
			if((*it).id == i_port)
				client->out_ports.remove(it);
	}
}

void Client::checkPortConnections()
{
	QValueList<Port *>::Iterator it;
	QValueList<Portinfo>::Iterator i3;

	for(it=ports.begin();it!=ports.end();++it)
	{
		QString val=config->getValue((*it)->name(), "");
		if(val == "")
			continue;
		QStringList sl=QStringList::split("=", val);
		QStringList::Iterator i2;
		for(i2=sl.begin();i2 != sl.end();++i2)
		{
			if(jack_port_connected_to((*it)->port, (*i2)))
				continue;
			(*it)->connect((*i2));
		}
	}
	for(i3=out_ports.begin();i3 != out_ports.end();++i3)
	{
		QString val=config->getValue((*i3).name, "");
		if(val == "")
			continue;
		QStringList sl=QStringList::split("=", val);
		QStringList::Iterator i2;
		for(i2=sl.begin();i2 != sl.end();++i2)
		{
			for(it=ports.begin();it!=ports.end();++it)
			{
				if((*it)->name() == (*i2))
				{
					if(jack_port_connected_to((*it)->port, (*i3).name))
						continue;
					(*it)->connect((*i3).name);
				}
			}
		}
	}
}

void Client::clearPortConnections()
{
	QValueList<Port *>::Iterator it;
	QValueList<Portinfo>::Iterator i3;

	for(it=ports.begin();it!=ports.end();++it)
	{
		QString val=config->getValue((*it)->name(), "");
		if(val == "")
			continue;
		QStringList sl=QStringList::split("=", val);
		QStringList::Iterator i2;
		for(i2=sl.begin();i2 != sl.end();++i2)
		{
			if(!jack_port_connected_to((*it)->port, (*i2)))
				continue;
			(*it)->disconnect((*i2));
		}
	}
	for(i3=out_ports.begin();i3 != out_ports.end();++i3)
	{
		QString val=config->getValue((*i3).name, "");
		if(val == "")
			continue;
		QStringList sl=QStringList::split("=", val);
		QStringList::Iterator i2;
		for(i2=sl.begin();i2 != sl.end();++i2)
		{
			for(it=ports.begin();it!=ports.end();++it)
			{
				if((*it)->name() == (*i2))
				{
					if(!jack_port_connected_to((*it)->port, (*i3).name))
						continue;
					(*it)->disconnect((*i3).name);
				}
			}
		}
	}
}
