/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DSYSLOG_EVENT_INCLUDE_RECURSION_GUARD
#define __DSYSLOG_EVENT_INCLUDE_RECURSION_GUARD

/* A syslog event. */
typedef struct {
	gulong uid;				/* a message id ... doesn't repeat too often */
	gint logcode;				/* syslog-style logcode, if -1, ignored */
	gchar *datestamp;			/* syslog-style datestamp */
	gchar *source;				/* source of message */
	gchar *program;				/* program sending message */
	gchar *message;				/* message */
} dsyslog_event_t;

extern void dsyslog_event_dispatch(gint logcode, gchar *datestamp, gchar *source, gchar *program, gchar *message);
extern void dsyslog_event_delete(dsyslog_event_t *event);
extern void dsyslog_event_init(void);

#endif
