#include <sys/signal.h>
#include <unistd.h>
#include <iostream>

#include "dvr.h"
#include "conf_analysis_yy.h"

DVR my_dvr;

void printStatistics() {
  cerr<<"Statistics :"<<endl;
  cerr<<"  number of elapsed frames : "<<my_dvr.nbFramesElapsed()<<endl;
  cerr<<"  number of stored frames : "<<my_dvr.nbFramesStored()<<endl;
  cerr<<"  number of frames lost in capture : "<<my_dvr.nbFramesLostInCapture()<<endl;
  cerr<<"  number of frames lost in encoding : "<<my_dvr.nbFramesLostInEncoding()<<endl;
}

void signalHandler(int) {
  my_dvr.stopRecording();
  cerr<<"Record ended by the user."<<endl;
  printStatistics();
  exit(0);
}

int main(int argc, char **argv) {
    
  if(argc!=2) {
    cerr<<"usage : "<<argv[0]<<" <config_file_name>"<<endl;
    cerr<<"available parameters are :"<<endl;
    my_dvr.listParameters();
    return 1;
  }

  FILE *f=fopen(argv[1], "r");
  if(!f) {
    cerr<<"Unable to open file : "<<argv[1]<<endl;
    return 1;
  }

  bool param_ok=false;
  yyin=f;
  while(yylex() != 0) {
    if(token_type==TOKEN_SECTION) {
      if(string(section_name)=="Recording") {
        param_ok=true;
      } else {
        param_ok=false;
      }
    }
      
    if(token_type==TOKEN_PARAMETER && param_ok) {
      my_dvr.setParameter(parameter_name, parameter_value);
      cerr<<"added parameter <"<<parameter_name<<"> with value '"<<parameter_value<<"'"<<endl;
    }
  }

  signal(SIGINT, signalHandler);
  signal(SIGTERM, signalHandler);

  if(!my_dvr.initialize()) {
    cerr<<"DVR encountered an error : "<<my_dvr.errorMessage()<<endl;
    return 1;
  }


  my_dvr.startRecording();
  if(!my_dvr.isGood()) {
    cerr<<"DVR encountered an error : "<<my_dvr.errorMessage()<<endl;
    return 1;
  }

  while(my_dvr.getStatus()==DVR::DVR_RECORDING) {
    sleep(1);
  }
      
  my_dvr.stopRecording();
  if(!my_dvr.isGood()) {
    cerr<<"DVR encountered an error : "<<my_dvr.errorMessage()<<endl;
  }

  printStatistics();
  
  return 0;
}
