#ifndef V4L_H
#define V4L_H

#include "linux/videodev.h"

#define DEBUG_OUTPUT(res, text) if(res==-1) { cerr<<__FILE__<<":"<<__LINE__<<" : "; if(text) { cerr<<text<<" : "<<strerror(errno)<<endl; } else { cerr<<strerror(errno)<<endl;}  }

#include <string>
#include <vector>

using namespace std;

class V4LDevice {
public:
  string file_name;
  string name;
};

class V4L {
public:
  enum PixelFormat { PX_RGB565, PX_RGB24, PX_YUV420P };

protected:

  int v4lfd;
  int sem_id;
  int current_frame;
  
  string v4l_file_name;
  struct video_capability vcap; // capabilities of the video device
  vector<video_channel> vchan;  // list of video channels
  vector<video_audio> achan;  // list of audio channels
  
  struct video_mmap *vgrab;   // description of each frame (dimension and format)
  struct video_buffer vbuf;     // description of the video buffer (address, dimension, depth, ...)
  struct video_mbuf vmbuf;      // description of video buffers mapping (total size, frame offsets, ...)
  struct video_window vwind;    // description of the overlay video window (location, dimension)
  struct video_picture vpic;    // description of the video picture (palette, hue, brightness, ...)

  unsigned char *capture_memory; // base address of frame data
  int capture_memory_size; // base address of frame data

  PixelFormat pixel_format;
  unsigned int current_video_channel;
  unsigned int current_audio_channel;
  bool video_preview_enabled;


private:
  // these functions are not thread safe
  void _setCaptureSize(unsigned int width, unsigned int height);
  void _setCurrentAudioChannel(unsigned int);
  bool _setPixelFormat(PixelFormat pixel_format);
  void _enableAudio(bool on);
  void _enableVideoPreview(bool on);
  void _close();

public:
  // these functions are thread safe
  V4L();
  ~V4L();

  vector<V4LDevice> availableDevicesList();
  
  void open(const char *file_name);
  void close();

  void lock();
  void unlock();

  string deviceFileName();
  string deviceName();

  bool isGood();

  vector<video_channel> &videoChannels();
  unsigned int currentVideoChannel();
  void setCurrentVideoChannel(unsigned int);
  
  vector<video_audio> &audioChannels();
  unsigned int currentAudioChannel();
  void setCurrentAudioChannel(unsigned int);
  
  bool hasVideoPreview();
  void enableVideoPreview(bool on);
  bool isVideoPreviewEnabled();

  void getMinSize(int &width, int &height);
  void getMaxSize(int &width, int &height);

  void getWindowPosition(unsigned int &x, unsigned int &y);
  void getWindowSize(unsigned int &width, unsigned int &height);
  void setWindowPositionSize(unsigned int x, unsigned int y, unsigned int width, unsigned int height);

  unsigned char *captureFrame();
  void setCaptureSize(unsigned int width, unsigned int height);
  void getCaptureSize(unsigned int &width, unsigned int &height, int frame=0);

  bool setPixelFormat(PixelFormat pixel_format);
  PixelFormat pixelFormat();

  bool hasAudio();
  void enableAudio(bool on);
  bool isAudioEnabled();

  bool hasTuner();
  void setTunerFrequency(unsigned long frequency);
  unsigned long tunerFrequency();
};

#endif //V4L_H
