-- $Id: pcicard.vhdl,v 1.7 2009-11-18 17:09:42 potyra Exp $
--
-- Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


library ieee;
use ieee.std_logic_1164.all;
ENTITY pcicard IS
	PORT (
		cbe_n_0 : INOUT std_logic;
		cbe_n_1 : INOUT std_logic;
		cbe_n_2 : INOUT std_logic;
		cbe_n_3 : INOUT std_logic;
		ad_0 : INOUT std_logic;
		ad_1 : INOUT std_logic;
		ad_2 : INOUT std_logic;
		ad_3 : INOUT std_logic;
		ad_4 : INOUT std_logic;
		ad_5 : INOUT std_logic;
		ad_6 : INOUT std_logic;
		ad_7 : INOUT std_logic;
		ad_8 : INOUT std_logic;
		ad_9 : INOUT std_logic;
		ad_10 : INOUT std_logic;
		ad_11 : INOUT std_logic;
		ad_12 : INOUT std_logic;
		ad_13 : INOUT std_logic;
		ad_14 : INOUT std_logic;
		ad_15 : INOUT std_logic;
		ad_16 : INOUT std_logic;
		ad_17 : INOUT std_logic;
		ad_18 : INOUT std_logic;
		ad_19 : INOUT std_logic;
		ad_20 : INOUT std_logic;
		ad_21 : INOUT std_logic;
		ad_22 : INOUT std_logic;
		ad_23 : INOUT std_logic;
		ad_24 : INOUT std_logic;
		ad_25 : INOUT std_logic;
		ad_26 : INOUT std_logic;
		ad_27 : INOUT std_logic;
		ad_28 : INOUT std_logic;
		ad_29 : INOUT std_logic;
		ad_30 : INOUT std_logic;
		ad_31 : INOUT std_logic;
		par : INOUT std_logic;
		frame_n : INOUT std_logic;
		trdy_n : INOUT std_logic;
		irdy_n : INOUT std_logic;
		stop_n : INOUT std_logic;
		devsel_n : INOUT std_logic;
		idsel : IN std_logic;
		perr_n : INOUT std_logic;
		serr_n : INOUT std_logic;
		clk : IN std_logic;
		rst_n : IN std_logic
	);
END ENTITY;

ARCHITECTURE pcicard_impl of pcicard is
	signal bus_addr : std_logic_vector(31 downto 0);

	signal is_addr_valid : std_logic;
	signal is_conf_access : std_logic;
	signal is_own_addr : std_logic;

	-- configuration space address register (10h)
	-- 0: hardwired to 1 (io)
	-- 1: hardwired to 0 (must be 0 for io)
	-- 2-3: hardwired to 0 (want 4 io ports)
	signal conf_addr : std_logic_vector(31 downto 4);
	-- status / command (04h), bit 0
	-- (others: hardwired to 0)
	signal conf_status_io : std_logic;
BEGIN

	decode_conf_access : process(is_addr_valid)
	begin
		if          is_addr_valid = '1'
			and ad_0 = '0' 
			and ad_1 = '0'
			and idsel = '1'
			and cbe_n_1 = '1'
			and cbe_n_2 = '0'
			and cbe_n_3 = '1' then
			
			is_conf_access <= '1';
		else 
			is_conf_access <= '0';
		end if;
	end process;


	decode_own_address : process(is_addr_valid)
	begin
		if	is_addr_valid = '1'
		    and bus_addr(31) = conf_addr(31)
		    and bus_addr(30) = conf_addr(30)
		    and bus_addr(29) = conf_addr(29)
		    and bus_addr(28) = conf_addr(28)
		    and bus_addr(27) = conf_addr(27)
		    and bus_addr(26) = conf_addr(26)
		    and bus_addr(25) = conf_addr(25)
		    and bus_addr(24) = conf_addr(24)
		    and bus_addr(23) = conf_addr(23)
		    and bus_addr(22) = conf_addr(22)
		    and bus_addr(21) = conf_addr(21)
		    and bus_addr(20) = conf_addr(20)
		    and bus_addr(19) = conf_addr(19)
		    and bus_addr(18) = conf_addr(18)
		    and bus_addr(17) = conf_addr(17)
		    and bus_addr(16) = conf_addr(16)
		    and bus_addr(15) = conf_addr(15)
		    and bus_addr(14) = conf_addr(14)
		    and bus_addr(13) = conf_addr(13)
		    and bus_addr(12) = conf_addr(12)
		    and bus_addr(11) = conf_addr(11)
		    and bus_addr(10) = conf_addr(10)
		    and bus_addr(9) = conf_addr(9)
		    and bus_addr(8) = conf_addr(8)
		    and bus_addr(7) = conf_addr(7)
		    and bus_addr(6) = conf_addr(6)
		    and bus_addr(5) = conf_addr(5)
		    and bus_addr(4) = conf_addr(4)
		    and idsel = '0'
		    and cbe_n_3 = '0' -- only act on io
		    and cbe_n_2 = '0' -- only act on io
		    and cbe_n_1 = '1' -- only act on io
		    and conf_status_io = '1' -- io enabled
		    then
			is_own_addr <= '1';
		else
			is_own_addr <= '0';
		end if;
	end process;

	buscycle : process
	begin
		wait on clk, frame_n until clk = '1' and frame_n = '0';
		-- address phase
		bus_addr(31) <= ad_31;
		bus_addr(30) <= ad_30;
		bus_addr(29) <= ad_29;
		bus_addr(28) <= ad_28;
		bus_addr(27) <= ad_27;
		bus_addr(26) <= ad_26;
		bus_addr(25) <= ad_25;
		bus_addr(24) <= ad_24;
		bus_addr(23) <= ad_23;
		bus_addr(22) <= ad_22;
		bus_addr(21) <= ad_21;
		bus_addr(20) <= ad_20;
		bus_addr(19) <= ad_19;
		bus_addr(18) <= ad_18;
		bus_addr(17) <= ad_17;
		bus_addr(16) <= ad_16;
		bus_addr(15) <= ad_15;
		bus_addr(14) <= ad_14;
		bus_addr(13) <= ad_13;
		bus_addr(12) <= ad_12;
		bus_addr(11) <= ad_11;
		bus_addr(10) <= ad_10;
		bus_addr(9) <= ad_9;
		bus_addr(8) <= ad_8;
		bus_addr(7) <= ad_7;
		bus_addr(6) <= ad_6;
		bus_addr(5) <= ad_5;
		bus_addr(4) <= ad_4;
		bus_addr(3) <= ad_3;
		bus_addr(2) <= ad_2;
		bus_addr(1) <= ad_1;
		bus_addr(0) <= ad_0;

		is_addr_valid <= '1';
		-- check if this is our address, if so, pull down trdy_n

		wait on clk until clk='1';
		-- data phase
		
	end process buscycle;
END ARCHITECTURE pcicard_impl;
