/*
 * $Id: cpu_intel_80386.c,v 1.17 2009-06-03 11:34:06 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "chip_intel_80386.h"

#include "cpu_intel_80386.h"

struct cpssp {
	void *chip;
};

void *
cpu_intel_80386_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_host_bus *port_conn
)
{
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));

	cpssp->chip = chip_intel_80386_create(name,
			port_manage,
			port_conn->power,
			port_conn->n_reset,
			port_conn->lint0,
			port_conn->lint1,
			port_conn->smi,
			port_conn->n_ferr,
			port_conn->n_ignne,
			port_conn->a20,
			port_conn->main);

	return cpssp;
}

void
cpu_intel_80386_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	chip_intel_80386_destroy(cpssp->chip);

	free(cpssp);
}
