/*
 * $Id: fau-camera-adapter-test.c,v 1.5 2010-12-10 11:02:10 vrsieh Exp $
 *
 * Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "fau-camera-adapter.h"

int
main(void)
{
	int fd;
	struct fau_camera_adapter_geometry info;
	unsigned char buf[3 * 1920 * 1080];
	unsigned int x;
	unsigned int y;
	unsigned int n;
	int ret;

	fprintf(stderr, "open(\"/dev/fau-camera-adapter0\", O_RDONLY)\n");
	fd = open("/dev/fau-camera-adapter0", O_RDONLY);
	fprintf(stderr, "-> %d\n", fd);
	assert(0 <= fd);

	fprintf(stderr, "ioctl(%d, FAU_CAMERA_ADAPTER_GET_GEOMETRY, &info)\n", fd);
	ret = ioctl(fd, FAU_CAMERA_ADAPTER_GET_GEOMETRY, &info);
	fprintf(stderr, "-> %d\n", ret);
	fprintf(stderr, "-> width=%u\n", info.width);
	fprintf(stderr, "-> height=%u\n", info.height);
	assert(0 <= ret);
	assert(0 < info.width && info.width <= 1920);
	assert(0 < info.height && info.height <= 1080);

	fprintf(stderr, "read(%d, %p, %d)\n", fd, buf, 3 * info.width * info.height);
	ret = read(fd, buf, 3 * info.width * info.height);
	fprintf(stderr, "-> %d\n", ret);
	assert(ret == 3 * info.width * info.height);

	fprintf(stderr, "close(%d)\n", fd);
	ret = close(fd);
	fprintf(stderr, "-> %d\n", ret);
	assert(0 <= ret);

	printf("Got image %dx%d\n", info.width, info.height);

	n = 0;
	for (y = 0; y < info.height; y++) {
		for (x = 0; x < info.width; x++) {
			unsigned int col;
			char c;

			col = buf[n+0] + buf[n+1] + buf[n+2];
			col /= 3;
			if (col < 256 * 1 / 4) {
				c = ' ';
			} else if (col < 256 * 2 / 4) {
				c = '.';
			} else if (col < 256 * 3 / 4) {
				c = 'o';
			} else {
				c = 'O';
			}
			printf("%c", c);
			n += 3;
		}
		printf("\n");
	}

	return 0;
}
