/*
 * $Id: media_gen_dvd_gui_gtk.c,v 1.5 2012-02-29 12:08:50 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "system.h"
#include "glue-gui.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-fi.h"
#include "glue.h"

#include "sig_boolean.h"
#include "media_gen_dvd_gui_gtk.h"

#define COMP		"media_gen_dvd"
#define COMP_(x)	media_gen_dvd_ ## x

#define PMA_SIZE	(60*75)
#define TOC_SIZE	(60*75)

struct cpssp {
	char name[1024];

	int32_t size;

	GtkWidget *gui_fi;

	int comp_id;

	struct {
		uint32_t blkno;
		unsigned int val;

		int sig_id;
		struct sig_boolean *sig_ptr;
	} fault[256];
	unsigned int nfaults;
};

/*
 * Simulator Callbacks
 */

/*
 * GUI Callbacks
 */
static void
COMP_(gui_gtk_block_fault_event)(
	GtkWidget *w,
	gpointer _fault,
	gpointer _cpssp
)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = _fault;
	struct cpssp *cpssp = _cpssp;

	int32_t blkno;
	unsigned int i;

	blkno = strtol(fault->loc0[0], NULL, 0);

	for (i = 0; ; i++) {
		if (i == cpssp->nfaults) {
			/* Not Found */
			char path[1024];
			char port[256];

			cpssp->fault[i].blkno = blkno;

			snprintf(path, sizeof(path) - 1, "%s:fault%u", cpssp->name, i);
			path[sizeof(path) - 1] = '\0';
			cpssp->fault[i].sig_id = system_sig_create("boolean", path);
			assert(0 <= cpssp->fault[i].sig_id);
			cpssp->fault[i].sig_ptr = system_sig_get(cpssp->fault[i].sig_id);
			assert(cpssp->fault[i].sig_ptr);

			sprintf(port, "block_fault/%u", blkno);
			system_comp_connect(cpssp->comp_id, port,
					cpssp->fault[i].sig_id);

			cpssp->nfaults++;
			break;
		}
		if (cpssp->fault[i].blkno == blkno) {
			/* Found */
			break;
		}
	}
	assert(cpssp->fault[i].sig_ptr);

	sig_boolean_set(cpssp->fault[i].sig_ptr, cpssp, fault->state);

	free(fault);
}

void *
COMP_(gui_gtk_create)(
	unsigned int page,
	const char *name,
	const char *media,
	const char *size,
	const char *iso,
	const char *cue,
	struct sig_manage *port_manage,
	struct sig_magneto_optical *port_connect
)
{
	struct cpssp *cpssp;
	GtkWidget *w;

	if (! media) media = "DVD-RW";
	if (! size) size = "360000"; /* 80*60*75 */

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	system_name_push(name);

	strcpy(cpssp->name, system_path());
	
	cpssp->comp_id = system_comp_lookup(cpssp->name);
	assert(0 <= cpssp->comp_id);

	cpssp->size = atoi(size);

	cpssp->gui_fi = gtk_vbox_new(FALSE, 1);

	w = gui_gtk_fi_pattern_new(
		"Block Fault", "Boolean",
		1, "Block",
		-(unsigned long long) (PMA_SIZE + TOC_SIZE),
		(unsigned long long) cpssp->size - 1,
		NULL, 0);
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(COMP_(gui_gtk_block_fault_event)),
			cpssp);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->gui_fi), w, FALSE, FALSE, 1);

	gui_gtk_comp_add(page, COMP, name, NULL, FALSE, FALSE, cpssp->gui_fi);

	cpssp->nfaults = 0;

	system_name_pop();

	return cpssp;
}

void
COMP_(gui_gtk_destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(gui_gtk_suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
COMP_(gui_gtk_resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	GtkWidget *savegui_fi = cpssp->gui_fi;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
	
	cpssp->gui_fi = savegui_fi;
	
	fprintf(stdout, "\t\t\ttoDo: Handle GtkWidget gui_fi and faults\n");
}
