# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.

from __future__ import unicode_literals

import string

makefileTemplate = """# THIS FILE IS AUTOGENERATED BY ${caller} - DO NOT EDIT

DEPTH := @DEPTH@

topsrcdir := @top_srcdir@
srcdir := @srcdir@
VPATH := @srcdir@
relativesrcdir := @relativesrcdir@

include $$(DEPTH)/config/autoconf.mk

${dirs}

${files}

include $$(topsrcdir)/config/rules.mk
"""

def makefileString(entries):
  if not len(entries):
    return "  $(NULL)"
  return "\n".join(["  %s \\" % (entry, ) for entry in entries]) + "\n  $(NULL)"

def assignList(variable, entries):
  return "%s := \\\n%s" % (variable, makefileString(entries))

def substMakefile(caller, subdirs, files):
  return string.Template(makefileTemplate).substitute({
    "caller": caller,
    "dirs": assignList("DIRS", subdirs),
    "files": assignList("MOCHITEST_FILES", files) if files else ""
  })
