# lint_ignore=E501
config = {
    "shipped-locales-url": "https://hg.mozilla.org/%(repo)s/raw-file/%(revision)s/browser/locales/shipped-locales",
    "products": {
        "installer": {
            "product-name": "Abrowser-%(version)s",
            "ssl-only": True,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/abrowser/releases/%(version)s/linux-i686/:lang/abrowser-%(version)s.tar.bz2",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/abrowser/releases/%(version)s/linux-x86_64/:lang/abrowser-%(version)s.tar.bz2",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/abrowser/releases/%(version)s/mac/:lang/Abrowser%%20%(version)s.dmg",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/abrowser/releases/%(version)s/win32/:lang/Abrowser%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win",
                },
                "opensolaris-i386": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.opensolaris-i386.tar.bz2",
                    "bouncer-platform": "opensolaris-i386",
                },
                "opensolaris-sparc": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.opensolaris-sparc.tar.bz2",
                    "bouncer-platform": "opensolaris-sparc",
                },
                "solaris-i386": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.solaris-i386.tar.bz2",
                    "bouncer-platform": "solaris-i386",
                },
                "solaris-sparc": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.solaris-sparc.tar.bz2",
                    "bouncer-platform": "solaris-sparc",
                },
            },
        },
        "installer-ssl": {
            "product-name": "Abrowser-%(version)s-SSL",
            "ssl-only": True,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/abrowser/releases/%(version)s/linux-i686/:lang/abrowser-%(version)s.tar.bz2",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/abrowser/releases/%(version)s/linux-x86_64/:lang/abrowser-%(version)s.tar.bz2",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/abrowser/releases/%(version)s/mac/:lang/Abrowser%%20%(version)s.dmg",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/abrowser/releases/%(version)s/win32/:lang/Abrowser%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win",
                },
                "opensolaris-i386": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.opensolaris-i386.tar.bz2",
                    "bouncer-platform": "opensolaris-i386",
                },
                "opensolaris-sparc": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.opensolaris-sparc.tar.bz2",
                    "bouncer-platform": "opensolaris-sparc",
                },
                "solaris-i386": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.solaris-i386.tar.bz2",
                    "bouncer-platform": "solaris-i386",
                },
                "solaris-sparc": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.solaris-sparc.tar.bz2",
                    "bouncer-platform": "solaris-sparc",
                },
            },
        },
        "stub-installer": {
            "product-name": "Abrowser-%(version)s-stub",
            "ssl-only": True,
            "add-locales": True,
            "paths": {
                "win32": {
                    "path": "/abrowser/releases/%(version)s/win32/:lang/Abrowser%%20Setup%%20Stub%%20%(version)s.exe",
                    "bouncer-platform": "win",
                },
            },
        },
        "complete-mar": {
            "product-name": "Abrowser-%(version)s-Complete",
            "ssl-only": False,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/abrowser/releases/%(version)s/update/linux-i686/:lang/abrowser-%(version)s.complete.mar",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/abrowser/releases/%(version)s/update/linux-x86_64/:lang/abrowser-%(version)s.complete.mar",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/abrowser/releases/%(version)s/update/mac/:lang/abrowser-%(version)s.complete.mar",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/abrowser/releases/%(version)s/update/win32/:lang/abrowser-%(version)s.complete.mar",
                    "bouncer-platform": "win",
                },
                "opensolaris-i386": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.opensolaris-i386.complete.mar",
                    "bouncer-platform": "opensolaris-i386",
                },
                "opensolaris-sparc": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.opensolaris-sparc.complete.mar",
                    "bouncer-platform": "opensolaris-sparc",
                },
                "solaris-i386": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.solaris-i386.complete.mar",
                    "bouncer-platform": "solaris-i386",
                },
                "solaris-sparc": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(version)s.en-US.solaris-sparc.complete.mar",
                    "bouncer-platform": "solaris-sparc",
                },
            },
        },
    },
    "partials": {
        "releases-dir": {
            "product-name": "Abrowser-%(version)s-Partial-%(prev_version)s",
            "ssl-only": False,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/abrowser/releases/%(version)s/update/linux-i686/:lang/abrowser-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/abrowser/releases/%(version)s/update/linux-x86_64/:lang/abrowser-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/abrowser/releases/%(version)s/update/mac/:lang/abrowser-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/abrowser/releases/%(version)s/update/win32/:lang/abrowser-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "win",
                },
                "opensolaris-i386": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(prev_version)s-%(version)s.en-US.opensolaris-i386.partial.mar",
                    "bouncer-platform": "opensolaris-i386",
                },
                "opensolaris-sparc": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(prev_version)s-%(version)s.en-US.opensolaris-sparc.partial.mar",
                    "bouncer-platform": "opensolaris-sparc",
                },
                "solaris-i386": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(prev_version)s-%(version)s.en-US.solaris-i386.partial.mar",
                    "bouncer-platform": "solaris-i386",
                },
                "solaris-sparc": {
                    "path": "/abrowser/releases/%(version)s/contrib/solaris_tarball/abrowser-%(prev_version)s-%(version)s.en-US.solaris-sparc.partial.mar",
                    "bouncer-platform": "solaris-sparc",
                },
            },
        },
    },
}
