// GTK_GPCVIEW_WND.CPP

// Copyright (C) 2006 Tommi Hassinen.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#include "gtk_gpcview_wnd.h"

#include "gpcview_wcl.h"
#include "gtk_app.h"

/*################################################################################################*/

GtkActionEntry gtk_gpcview_wnd::entries[] =
{
	{ "AttachDetachGPC", NULL, "Attach/Detach This View", NULL, "Select whether this view is attached or in an independent window", (GCallback) gtk_gpcview_wnd::popup_AttachDetach },
	{ "DeleteViewGPC", NULL, "Delete View", NULL, "Delete this view", (GCallback) gtk_gpcview_wnd::popup_DeleteView }
};

const char * gtk_gpcview_wnd::ui_description =
"<ui>"
"  <popup name='ggpcvMenu'>"
"    <menuitem action='AttachDetachGPC'/>"
"    <separator/>"
"    <menuitem action='DeleteViewGPC'/>"
"  </popup>"
"</ui>";

gtk_gpcview_wnd::gtk_gpcview_wnd(bool det_flag) :
	gtk_wnd(det_flag)
{
	GtkActionGroup * action_group = gtk_action_group_new("ggpcvActions");
	gtk_action_group_add_actions(action_group, entries, G_N_ELEMENTS(entries), GTK_WIDGET(view_widget));
	
	gtk_ui_manager_insert_action_group(gtk_app::GetUIManager(), action_group, 0);
	
	GError * error = NULL;
	if (!gtk_ui_manager_add_ui_from_string(gtk_app::GetUIManager(), ui_description, -1, & error))
	{
		g_message("Building ggpcv menu failed : %s", error->message);
		g_error_free(error); exit(EXIT_FAILURE);
	}
	
	// set gtk_view::popupmenu so that gtk_ogl_view::ButtonHandler() will display it...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	popupmenu = gtk_ui_manager_get_widget(gtk_app::GetUIManager(), "/ggpcvMenu");
}

gtk_gpcview_wnd::~gtk_gpcview_wnd(void)
{
}

// here are the popup menu callbacks:
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

void gtk_gpcview_wnd::popup_AttachDetach(GtkWidget *, gpointer data)
{
	gtk_wnd * wnd = iv_Find((GtkWidget *) data);
	gpcview_wcl * wcl = dynamic_cast<gpcview_wcl *>(wnd->GetClient());
	
	gtk_app::GetAppX()->AttachDetachView(wcl);
}

void gtk_gpcview_wnd::popup_DeleteView(GtkWidget *, gpointer data)
{
	gtk_wnd * wnd = iv_Find((GtkWidget *) data);
	gpcview_wcl * wcl = dynamic_cast<gpcview_wcl *>(wnd->GetClient());
	
	gtk_app::GetPrjX()->RemovePlottingClient(wcl);
}

/*################################################################################################*/

// eof
