/*
*  
*  $Id: comandogenerarthumbnails.h 3571 2011-03-21 09:51:24Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/icomando.h>
#include <api/api.h>

class wxImage;

namespace GADAPI {
	class ComandoGenerarThumbnailsParams;

	class EXTAPI INotificadorThumbnail
	{
	public:
		INotificadorThumbnail(){};
		~INotificadorThumbnail(){};
		virtual void SetImage(const std::string& ruta, wxImage* pImage) = 0;
	};

	class EXTAPI ComandoGenerarThumbnails : public GNC::GCS::IComando {
	public:
		ComandoGenerarThumbnails(const std::string& ruta, INotificadorThumbnail* pNotificador);

		wxImage* GetImage();

    protected:
		void Execute();
		void Update();

	protected:
		wxImage* GetImageFromBD();
		void GuardarImagen();

		ComandoGenerarThumbnailsParams* m_pThumbParams;
		bool                            m_Error;

	};
}
