/*
*  
*  $Id: iherramientaslider.h 4400 2011-11-11 12:52:23Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/iherramienta.h>
#include "icontratoscore.h"
#include "iherramientascore.h"


namespace GNC {
	namespace GCS {

		class EXTAPI IHerramientaSlider: public IHerramienta, public IContratable<IContratoWidgets>, public IContratable<IContratoSlider> {
		public:
			typedef IContratoWidgets               TContratoWidgets;
			typedef IContratoSlider                TContratoSlider;
			typedef IContratable<TContratoWidgets> TContratableWidgets;
			typedef IContratable<TContratoSlider>  TContratableSlider;

			static const IHerramienta::UID ID = HCore_Slider;
			IHerramientaSlider() : IHerramienta(HCore_Slider,TFamiliaVisualizacion, "CoreSlider") {};
			virtual ~IHerramientaSlider() {};

			virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

			virtual void ConectarContratos(bool) = 0;

			virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
				return TContratableWidgets::ValidaContrato(pVista) && TContratableSlider::ValidaContrato(pVista);
			}
			
		};
	}
}
