/*
 *
 *  $Id: controladorhistorial.cpp 4404 2011-11-15 09:41:03Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "controladorhistorial.h"
#include <api/iproxynotificadorprogreso.h>
#include <api/dicom/idicommanager.h>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/msgdlg.h>

#include <api/icontextoestudio.h>

#include "pacscontroller.h"
#include "controladoreventos.h"
#include <eventos/eventosginkgo.h>
#define LOGGER "ControladorHistorial"
#include "controladorlog.h"
#include <sqlite/ginkgosqlite.h>
#include "controladorcomandos.h"
#include <commands/comandoincluirhistorial.h>

#include <main/entorno.h>
#include <sstream>
#include <cmath>

//region "Patron singleton"
GNC::GCS::ControladorHistorial* GNC::GCS::ControladorHistorial::m_pInstance = 0;

GNC::GCS::ControladorHistorial::ControladorHistorial()
{
	m_pConexion = NULL;
	m_pConexionThumbnails = NULL;
	m_pCriticalSection = new wxCriticalSection();
	RecargarHistorial();
}

void GNC::GCS::ControladorHistorial::RecargarHistorial()
{
	bool reloadHistory = false;
	if(m_pConexion!=NULL) {
		m_pConexion->Close();
		delete m_pConexion;
		m_pConexion = NULL;
	}
	if(m_pConexionThumbnails!=NULL) {
		m_pConexionThumbnails->Close();
		delete m_pConexionThumbnails;
		m_pConexionThumbnails = NULL;
	}

	try {
		m_pConexion = new wxSQLite3Database();
		m_pConexionThumbnails = new wxSQLite3Database();
		//pillamos la bbdd
		std::string pathFicheroDB;
		std::string pathFicheroDBThumbnails;
		{
			std::ostringstream ostr;
			ostr << GNC::Entorno::Instance()->GetGinkgoDicomDir()  << (char)wxFileName::GetPathSeparator(wxPATH_NATIVE) << "ginkgodatabase_2.1.db";
			pathFicheroDB = ostr.str();
		}
		{
			std::ostringstream ostr;
			ostr << GNC::Entorno::Instance()->GetGinkgoDicomDir() << (char)wxFileName::GetPathSeparator(wxPATH_NATIVE) << "ginkgothumbnails.db";
			pathFicheroDBThumbnails = ostr.str();
		}

		wxString wxDirectorio = FROMPATH(GNC::Entorno::Instance()->GetGinkgoDicomDir());
		bool correcto = true;
		if(!wxDirExists(wxDirectorio)){
#ifdef _WIN32
			correcto = wxMkdir(wxDirectorio,511);
#else
			correcto = wxMkDir(wxDirectorio.ToUTF8(), 0770) == -1? false : true;
#endif
			if(!correcto){
				GINKGOLOGERROR("Error al crear el dicom Dir " << wxDirectorio.ToUTF8())
					//se escribe en tmp...
					wxMessageBox(_("You do not have permissions to write to the dicom Dir, preferences will be stored in the temporary directory"), _("Info"),
					wxOK | wxICON_WARNING);
				{
					std::ostringstream ostr2;
					ostr2 << GNC::Entorno::Instance()->GetGinkgoTempDir() << (char)wxFileName::GetPathSeparator(wxPATH_NATIVE) << "ginkgodatabase_2.1.db"<<std::ends;
					pathFicheroDB = ostr2.str();
				}
				{
					std::ostringstream ostr2;
					ostr2 << GNC::Entorno::Instance()->GetGinkgoTempDir() << (char)wxFileName::GetPathSeparator(wxPATH_NATIVE) << "ginkgothumbnails.db"<<std::ends;
					pathFicheroDBThumbnails = ostr2.str();
				}
			}
		}

		//existe el historial??
		if(!wxFileExists(FROMPATH(pathFicheroDB))) {
			//se crea el fichero de base de datos
			if(CreateGinkgoDB(*m_pConexion,pathFicheroDB.c_str()) == 0)
			{
				GINKGOLOGERROR("Error al crear el la bbdd del historial ")
			}
		} 

		if(!m_pConexion->IsOpen()) {
			if( !AbrirConexion(*m_pConexion,pathFicheroDB.c_str()) ){
				GINKGOLOGFATAL("Error al crear el la bbdd del historial "<<pathFicheroDB)
					wxMessageBox(_("Fatal error, can not write the history database"), _("Info"),
					wxOK | wxICON_WARNING);
			} else {
				//check version
				reloadHistory = CheckReloadGinkgoDBVersion(*m_pConexion);
			}
		}

		//existe el d los thumbnails??
		if(!wxFileExists(FROMPATH(pathFicheroDBThumbnails))) {
			//se crea el fichero de base de datos
			if(CreateGinkgoDBThumbnails(*m_pConexionThumbnails,pathFicheroDBThumbnails.c_str()) == 0)
			{
				GINKGOLOGERROR("Error al crear el la bbdd de thumbnails ")
			}
		}

		if(!m_pConexionThumbnails->IsOpen()) {
			if( !AbrirConexion(*m_pConexionThumbnails,pathFicheroDBThumbnails.c_str()) ){
				GINKGOLOGFATAL("Error al crear el la bbdd de thumbnails "<<pathFicheroDBThumbnails)
			}
		}

		if(m_pConexion->IsOpen() && m_pConexionThumbnails->IsOpen()){
			PurgarHistorial();
		}

		if (reloadHistory) 
		{
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventHideSplashWindow());
			wxMessageBox(_("Version of Ginkgo CADx dicom dir is old, database will be migrated to new version, do not close Ginkgo CADx until migration is finished"), _("Warning"), wxOK|wxICON_WARNING);
			m_pConexion->Close();			
			if (wxCopyFile(FROMPATH(pathFicheroDB), FROMPATH(pathFicheroDB)+wxT(".bkp"),true)) {
				if (wxRemoveFile(FROMPATH(pathFicheroDB))) {
					if(CreateGinkgoDB(*m_pConexion,pathFicheroDB.c_str()) != 0) {
						std::string historyPath = GNC::Entorno::Instance()->GetGinkgoDicomDir();
						GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams* pParams = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams(historyPath, true, true);
						GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial* pCmd = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial(pParams);
						GNC::GCS::ControladorComandos::Instance()->ProcessAsync("Migrating History", pCmd, NULL);
					} else {
						GINKGOLOGERROR("Error creating ginkgo BBDD")
					}
				} else {
					GINKGOLOGFATAL("Error copying database file "<<pathFicheroDB)
				}
			} else {
				GINKGOLOGFATAL("Error copying database file "<<pathFicheroDB)
			}
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("Error al crear el la bbdd " << ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error creating database:\n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
}

GNC::GCS::ControladorHistorial::~ControladorHistorial()
{
	if(m_pConexion!=NULL) {
		m_pConexion->Close();
		delete m_pConexion;
		m_pConexion = NULL;
	}
	if(m_pConexionThumbnails!=NULL) {
		m_pConexionThumbnails->Close();
		delete m_pConexionThumbnails;
		m_pConexionThumbnails = NULL;
	}
	if(m_pCriticalSection != NULL) {
		delete m_pCriticalSection;
		m_pCriticalSection = NULL;
	}
}

GNC::GCS::ControladorHistorial* GNC::GCS::ControladorHistorial::Instance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new GNC::GCS::ControladorHistorial();
	}
	return m_pInstance;
}

void GNC::GCS::ControladorHistorial::FreeInstance()
{
	if (m_pInstance != NULL) {
		delete m_pInstance;
		m_pInstance = NULL;
	}
}

//region "metodos propios del historial"
bool GNC::GCS::ControladorHistorial::AddFiles(const ListaPaths& listaPaths,ListaModelosDCM& listaModelos, ListaPaths& listaSobreescritos, TAddErrorList& errorList, bool forzarSobreescribir, GNC::IProxyNotificadorProgreso* pNotificador, bool soloLeer, bool mover)
{
	wxCriticalSectionLocker locker(*m_pCriticalSection);
	try {
		m_pConexion->Begin();

		int i = 0;
		for(ListaPaths::const_iterator it=listaPaths.begin(); it!= listaPaths.end(); ++it,++i){
			if(pNotificador != NULL) {
				std::ostringstream ostr;
				ostr << _Std("Including image ") << (i+1) << _Std(" of ") << listaPaths.size();
				if(!pNotificador->NotificarProgreso((float)i/listaPaths.size(),ostr.str()))
				{
					m_pConexion->Commit();
					return false;
				}
			}
			ModeloDCM fichero;

			if(!wxFileExists((FROMPATH((*it))))) {
				errorList.push_back(TAddError(TAddError::TE_FileNotExist, (*it)));
			} 
			else 
			{
				if(!RellenaDCM(fichero,(*it),listaSobreescritos, errorList,forzarSobreescribir,!soloLeer,mover))
				{
					continue;
				}

				if(!ExistePaciente(fichero.m_idPaciente)){
					if(!InsertarPaciente(fichero.m_idPaciente,fichero.m_nombrePaciente,fichero.m_fechaNacimiento,fichero.m_sexo)) {
						GINKGOLOGERROR("Ha ocurrido un error al insertar el paciente con uid "<<fichero.m_idPaciente)
					/*		wxMessageBox(wxT("Ha ocurrido un error al insertar el paciente con uid ")+ wxString::FromUTF8(fichero.m_idPaciente.c_str()), wxT("Info"),
							wxOK | wxICON_WARNING);*/
						m_pConexion->Rollback();
						return false;
					}
				}

				if(!ExisteEstudio(fichero.m_uidEstudio)) {
					if(!InsertarEstudio(fichero.m_uidEstudio,fichero.m_descripcionEstudio,fichero.m_nombreMedico,fichero.m_fechaEstudio,fichero.m_horaEstudio,fichero.m_idPaciente, fichero.m_studyId, fichero.m_accessionNumber)) {
						GINKGOLOGERROR("Ha ocurrido un error al insertar el estudio con uid "<<fichero.m_uidEstudio)
				/*			wxMessageBox(wxT("Ha ocurrido un error al insertar el estudio con uid ")+ wxString::FromUTF8(fichero.m_uidEstudio.c_str()), wxT("Info"),
							wxOK | wxICON_WARNING);*/
						m_pConexion->Rollback();
						return false;
					}
				}

				if(!ExisteSerie(fichero.m_uidSerie)) {
					if(!InsertarSerie(fichero.m_uidSerie,fichero.m_descripcionSerie,fichero.m_fechaSerie,fichero.m_horaSerie,fichero.m_uidEstudio, fichero.m_seriesNumber)) {
						GINKGOLOGERROR("Ha ocurrido un error al insertar la serie con uid "<<fichero.m_uidSerie)
				/*			wxMessageBox(wxT("Ha ocurrido un error al insertar la serie con uid ")+ wxString::FromUTF8(fichero.m_uidSerie.c_str()), wxT("Info"),
							wxOK | wxICON_WARNING);*/
						m_pConexion->Rollback();
						return false;
					}
				}

				if(!ExisteFichero(fichero.m_pathRelativo)) {
					if(!InsertarFichero(fichero.m_pathRelativo,fichero.m_uidImagen,fichero.m_modalidad,fichero.m_descripcionImagen,fichero.m_uidImportador,fichero.m_fechaImagen,fichero.m_horaImagen, fichero.m_uidTransferSyntax,fichero.m_uidSerie, fichero.m_sopClassUID)) {
						GINKGOLOGERROR("Ha ocurrido un error al insertar el fichero con path "<<fichero.m_pathRelativo)
					/*		wxMessageBox(wxT("Ha ocurrido un error al insertar el fichero con path ")+ wxString::FromUTF8(fichero.m_path.c_str()), wxT("Info"),
							wxOK | wxICON_WARNING);*/
						m_pConexion->Rollback();
						return false;
					}
					if (fichero.m_modalidad != "SR")
					{
						//insertamos los tags de ordenacion
						if(!InsertarTagsOrdenacion(fichero.m_pathRelativo,fichero.m_orientacion,fichero.m_patientPosition, fichero.m_sliceLocation, fichero.m_height, fichero.m_width, fichero.m_instanceNumber, fichero.m_contentDate, fichero.m_contentTime)) {
							GINKGOLOGERROR("Ha ocurrido un error al insertar el fichero con path "<<fichero.m_pathRelativo)
						/*		wxMessageBox(wxT("Ha ocurrido un error al insertar el fichero con path ")+ wxString::FromUTF8(fichero.m_path.c_str()), wxT("Info"),
								wxOK | wxICON_WARNING);*/
							m_pConexion->Rollback();
							return false;
						}
					}
					for(std::list<std::string>::iterator it = fichero.m_listaReferencias.begin(); it!= fichero.m_listaReferencias.end(); it++){
						InstertarReferencias(fichero.m_uidImagen, (*it));
					}
				}
				listaModelos.push_back(fichero);
			}
		}
		m_pConexion->Commit();
		return true;
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("Error al anadir el fichero a la base de datos "<<ex.GetMessage().ToUTF8())
			/*wxMessageBox(wxT("Error al anadir el fichero a la base de datos: \n")+ex.GetMessage(), wxT("Info"),
			wxOK | wxICON_WARNING);*/
		m_pConexion->Rollback();
		return false;
	}
}

//region "metodos propios del historial"
bool GNC::GCS::ControladorHistorial::EliminarPaciente(const std::string& idPaciente, bool eliminarDelDisco)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		if(eliminarDelDisco) {
			//primero se pillan todos sus ficheros...
			bufSQL.Format("SELECT DISTINCT Path FROM Ficheros,Series,Estudios "
				"WHERE Ficheros.UIDSerie=Series.UIDSerie AND Series.UIDEstudio = Estudios.UIDEstudio "
				"AND Estudios.IDPaciente = '%q'",idPaciente.c_str());
			wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
			std::list<std::string> listaPaths;
			while (resultados.NextRow()) {
				std::string path(TOPATH(resultados.GetAsString(0)));
				listaPaths.push_back(path);
			}
			EliminarFicherosDisco(listaPaths);
		}

		bufSQL.Format("DELETE FROM Thumbnails WHERE IDPaciente='%q'",idPaciente.c_str());
		m_pConexionThumbnails->ExecuteUpdate(bufSQL);

		bufSQL.Format("DELETE FROM Pacientes WHERE IDPaciente ='%q'",idPaciente.c_str());
		if(m_pConexion->ExecuteUpdate(bufSQL)>0){
			return true;
		} else {
			return false;
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("EliminarPaciente "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error deleting the patient in the database:\n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::EliminarEstudio(const std::string& uidEstudio, bool eliminarDelDisco)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT Path FROM Ficheros,Series "
			"WHERE Ficheros.UIDSerie=Series.UIDSerie AND Series.UIDEstudio = '%q'",uidEstudio.c_str());
		std::list<std::string> listaFicheros;
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			std::string path(TOPATH(resultados.GetAsString(0)));
			listaFicheros.push_back(path);
		}
		return EliminarFicheros(listaFicheros,eliminarDelDisco);
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("EliminarEstudio "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error deleting the Study of database:\n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::DeleteSeriesList(const ListaStrings& uids, bool removeFromDisk)
{
	bool result = true;
	if (uids.size() == 0) {
		return true;
	}
	try {
		std::stringstream ostr;
		wxSQLite3StatementBuffer bufSQL;
		ostr << bufSQL.Format("SELECT DISTINCT Path FROM Ficheros,Series "
			"WHERE");

		bool first = true;
		for (ListaStrings::const_iterator it = uids.begin(); it != uids.end(); ++it) {
			if (!first) {
				ostr << " OR";
			}
			ostr << bufSQL.Format(" Ficheros.UIDSerie = '%q'", (*it).c_str());
			first = false;
		}

		std::list<std::string> listaFicheros;
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(ostr.str().c_str());
		while (resultados.NextRow()) {
			std::string path(TOPATH(resultados.GetAsString(0)));
			listaFicheros.push_back(path);
		}
		result = EliminarFicheros(listaFicheros,removeFromDisk);
		
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("EliminarSerie "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Failed to delete the number of database:\n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
		result = false;
	}
	return result;
}

bool GNC::GCS::ControladorHistorial:: DeleteFilesList(const std::string& patientID, const std::string& studyId, const std::string& seriesID, const ListaStrings& listaSopInstancesUIDS, bool removeFromDisk)
{
	bool result = true;
	try {
		std::stringstream ostr;
		wxSQLite3StatementBuffer bufSQL;
		/*ostr << bufSQL.Format("SELECT DISTINCT Path FROM Ficheros,Series,Estudios "
			"WHERE Estudios.IDPaciente='%q' AND Estudios.UIDEstudio ='%q' AND Series.UIDEstudio = Estudios.UIDEstudio AND Series.UIDSerie = '%q' "
			"AND Ficheros.UIDSerie = Series.UIDSerie AND (", patientID.c_str(), studyId.c_str(), seriesID.c_str());

		bool first = true;
		for (ListaStrings::const_iterator it = listaSopInstancesUIDS.begin(); it != listaSopInstancesUIDS.end(); ++it) {
			if (!first) {
				ostr << " OR";
			}
			ostr << bufSQL.Format(" Ficheros.UIDFichero = '%q'", (*it).c_str());
			first = false;
		}
		ostr << ")";*/
		ostr << bufSQL.Format("SELECT DISTINCT Path FROM Ficheros,Series,Estudios "
			"WHERE Series.UIDEstudio = Estudios.UIDEstudio AND Ficheros.UIDSerie = Series.UIDSerie ");
		if (patientID != "") {
			ostr << bufSQL.Format(" AND Estudios.IDPaciente='%q'",patientID.c_str());
		}
		if (studyId != "") {
			ostr << bufSQL.Format(" AND Estudios.UIDEstudio='%q'",studyId.c_str());
		}
		if (seriesID != "") {
			ostr << bufSQL.Format(" AND Series.UIDSerie = '%q'",seriesID.c_str());
		}

		if (listaSopInstancesUIDS.size() > 0) {
			bool first = true;
			for (ListaStrings::const_iterator it = listaSopInstancesUIDS.begin(); it != listaSopInstancesUIDS.end(); ++it) {
				if (!first) {
					ostr << " OR";
				} else {
					ostr << "AND (";
				}
				ostr << bufSQL.Format(" Ficheros.UIDFichero = '%q'", (*it).c_str());
				first = false;
			}
			ostr << ") ";
		}
		

		std::list<std::string> listaFicheros;
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(ostr.str().c_str());
		while (resultados.NextRow()) {
			std::string path(TOPATH(resultados.GetAsString(0)));
			listaFicheros.push_back(path);
		}
		result = EliminarFicheros(listaFicheros,removeFromDisk);
		
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("DeleteFilesList "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Failed to delete the number of database:\n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
		result = false;
	}
	return result;
}

bool GNC::GCS::ControladorHistorial::EliminarSerie(const std::string& uidSerie, bool eliminarDelDisco)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT Path FROM Ficheros,Series "
			"WHERE Ficheros.UIDSerie= '%q'",uidSerie.c_str());
		std::list<std::string> listaFicheros;
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			std::string path(TOPATH(resultados.GetAsString(0)));
			listaFicheros.push_back(path);
		}
		return EliminarFicheros(listaFicheros,eliminarDelDisco);
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("EliminarSerie "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Failed to delete the number of database:\n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::VaciarHistorial(bool eliminarDelDisco)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		if(eliminarDelDisco) {
			bufSQL.Format("SELECT DISTINCT Path FROM Ficheros");
			wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
			std::list<std::string> listaPaths;
			while (resultados.NextRow()) {
				std::string path(TOPATH(resultados.GetAsString(0)));
				listaPaths.push_back(path);
			}
			EliminarFicherosDisco(listaPaths);
		}
		bufSQL.Format("DELETE FROM Ficheros WHERE Path is not null");
		m_pConexion->ExecuteUpdate(bufSQL);
		bufSQL.Format("DELETE FROM Thumbnails WHERE Path is not null");
		m_pConexionThumbnails->ExecuteUpdate(bufSQL);
		return true;
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("VaciarHistorial "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Failed to empty the history:\n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::EliminarFichero(const std::string& pathAbsolutoFichero, bool eliminarDelDisco)
{
	try {
		std::list<std::string> pathsFicheros;
		pathsFicheros.push_back(GNC::Entorno::Instance()->GetPathRelativoFichero(pathAbsolutoFichero));
		return EliminarFicheros(pathsFicheros,eliminarDelDisco);
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("EliminarFichero "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error deleting file from de database: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::EliminarFicheros(const std::list<std::string>& pathsRelativosFicheros, bool eliminarDeDisco)
{
	wxSQLite3StatementBuffer bufSQL;
	//se cogenma todos los diagnosticos de los ficheros
	if(pathsRelativosFicheros.size()>0){
		std::stringstream ostr1;
		std::list<std::string>::const_iterator it = pathsRelativosFicheros.begin();
		ostr1 << "SELECT DISTINCT f2.Path, f2.UIDFichero FROM Ficheros as f1, ReferenciasFicheros as ref, Ficheros as f2 ";
		ostr1 << "WHERE f1.Path IN ("<< bufSQL.Format("'%q'",(*it).c_str());
		for(++it; it!=pathsRelativosFicheros.end(); ++it) {
			ostr1<<bufSQL.Format(" ,'%q'",(*it).c_str());
		}
		ostr1<<") AND f1.UIDFichero = ref.UIDFicheroDestino AND f2.UIDFichero = ref.UIDFicheroOrigen AND f2.Modalidad='SR'";
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(ostr1.str().c_str());
		std::list<std::string> listaFicheros;
		std::list<std::string> uidsDiagnosticos;
		while (resultados.NextRow()) {
			std::string path(TOPATH(resultados.GetAsString(0)));
			listaFicheros.push_back(path);
			std::string uid(resultados.GetAsString(1).ToUTF8());
			uidsDiagnosticos.push_back(uid);
		}
		for(std::list<std::string>::const_iterator it2 = pathsRelativosFicheros.begin(); it2!= pathsRelativosFicheros.end(); it2++) {
			listaFicheros.push_back((*it2));
		}
		bool correcto = QuitarFicheros(listaFicheros);
		//ahora se buscan los ficheros claves que puedan haber quedado descolgados...
		if(uidsDiagnosticos.size()>0) {
			std::stringstream ostr;
			std::list<std::string>::const_iterator it = uidsDiagnosticos.begin();
			ostr << "Select DISTINCT f1.Path from Ficheros as f1, ReferenciasFicheros as ref1 WHERE f1.UIDFichero IN ";
			ostr <<"( SELECT DISTINCT ref.UIDFicheroOrigen FROM ReferenciasFicheros as ref WHERE ref.UIDFicheroDestino IN (";
			ostr << bufSQL.Format("'%q'",(*it).c_str());
			for(++it; it!=uidsDiagnosticos.end(); ++it) {
				ostr<<bufSQL.Format(" ,'%q'",(*it).c_str());
			}
			ostr<<")) AND f1.UIDFichero = ref1.UIDFicheroOrigen AND ref1.UIDFicheroDestino NOT IN (Select DISTINCT UIDFichero From Ficheros);";
			resultados = m_pConexion->ExecuteQuery(ostr.str().c_str());
			std::list<std::string> pathsDiagnosticosClave;
			while (resultados.NextRow()) {
				std::string path(TOPATH(resultados.GetAsString(0)));
				listaFicheros.push_back(path);
				pathsDiagnosticosClave.push_back(path);
			}
			correcto = correcto && QuitarFicheros(pathsDiagnosticosClave);
		}

		if(eliminarDeDisco) {
			EliminarFicherosDisco(listaFicheros);
		}
		return correcto;
	} else {
		return true;
	}
}

bool  GNC::GCS::ControladorHistorial::QuitarFicheros(const std::list<std::string>& pathsFicheros)
{
	try {
		std::ostringstream ostr;
		wxSQLite3StatementBuffer bufSQL;
		if(pathsFicheros.size()>0) {
			{
				std::ostringstream ostr1;
				std::list<std::string>::const_iterator it = pathsFicheros.begin();
				ostr1 << "DELETE FROM Thumbnails WHERE  Path IN (" << bufSQL.Format("'%q'",(*it).c_str());
				for(++it; it!=pathsFicheros.end(); ++it) {
					ostr1<<bufSQL.Format(" ,'%q'",(*it).c_str());
				}
				ostr1<<");";
				m_pConexionThumbnails->ExecuteUpdate(ostr1.str().c_str());
			}


			std::list<std::string>::const_iterator it = pathsFicheros.begin();
			ostr << "DELETE FROM Ficheros WHERE Path IN (" << bufSQL.Format("'%q'",(*it).c_str());

			for(++it; it!=pathsFicheros.end(); ++it) {
				ostr<<bufSQL.Format(" ,'%q'",(*it).c_str());
			}
			ostr<<");";

			if(m_pConexion->ExecuteUpdate(ostr.str().c_str())>0){
				return true;
			} else {
				return false;
			}
		} else {
			return true;
		}
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("QuitarFicheros "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error deleting file from database:\n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::ExistePaciente(const std::string& idPaciente)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("Select count(*) from Pacientes where IDPaciente = '%q'",idPaciente.c_str());
		if(m_pConexion->ExecuteScalar(bufSQL)>0){
			return true;
		} else {
			return false;
		}
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("ExistePaciente "<<ex.GetMessage().ToUTF8())
			return false;
	}

}


bool GNC::GCS::ControladorHistorial::ExisteEstudio(const std::string& uidEstudio)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("Select count(*) from Estudios where UIDEstudio = '%q'",uidEstudio.c_str());
		if(m_pConexion->ExecuteScalar(bufSQL)>0){
			return true;
		} else {
			return false;
		}
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("ExisteEstudio "<<ex.GetMessage().ToUTF8())
			return false;
	}
}

bool GNC::GCS::ControladorHistorial::ExisteSerie(const std::string& uidSerie)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("Select count(*) from Series where UIDSerie = '%q'",uidSerie.c_str());
		if(m_pConexion->ExecuteScalar(bufSQL)>0){
			return true;
		} else {
			return false;
		}
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("ExisteSerie "<<ex.GetMessage().ToUTF8())
			return false;
	}
}

bool GNC::GCS::ControladorHistorial::ExisteFichero(const std::string& pathRelativoFichero)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("Select count(*) from Ficheros where  Path= '%q'",pathRelativoFichero.c_str());
		if(m_pConexion->ExecuteScalar(bufSQL)>0){
			return true;
		} else {
			return false;
		}
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("ExisteFichero "<<ex.GetMessage().ToUTF8())
			return false;
	}
}

bool GNC::GCS::ControladorHistorial::ReferenciaResuelta(const std::string& uidFichero)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("Select count(*) from Ficheros where  UIDFichero= '%q'",uidFichero.c_str());
		if(m_pConexion->ExecuteScalar(bufSQL)>0){
			return true;
		} else {
			return false;
		}
	} catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("ReferenciaResuelta "<<ex.GetMessage().ToUTF8())
			return false;
	}
}

GNC::GCS::ControladorHistorial::ModeloDCM GNC::GCS::ControladorHistorial::GetModeloDCM(const std::string& pathAbsoluto)
{
	std::string pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero(pathAbsoluto);
	ModeloDCM modelo;
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
			"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.UIDSerie,"
			"Series.Descripcion as DescripcionSeries, Series.SeriesNumber as SeriesNumber,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie,Ficheros.Path, Ficheros.UIDFichero,"
			"Ficheros.Modalidad, Ficheros.Descripcion as DescripcionFichero, Ficheros.UIDImportador, Ficheros.TransferSyntaxUID, Ficheros.SopClassUID, Ficheros.Fecha as FechaFichero, Ficheros.Hora as HoraFichero "
			"FROM Pacientes,Estudios,Series,Ficheros "
			"WHERE Ficheros.Path = '%q' AND Pacientes.IDPaciente = Estudios.IDPaciente AND "
			"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=Ficheros.UIDSerie "
			,pathRelativo.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		if (resultados.NextRow()) {
			modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
			modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
			modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
			modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
			modelo.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
			modelo.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
			modelo.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
			modelo.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
			modelo.m_pathRelativo = resultados.GetAsString(wxT("Path")).ToUTF8();
			modelo.m_uidImagen = resultados.GetAsString(wxT("UIDFichero")).ToUTF8();
			modelo.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
			modelo.m_descripcionImagen = resultados.GetAsString(wxT("DescripcionFichero")).ToUTF8();
			modelo.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
			modelo.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
			modelo.m_sopClassUID = resultados.GetAsString(wxT("SopClassUID")).ToUTF8();
			modelo.m_fechaImagen = resultados.GetAsString(wxT("FechaFichero")).ToUTF8();
			modelo.m_horaImagen= resultados.GetAsString(wxT("HoraFichero")).ToUTF8();
			modelo.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetModeloDCM "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return modelo;
}

void GNC::GCS::ControladorHistorial::GetAllModelosDCMSeries(const std::string& uidSeries, GNC::GCS::ControladorHistorial::ListaModelosDCM& models)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
			"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.UIDSerie,"
			"Series.Descripcion as DescripcionSeries, Series.SeriesNumber as SeriesNumber,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie,Ficheros.Path, Ficheros.UIDFichero,"
			"Ficheros.Modalidad, Ficheros.Descripcion as DescripcionFichero, Ficheros.UIDImportador, Ficheros.TransferSyntaxUID, Ficheros.SopClassUID, Ficheros.Fecha as FechaFichero, Ficheros.Hora as HoraFichero, "
			"TagsFicheros.InstanceNumber as InstanceNumber "
			"FROM Pacientes,Estudios,Series,Ficheros,TagsFicheros "
			"WHERE Series.UIDSerie = '%q' AND Pacientes.IDPaciente = Estudios.IDPaciente AND "
			"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=Ficheros.UIDSerie AND Ficheros.Path = TagsFicheros.Path "
			,uidSeries.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			ModeloDCM model;
			model.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
			model.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
			model.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
			model.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
			model.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			model.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			model.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			model.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			model.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
			model.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
			model.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
			model.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
			model.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
			model.m_pathRelativo = resultados.GetAsString(wxT("Path")).ToUTF8();
			model.m_uidImagen = resultados.GetAsString(wxT("UIDFichero")).ToUTF8();
			model.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
			model.m_descripcionImagen = resultados.GetAsString(wxT("DescripcionFichero")).ToUTF8();
			model.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
			model.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
			model.m_sopClassUID = resultados.GetAsString(wxT("SopClassUID")).ToUTF8();
			model.m_fechaImagen = resultados.GetAsString(wxT("FechaFichero")).ToUTF8();
			model.m_horaImagen= resultados.GetAsString(wxT("HoraFichero")).ToUTF8();
			if (!resultados.GetAsString(wxT("InstanceNumber")).ToDouble(&model.m_instanceNumber)) {
				model.m_instanceNumber = 0.;
			}
			model.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
			model.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			model.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			models.push_back(model);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetAllModelosDCMSeries "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
}

//trhows exception
void GNC::GCS::ControladorHistorial::GetDCMModelSql(const std::string& sql, ListaModelosDCM& dcmList)
{
	wxSQLite3StatementBuffer bufSQL;
	std::ostringstream ostr;
	ostr << bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
		"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.UIDSerie,"
		"Series.Descripcion as DescripcionSeries, Series.SeriesNumber as SeriesNumber,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie,Ficheros.Path, Ficheros.UIDFichero,"
		"Ficheros.Modalidad, Ficheros.Descripcion as DescripcionFichero, Ficheros.UIDImportador, Ficheros.TransferSyntaxUID, Ficheros.SopClassUID, Ficheros.Fecha as FechaFichero, Ficheros.Hora as HoraFichero "
		"FROM Pacientes,Estudios,Series,Ficheros "
		"WHERE Pacientes.IDPaciente = Estudios.IDPaciente AND "
		"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=Ficheros.UIDSerie ");

	if (sql != "") {
		ostr << " AND " << sql.c_str();;
	}

	ostr << " ORDER BY Pacientes.Nombre ASC, Ficheros.Fecha DESC, Ficheros.Hora DESC";

	wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(ostr.str().c_str());
	while (resultados.NextRow()) {
		ModeloDCM modelo;
		modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
		modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
		modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
		modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
		modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
		modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
		modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
		modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
		modelo.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
		modelo.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
		modelo.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
		modelo.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
		modelo.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
		modelo.m_pathRelativo = resultados.GetAsString(wxT("Path")).ToUTF8();
		modelo.m_uidImagen = resultados.GetAsString(wxT("UIDFichero")).ToUTF8();
		modelo.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
		modelo.m_sopClassUID = resultados.GetAsString(wxT("SopClassUID")).ToUTF8();
		modelo.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
		modelo.m_descripcionImagen = resultados.GetAsString(wxT("DescripcionFichero")).ToUTF8();
		modelo.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
		modelo.m_fechaImagen = resultados.GetAsString(wxT("FechaFichero")).ToUTF8();
		modelo.m_horaImagen= resultados.GetAsString(wxT("HoraFichero")).ToUTF8();
		modelo.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
		modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
		modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
		dcmList.push_back(modelo);
	}
}

void GNC::GCS::ControladorHistorial::GetModelosSeriePacienteModalidad(const std::string& idPaciente, const std::string& modalidad, const wxDateTime& from, const wxDateTime& to, const std::string& timeFrom, const std::string& timeTo, ListaModelosSeries& listaModelos)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		std::ostringstream ostr;
		ostr << bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
			"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.UIDSerie,"
			"Series.Descripcion as DescripcionSeries, Series.SeriesNumber as SeriesNumber,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie, "
			"Ficheros.Modalidad, Ficheros.UIDImportador, Ficheros.TransferSyntaxUID, count(*) as NumeroSlices "
			"FROM Pacientes,Estudios,Series,Ficheros WHERE Pacientes.IDPaciente = Estudios.IDPaciente AND "
			"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=Ficheros.UIDSerie AND Ficheros.Modalidad != 'SR'");
		if (idPaciente != _Std("All patients")) {
			ostr << bufSQL.Format(" AND Pacientes.IDPaciente = '%q'", idPaciente.c_str());
		}
		if (modalidad != _Std("All modalities")) {
			ostr << bufSQL.Format(" AND Ficheros.Modalidad = '%q'", modalidad.c_str());
		}
		if (from.IsValid()) {
			std::string tmpStr(from.Format(wxT("%Y-%m-%d")).ToUTF8());
			ostr << bufSQL.Format(" AND Series.Fecha >= '%q'",  tmpStr.c_str());
		}
		if (to.IsValid()) {
			std::string tmpStr(to.Format(wxT("%Y-%m-%d")).ToUTF8());
			ostr << bufSQL.Format(" AND Series.Fecha <= '%q'", tmpStr.c_str());
		}
		if (timeFrom != "" && timeTo != "") {
			ostr << bufSQL.Format(" AND Series.Hora BETWEEN '%q' AND '%q'", timeFrom.c_str(), timeTo.c_str());
		}

		ostr << bufSQL.Format(" GROUP BY Series.UIDSerie  "
			"ORDER BY Pacientes.Nombre ASC, Ficheros.Fecha DESC, Ficheros.Hora DESC");

		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(ostr.str().c_str());
		while (resultados.NextRow()) {
			ModeloSerie modelo;
			modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
			modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
			modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
			modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
			modelo.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
			modelo.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
			modelo.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
			modelo.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
			modelo.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
			modelo.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
			modelo.m_numeroSlices = resultados.GetInt(wxT("NumeroSlices"));
			modelo.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			listaModelos.push_back(modelo);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetModelosDCMPaciente "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
}

void GNC::GCS::ControladorHistorial::GetStudyModelSql(const std::string& sql, ListaModelosEstudios& listaModelos)
{
	wxSQLite3StatementBuffer bufSQL;
	std::ostringstream ostr;
	ostr << bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
		"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Estudios.Hora as HoraEstudio "
		"FROM Pacientes,Estudios,Series,Ficheros WHERE Pacientes.IDPaciente = Estudios.IDPaciente AND "
		"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=Ficheros.UIDSerie AND Ficheros.Modalidad != 'SR'");
	if (sql != "") {
		ostr << " AND " << sql.c_str();;
	}

	ostr << bufSQL.Format(" GROUP BY Estudios.UIDEstudio  "
		"ORDER BY Pacientes.Nombre ASC, Ficheros.Fecha DESC, Ficheros.Hora DESC");

	wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(ostr.str().c_str());
	while (resultados.NextRow()) {
		ModeloEstudio modelo;
		modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
		modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
		modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
		modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
		modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
		modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
		listaModelos.push_back(modelo);
	}
}

void GNC::GCS::ControladorHistorial::GetSeriesModelSql(const std::string& sql, ListaModelosSeries& listaModelos)
{
	wxSQLite3StatementBuffer bufSQL;
	std::ostringstream ostr;
	ostr << bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
		"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Series.SeriesNumber as SeriesNumber, Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Estudios.Hora as HoraEstudio, Series.UIDSerie,"
		"Series.Descripcion as DescripcionSeries,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie, "
		"Ficheros.Modalidad, Ficheros.UIDImportador, Ficheros.TransferSyntaxUID, count(*) as NumeroSlices "
		"FROM Pacientes,Estudios,Series,Ficheros WHERE Pacientes.IDPaciente = Estudios.IDPaciente AND "
		"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=Ficheros.UIDSerie AND Ficheros.Modalidad != 'SR'");
	if (sql != "") {
		ostr << " AND " << sql.c_str();;
	}

	ostr << bufSQL.Format(" GROUP BY Series.UIDSerie  "
		"ORDER BY Pacientes.Nombre ASC, Ficheros.Fecha DESC, Ficheros.Hora DESC");

	wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(ostr.str().c_str());
	while (resultados.NextRow()) {
		ModeloSerie modelo;
		modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
		modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
		modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
		modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
		modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
		modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
		modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
		modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
		modelo.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
		modelo.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
		modelo.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
		modelo.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
		modelo.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
		modelo.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
		modelo.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
		modelo.m_numeroSlices = resultados.GetInt(wxT("NumeroSlices"));
		modelo.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
		modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
		modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
		listaModelos.push_back(modelo);
	}
}


void GNC::GCS::ControladorHistorial::GetAllModelosSerieSeries(const ListaStrings& listaUIDs, ListaModelosSeries& listaModelos)
{
	if (listaUIDs.size() == 0) {
		return;
	}
	return GetAllModelosSerie(listaModelos, listaUIDs);
}

void GNC::GCS::ControladorHistorial::GetAllModelosSeriePatient(const std::string& patientID, ListaModelosSeries& listaModelos)
{
	return GetAllModelosSerie(listaModelos, ListaStrings(), "", patientID);
}

void GNC::GCS::ControladorHistorial::GetAllModelosSerieStudy(const std::string& studyInstanceUID, ListaModelosSeries& listaModelos)
{
	return GetAllModelosSerie(listaModelos, ListaStrings(), studyInstanceUID);
}

void GNC::GCS::ControladorHistorial::GetAllModelosSerie(ListaModelosSeries& listaModelos, const ListaStrings& uidsSeries, const std::string& studyInstanceUID, const std::string& patientId)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		std::ostringstream ostr;
		ostr << bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
			"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Estudios.Hora as HoraEstudio, Series.UIDSerie,"
			"Series.Descripcion as DescripcionSeries,Series.SeriesNumber as SeriesNumber,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie, "
			"Ficheros.Modalidad, Ficheros.UIDImportador, Ficheros.TransferSyntaxUID, count(*) as NumeroSlices "
			"FROM Pacientes,Estudios,Series,Ficheros WHERE Pacientes.IDPaciente = Estudios.IDPaciente AND "
			"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=Ficheros.UIDSerie AND Ficheros.Modalidad != 'SR' ");

		//only this uidSeries
		if (uidsSeries.size() > 0) {
			ostr << "AND (";
			ListaStrings::const_iterator it = uidsSeries.begin(); 
			ostr << bufSQL.Format("Series.UIDSerie = '%q' " , (*it).c_str());
			for (;it != uidsSeries.end(); ++it) {
				ostr << bufSQL.Format("OR Series.UIDSerie = '%q'" , (*it).c_str());	
			}
			ostr << ")";
		}		
		//only this study
		if (studyInstanceUID != "")
		{
			ostr << bufSQL.Format("AND Estudios.UIDEstudio ='%q'", studyInstanceUID.c_str());
		}
		//only this patient
		if (patientId != "")
		{
			ostr << bufSQL.Format("AND Pacientes.IDPaciente ='%q'", patientId.c_str());
		}

		ostr << "GROUP BY Series.UIDSerie ";
		ostr << "ORDER BY Pacientes.Nombre ASC, Ficheros.Fecha DESC, Ficheros.Hora DESC";
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(ostr.str().c_str());
		while (resultados.NextRow()) {
			ModeloSerie modelo;
			modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
			modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
			modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
			modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
			modelo.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
			modelo.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
			modelo.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
			modelo.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
			modelo.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
			modelo.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
			modelo.m_numeroSlices = resultados.GetInt(wxT("NumeroSlices"));
			modelo.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			listaModelos.push_back(modelo);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetModelosDCMPaciente "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
}

void GNC::GCS::ControladorHistorial::GetAllModelosSerieDiagnostico(ListaModelosSeries& listaModelos, const ListaStrings& uidsSeries)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		std::ostringstream ostr;
		ostr << bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
			"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Series.UIDSerie,"
			"Series.Descripcion as DescripcionSeries,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie, "
			"Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.SeriesNumber as SeriesNumber, "
			"Ficheros.Modalidad, Ficheros.UIDImportador, Ficheros.TransferSyntaxUID, count(*) as NumeroSlices "
			"FROM Pacientes,Estudios,Series,Ficheros WHERE Pacientes.IDPaciente = Estudios.IDPaciente AND "
			"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=Ficheros.UIDSerie AND Ficheros.Modalidad == 'SR' ");
		//only this uidSeries
		if (uidsSeries.size() > 0) {
			ostr << bufSQL.Format("AND Series.UIDSerie IN (Select f3.UIDSerie "
										 "FROM Ficheros as f2, ReferenciasFicheros as ref, Ficheros as f3 "
										 "WHERE (");
			ListaStrings::const_iterator it = uidsSeries.begin(); 
			ostr << bufSQL.Format("f2.UIDSerie = '%q' " , (*it).c_str());
			for (;it != uidsSeries.end(); ++it) {
				ostr << bufSQL.Format("OR f2.UIDSerie = '%q'" , (*it).c_str());	
			}
			ostr << bufSQL.Format(") AND f2.UIDFichero = ref.UIDFicheroDestino AND ref.UIDFicheroOrigen = f3.UIDFichero");
			ostr << ")";
		}
		ostr << "GROUP BY Series.UIDSerie ";
		ostr << "ORDER BY Pacientes.Nombre ASC, Ficheros.Fecha DESC, Ficheros.Hora DESC";
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(ostr.str().c_str());
		while (resultados.NextRow()) {
			ModeloSerie modelo;
			modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
			modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
			modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
			modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
			modelo.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
			modelo.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
			modelo.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
			modelo.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
			modelo.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
			modelo.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
			modelo.m_numeroSlices = resultados.GetInt(wxT("NumeroSlices"));			
			modelo.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			listaModelos.push_back(modelo);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetModelosDCMPaciente "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
}


void GNC::GCS::ControladorHistorial::GetAllPatients(ListaModelosPaciente& listaPacientes)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo "
			"FROM Pacientes ORDER BY Pacientes.Nombre ASC");
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			ModeloPaciente modelo;
			modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
			modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
			modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
			modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
			listaPacientes.push_back(modelo);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetAllPatients "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
}

void GNC::GCS::ControladorHistorial::GetAllModalities(ListaStrings& modalitiesList)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT Ficheros.Modalidad as Modalidad "
			"FROM Ficheros "
			"WHERE Ficheros.Modalidad != 'SR' "
			"ORDER BY Ficheros.Modalidad ASC");
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			modalitiesList.push_back( std::string(resultados.GetAsString(wxT("Modalidad")).ToUTF8()) );
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetAllModalities "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}

}

void GNC::GCS::ControladorHistorial::GetModelosSerieEstudio(std::string& uidEstudio, ListaModelosSeries& listaModelos)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
			"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Series.UIDSerie,"
			"Series.Descripcion as DescripcionSeries,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie, "
			"Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.SeriesNumber as SeriesNumber, "
			"Ficheros.Modalidad, Ficheros.UIDImportador, Ficheros.TransferSyntaxUID, count(*) as NumeroSlices "
			"FROM Pacientes,Estudios,Series,Ficheros WHERE Estudios.UIDEstudio='%q' AND Pacientes.IDPaciente = Estudios.IDPaciente AND "
			"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=Ficheros.UIDSerie AND Ficheros.Modalidad != 'SR' "
			"GROUP BY Series.UIDSerie  "
			"ORDER BY Ficheros.Fecha DESC, Ficheros.Hora DESC", uidEstudio.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			ModeloSerie modelo;
			modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
			modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
			modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
			modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
			modelo.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
			modelo.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
			modelo.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
			modelo.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
			modelo.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
			modelo.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
			modelo.m_numeroSlices = resultados.GetInt(wxT("NumeroSlices"));	
			modelo.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			listaModelos.push_back(modelo);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetModelosSerieEstudio "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
}

int GNC::GCS::ControladorHistorial::GetSlicesCount(const std::string& uidSerie)
{
	int numeroSlices = 0;
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT count(*) as NumeroSlices "
			"FROM Ficheros WHERE "
			"Ficheros.UIDSerie='%q' AND Ficheros.Modalidad != 'SR'"
			,uidSerie.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		if (resultados.NextRow()) {
			numeroSlices = resultados.GetInt(wxT("NumeroSlices"));
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetAllModeloDCM "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return numeroSlices;
}

std::string GNC::GCS::ControladorHistorial::GetPathFrameOfReference(const std::string& uidSerie)
{
	VectorPaths paths = GetPathsSerieOrdenados(uidSerie);
	if (paths.size() > 0) {
		return paths[0];
	} else {
		return "";
	}
}


/*obtiene los diagnosticos asociados a un fichero con un importador dado y una serie dada*/
GNC::GCS::ControladorHistorial::ModeloDCM GNC::GCS::ControladorHistorial::GetDiagnostico(const std::string& pathFicheroAbsoluto,const std::string& uidEstudio, const std::string& uidImportador)
{
	std::string pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero(pathFicheroAbsoluto);
	GNC::GCS::ControladorHistorial::ListaModelosDCM listaModelos;
	try {
		wxSQLite3StatementBuffer bufSQL;
		if(uidImportador != "") {
			bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
				"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Series.UIDSerie,"
				"Series.Descripcion as DescripcionSeries,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie, f2.Path, f2.UIDFichero,"
				"Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.SeriesNumber as SeriesNumber, "
				"f2.Modalidad, f2.Descripcion as DescripcionFichero, f2.UIDImportador, f2.TransferSyntaxUID, f2.SopClassUID, f2.Fecha as FechaFichero, f2.Hora as HoraFichero "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Pacientes,Estudios,Series WHERE "
				"f1.Path='%q' AND f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.UIDImportador = '%q' AND f2.Modalidad = 'SR' "
				"AND Pacientes.IDPaciente = Estudios.IDPaciente AND "
				"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=f2.UIDSerie AND Estudios.UIDEstudio = '%q'"
				,pathRelativo.c_str(),uidImportador.c_str(),uidEstudio.c_str());
		} else {
			bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
				"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Series.UIDSerie,"
				"Series.Descripcion as DescripcionSeries,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie, f2.Path, f2.UIDFichero,"
				"Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.SeriesNumber as SeriesNumber, "
				"f2.Modalidad, f2.Descripcion as DescripcionFichero, f2.UIDImportador, f2.TransferSyntaxUID, f2.SopClassUID, f2.Fecha as FechaFichero, f2.Hora as HoraFichero "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Pacientes,Estudios,Series WHERE "
				"f1.Path='%q' AND f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.Modalidad = 'SR' "
				"AND Pacientes.IDPaciente = Estudios.IDPaciente AND "
				"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=f2.UIDSerie AND Estudios.UIDEstudio = '%q'"
				,pathRelativo.c_str(),uidEstudio.c_str());
		}
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			ModeloDCM modelo;
			modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
			modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
			modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
			modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
			modelo.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
			modelo.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
			modelo.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
			modelo.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
			modelo.m_pathRelativo = resultados.GetAsString(wxT("Path")).ToUTF8();
			modelo.m_uidImagen = resultados.GetAsString(wxT("UIDFichero")).ToUTF8();
			modelo.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
			modelo.m_descripcionImagen = resultados.GetAsString(wxT("DescripcionFichero")).ToUTF8();
			modelo.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
			modelo.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
			modelo.m_sopClassUID = resultados.GetAsString(wxT("SopClassUID")).ToUTF8();
			modelo.m_fechaImagen = resultados.GetAsString(wxT("FechaFichero")).ToUTF8();
			modelo.m_horaImagen= resultados.GetAsString(wxT("HoraFichero")).ToUTF8();
			modelo.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			return modelo;
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetDiagnostico "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	ModeloDCM modelo;
	return modelo;
}

/*obtiene los diagnosticos asociados a una serie con un importador dado y una estudio dado*/
GNC::GCS::ControladorHistorial::ModeloDCM GNC::GCS::ControladorHistorial::GetDiagnosticoSerie(const std::string& uidSerie,const std::string& uidEstudio, const std::string& uidImportador)
{
	GNC::GCS::ControladorHistorial::ListaModelosDCM listaModelos;
	ModeloDCM modelo;
	try {
		wxSQLite3StatementBuffer bufSQL;
		if(uidImportador != "") {
			bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
				"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Series.UIDSerie,"
				"Series.Descripcion as DescripcionSeries,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie, f2.Path, f2.UIDFichero,"
				"Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.SeriesNumber as SeriesNumber, "
				"f2.Modalidad, f2.Descripcion as DescripcionFichero, f2.UIDImportador, f2.TransferSyntaxUID, f2.SopClassUID, f2.Fecha as FechaFichero, f2.Hora as HoraFichero "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Pacientes,Estudios,Series WHERE "
				"f1.UIDSerie='%q' AND f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.UIDImportador = '%q' AND f2.Modalidad = 'SR' "
				"AND Pacientes.IDPaciente = Estudios.IDPaciente AND "
				"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=f2.UIDSerie AND Estudios.UIDEstudio = '%q'"
				,uidSerie.c_str(),uidImportador.c_str(),uidEstudio.c_str());
		} else {
			bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
				"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Series.UIDSerie,"
				"Series.Descripcion as DescripcionSeries,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie, f2.Path, f2.UIDFichero,"
				"Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.SeriesNumber as SeriesNumber, "
				"f2.Modalidad, f2.Descripcion as DescripcionFichero, f2.UIDImportador, f2.TransferSyntaxUID, f2.SopClassUID, f2.Fecha as FechaFichero, f2.Hora as HoraFichero "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Pacientes,Estudios,Series WHERE "
				"f1.UIDSerie ='%q' AND f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.Modalidad = 'SR' "
				"AND Pacientes.IDPaciente = Estudios.IDPaciente AND "
				"Estudios.UIDEstudio=Series.UIDEstudio and Series.UIDSerie=f2.UIDSerie AND Estudios.UIDEstudio = '%q'"
				,uidSerie.c_str(),uidEstudio.c_str());
		}
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		if (resultados.NextRow()) {
			modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
			modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
			modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
			modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
			modelo.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
			modelo.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
			modelo.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
			modelo.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
			modelo.m_pathRelativo = resultados.GetAsString(wxT("Path")).ToUTF8();
			modelo.m_uidImagen = resultados.GetAsString(wxT("UIDFichero")).ToUTF8();
			modelo.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
			modelo.m_descripcionImagen = resultados.GetAsString(wxT("DescripcionFichero")).ToUTF8();
			modelo.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
			modelo.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
			modelo.m_sopClassUID = resultados.GetAsString(wxT("SopClassUID")).ToUTF8();
			modelo.m_fechaImagen = resultados.GetAsString(wxT("FechaFichero")).ToUTF8();
			modelo.m_horaImagen= resultados.GetAsString(wxT("HoraFichero")).ToUTF8();
			modelo.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetDiagnostico "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return modelo;
}

GNC::GCS::ControladorHistorial::ModeloDCM GNC::GCS::ControladorHistorial::GetDiagnosticoClave(const std::string& uidEstudio, const std::string& uidImportador)
{
	GNC::GCS::ControladorHistorial::ListaModelosDCM listaModelos;
	try {
		wxSQLite3StatementBuffer bufSQL;
		//estraemos los ficheros SR de la serie indicada que apuntan a ficheros SR del mismo estudio
		bufSQL.Format("SELECT DISTINCT Pacientes.IDPaciente, Pacientes.Nombre, Pacientes.FechaNacimiento, Pacientes.Sexo, Estudios.UIDEstudio,"
			"Estudios.Descripcion as DescripcionEstudio, Estudios.Fecha as FechaEstudio, Estudios.Hora as HoraEstudio, Series.UIDSerie,"
			"Estudios.StudyId as StudyId, Estudios.AccessionNumber as AccessionNumber, Series.SeriesNumber as SeriesNumber, "
			"Series.Descripcion as DescripcionSeries,Estudios.NombreMedico, Series.Fecha as FechaSerie, Series.Hora as HoraSerie, f2.Path, f2.UIDFichero,"
			"f2.Modalidad, f2.Descripcion as DescripcionFichero, f2.UIDImportador, f2.TransferSyntaxUID, f2.SopClassUID, f2.Fecha as FechaFichero, f2.Hora as HoraFichero "
			"FROM Ficheros as f1, Series as s1, Ficheros as f2, ReferenciasFicheros,Pacientes,Estudios,Series WHERE "
			"f1.Modalidad = 'SR' AND s1.UIDSerie=f1.UIDSerie AND s1.UIDEstudio= '%q' "
			"AND f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
			"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
			"AND f2.UIDImportador = '%q' AND f2.Modalidad = 'SR' "
			"AND Pacientes.IDPaciente = Estudios.IDPaciente AND "
			"Estudios.UIDEstudio=Series.UIDEstudio and Estudios.UIDEstudio = '%q'"
			,uidEstudio.c_str(),uidImportador.c_str(),uidEstudio.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			ModeloDCM modelo;
			modelo.m_idPaciente = resultados.GetAsString(wxT("IDPaciente")).ToUTF8();
			modelo.m_nombrePaciente = resultados.GetAsString(wxT("Nombre")).ToUTF8();
			modelo.m_fechaNacimiento = resultados.GetAsString(wxT("FechaNacimiento")).ToUTF8();
			modelo.m_sexo = resultados.GetAsString(wxT("Sexo")).GetChar(0);
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio= resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidSerie = resultados.GetAsString(wxT("UIDSerie")).ToUTF8();
			modelo.m_descripcionSerie = resultados.GetAsString(wxT("DescripcionSeries")).ToUTF8();
			modelo.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
			modelo.m_fechaSerie = resultados.GetAsString(wxT("FechaSerie")).ToUTF8();
			modelo.m_horaSerie= resultados.GetAsString(wxT("HoraSerie")).ToUTF8();
			modelo.m_pathRelativo = resultados.GetAsString(wxT("Path")).ToUTF8();
			modelo.m_uidImagen = resultados.GetAsString(wxT("UIDFichero")).ToUTF8();
			modelo.m_modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
			modelo.m_descripcionImagen = resultados.GetAsString(wxT("DescripcionFichero")).ToUTF8();
			modelo.m_uidImportador = resultados.GetAsString(wxT("UIDImportador")).ToUTF8();
			modelo.m_uidTransferSyntax = resultados.GetAsString(wxT("TransferSyntaxUID")).ToUTF8();
			modelo.m_sopClassUID = resultados.GetAsString(wxT("SopClassUID")).ToUTF8();
			modelo.m_fechaImagen = resultados.GetAsString(wxT("FechaFichero")).ToUTF8();
			modelo.m_horaImagen= resultados.GetAsString(wxT("HoraFichero")).ToUTF8();
			modelo.m_seriesNumber = resultados.GetAsString(wxT("SeriesNumber")).ToUTF8();
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			return modelo;
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetDiagnosticoClave "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	ModeloDCM modelo;
	return modelo;
}


/*Obtiene los diagnosticos del estudio del fichero*/

GNC::GCS::ControladorHistorial::ListaModelosEstudios GNC::GCS::ControladorHistorial::GetEstudiosDiagnosticosFichero(const std::string& pathAbsoluto, const std::string& uidImportador)
{
	std::string pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero(pathAbsoluto);
	GNC::GCS::ControladorHistorial::ListaModelosEstudios listaModelos;
	try {
		wxSQLite3StatementBuffer bufSQL;
		//falta el distinct
		if(uidImportador != "") {
			bufSQL.Format("SELECT DISTINCT e2.UIDEstudio,e2.Descripcion as DescripcionEstudio, e2.NombreMedico, "
				"e2.StudyId as StudyId, e2.AccessionNumber as AccessionNumber, "
				"e2.Fecha as FechaEstudio, e2.Hora as HoraEstudio "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Series as s2, Estudios as e2 WHERE "
				"f1.Path = '%q' AND "
				"f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.UIDImportador = '%q' AND f2.Modalidad = 'SR' "
				"AND s2.UIDSerie=f2.UIDSerie AND s2.UIDEstudio=e2.UIDEstudio"
				,pathRelativo.c_str(),uidImportador.c_str());
		} else {
			bufSQL.Format("SELECT DISTINCT e2.UIDEstudio,e2.Descripcion as DescripcionEstudio, e2.NombreMedico, "
				"e2.StudyId as StudyId, e2.AccessionNumber as AccessionNumber, "
				"e2.Fecha as FechaEstudio, e2.Hora as HoraEstudio "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Series as s2, Estudios as e2 WHERE "
				"f1.Path = '%q' AND "
				"f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.Modalidad = 'SR' "
				"AND s2.UIDSerie=f2.UIDSerie AND s2.UIDEstudio=e2.UIDEstudio"
				,pathRelativo.c_str());
		}
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			ModeloEstudio modelo;
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio = resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidImportador = uidImportador;
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			listaModelos.push_back(modelo);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetEstudiosDiagnosticosFichero "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return listaModelos;
}

GNC::GCS::ControladorHistorial::ListaModelosEstudios GNC::GCS::ControladorHistorial::GetEstudiosDiagnosticosSerie(const std::string& uidSerie, const std::string& uidImportador)
{
	GNC::GCS::ControladorHistorial::ListaModelosEstudios listaModelos;
	try {
		wxSQLite3StatementBuffer bufSQL;
		//falta el distinct
		if(uidImportador != "") {
			bufSQL.Format("SELECT DISTINCT e2.UIDEstudio,e2.Descripcion as DescripcionEstudio, e2.NombreMedico, "
				"e2.StudyId as StudyId, e2.AccessionNumber as AccessionNumber, "
				"e2.Fecha as FechaEstudio, e2.Hora as HoraEstudio "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Series as s2, Estudios as e2 WHERE "
				"f1.UIDSerie = '%q' AND "
				"f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.UIDImportador = '%q' AND f2.Modalidad = 'SR' "
				"AND s2.UIDSerie=f2.UIDSerie AND e2.UIDEstudio=s2.UIDEstudio"
				,uidSerie.c_str(),uidImportador.c_str());
		} else {
			bufSQL.Format("SELECT DISTINCT e2.UIDEstudio,e2.Descripcion as DescripcionEstudio, e2.NombreMedico, "
				"e2.StudyId as StudyId, e2.AccessionNumber as AccessionNumber, "
				"e2.Fecha as FechaEstudio, e2.Hora as HoraEstudio "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Series as s2, Estudios as e2 WHERE "
				"f1.UIDSerie = '%q' AND "
				"f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.Modalidad = 'SR' "
				"AND s2.UIDSerie=f2.UIDSerie AND e2.UIDEstudio=s2.UIDEstudio"
				,uidSerie.c_str());
		}
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			ModeloEstudio modelo;
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio = resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidImportador = uidImportador;
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			listaModelos.push_back(modelo);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetEstudiosDiagnosticosSerie "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return listaModelos;
}


/*devuelve los diagnosticos de un estudio a partir del path de uno de los ficheros del estudio*/
GNC::GCS::ControladorHistorial::ListaModelosEstudios GNC::GCS::ControladorHistorial::GetEstudiosDiagnosticosEstudioPath(const std::string& pathAbsoluto, const std::string& uidImportador)
{
	std::string pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero(pathAbsoluto);
	GNC::GCS::ControladorHistorial::ListaModelosEstudios listaModelos;
	try {
		wxSQLite3StatementBuffer bufSQL;
		//falta el distinct
		if(uidImportador != "") {
			bufSQL.Format("SELECT DISTINCT e2.UIDEstudio,e2.Descripcion as DescripcionEstudio, e2.NombreMedico, "
				"e2.StudyId as StudyId, e2.AccessionNumber as AccessionNumber, "
				"e2.Fecha as FechaEstudio, e2.Hora as HoraEstudio "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Series as s1, Series as s2, Estudios as e2 WHERE "
				"s1.UIDEstudio IN (Select DISTINCT UIDEstudio from Series as s3, Ficheros as f3 WHERE f3.Path = '%q' and f3.UIDSerie = s3.UIDSerie) AND "
				"s1.UIDSerie = f1.UIDSerie AND "
				"f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.UIDImportador = '%q' AND f2.Modalidad = 'SR' "
				"AND s2.UIDSerie=f2.UIDSerie AND s2.UIDEstudio=e2.UIDEstudio "
				"ORDER BY FechaEstudio DESC, HoraEstudio DESC"
				,pathRelativo.c_str(),uidImportador.c_str());
		} else {
			bufSQL.Format("SELECT DISTINCT e2.UIDEstudio,e2.Descripcion as DescripcionEstudio, e2.NombreMedico, "
				"e2.StudyId as StudyId, e2.AccessionNumber as AccessionNumber, "
				"e2.Fecha as FechaEstudio, e2.Hora as HoraEstudio "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Series as s1, Series as s2, Estudios as e2 WHERE "
				"s1.UIDEstudio IN (Select DISTINCT UIDEstudio from Series as s3, Ficheros as f3 WHERE f3.Path = '%q' and f3.UIDSerie = s3.UIDSerie) AND "
				"s1.UIDSerie = f1.UIDSerie AND "
				"f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.Modalidad = 'SR' "
				"AND s2.UIDSerie=f2.UIDSerie AND s2.UIDEstudio=e2.UIDEstudio "
				"ORDER BY FechaEstudio DESC, HoraEstudio DESC"
				,pathRelativo.c_str());
		}
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			ModeloEstudio modelo;
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio = resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidImportador = uidImportador;
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			listaModelos.push_back(modelo);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetEstudiosDiagnosticosEstudioPath "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return listaModelos;
}

/*devuelve los diagnosticos de una serie a partir del path de uno de los ficheros de la serie*/
GNC::GCS::ControladorHistorial::ListaModelosEstudios GNC::GCS::ControladorHistorial::GetEstudiosDiagnosticosSeriePath(const std::string& pathAbsoluto, const std::string& uidImportador)
{
	std::string pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero(pathAbsoluto);
	GNC::GCS::ControladorHistorial::ListaModelosEstudios listaModelos;
	try {
		wxSQLite3StatementBuffer bufSQL;
		//falta el distinct
		if(uidImportador != "") {
			bufSQL.Format("SELECT DISTINCT e2.UIDEstudio,e2.Descripcion as DescripcionEstudio, e2.NombreMedico, "
				"e2.StudyId as StudyId, e2.AccessionNumber as AccessionNumber, "
				"e2.Fecha as FechaEstudio, e2.Hora as HoraEstudio "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Series as s1, Series as s2, Estudios as e2 WHERE "
				"s1.UIDSerie IN (Select DISTINCT UIDSerie from Ficheros as f3 WHERE f3.Path = '%q') AND "
				"s1.UIDSerie = f1.UIDSerie AND "
				"f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.UIDImportador = '%q' AND f2.Modalidad = 'SR' "
				"AND s2.UIDSerie=f2.UIDSerie AND s2.UIDEstudio=e2.UIDEstudio "
				"ORDER BY FechaEstudio DESC, HoraEstudio DESC"
				,pathRelativo.c_str(),uidImportador.c_str());
		} else {
			bufSQL.Format("SELECT DISTINCT e2.UIDEstudio,e2.Descripcion as DescripcionEstudio, e2.NombreMedico, "
				"e2.StudyId as StudyId, e2.AccessionNumber as AccessionNumber, "
				"e2.Fecha as FechaEstudio, e2.Hora as HoraEstudio "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Series as s1, Series as s2, Estudios as e2 WHERE "
				"s1.UIDSerie IN (Select DISTINCT UIDSerie from Ficheros as f3 WHERE f3.Path = '%q') AND "
				"s1.UIDSerie = f1.UIDSerie AND "
				"f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.Modalidad = 'SR' "
				"AND s2.UIDSerie=f2.UIDSerie AND s2.UIDEstudio=e2.UIDEstudio "
				"ORDER BY FechaEstudio DESC, HoraEstudio DESC"
				,pathRelativo.c_str());
		}
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			ModeloEstudio modelo;
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio = resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidImportador = uidImportador;
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			listaModelos.push_back(modelo);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetEstudiosDiagnosticosSeriePath "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(),_("Info"),
			wxOK | wxICON_WARNING);
	}
	return listaModelos;
}

GNC::GCS::ControladorHistorial::ListaModelosEstudios GNC::GCS::ControladorHistorial::GetEstudiosDiagnosticosEstudio(const std::string& uidEstudio, const std::string& uidImportador)
{
	GNC::GCS::ControladorHistorial::ListaModelosEstudios listaModelos;
	try {
		wxSQLite3StatementBuffer bufSQL;
		//falta el distinct
		if(uidImportador != "") {
			bufSQL.Format("SELECT DISTINCT  e2.UIDEstudio,e2.Descripcion as DescripcionEstudio, e2.NombreMedico, "
				"e2.StudyId as StudyId, e2.AccessionNumber as AccessionNumber, "
				"e2.Fecha as FechaEstudio, e2.Hora as HoraEstudio "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Series as s1, Series as s2, Estudios as e2 WHERE "
				"s1.UIDEstudio = '%q' AND s1.UIDSerie = f1.UIDSerie AND "
				"f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.UIDImportador = '%q' AND f2.Modalidad = 'SR' "
				"AND s2.UIDSerie=f2.UIDSerie AND s2.UIDEstudio = e2.UIDEstudio"
				,uidEstudio.c_str(),uidImportador.c_str());
		} else {
			bufSQL.Format("SELECT DISTINCT  e2.UIDEstudio,e2.Descripcion as DescripcionEstudio, e2.NombreMedico, "
				"e2.StudyId as StudyId, e2.AccessionNumber as AccessionNumber, "
				"e2.Fecha as FechaEstudio, e2.Hora as HoraEstudio "
				"FROM Ficheros as f1, Ficheros as f2, ReferenciasFicheros,Series as s1, Series as s2, Estudios as e2 WHERE "
				"s1.UIDEstudio = '%q' AND s1.UIDSerie = f1.UIDSerie AND "
				"f1.UIDFichero = ReferenciasFicheros.UIDFicheroDestino "
				"AND ReferenciasFicheros.UIDFicheroOrigen = f2.UIDFichero "
				"AND f2.Modalidad = 'SR' "
				"AND s2.UIDSerie=f2.UIDSerie AND s2.UIDEstudio = e2.UIDEstudio"
				,uidEstudio.c_str());
		}
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			ModeloEstudio modelo;
			modelo.m_uidEstudio = resultados.GetAsString(wxT("UIDEstudio")).ToUTF8();
			modelo.m_descripcionEstudio = resultados.GetAsString(wxT("DescripcionEstudio")).ToUTF8();
			modelo.m_nombreMedico = resultados.GetAsString(wxT("NombreMedico")).ToUTF8();
			modelo.m_fechaEstudio = resultados.GetAsString(wxT("FechaEstudio")).ToUTF8();
			modelo.m_horaEstudio = resultados.GetAsString(wxT("HoraEstudio")).ToUTF8();
			modelo.m_uidImportador = uidImportador;
			modelo.m_accessionNumber = resultados.GetAsString(wxT("AccessionNumber")).ToUTF8();
			modelo.m_studyId = resultados.GetAsString(wxT("StudyId")).ToUTF8();
			listaModelos.push_back(modelo);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetEstudiosDiagnosticosEstudio "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return listaModelos;
}

std::string GNC::GCS::ControladorHistorial::GetModalidadSerie(const std::string& uidSerie)
{
	std::string modalidad("");
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT Ficheros.Modalidad "
			"FROM Ficheros WHERE Ficheros.UIDSerie='%q'",uidSerie.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		if (resultados.NextRow()) {
			modalidad = resultados.GetAsString(wxT("Modalidad")).ToUTF8();
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetModalidadSerie "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return modalidad;
}

GNC::GCS::ControladorHistorial::ListaStrings GNC::GCS::ControladorHistorial::GetModalidadesEstudio(const std::string& uidEstudio)
{
	ListaStrings listaModalidades;
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT Ficheros.Modalidad "
			"FROM Ficheros,Series WHERE Series.UIDSerie =Ficheros.UIDSerie AND Series.UIDEstudio='%q'",uidEstudio.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			std::string tmp(resultados.GetAsString(wxT("Modalidad")).ToUTF8());
			if(tmp!="SR") {
				listaModalidades.push_back(tmp);
			}
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetModalidadesEstudio "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(),_("Info"),
			wxOK | wxICON_WARNING);
	}
	return listaModalidades;
}

std::string GNC::GCS::ControladorHistorial::GetUIDImporterFromDiagnosticStudy(const std::string& uidStudy)
{
	std::string uid("");


	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("select DISTINCT Ficheros.UIDImportador "
			"FROM Ficheros, Series WHERE "
			"series.UIDEstudio = '%q' AND Series.UIDSerie = Ficheros.UIDSerie",uidStudy.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		if (resultados.NextRow()) {
			uid = resultados.GetAsString(0).ToUTF8();
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetPathsFichero "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}


	return uid;
}


void GNC::GCS::ControladorHistorial::GetReferencedFiles(const std::string& uidDiagnosticStudy, ListaStrings& pathList)
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT fich.Path "
			"FROM Ficheros as fich "
			"Where fich.UIDSerie IN "
			"(Select f2.UIDSerie FROM Ficheros as f2, Ficheros as f1, ReferenciasFicheros, Series as s1 WHERE "
			"s1.UIDEstudio = '%q' AND s1.UIDSerie = f1.UIDSerie AND f1.UIDFichero = ReferenciasFicheros.UIDFicheroOrigen AND "
			"ReferenciasFicheros.UIDFicheroDestino = f2.UIDFichero)", uidDiagnosticStudy.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			const std::string pathAbsoluto = GNC::Entorno::Instance()->GetPathAbsolutoFichero(std::string(resultados.GetAsString(wxT("Path")).ToUTF8()));
			pathList.push_back(pathAbsoluto);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetReferencedFiles "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
}


GNC::GCS::ControladorHistorial::ListaPaths GNC::GCS::ControladorHistorial::GetPathsFichero(std::string uidFichero)
{
	GNC::GCS::ControladorHistorial::ListaPaths listaPaths;
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT f1.Path "
			"FROM Ficheros as f1 WHERE "
			"f1.UIDFichero = '%q'",uidFichero.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		while (resultados.NextRow()) {
			std::string path(resultados.GetAsString(0).ToUTF8());
			listaPaths.push_back(path);
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetPathsFichero "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return listaPaths;
}

std::string GNC::GCS::ControladorHistorial::GetSopInstanceUID(const std::string& pathAbsoluto)
{
	std::string pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero(pathAbsoluto);
	std::string sop = "";
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT f1.UIDFichero "
			"FROM Ficheros as f1 WHERE "
			"f1.Path = '%q'",pathRelativo.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		if (resultados.NextRow()) {
			sop = std::string(resultados.GetAsString(0).ToUTF8());
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetPathsFichero "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return sop;
}

std::string GNC::GCS::ControladorHistorial::GetPathAbsoluto(const std::string& sopInstanceUID)
{
	std::string pathAbsoluto = "";
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT f1.Path "
			"FROM Ficheros as f1 WHERE "
			"f1.UIDFichero = '%q'",sopInstanceUID.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		if (resultados.NextRow()) {
			pathAbsoluto = GNC::Entorno::Instance()->GetPathAbsolutoFichero(std::string(resultados.GetAsString(0).ToUTF8()));
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetPathAbsoluto "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return pathAbsoluto;
}

char GNC::GCS::ControladorHistorial::GetSeriesOrientation(const std::string& uidSerie)
{
	char orientacion = '?';
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT DISTINCT TagsFicheros.Orientation "
			"FROM TagsFicheros, Ficheros WHERE "
			"Ficheros.UIDSerie='%q' AND Ficheros.Modalidad != 'SR' "
			"AND Ficheros.Path = TagsFicheros.Path "
			,uidSerie.c_str());
		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
		if (resultados.NextRow()) {
			std::string tmp (resultados.GetAsString(wxT("Orientation")).ToUTF8());
			if(tmp.size() == 1) {
				orientacion = tmp[0];
			}
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetPathsSerieOrdenados "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return orientacion;
}

GNC::GCS::ControladorHistorial::VectorPaths GNC::GCS::ControladorHistorial::GetPathsSerieOrdenados(const std::string& uidSerie)
{

	GNC::GCS::ControladorHistorial::VectorPaths resultado;
	try {
		std::ostringstream sentencia;
		wxSQLite3StatementBuffer bufSQL;
		sentencia << bufSQL.Format("SELECT TagsFicheros.Path "
			"FROM TagsFicheros, Ficheros WHERE "
			"Ficheros.UIDSerie='%q' AND Ficheros.Modalidad != 'SR' "
			"AND Ficheros.Path = TagsFicheros.Path "
			"ORDER BY "
			,uidSerie.c_str());

		sentencia << "TagsFicheros.InstanceNumber ASC, TagsFicheros.ContentDate ASC, TagsFicheros.ContentTime ASC";

		switch (GetSeriesOrientation(uidSerie))
		{
		case 'A':
			{
				sentencia << ", TagsFicheros.PatientPositionZ ASC";
			}
			break;
		case 'C':
			{
				sentencia << ", TagsFicheros.PatientPositionY ASC";
			}
			break;
		case 'S':
			{
				sentencia << ", TagsFicheros.PatientPositionX ASC";
			}
			break;
		case 'O':
			{
				sentencia << ", TagsFicheros.SliceLocation ASC";
			}
			break;
		default:
			sentencia << ", TagsFicheros.SliceLocation ASC";
			break;
		}



		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(sentencia.str().c_str());
		while (resultados.NextRow()) {
			const std::string pathAbsoluto = GNC::Entorno::Instance()->GetPathAbsolutoFichero(std::string(resultados.GetAsString(wxT("Path")).ToUTF8()));
			resultado.push_back( pathAbsoluto );
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetPathsSerieOrdenados "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return resultado;
}


GNC::GCS::ControladorHistorial::VectorPaths GNC::GCS::ControladorHistorial::GetPathsStudyOfSeries(const std::string& uidSerie)
{
	GNC::GCS::ControladorHistorial::VectorPaths resultado;
	try {
		std::ostringstream sentencia;
		wxSQLite3StatementBuffer bufSQL;
		sentencia << bufSQL.Format("SELECT TagsFicheros.Path "
			"FROM TagsFicheros, Ficheros, Series WHERE "
			"Ficheros.Modalidad != 'SR' "
			"AND Ficheros.Path = TagsFicheros.Path "
			"AND Ficheros.UIDSerie = Series.UIDSerie "
			"AND Series.UIDEstudio IN (select s1.UIDEstudio from Series as s1 WHERE s1.UIDSerie = '%q') "
			"ORDER BY "
			,uidSerie.c_str());

		sentencia << "TagsFicheros.InstanceNumber ASC, TagsFicheros.ContentDate ASC, TagsFicheros.ContentTime ASC";

		switch (GetSeriesOrientation(uidSerie))
		{
		case 'A':
			{
				sentencia << ", TagsFicheros.PatientPositionZ ASC";
			}
			break;
		case 'C':
			{
				sentencia << ", TagsFicheros.PatientPositionY ASC";
			}
			break;
		case 'S':
			{
				sentencia << ", TagsFicheros.PatientPositionX ASC";
			}
			break;
		case 'O':
			{
				sentencia << ", TagsFicheros.SliceLocation ASC";
			}
			break;
		default:
			sentencia << ", TagsFicheros.SliceLocation ASC";
			break;
		}



		wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(sentencia.str().c_str());
		while (resultados.NextRow()) {
			const std::string pathAbsoluto = GNC::Entorno::Instance()->GetPathAbsolutoFichero(std::string(resultados.GetAsString(wxT("Path")).ToUTF8()));
			resultado.push_back( pathAbsoluto );
		}
	}catch (wxSQLite3Exception& ex) {
		GINKGOLOGERROR("GetPathsSerieOrdenados "<<ex.GetMessage().ToUTF8())
			wxMessageBox(_("Error reading history: \n")+ex.GetMessage(), _("Info"),
			wxOK | wxICON_WARNING);
	}
	return resultado;
}

void GNC::GCS::ControladorHistorial::GetStudyModelsFromPatient(ListaModelosEstudios& estudyList, const std::string& patientId, const std::string& uidImporter)
{
	wxSQLite3StatementBuffer bufSQL;
	std::string strTmp;
	if (uidImporter != "") {
		strTmp = bufSQL.Format("Pacientes.IDPaciente = '%q' AND Ficheros.UIDImportador = '%q'", patientId.c_str(), uidImporter.c_str());
	} else {
		strTmp = bufSQL.Format("Pacientes.IDPaciente = '%q'", patientId.c_str());
	}

	GetStudyModelSql(strTmp, estudyList);
}

void GNC::GCS::ControladorHistorial::GetSeriesModelsFromStudy(ListaModelosSeries& seriesList, const std::string& uidStudy, const std::string& uidImporter)
{
	wxSQLite3StatementBuffer bufSQL;
	std::string strTmp;
	if (uidImporter != "") {
		strTmp = bufSQL.Format("Estudios.UIDEstudio = '%q' AND Ficheros.UIDImportador = '%q'", uidStudy.c_str(), uidImporter.c_str());
	} else {
		strTmp = bufSQL.Format("Estudios.UIDEstudio = '%q'", uidStudy.c_str());
	}

	GetSeriesModelSql(strTmp, seriesList);
}

bool GNC::GCS::ControladorHistorial::InsertarPaciente(const std::string& idPaciente, const std::string& nombre, const std::string& fechaNacimento,const char& sexo)
{
	wxSQLite3StatementBuffer bufSQL;
	if(fechaNacimento != "") {
		bufSQL.Format("INSERT INTO Pacientes (IDPaciente,Nombre,FechaNacimiento,Sexo) VALUES ('%q','%q','%q','%c')",idPaciente.c_str(),nombre.c_str(),fechaNacimento.c_str(),sexo);
	} else {
		bufSQL.Format("INSERT INTO Pacientes (IDPaciente,Nombre,FechaNacimiento,Sexo) VALUES ('%q','%q',NULL,'%c')",idPaciente.c_str(),nombre.c_str(),sexo);
	}
	if(m_pConexion->ExecuteUpdate(bufSQL)>0){
		return true;
	} else {
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::InsertarEstudio(const std::string& uidEstudio, const std::string& descripcion, const std::string& m_nombreMedico, const std::string& fecha, const std::string& hora,const std::string& idPaciente, const std::string& studyId, const std::string& accessionNumber)
{
	std::ostringstream ostr;
	wxSQLite3StatementBuffer bufSQL;
	ostr << bufSQL.Format("INSERT INTO Estudios (UIDEstudio,Descripcion,NombreMedico,Fecha,Hora,IDPaciente, StudyId, AccessionNumber) VALUES ('%q','%q','%q',",uidEstudio.c_str(),descripcion.c_str(),m_nombreMedico.c_str());
	if(fecha != "") {
		ostr << bufSQL.Format("'%q',",fecha.c_str());
	} else {
		ostr << "NULL,";
	}
	if(hora != "") {
		ostr << bufSQL.Format("'%q',",hora.c_str());
	} else {
		ostr << "NULL,";
	}	
	ostr << bufSQL.Format("'%q',",idPaciente.c_str());
	ostr << bufSQL.Format("'%q',",studyId.c_str());
	ostr << bufSQL.Format("'%q')",accessionNumber.c_str());

	if(m_pConexion->ExecuteUpdate(ostr.str().c_str())>0){
		return true;
	} else {
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::InsertarSerie(const std::string& uidSerie, const std::string& descripcion, const std::string& fecha, const std::string& hora,const std::string& uidEstudio, const std::string& seriesNumber)
{
	std::ostringstream ostr;
	wxSQLite3StatementBuffer bufSQL;
	ostr << bufSQL.Format("INSERT INTO Series (UIDSerie,Descripcion,Fecha,Hora,UIDEstudio,SeriesNumber) VALUES ('%q','%q',",uidSerie.c_str(),descripcion.c_str());
	if(fecha != "") {
		ostr << bufSQL.Format("'%q',",fecha.c_str());
	} else {
		ostr << "NULL,";
	}
	if(hora != "") {
		ostr << bufSQL.Format("'%q',",hora.c_str());
	} else {
		ostr << "NULL,";
	}
	ostr << bufSQL.Format("'%q',",uidEstudio.c_str());
	
	ostr << bufSQL.Format("'%q')",seriesNumber.c_str());

	if(m_pConexion->ExecuteUpdate(ostr.str().c_str())>0){
		return true;
	} else {
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::InsertarFichero(const std::string& pathRelativo, const std::string& uidFichero, const std::string& modalidad,const std::string& descripcion,
																	  const std::string& uidImportador, const std::string& fecha, const std::string& hora, const std::string& transferSyntax, const std::string& uidSerie, 
																	  const std::string& sopClassUID)
{
	std::ostringstream ostr;
	wxSQLite3StatementBuffer bufSQL;

	ostr << bufSQL.Format("INSERT INTO Ficheros (Path,UIDFichero,Modalidad,Descripcion,UIDImportador,TransferSyntaxUID,SopClassUID,Fecha,Hora,UIDSerie) VALUES ('%q','%q','%q','%q','%q','%q','%q',",pathRelativo.c_str(),uidFichero.c_str(),modalidad.c_str(),descripcion.c_str(),uidImportador.c_str(), transferSyntax.c_str(), sopClassUID.c_str());
	if(fecha != "") {
		ostr << bufSQL.Format("'%q',",fecha.c_str());
	} else {
		ostr << "NULL,";
	}
	if(hora != "") {
		ostr << bufSQL.Format("'%q',",hora.c_str());
	} else {
		ostr << "NULL,";
	}
	ostr << bufSQL.Format("'%q')",uidSerie.c_str());

	if(m_pConexion->ExecuteUpdate(ostr.str().c_str())>0){
		return true;
	} else {
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::InsertarTagsOrdenacion(const std::string& pathRelativo, const char orientacion, double posicion[3], double sliceLocation,const std::string& height,
				const std::string& width, double instanceNumber, const std::string& fecha,const std::string& hora)
{
	std::ostringstream ostr;
	wxSQLite3StatementBuffer bufSQL;

	ostr << bufSQL.Format("INSERT INTO TagsFicheros (Path,Orientation,PatientPositionX,PatientPositionY,PatientPositionz,SliceLocation,Height,Width,InstanceNumber,ContentDate,ContentTime) "
		"VALUES ('%q','%c','%f','%f','%f','%f','%q','%q','%f',",pathRelativo.c_str(), orientacion,posicion[0], posicion[1], posicion[2],sliceLocation, height.c_str(), width.c_str(), instanceNumber);
	if(fecha != "") {
		ostr << bufSQL.Format("'%q',",fecha.c_str());
	} else {
		ostr << "NULL,";
	}
	if(hora != "") {
		ostr << bufSQL.Format("'%q')",hora.c_str());
	} else {
		ostr << "NULL)";
	}

	if(m_pConexion->ExecuteUpdate(ostr.str().c_str())>0){
		return true;
	} else {
		return false;
	}
}

void GNC::GCS::ControladorHistorial::InstertarReferencias(const std::string& uidOrigen, const std::string& uidDestino)
{
	wxSQLite3StatementBuffer bufSQL;
	bufSQL.Format("INSERT OR REPLACE INTO ReferenciasFicheros (UIDFicheroOrigen,UIDFicheroDestino) VALUES ('%q','%q')",uidOrigen.c_str(),uidDestino.c_str());
	m_pConexion->ExecuteUpdate(bufSQL);
}

bool GNC::GCS::ControladorHistorial::ActualizarEstudio(const std::string& uidEstudio, const std::string& descripcion, const std::string& m_nombreMedico, const std::string& fecha, const std::string& hora)
{
	std::ostringstream ostr;
	wxSQLite3StatementBuffer bufSQL;
	ostr << bufSQL.Format("Update Estudios Set Descripcion='%q', NombreMedico='%q',",descripcion.c_str(),m_nombreMedico.c_str());
	if(fecha != "") {
		ostr << bufSQL.Format("Fecha = '%q',",fecha.c_str());
	} else {
		ostr << "Fecha = NULL,";
	}
	if(hora != "") {
		ostr << bufSQL.Format("Hora = '%q' ",hora.c_str());
	} else {
		ostr << "Hora = NULL ";
	}
	ostr << bufSQL.Format(" WHERE UIDEstudio='%q'",uidEstudio.c_str());

	if(m_pConexion->ExecuteUpdate(ostr.str().c_str())>0){
		return true;
	} else {
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::ActualizarSerie(const std::string& uidSerie, const std::string& descripcion, const std::string& fecha, const std::string& hora)
{
	std::ostringstream ostr;
	wxSQLite3StatementBuffer bufSQL;
	ostr << bufSQL.Format("UPDATE Series SET Descripcion='%q',",descripcion.c_str());
	if(fecha != "") {
		ostr << bufSQL.Format("Fecha='%q',",fecha.c_str());
	} else {
		ostr << "Fecha=NULL,";
	}
	if(hora != "") {
		ostr << bufSQL.Format("Hora='%q' ",hora.c_str());
	} else {
		ostr << "Hora=NULL ";
	}
	ostr << bufSQL.Format("WHERE UIDSerie='%q'",uidSerie.c_str());

	if(m_pConexion->ExecuteUpdate(ostr.str().c_str())>0){
		return true;
	} else {
		return false;
	}
}

bool GNC::GCS::ControladorHistorial::ActualizarFichero(const std::string& pathRelativo,const std::string& descripcion,
																		 const std::string& uidImportador, const std::string& fecha,const std::string& hora)
{
	std::ostringstream ostr;
	wxSQLite3StatementBuffer bufSQL;
	ostr << bufSQL.Format("UPDATE Ficheros SET Descripcion='%q',UIDImportador='%q',",descripcion.c_str(),uidImportador.c_str());
	if(fecha != "") {
		ostr << bufSQL.Format("Fecha='%q',",fecha.c_str());
	} else {
		ostr << "Fecha=NULL,";
	}
	if(hora != "") {
		ostr << bufSQL.Format("Hora='%q' ",hora.c_str());
	} else {
		ostr << "Hora=NULL ";
	}
	ostr << bufSQL.Format("WHERE Path='%q'",pathRelativo.c_str());

	if(m_pConexion->ExecuteUpdate(ostr.str().c_str())>0){
		return true;
	} else {
		return false;
	}
}

//endregion

//helper orientacion
char getMajorAxisFromPatientRelativeDirectionCosine(double x, double y, double z) {
	// 0.5477 would be the square root of 1 (unit vector sum of squares) divided by 3 (oblique axes - a "double" oblique)
	// 0.7071 would be the square root of 1 (unit vector sum of squares) divided by 2 (oblique axes)
	/***/
	const double obliquityThresholdCosineValue = 0.8;


	char axis = '?';

	char orientationX = x < 0 ? 'R' : 'L';
	char orientationY = y < 0 ? 'A' : 'P';
	char orientationZ = z < 0 ? 'F' : 'H';

	double absX = std::abs(x);
	double absY = std::abs(y);
	double absZ = std::abs(z);

	// The tests here really don't need to check the other dimensions,
	// just the threshold, since the sum of the squares should be == 1.0
	// but just in case ...

	if (absX>obliquityThresholdCosineValue && absX>absY && absX>absZ) {
		axis=orientationX;
	}
	else if (absY>obliquityThresholdCosineValue && absY>absX && absY>absZ) {
		axis=orientationY;
	}
	else if (absZ>obliquityThresholdCosineValue && absZ>absX && absZ>absY) {
		axis=orientationZ;
	}
	return axis;
}

char makeImageOrientationLabelFromImageOrientationPatient(
			const double rowX,const double rowY,const double rowZ,
			const double colX,const double colY,const double colZ) {
		char label = 'O';
		char rowAxis = getMajorAxisFromPatientRelativeDirectionCosine(rowX,rowY,rowZ);
		char colAxis = getMajorAxisFromPatientRelativeDirectionCosine(colX,colY,colZ);
		if (rowAxis != '?' && colAxis != '?') {
			if      ((rowAxis == 'R' || rowAxis == 'L') && (colAxis == 'A' || colAxis == 'P')) label='A';
			else if ((colAxis == 'R' || colAxis == 'L') && (rowAxis == 'A' || rowAxis == 'P')) label='A';

			else if ((rowAxis == 'R' || rowAxis == 'L') && (colAxis == 'H' || colAxis == 'F')) label='C';
			else if ((colAxis == 'R' || colAxis == 'L') && (rowAxis == 'H' || rowAxis == 'F')) label='C';

			else if ((rowAxis == 'A' || rowAxis == 'P') && (colAxis == 'H' || colAxis == 'F')) label='S';
			else if ((colAxis == 'A' || colAxis == 'P') && (rowAxis == 'H' || rowAxis == 'F')) label='S';
		}
		return label;
	}




//region "helpers"

bool GNC::GCS::ControladorHistorial::RellenaDCM(ModeloDCM& modeloDCM, const std::string& pathAbsoluto, ListaPaths& listaSobreescritos, TAddErrorList& errorList, bool forzarSobreescribir, bool copia, bool mover)
{
	GIL::DICOM::IDICOMManager*	pDICOMManager= GNC::Entorno::Instance()->GetPACSController()->CrearInstanciaDeDICOMManager();
	if(!pDICOMManager->CargarFichero(pathAbsoluto)) {
		//error en la carga dcmtk no es un dicom
		GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pDICOMManager);
		errorList.push_back(TAddError(TAddError::TE_WrongFormat, pathAbsoluto));
		return false;
	}

	std::string tag("");
	//si es dicomdir => return false
	// Leemos el tag 0004 0x1130 => Si existe es DICOMDIR
	if (pDICOMManager->GetTag(0x0004,0x1130,tag)) {
		errorList.push_back(TAddError(TAddError::TE_DICOMDir, pathAbsoluto));
		return false;
	}

	if(pDICOMManager->GetTag(0x0010,0x0010,tag)){//nombre del paciente
		modeloDCM.m_nombrePaciente=tag;
	}else{
		modeloDCM.m_nombrePaciente="";
	}

	if(pDICOMManager->GetTag(0x0010,0x0020,tag)){//id del paciente
		modeloDCM.m_idPaciente=tag;
	}else{
		modeloDCM.m_idPaciente="";
	}

	if(pDICOMManager->GetTag(0x0020,0x000d,tag)){//uid estudio
		modeloDCM.m_uidEstudio=tag;
	}

	if(pDICOMManager->GetTag(0x0020,0x000e,tag)){//uid serie
		modeloDCM.m_uidSerie=tag;
	}

	if(pDICOMManager->GetTag(0x0008, 0x0018,tag)){//uid imagen
		modeloDCM.m_uidImagen=tag;
	}

	if(pDICOMManager->GetTag(0x0020, 0x0010,tag)){//id study
		modeloDCM.m_studyId=tag;
	}

	if(pDICOMManager->GetTag(0x0008, 0x0050,tag)){//acc number
		modeloDCM.m_accessionNumber=tag;
	}

	if(pDICOMManager->GetTag(0x0020, 0x0011,tag)){//series number
		modeloDCM.m_seriesNumber=tag;
	}

	if(pDICOMManager->GetTag(0x0010, 0x0040,tag)){//sexo
		if(tag.compare("M")==0){
			modeloDCM.m_sexo='M';
		}else if(tag.compare("F")==0){
			modeloDCM.m_sexo='F';
		}else if(tag.compare("O")==0){
			modeloDCM.m_sexo='O';
		}else{
			modeloDCM.m_sexo='O';
		}
	}else{
		modeloDCM.m_sexo='O';
	}

	if(pDICOMManager->GetTag(0x0008, 0x0020,tag)){//fecha estudio
		wxDateTime fecha;
		fecha.ParseFormat(wxString::FromUTF8(tag.c_str()),wxT("%Y%m%d"));
		if(fecha.IsValid()){
			modeloDCM.m_fechaEstudio=std::string(fecha.Format(wxT("%Y-%m-%d")).ToUTF8());
		}else{
			modeloDCM.m_fechaEstudio="";
		}
	}else{
		modeloDCM.m_fechaEstudio="";
	}

	if(pDICOMManager->GetTag(0x0008, 0x0030,tag)){//hora del estudio
		wxDateTime hora;
		wxString wxTag = wxString::FromUTF8(tag.c_str());
		hora.ParseFormat(wxTag,wxT("%H%M%S"));
		if(hora.IsValid()){
			std::ostringstream ostr;
			ostr << hora.Format(wxT("%H:%M:%S")).ToUTF8();
			const int posPunto = wxTag.find(wxT("."));
			if (posPunto >= 0) {
				ostr << wxTag.SubString(posPunto, wxTag.size() - 1).ToUTF8();
			}
			modeloDCM.m_horaEstudio=ostr.str();
		}else{
			modeloDCM.m_horaEstudio="";
		}
	}else{
		modeloDCM.m_horaEstudio="";
	}

	if(pDICOMManager->GetTag(0x0008, 0x0021,tag)){//fecha serie
		wxDateTime fecha;
		fecha.ParseFormat(wxString::FromUTF8(tag.c_str()),wxT("%Y%m%d"));
		if(fecha.IsValid()){
			modeloDCM.m_fechaSerie=std::string(fecha.Format(wxT("%Y-%m-%d")).ToUTF8());
		}else{
			modeloDCM.m_fechaSerie="";
		}
	}else{
		modeloDCM.m_fechaSerie="";
	}

	if(pDICOMManager->GetTag(0x0008, 0x0031,tag)){//hora de la serie
		wxDateTime hora;
		wxString wxTag = wxString::FromUTF8(tag.c_str());
		hora.ParseFormat(wxTag,wxT("%H%M%S"));
		if(hora.IsValid()){
			std::ostringstream ostr;
			ostr << hora.Format(wxT("%H:%M:%S")).ToUTF8();
			const int posPunto = wxTag.find(wxT("."));
			if (posPunto >= 0) {
				ostr << wxTag.SubString(posPunto, wxTag.size() - 1).ToUTF8();
			}
			modeloDCM.m_horaSerie=ostr.str();
		}else{
			modeloDCM.m_horaSerie="";
		}
	}else{
		modeloDCM.m_horaSerie="";
	}

	if(pDICOMManager->GetTag(0x0010, 0x0030,tag)){//fecha nacimiento
		wxDateTime fecha;
		fecha.ParseFormat(wxString::FromUTF8(tag.c_str()),wxT("%Y%m%d"));
		if(fecha.IsValid()){
			modeloDCM.m_fechaNacimiento=std::string(fecha.Format(wxT("%Y-%m-%d")).ToUTF8());
		}else{
			modeloDCM.m_fechaNacimiento="";
		}
	}else{
		modeloDCM.m_fechaSerie="";
	}

	if(pDICOMManager->GetTag(0x0008, 0x0022,tag)){//fecha imagen
		wxDateTime fecha;
		fecha.ParseFormat(wxString::FromUTF8(tag.c_str()),wxT("%Y%m%d"));
		if(fecha.IsValid()){
			modeloDCM.m_fechaImagen=std::string(fecha.Format(wxT("%Y-%m-%d")).ToUTF8());
		}else{
			modeloDCM.m_fechaImagen="";
		}
	}else{
		modeloDCM.m_fechaImagen="";
	}

	if(pDICOMManager->GetTag(0x0008, 0x0032,tag)){//hora de la imagen
		wxDateTime hora;
		wxString wxTag = wxString::FromUTF8(tag.c_str());
		hora.ParseFormat(wxTag,wxT("%H%M%S"));
		if(hora.IsValid()){
			std::ostringstream ostr;
			ostr << hora.Format(wxT("%H:%M:%S")).ToUTF8();
			const int posPunto = wxTag.find(wxT("."));
			if (posPunto >= 0) {
				ostr << wxTag.SubString(posPunto, wxTag.size() - 1).ToUTF8();
			}
			modeloDCM.m_horaImagen=ostr.str();
		}else{
			modeloDCM.m_horaImagen="";
		}
	}else{
		modeloDCM.m_horaImagen="";
	}

	if(pDICOMManager->GetTag(0x0008, 0x1030,tag)){//descripcion estudio
		modeloDCM.m_descripcionEstudio=tag;
	}else{
		modeloDCM.m_descripcionEstudio="";
	}

	if(pDICOMManager->GetTag(0x0008, 0x103e,tag)){//descripcion serie
		modeloDCM.m_descripcionSerie=tag;
	}else{
		modeloDCM.m_descripcionSerie="";
	}

	if(pDICOMManager->GetTag(0x0020, 0x4000,tag)){//descripcion imagen
		modeloDCM.m_descripcionImagen=tag;
	}else{
		modeloDCM.m_descripcionImagen="";
	}

	if(pDICOMManager->GetTag(0x0018, 0x1030,tag)){//uid importador
		modeloDCM.m_uidImportador=tag;
	}else{
		modeloDCM.m_uidImportador="";
	}

	if(pDICOMManager->GetTag(0x0008, 0x0060,tag)){//modalidad
		modeloDCM.m_modalidad=tag;
	}else{
		modeloDCM.m_modalidad="";
	}

	if(pDICOMManager->GetTag(0x0008, 0x0090,tag)){//modalidad
		modeloDCM.m_nombreMedico=tag;
	}else{
		modeloDCM.m_nombreMedico="";
	}

	//transfer syntax and sop class
	{
		GIL::DICOM::TipoMetaInfo tags;
		pDICOMManager->CargarMetaInfo(pathAbsoluto, tags);
		if(tags.getTag("0002|0010",tag)) {
			modeloDCM.m_uidTransferSyntax = tag;
		} else {
			modeloDCM.m_uidTransferSyntax = "";
		}
		if(tags.getTag("0002|0002",tag)) {
			modeloDCM.m_sopClassUID = tag;
		} else {
			modeloDCM.m_sopClassUID = "";
		}
	}

	//Tags extra
	if (modeloDCM.m_modalidad != "SR") {
		//se pillan los direction cosines...

		if (pDICOMManager->GetTag(0x0020,0x0037,tag)) {
			double row[3] = {0.0,0.0,0.0};
			double col[3] = {0.0,0.0,0.0};
			char c;
			bool ok = true;
			std::istringstream istr(tag);
			for (int i = 0; i < 3; ++i) {
				if (ok && !istr.eof()) {
					istr >> row[i];
					if (!istr.eof()) {
						istr >> c; //la barra
					}
				} else {
					ok = false;
				}
			}
			for (int i = 0; i < 3; ++i) {
				if (ok && !istr.eof()) {
					istr >> col[i];
					if (!istr.eof()) {
						istr >> c; //la barra
					}
				} else {
					ok = false;
				}
			}
			if (ok) {
				modeloDCM.m_orientacion = makeImageOrientationLabelFromImageOrientationPatient(row[0], row[1], row[2], col[0], col[1], col[2]);
			} else {
				modeloDCM.m_orientacion = 'A';
			}
		} else {
			modeloDCM.m_orientacion = 'A';
		}

		//patient position
		modeloDCM.m_patientPosition[0] = 0.0;
		modeloDCM.m_patientPosition[1] = 0.0;
		modeloDCM.m_patientPosition[2] = 0.0;
		if (pDICOMManager->GetTag(0x0020,0x0032, tag) ) {
			std::istringstream iiPos(tag);

			char c;
			bool ok = true;
			std::istringstream istr(tag);
			for (int i = 0; i < 3; ++i) {
				if (ok && !istr.eof()) {
					istr >> modeloDCM.m_patientPosition[i];
					if (!istr.eof()) {
						istr >> c; //la barra
					}
				} else {
					ok = false;
				}
			}
			if(!ok)
			{
				modeloDCM.m_patientPosition[0] = 0.0;
				modeloDCM.m_patientPosition[1] = 0.0;
				modeloDCM.m_patientPosition[2] = 0.0;
			}
		}

		if (pDICOMManager->GetTag(0x0020,0x0013,tag)) { //instance number
			std::istringstream istr(tag);
			istr >>	modeloDCM.m_instanceNumber;
		} else {
			modeloDCM.m_instanceNumber = 0.0f;
		}

		if (pDICOMManager->GetTag(0x0020,0x1041,tag)) { //slice location
			std::istringstream istr(tag);
			istr >>	modeloDCM.m_sliceLocation;
		} else {
			modeloDCM.m_sliceLocation = 0.0f;
		}


		if (pDICOMManager->GetTag(0x0028,0x0010,tag)) { //rows
			modeloDCM.m_height = tag;
		} else {
			modeloDCM.m_height = "";
		}

		if (pDICOMManager->GetTag(0x0028,0x0011,tag)) { //cols
			modeloDCM.m_width = tag;
		} else {
			modeloDCM.m_width = "";
		}

		if(pDICOMManager->GetTag(0x0008, 0x0023,tag)){//content date
			wxDateTime fecha;
			fecha.ParseFormat(wxString::FromUTF8(tag.c_str()),wxT("%Y%m%d"));
			if(fecha.IsValid()){
				modeloDCM.m_contentDate=std::string(fecha.Format(wxT("%Y-%m-%d")).ToUTF8());
			}else{
				modeloDCM.m_contentDate="";
			}
		}else{
			modeloDCM.m_contentDate="";
		}

		if(pDICOMManager->GetTag(0x0008, 0x0033,tag)){//content time
			wxDateTime hora;
			wxString wxTag = wxString::FromUTF8(tag.c_str());
			hora.ParseFormat(wxTag,wxT("%H%M%S"));
			if(hora.IsValid()){
				std::ostringstream ostr;
				ostr << hora.Format(wxT("%H:%M:%S")).ToUTF8();
				const int posPunto = wxTag.find(wxT("."));
				if (posPunto >= 0) {
					ostr << wxTag.SubString(posPunto, wxTag.size() - 1).ToUTF8();
				}
				modeloDCM.m_contentTime=ostr.str();
			}else{
				modeloDCM.m_contentTime="";
			}
		}else{
			modeloDCM.m_contentTime="";
		}
	}

	//se pillan las referencias...
	{
		GIL::DICOM::TipoJerarquia base;
		pDICOMManager->GetTag(0x0008,0x1140,base);
		GIL::DICOM::TipoJerarquia* pSecuenciaReferencias = base.buscar_secuencia("0008|1140");
		if(pSecuenciaReferencias != NULL) {
			for(GIL::DICOM::TipoJerarquia::ListaJerarquias::iterator it = pSecuenciaReferencias->items.begin(); it!= pSecuenciaReferencias->items.end(); it++) {
				std::string uid;
				if((*it).getTag("0008|1155",uid)){
					modeloDCM.m_listaReferencias.push_back(uid);
				}
			}
		}
	}

	GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pDICOMManager);

	if(copia) {
		std::string rutaDicomDir;
		GNC::Entorno::Instance()->GetPACSController()->GetRutaImagen(modeloDCM.m_idPaciente,modeloDCM.m_uidEstudio,modeloDCM.m_uidSerie,modeloDCM.m_uidImagen,rutaDicomDir);
		modeloDCM.m_pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero(rutaDicomDir);
		//si existe ya el fichero...
		wxString pathDicom = FROMPATH(rutaDicomDir);

		//si el fichero ya esta incluido en el dicomdir avisamos...
		if(!forzarSobreescribir) {
			if ( wxFileExists(pathDicom) ) {
				listaSobreescritos.push_back(pathAbsoluto);
				return false;
			}
		}

		if(pathAbsoluto != rutaDicomDir) {
			if(wxCopyFile(FROMPATH(pathAbsoluto),FROMPATH(rutaDicomDir))) {
				if(mover) {
					wxRemoveFile(FROMPATH(pathAbsoluto));
				}
			} else {
				//no se ha podido copiar
				return false;
			}
		}
		//si copia siempre esta donde deberia
		return true;
	} else {
		std::string rutaDicomDir;
		GNC::Entorno::Instance()->GetPACSController()->GetRutaImagen(modeloDCM.m_idPaciente,modeloDCM.m_uidEstudio,modeloDCM.m_uidSerie,modeloDCM.m_uidImagen,rutaDicomDir,false);
		modeloDCM.m_pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero(rutaDicomDir);
		if(rutaDicomDir != pathAbsoluto)
		{
			return false;
		} else {
			return true;
		}
	}
}

void GNC::GCS::ControladorHistorial::PurgarHistorial()
{
/*TODO hay que borar los ficheros que no existan... aunq mejor en segundo plano
	wxSQLite3StatementBuffer bufSQL;
	bufSQL.Format("SELECT DISTINCT Ficheros.Path "
		"FROM Ficheros");
	wxSQLite3ResultSet resultados = m_pConexion->ExecuteQuery(bufSQL);
	wxArrayString paths;
	while (resultados.NextRow()) {
		if(!wxFileExists(resultados.GetAsString(0))) {
			paths.push_back(resultados.GetAsString(0));
		}
	}
	std::list<std::string> lista;
	for(wxArrayString::iterator it = paths.begin(); it!= paths.end(); it++) {
		lista.push_back(std::string(TOPATH((*it))));
	}
	QuitarFicheros(lista);*/
}

void GNC::GCS::ControladorHistorial::EliminarFicherosDisco(std::list<std::string>&listaFicherosRelativos)
{
	for (std::list<std::string>::iterator it = listaFicherosRelativos.begin(); it!= listaFicherosRelativos.end(); it++) {
		wxString wxPath = FROMPATH(GNC::Entorno::Instance()->GetPathAbsolutoFichero((*it)));
		if(wxFileExists(wxPath)){
			wxRemoveFile(wxPath);
		}
		wxFileName fileName(wxPath);
		//serie
		#if defined(_WINDOWS)
		wxRmDir(fileName.GetPath());
		#else
		wxRmDir(fileName.GetPath().ToUTF8());
		#endif
	}
}

void GNC::GCS::ControladorHistorial::SetThumbnail(const std::string& idPaciente, const std::string& uidEstudio, const std::string& uidSerie, const std::string& pathRelativo, int ancho, int alto, const unsigned char* imagen)
{
	int size = ancho * alto * 3;
	if(size > 0){
		wxSQLite3StatementBuffer bufSQL;
		try {
			bufSQL.Format("INSERT OR REPLACE INTO Thumbnails (IDPaciente,UIDEstudio,UIDSerie,Path,Ancho,Alto,Thumbnail) VALUES ('%q','%q','%q','%q','%d','%d',?);",idPaciente.c_str(),uidEstudio.c_str(),uidSerie.c_str(),pathRelativo.c_str(),ancho,alto);
			wxSQLite3Statement stmt = m_pConexionThumbnails->PrepareStatement(bufSQL);
			if(stmt.IsOk())
			{
				stmt.Bind(1, imagen, size);
				stmt.ExecuteUpdate();
			}
			else {
				LOG_WARN("Historial", "Error al insertar en la base de datos");
			}
		}
		catch (wxSQLite3Exception& ex) {
			LOG_ERROR("Historial", "SetThumbnail " << ex.GetMessage().ToUTF8() << " path = "<< pathRelativo);
		}
	}
}

void GNC::GCS::ControladorHistorial::GetThumbnail(const std::string& pathAbsoluto, int& ancho, int& alto, unsigned char*& imagen)
{
	std::string pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero(pathAbsoluto);
	wxSQLite3StatementBuffer bufSQL;
	try {
		bufSQL.Format("Select Ancho, Alto, Thumbnail FROM Thumbnails WHERE Path = '%q';",pathRelativo.c_str());
		wxSQLite3ResultSet resultados = m_pConexionThumbnails->ExecuteQuery(bufSQL);

		const unsigned char* pbin;
		if (resultados.NextRow())
		{
			ancho = resultados.GetInt(wxT("Ancho"));
			alto = resultados.GetInt(wxT("Alto"));
			int size = ancho*alto*3;
			int blobLen;
			pbin = resultados.GetBlob(wxT("Thumbnail"),blobLen);
			if(blobLen != size) {
				ancho = alto = 0;
				imagen = NULL;
			} else {
				imagen = (unsigned char*)malloc(size*sizeof(unsigned char));
				memcpy(imagen, pbin, size);
			}
		}
	}
	catch (wxSQLite3Exception& ex) {
		LOG_ERROR("Historial", "GetThumbnail "<<ex.GetMessage().ToUTF8());
	}
}

//endergion

