/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "glrr-gobject.h"



static void builtin_module_init (void);

static gpointer create_window_property_editor (gpointer data,
					       gpointer func_data,
					       gpointer invoke_data);



void
g_inspector_builtin_register_module_window_property_editor (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-window-property-editor";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("edit-properties",
				  "Edit Properties",
                                  G_INSPECTOR_PROCEDURE_TYPE_WINDOW,
                                  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
                                  G_TYPE_OBJECT,
				  create_window_property_editor,
                                  NULL);
}



static GtkWidget* create_all_property_list (GObject *object);
static GtkWidget* create_property_list (GObject      *object,
					GType         type,
					GtkSizeGroup *size_group);
static void weak_notify (gpointer  data,
			 GObject  *where_the_object_was);
static void close_button_clicked (GtkButton *button,
				  gpointer   user_data);


static gpointer
create_window_property_editor (gpointer data,
			       gpointer func_data,
			       gpointer invoke_data)
{
  GObject   *object;

  GtkWidget *top;
  GtkWidget *dialog;
  GtkWidget *close_button;


  object = G_OBJECT (data);

  
  dialog = gtk_dialog_new ();
  top = dialog;

  g_inspector_tag_to_widget (dialog);

  {
    gchar     *window_title;
    window_title = g_strdup_printf ("Property Editor: %s: %p",
				    g_get_prgname (), object);
    gtk_window_set_title (GTK_WINDOW (dialog), window_title);
    g_free (window_title);
  }

  {
    g_object_weak_xref (object, weak_notify,
			G_OBJECT (dialog), NULL);
  }

  {
     gtk_window_set_default_size (GTK_WINDOW (dialog),
				  -1, 400);
  }


  {
    close_button = gtk_button_new_with_label ("Close");
    g_signal_connect (close_button,
		      "clicked",
		      G_CALLBACK (close_button_clicked),
		      (gpointer)dialog);
    gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (dialog)->action_area),
				 close_button);
  }


  {
    GtkWidget *scrolled_window;
    GtkWidget *w;

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

    w = create_all_property_list (object);
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window), w);
    gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (scrolled_window)->child),
				  GTK_SHADOW_NONE);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			scrolled_window,
			TRUE, TRUE, 0);
  }

  
  gtk_widget_show_all (top);


  return top;
}

static void
close_button_clicked (GtkButton *button,
                      gpointer   user_data)
{
  gtk_widget_destroy (GTK_WIDGET (user_data));
}

static void
weak_notify (gpointer  data,
	     GObject  *where_the_object_was)
{
  GtkWidget *property_edit_window;

  property_edit_window = GTK_WIDGET (data);

  gtk_widget_destroy (property_edit_window);
}



static GtkWidget *
create_all_property_list (GObject *object)
{
  GtkWidget *top;
  GtkWidget *vbox;
  GtkSizeGroup *size_group;

  GType tmp_type;



  vbox = gtk_vbox_new (FALSE, 0);
  top = vbox;

  size_group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);

  tmp_type = G_OBJECT_TYPE (object);
  while (tmp_type != 0)
    {
      GtkWidget *frame;
      GtkWidget *w;

      frame = gtk_frame_new (g_type_name (tmp_type));
      gtk_box_pack_end (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

      w = create_property_list (object, tmp_type, size_group);
      gtk_container_add (GTK_CONTAINER (frame), w);

      tmp_type = g_type_parent (tmp_type);
    }


  if (size_group->widgets == NULL)
    {
      g_object_unref (size_group);
    }

  return top;
}


static GtkWidget *
create_property_list (GObject      *object,
		      GType         type,
		      GtkSizeGroup *size_group)
{
  GtkWidget *top;
  GtkWidget *vbox;


  vbox = gtk_vbox_new (FALSE, 0);
  top = vbox;


  {
      GParamSpec **properties;
      guint n_properties;
      GParamSpec *spec;
      guint i;


      {
	GObjectClass *object_class;

	object_class = g_type_class_ref (G_OBJECT_TYPE (object));

	properties = g_object_class_list_properties (object_class,
						     &n_properties);

	g_type_class_unref (object_class);
      }

      for (i = 0; i < n_properties; ++i)
	{
	  spec = properties[i];

	  if (spec->owner_type == type)
	    {
	      GtkWidget *hbox;
	      GtkWidget *label;
	      GtkWidget *w;

	      hbox = gtk_hbox_new (FALSE, 0);
	      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	  

	      label = gtk_label_new (spec->name);
	      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	      gtk_size_group_add_widget (size_group, label);
	      gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);



	      w = g_inspector_create_property_editor (object, spec);
	      if (w != NULL)
		{
		  gtk_box_pack_start (GTK_BOX (hbox), w, TRUE, TRUE, 0);
		}
	    }
	}


      if (properties != NULL) {
	g_free (properties);
      }
  }

  return top;
}
