{- This module was generated from data in the Kate syntax
   highlighting file cpp.xml, version 1.49, by  -}

module Text.Highlighting.Kate.Syntax.Cpp
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "C++"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.c++;*.cxx;*.cpp;*.cc;*.C;*.h;*.hh;*.H;*.h++;*.hxx;*.hpp;*.hcc;*.moc"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "C++" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("C++",["Normal"])], synStLanguage = "C++", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "String" -> (popContext) >> pEndLine
    "Region Marker" -> (popContext) >> pEndLine
    "Commentar 1" -> (popContext) >> pEndLine
    "Commentar 2" -> return ()
    "AfterHash" -> (popContext) >> pEndLine
    "Preprocessor" -> (popContext) >> pEndLine
    "Define" -> (popContext) >> pEndLine
    "Commentar/Preprocessor" -> return ()
    "Outscoped" -> return ()
    "Outscoped intern" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "asm break case catch class constexpr const_cast continue decltype default delete do dynamic_cast else enum explicit export extern false friend for goto if inline namespace new nullptr operator private protected public qobject_cast reinterpret_cast return sizeof static_assert static_cast struct switch template this throw true try typedef typeid type_info typename union using virtual while and and_eq bad_cast bad_typeid bitand bitor compl not not_eq or or_eq xor xor_eq"
list_extensions = Set.fromList $ words $ "K_DCOP Q_ARG Q_ASSERT Q_ASSERT_X Q_CHECK_PTR Q_CLASSINFO Q_CLEANUP_RESOURCE Q_D Q_DECLARE_FLAGS Q_DECLARE_FLAGS Q_DECLARE_INTERFACE Q_DECLARE_METATYPE Q_DECLARE_OPERATORS_FOR_FLAGS Q_DECLARE_PRIVATE Q_DECLARE_PUBLIC Q_DECLARE_SHARED Q_DECLARE_TYPEINFO Q_DISABLE_COPY Q_ENUMS Q_EXPORT Q_FLAGS Q_FOREACH Q_FOREVER Q_GADGET Q_GLOBAL_STATIC Q_GLOBAL_STATIC_WITH_ARGS Q_INIT_RESOURCE Q_INTERFACES Q_INVOKABLE Q_NOREPLY Q_OBJECT Q_OVERRIDE Q_PRIVATE_SLOT Q_PROPERTY Q_Q Q_RETURN_ARG Q_SCRIPTABLE Q_SETS Q_SIGNALS Q_SLOTS Q_UNUSED SIGNAL SLOT TRUE FALSE connect disconnect emit signals slots foreach forever qint8 qint16 qint32 qint64 qlonglong qptrdiff qreal quint8 quint16 quint32 quint64 quintptr qulonglong"
list_types = Set.fromList $ words $ "auto bool char char16_t char32_t const double float int long mutable register short signed static unsigned void volatile uchar uint int8_t int16_t int32_t int64_t uint8_t uint16_t uint32_t uint64_t wchar_t"

regex_'23'5cs'2aif'5cs'2b0'5cs'2a'24 = compileRegex "#\\s*if\\s+0\\s*$"
regex_'23'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'5cs'2b'5cS'29 = compileRegex "#\\s*if(?:def|ndef)?(?=\\s+\\S)"
regex_'23'5cs'2aendif = compileRegex "#\\s*endif"
regex_'23'5cs'2adefine'2e'2a'28'28'3f'3d'5c'5c'29'29 = compileRegex "#\\s*define.*((?=\\\\))"
regex_'23'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7cinclude'28'3f'3a'5fnext'29'3f'7cdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 = compileRegex "#\\s*(?:el(?:se|if)|include(?:_next)?|define|undef|line|error|warning|pragma)"
regex_'23'5cs'2b'5b0'2d9'5d'2b = compileRegex "#\\s+[0-9]+"
regex_'23'5cs'2aif = compileRegex "#\\s*if"
regex_'23'5cs'2ael'28'3f'3ase'7cif'29 = compileRegex "#\\s*el(?:se|if)"

defaultAttributes = [("Normal",NormalTok),("String",StringTok),("Region Marker",RegionMarkerTok),("Commentar 1",CommentTok),("Commentar 2",CommentTok),("AfterHash",ErrorTok),("Preprocessor",OtherTok),("Define",OtherTok),("Commentar/Preprocessor",CommentTok),("Outscoped",CommentTok),("Outscoped intern",CommentTok)]

parseRules "Normal" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'5cs'2b0'5cs'2a'24 >>= withAttribute OtherTok) >>~ pushContext "Outscoped")
   <|>
   ((pFirstNonSpace >> lookAhead (pDetectChar False '#') >> pushContext "AfterHash" >> currentContext >>= parseRules))
   <|>
   ((pFirstNonSpace >> pString False "//BEGIN" >>= withAttribute RegionMarkerTok) >>~ pushContext "Region Marker")
   <|>
   ((pFirstNonSpace >> pString False "//END" >>= withAttribute RegionMarkerTok) >>~ pushContext "Region Marker")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_extensions >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "fF" >>= withAttribute FloatTok)))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) (((pString False "ULL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LUL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LLU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "UL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "U" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "L" >>= withAttribute DecValTok))))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Commentar 1")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Commentar 2")
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]{|}~^;" >>= withAttribute NormalTok)))

parseRules "String" =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Region Marker" =
  pzero

parseRules "Commentar 1" =
  (((pLineContinue >>= withAttribute CommentTok))
   <|>
   ((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "Commentar 2" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "AfterHash" =
  (((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'5cs'2b'5cS'29 >>= withAttribute OtherTok) >>~ pushContext "Preprocessor")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute OtherTok) >>~ pushContext "Preprocessor")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2adefine'2e'2a'28'28'3f'3d'5c'5c'29'29 >>= withAttribute OtherTok) >>~ pushContext "Define")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7cinclude'28'3f'3a'5fnext'29'3f'7cdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 >>= withAttribute OtherTok) >>~ pushContext "Preprocessor")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2b'5b0'2d9'5d'2b >>= withAttribute OtherTok) >>~ pushContext "Preprocessor"))

parseRules "Preprocessor" =
  (((pLineContinue >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '"' '"' >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute OtherTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression >>= ((withAttribute OtherTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Commentar/Preprocessor")
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Commentar 1"))

parseRules "Define" =
  ((pLineContinue >>= withAttribute OtherTok))

parseRules "Commentar/Preprocessor" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "Outscoped" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Commentar 1")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Commentar 2")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext "Outscoped intern")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2ael'28'3f'3ase'7cif'29 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute OtherTok) >>~ (popContext)))

parseRules "Outscoped intern" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Commentar 1")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Commentar 2")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext "Outscoped intern")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
