/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLUListElement.h"

#include "HTMLUListElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLUListElement);

/* Hash table */

static const HashTableValue JSHTMLUListElementTableValues[4] =
{
    { "compact", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLUListElementCompact), (intptr_t)setJSHTMLUListElementCompact },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLUListElementType), (intptr_t)setJSHTMLUListElementType },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLUListElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLUListElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSHTMLUListElementTableValues, 0 };
#else
    { 8, 7, JSHTMLUListElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLUListElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLUListElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLUListElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLUListElementConstructorTableValues, 0 };
#endif

class JSHTMLUListElementConstructor : public DOMConstructorObject {
public:
    JSHTMLUListElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLUListElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLUListElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLUListElementConstructor::s_info = { "HTMLUListElementConstructor", 0, &JSHTMLUListElementConstructorTable, 0 };

bool JSHTMLUListElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLUListElementConstructor, DOMObject>(exec, &JSHTMLUListElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLUListElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLUListElementConstructor, DOMObject>(exec, &JSHTMLUListElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLUListElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLUListElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLUListElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLUListElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLUListElementPrototype::s_info = { "HTMLUListElementPrototype", 0, &JSHTMLUListElementPrototypeTable, 0 };

JSObject* JSHTMLUListElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLUListElement>(exec, globalObject);
}

const ClassInfo JSHTMLUListElement::s_info = { "HTMLUListElement", &JSHTMLElement::s_info, &JSHTMLUListElementTable, 0 };

JSHTMLUListElement::JSHTMLUListElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLUListElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLUListElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLUListElementPrototype(JSHTMLUListElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLUListElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLUListElement, Base>(exec, &JSHTMLUListElementTable, this, propertyName, slot);
}

bool JSHTMLUListElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLUListElement, Base>(exec, &JSHTMLUListElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLUListElementCompact(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLUListElement* castedThis = static_cast<JSHTMLUListElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLUListElement* imp = static_cast<HTMLUListElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->compact());
    return result;
}

JSValue jsHTMLUListElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLUListElement* castedThis = static_cast<JSHTMLUListElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLUListElement* imp = static_cast<HTMLUListElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}

JSValue jsHTMLUListElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLUListElement* domObject = static_cast<JSHTMLUListElement*>(asObject(slotBase));
    return JSHTMLUListElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLUListElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLUListElement, Base>(exec, propertyName, value, &JSHTMLUListElementTable, this, slot);
}

void setJSHTMLUListElementCompact(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLUListElement* castedThisObj = static_cast<JSHTMLUListElement*>(thisObject);
    HTMLUListElement* imp = static_cast<HTMLUListElement*>(castedThisObj->impl());
    imp->setCompact(value.toBoolean(exec));
}

void setJSHTMLUListElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLUListElement* castedThisObj = static_cast<JSHTMLUListElement*>(thisObject);
    HTMLUListElement* imp = static_cast<HTMLUListElement*>(castedThisObj->impl());
    imp->setType(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLUListElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLUListElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
