#define ASQL "BEGIN TRANSACTION; \
CREATE TABLE Alarm (ROWID INTEGER PRIMARY KEY AUTOINCREMENT, trigger_date INTEGER, trigger_interval INTEGER, type INTEGER, entity_id INTEGER, entity_type INTEGER); \
CREATE TABLE AlarmChanges (record INTEGER, type INTEGER); \
CREATE TABLE Calendar (ROWID INTEGER PRIMARY KEY AUTOINCREMENT, title TEXT, read_only INTEGER); \
INSERT INTO Calendar (title, read_only) VALUES ('Default', '0'); \
CREATE TABLE CalendarChanges (record INTEGER, type INTEGER); \
CREATE TABLE Event (ROWID INTEGER PRIMARY KEY AUTOINCREMENT, summary TEXT, location TEXT, description TEXT, start_date INTEGER, start_tz TEXT, end_date INTEGER, all_day INTEGER, calendar_id INTEGER, orig_event_id INTEGER, orig_start_date INTEGER); \
CREATE TABLE EventChanges (record INTEGER, type INTEGER); \
CREATE TABLE EventExceptionDate (event_id INTEGER, date INTEGER, UNIQUE(event_id, date)); \
CREATE TABLE OccurrenceCache (day INTEGER, event_id INTEGER, occurrence_date INTEGER, occurrence_start_date INTEGER); \
CREATE TABLE OccurrenceCacheDays (day INTEGER PRIMARY KEY, count INTEGER); \
CREATE TABLE Recurrence (ROWID INTEGER PRIMARY KEY AUTOINCREMENT, frequency INTEGER, interval INTEGER, week_start INTEGER, count INTEGER, cached_end_date INTEGER, cached_end_date_tz TEXT, end_date INTEGER, specifier TEXT, by_month_months INTEGER, event_id INTEGER); \
CREATE TABLE RecurrenceChanges (record INTEGER, type INTEGER); \
CREATE TABLE Task (ROWID INTEGER PRIMARY KEY AUTOINCREMENT, summary TEXT, priority INTEGER, due_date INTEGER, completion_date INTEGER, calendar_id INTEGER); \
CREATE TABLE TaskChanges (record INTEGER, type INTEGER); \
CREATE TABLE _SqliteDatabaseProperties (key TEXT, value TEXT, UNIQUE(key)); \
INSERT INTO _SqliteDatabaseProperties VALUES('_ClientVersion',6); \
INSERT INTO _SqliteDatabaseProperties VALUES('_UniqueIdentifier',NULL); \
INSERT INTO _SqliteDatabaseProperties VALUES('OccurrenceCacheLastSavedDay',0); \
INSERT INTO _SqliteDatabaseProperties VALUES('OccurrenceCacheTimeZone',NULL); \
CREATE INDEX EventCalendarId on Event(calendar_id); \
CREATE INDEX EventExceptionDateEventId on EventExceptionDate(event_id, date); \
CREATE INDEX EventOriginalEventId on Event(orig_event_id); \
CREATE INDEX OccurrenceCacheDay on OccurrenceCache(day); \
CREATE INDEX OccurrenceCacheEventId on OccurrenceCache(event_id); \
CREATE INDEX OccurrenceCacheOccurrenceDate on OccurrenceCache(occurrence_date); \
CREATE INDEX RecurrenceEndCountIndex on Recurrence(end_date, count); \
CREATE INDEX RecurrenceEventIdIndex on Recurrence(event_id); \
CREATE TRIGGER delete_calendar_members AFTER DELETE ON Calendar BEGIN DELETE FROM Task WHERE calendar_id = OLD.ROWID;DELETE FROM Event WHERE calendar_id = OLD.ROWID; END; \
CREATE TRIGGER delete_event_alarms_recurs AFTER DELETE ON Event BEGIN DELETE FROM Alarm WHERE entity_id = OLD.ROWID AND entity_type = 2;DELETE FROM Recurrence WHERE event_id = OLD.ROWID;DELETE FROM EventExceptionDate WHERE event_id = OLD.ROWID;DELETE FROM OccurrenceCache WHERE event_id = OLD.ROWID; END; \
CREATE TRIGGER delete_task_alarms AFTER DELETE ON Task BEGIN DELETE FROM Alarm WHERE entity_id = OLD.ROWID AND entity_type = 3; END; \
CREATE TRIGGER update_cache_days_after_delete AFTER DELETE ON OccurrenceCache BEGIN UPDATE OccurrenceCacheDays SET count = count - 1 WHERE day = OLD.day;DELETE FROM OccurrenceCacheDays WHERE day=OLD.day AND count = 0; END; \
CREATE TRIGGER update_cache_days_after_insert AFTER INSERT ON OccurrenceCache BEGIN REPLACE INTO OccurrenceCacheDays VALUES (NEW.day, 1 + IFNULL((SELECT count FROM OccurrenceCacheDays WHERE day = NEW.day), 0)); END; \
COMMIT;"
