# -*- coding: iso-8859-1 -*-
#
#-------------------------------------------------------------------------------
#
#     This file is part of the Code_Saturne User Interface, element of the
#     Code_Saturne CFD tool.
#
#     Copyright (C) 1998-2008 EDF S.A., France
#
#     contact: saturne-support@edf.fr
#
#     The Code_Saturne User Interface is free software; you can redistribute it
#     and/or modify it under the terms of the GNU General Public License
#     as published by the Free Software Foundation; either version 2 of
#     the License, or (at your option) any later version.
#
#     The Code_Saturne User Interface is distributed in the hope that it will be
#     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
#     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with the Code_Saturne Kernel; if not, write to the
#     Free Software Foundation, Inc.,
#     51 Franklin St, Fifth Floor,
#     Boston, MA  02110-1301  USA

#
#-------------------------------------------------------------------------------

"""
This module defines some useful classes and functions used mainly by
the BaseTkGUI class.

This module defines the following classes and functions:
- GuiParam
- displaySelectedPage
- dicoLabel
"""

#-------------------------------------------------------------------------------
# Library modules import
#-------------------------------------------------------------------------------

import os, sys, logging

#-------------------------------------------------------------------------------
# Application modules import
#-------------------------------------------------------------------------------

from Common import *

#-------------------------------------------------------------------------------
# Global GUI parameters
#-------------------------------------------------------------------------------

class GuiParam(object):
    """
    Language default chooser, and bell ON/OFF switch.
    """
    # 'fr' or 'en' (default)
    #
    try:
        lang = os.environ['LANG'][0:2]
    except Exception:
        lang = 'fr'

    # 'on' (default) or 'off'
    #
    beep = 'on'

    # pdf reader
    #
    pdfReader = 'on'

    # Matisse: False (default) or True
    #
    matisse = False

    # debug
    #
    DEBUG = logging.NOTSET
    #DEBUG = logging.DEBUG

#-------------------------------------------------------------------------------
# displaySelectedPage direct to the good page with its name
#-------------------------------------------------------------------------------

def displaySelectedPage(page_name, root, case, stbar=None, study=None, tree=None):
    """
    This function enables to display a new page when the TreeNavigator
    send the order.
    """
    # 'win' is the frame-support of the Pages
    # 'thisPage' is the instance of classes which create thePages
    # 'page_name' is the name of the page
    #
    if page_name == tr("Identity and paths"):
        import Pages.IdentityAndPathesView as Page
        thisPage = Page.IdentityAndPathesView(root, case, study)

    elif page_name == tr("Meshes selection"):
        import Pages.SolutionDomainView as Page
        thisPage = Page.SolutionDomainView(root, case, stbar)

    elif page_name == tr("Wall thermal coupling"):
        import Pages.SyrthesView as Page
        thisPage = Page.SyrthesView(root, case)

    elif page_name == tr("Solution domain verification"):
        import Pages.SolutionVerifView as Page
        thisPage = Page.SolutionVerifView(root, case)

    elif page_name == tr("Volume regions definition"):
        import Pages.LocalizationView as Page
        thisPage = Page.VolumeLocalizationView(root, case)
##         import Pages.AddScalarFieldBoundView as Page
##         thisPage = Page.AddScalarFieldBoundView(root, case)

    elif page_name == tr("Storage system type"):
        import Pages.MatisseTypeView as Page
        thisPage = Page.MatisseTypeView(root, case)

    elif page_name == tr("Storage system geometry"):
        import Pages.MatisseGeomView as Page
        thisPage = Page.MatisseGeomView(root, case)

    elif page_name == tr("Inlet description"):
        import Pages.MatisseRangeDescriptionView as Page
        thisPage = Page.MatisseRangeDescriptionView(root, case, 'inlet_range')

    elif page_name == tr("Outlet description"):
        import Pages.MatisseRangeDescriptionView as Page
        thisPage = Page.MatisseRangeDescriptionView(root, case, 'outlet_range')

    elif page_name == tr("Network description"):
        import Pages.MatisseNetworkView as Page
        thisPage = Page.MatisseNetworkView(root, case)

    elif page_name == tr("Hydraulic load"):
        import Pages.MatisseHydrauView as Page
        thisPage = Page.MatisseHydrauView(root, case)

    elif page_name == tr("Thermal load"):
        import Pages.MatisseThermicView as Page
        thisPage = Page.MatisseThermicView(root, case)

    elif page_name == tr("Calculation features"):
        import Pages.AnalysisFeaturesView as Page
        thisPage = Page.AnalysisFeaturesView(root, case, tree)

    elif page_name == tr("Mobile mesh"):
        import Pages.MobilMeshView as Page
        thisPage = Page.MobilMeshView(root, case)

    elif page_name == tr("Turbulence models"):
        import Pages.TurbulenceView as Page
        thisPage = Page.TurbulenceView(root, case)

    elif page_name == tr("Thermal model"):
        import Pages.ThermalScalarView as Page
        thisPage = Page.ThermalScalarView(root, case, tree)

##     elif page_name == tr("Gas combustion"):
##         thisPage = root.fr2.p2.fr.window.myPage

    elif page_name == tr("Current species"):
        import Pages.CurrentSpeciesView as Page
        thisPage = Page.CurrentSpeciesView(root, case)

    elif page_name == tr("Pulverized coal combustion"):
        import Pages.CoalCombustionView as Page
        thisPage = Page.CoalCombustionView(root, case, stbar)

##     elif page_name == tr("Electrical models"):
##         thisPage = root.fr2.p2.fr.window.myPage

    elif page_name == tr("Radiative transfers"):
        import Pages.ThermalRadiationView as Page
        thisPage = Page.ThermalRadiationView(root, case, tree)

    elif page_name == tr("Initialization"):
        import Pages.InitializationView as Page
        thisPage = Page.InitializationView(root, case, stbar)

    elif page_name == tr("Head losses"):
        import Pages.HeadLossesView as Page
        thisPage = Page.HeadLossesView(root, case, stbar)

    elif page_name == tr("Reference values"):
        import Pages.ReferenceValuesView as Page
        thisPage = Page.ReferenceValuesView(root, case)

    elif page_name == tr("Fluid properties"):
        import Pages.FluidCharacteristicsView as Page
        thisPage = Page.FluidCharacteristicsView(root, case)

    elif page_name == tr("Gravity, hydrostatic pressure"):
        import Pages.BodyForcesView as Page
        thisPage = Page.BodyForcesView(root, case)

    elif page_name == tr("Definition and initialization"):
        import Pages.DefineUserScalarsView as Page
        thisPage = Page.DefineUserScalarsView(root, case, stbar)

    elif page_name == tr("Physicals properties"):
        import Pages.UserScalarPropertiesView as Page
        thisPage = Page.UserScalarPropertiesView(root, case, stbar)

##     elif page_name == tr("Global parameters"):
##         import Pages.LagrangianView as Page
##         thisPage = Page.LagrangianView(root, case, stbar, tree)

##     elif page_name == tr("Statistics"):
##         thisPage = root.fr2.p2.fr.window.myPage

    elif page_name == tr("Definition of boundary regions"):
        import Pages.LocalizationView as Page
        thisPage = Page.BoundaryLocalizationView(root, case)
##         import Pages.DefineBoundaryRegionsView as Page
##         thisPage = Page.DefBCView(root, case, stbar, tree)

    elif page_name == tr("Dynamic variables boundary conditions"):
        import Pages.BoundaryConditionsView as Page
        thisPage = Page.BoundaryConditionsView(root, case)

    elif page_name == tr("Scalars boundary conditions"):
        import Pages.ScalarsBoundariesView as Page
        thisPage = Page.ScalarsBoundariesView(root, case)

    elif page_name == tr("Radiative boundary conditions"):
        import Pages.RadiativeBoundariesView as Page
        thisPage = Page.RadiativeBoundariesView(root, case)

    elif page_name == tr("Time averages"):
        import Pages.TimeAveragesView as Page
        thisPage = Page.TimeAveragesView(root, case, stbar)

    elif page_name == tr("Time step"):
        import Pages.TimeStepView as Page
        thisPage = Page.TimeStepView(root, case)
##         if GuiParam.matisse :
##             thisPage = Page.TimeStepMatisseView(root, case, stbar)
##         else :
##             thisPage = Page.TimeStepView(root, case, stbar)

    elif page_name == tr("Steady management"):
        import Pages.SteadyManagementView as Page
        thisPage = Page.SteadyManagementView(root, case)

    elif page_name == tr("Output control"):
        import Pages.OutputControlView as Page
        thisPage = Page.OutputControlView(root, case, tree)

    elif page_name == tr("Volume solution control"):
        import Pages.OutputVolumicVariablesView as Page
        thisPage = Page.OutputVolumicVariablesView(root, case)

    elif page_name == tr("Surface solution control"):
        import Pages.OutputSurfacicVariablesView as Page
        thisPage = Page.OutputSurfacicVariablesView(root, case)

    elif page_name == tr("Profiles"):
        import Pages.ProfilesView as Page
        thisPage = Page.ProfilesView(root, case, stbar)

    elif page_name == tr("Equation parameters"):
        import Pages.NumericalParamEquationView as Page
        thisPage = Page.NumericalParamEquationView(root, case)

    elif page_name == tr("Global parameters"):
        import Pages.NumericalParamGlobalView as Page
        thisPage = Page.NumericalParamGlobalView(root, case)

    elif page_name == tr("User arrays"):
        import Pages.UserArraysView as Page
        thisPage = Page.UserArraysView(root, case)

    elif page_name == tr("Memory management"):
        import Pages.MemoryAllocationView as Page
        thisPage = Page.MemoryAllocationView(root, case)

    elif page_name == tr("Start/Restart"):
        import Pages.StartRestartView as Page
        thisPage = Page.StartRestartView(root, case)

    elif page_name == tr("Prepare batch calculation"):
        import Pages.BatchRunningView as Page
        thisPage = Page.BatchRunningView(root, case)

    else:
        msg = tr("Warning: the corresponding Page %s doesn't exist!") % page_name
        print msg
        # So we display the Welcome Page!
        import Pages.WelcomeView as Page
        thisPage = Page.WelcomeView()

    return thisPage


def tr(text):
    """
    Translation
    """
    return text

#-------------------------------------------------------------------------------
# Dictionary : dependance between names and labels
#-------------------------------------------------------------------------------

def dicoLabel(name):
    """
    Correspondence between the names and the labels according to
    whether one is in French or in English.
    """
    for (n, labF, labE) in [('velocity_U',           "VitesseX", "VelocitU"),
                            ('velocity_V',           "VitesseY", "VelocitV"),
                            ('velocity_W',           "VitesseZ", "VelocitW"),
                            ('pressure',             "Pression", "Pressure"),
                            ('turb_k',               "EnerTurb", "TurbEner"),
                            ('turb_eps',             "Dissip",   "Dissip"),
                            ('turb_viscosity',       "visc. tu", "turb. vi"),
                            ('component_R11',        "R11",      "R11"),
                            ('component_R22',        "R22",      "R22"),
                            ('component_R33',        "R33",      "R33"),
                            ('component_R12',        "R12",      "R12"),
                            ('component_R13',        "R13",      "R13"),
                            ('component_R23',        "R23",      "R23"),
                            ('turb_phi',             "phi",  "phi"),
                            ('turb_fb',              "fb",   "fb"),
                            ('turb_omega',           "omega",    "omega"),
                            ('smagorinsky_constant', "Csdyn2",   "Csdyn2"),
                            ('temperature_celsius',  "Temp.C",   "Temp.C"),
                            ('temperature_kelvin',   "Temp.K",   "Temp.K"),
                            ('enthalpy',             "Enthal.",  "Enthalpy"),
                            ('density',              "Masse vo", "Density"),
                            ('molecular_viscosity',  "Visc. la", "Lam. vis"),
                            ('specific_heat',        "Ch.spec.", "Sp. heat"),
                            ('thermal_conductivity', "Cond. th", "Th. cond"),
                            ('local_time_step',      "pdtlocal", "loc.time"),
                            ('courant_number',       "Nb Courant", "Courant nb"),
                            ('fourier_number',       "Nb Fourier", "Fourier nb"),
                            ('weight_matrix_X',      "VPsolve1",       "VPsolve1"),
                            ('weight_matrix_Y',      "VPsolve2",       "VPsolve2"),
                            ('weight_matrix_Z',      "VPsolve3",       "VPsolve3")]:

        if n == name:
            if GuiParam.lang == 'fr':
                label = labF
            else:
                label = labE

    return label


def dicoRayLabel():
    """
    """
    dico = {}
    rayName = ['srad',     'qrad',     'absorp',  'emiss',    'coefAb',
                'wall_temp', 'flux_incident', 'thermal_conductivity', 'thickness',
                'emissivity', 'flux_net',      'flux_convectif',  'coeff_ech_conv']

    raylabF = ['Srad',       'Qrad',          'Absorp',     'Emiss',    'CoefAb',
                'Temp_paroi', 'Flux_incident', 'Conductivite_th', 'Epaisseur',
            'Emissivite', 'Flux_net',      'Flux_convectif',  'Coeff_ech_conv']

    raylabE = ['Srad',      'Qrad',      'Absorp',          'Emiss',    'CoefAb',
                'Wall_temp', 'Flux_incident', 'Th_conductivity', 'Thickness',
            'Emissivity','Flux_net',      'Flux_convectif',  'Coeff_ech_conv']

    dico['name'] = rayName
    dico['labF'] = raylabF
    dico['labE'] = raylabE
    if GuiParam.lang == 'fr':
        label = dico['labF']
    else:
        label = dico['labE']

    return dico['name'], label

#-------------------------------------------------------------------------------
# End of Toolbox
#-------------------------------------------------------------------------------
