#ifndef IMCONNECTION_HH_
#define IMCONNECTION_HH_
#include <list>
#include "basictype.hh"
#include "IMHandler.hh"
#include "IMSvr.hh"

class IMInputContext;
class IMUser;
class IMDesktop;
class IMConnection : public IMHandler
{
    IMUser *puser;
    IMDesktop *pdesktop;
    IMSvr *pimsvr;
    string hostname;

    LEMgr* get_lemgr()
    { return pimsvr->get_lemgr(); }

  public:
    IMUser *get_user()
    { return puser; }
    IMDesktop *get_desktop();
    IMSvr* get_imsvr()
    { return pimsvr; }
    const string& get_hostname() const
    { return hostname; }
    IMConnection(
	IMSvr *pimsvr,
	IMUser *user,
	const string &hostname
    );
  protected:
    virtual ~IMConnection();

  public:
    /* IMHandler realization */
    virtual bool set_client_info(
	const IMHandler::ClientAttrList& attrlist
    );
    virtual bool get_triggerkeys(
	IMKeySpecList &onkeys,
	IMKeySpecList &offkeys
    );
    virtual const IMLangList* get_langlist(iml_desktop_t *);
    virtual const IMObjectWithDescList* get_imobjectdesclist();
    virtual IMHotkeyProfileStruct* get_hotkey_profiles(int *count_profiles);
    virtual const IMDescriptorList* get_imdesclist(iml_desktop_t *);
    virtual const bool update_imdesclist(
        IMLEName *LEname,
        IMLocale *Locales,
        int nLocales
    );
    virtual const IMObject* get_imobject(
	int attribid
    );
    virtual ICHandler* createic(
	ICAttribute &icattr
    );
    virtual void destroy()
    { delete this; }
};

#endif /* not IMCONNECTION_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
