#ifndef IM_HOTKEY_PRIMITIVE_HH_
#define IM_HOTKEY_PRIMITIVE_HH_

class IMKeySpec;
typedef list<IMKeySpec> IMKeySpecList;

class IMHotkey
{
  int hotkey_id;
  int state_flag;
  int action_flag;
  IMKeySpecList keys;
  u16string label;

private:

  IMKeySpecList* get_keylist() { return &keys; }

public:

  const int get_hotkey_id() const { return hotkey_id; }
  const int get_state_flag() const { return state_flag; }
  const int get_action_flag() const { return action_flag; }
  const IMKeySpecList* get_keylist() const { return &keys; } 
  const u16string& get_label() const { return label; }

  IMHotkey(
      int a_id,
      const IMHotkeyStruct& hk,
      const u16string& label);
  IMHotkey(
      int a_id,
      int sflag,
      int aflag,
      const IMKeySpecList& a_keys,
      const u16string& a_label
  ) : hotkey_id(a_id), state_flag(sflag),
      action_flag(aflag), keys(a_keys), label(a_label) {}

friend class IIIMP_hotkey_profile;

};

typedef list<IMHotkey> IMHotkeyList;

class IMHotkeyProfile {

private:

  IMHotkeyList hklist;
  int profile_id;
  const IMHotkeyProfileStruct *hotkey_profile_struct;

private:

  IMHotkeyList *get_hotkey_list() { return &hklist; }

public:

  const int get_profile_id() const
  { return profile_id; }
  const IMHotkeyList *get_hotkey_list() const
  { return &hklist; }
  const IMHotkeyProfileStruct *get_hotkey_profile_struct() const
  { return hotkey_profile_struct; }

  IMHotkeyProfile(
      int a_id,
      int hk_id, 
      const IMHotkeyProfileStruct *imhkp
  );
  IMHotkeyProfile(
      int a_id, 
      const IMHotkeyList& a_hklist
  ) : profile_id(a_id), hklist(a_hklist), hotkey_profile_struct(NULL) {}


friend class IIIMP_hotkey_profile;
};

typedef list<IMHotkeyProfile> IMHotkeyProfileList ;

#endif
