#if !defined(IIIMP_FILE_OPERATION_H)
#define IIIMP_FILE_OPERATION_H


#ifdef	__cplusplus
extern "C" {
#endif

/* IIIMP_FILE_OPERATION */

enum IIIMP_FILE_OPERATION {
	IIIMP_FILE_OPERATION_NONE 	= 0,

	IIIMP_FILE_OPERATION_CLOSE 	= 1,
	IIIMP_FILE_OPERATION_CREAT 	= 2,
	IIIMP_FILE_OPERATION_FTRUNCATE 	= 3,
	IIIMP_FILE_OPERATION_LSEEK 	= 4,
	IIIMP_FILE_OPERATION_OPEN 	= 5,
	IIIMP_FILE_OPERATION_READ 	= 6,
	IIIMP_FILE_OPERATION_TRUNCATE 	= 7,
	IIIMP_FILE_OPERATION_WRITE 	= 8,

	IIIMP_FILE_OPERATION_LINK 	= 9,
	IIIMP_FILE_OPERATION_READLINK 	= 10,
	IIIMP_FILE_OPERATION_RENAME 	= 11,
	IIIMP_FILE_OPERATION_SYMLINK 	= 12,
	IIIMP_FILE_OPERATION_UNLINK 	= 13,

	IIIMP_FILE_OPERATION_CHMOD 	= 14,
	IIIMP_FILE_OPERATION_CHOWN 	= 15,
	IIIMP_FILE_OPERATION_FCHMOD 	= 16,
	IIIMP_FILE_OPERATION_FCHOWN 	= 17,
	IIIMP_FILE_OPERATION_LCHOWN 	= 18,
	IIIMP_FILE_OPERATION_UTIME 	= 19,
	IIIMP_FILE_OPERATION_UTIMES 	= 20,

	IIIMP_FILE_OPERATION_FSTAT 	= 21,
	IIIMP_FILE_OPERATION_LSTAT 	= 22,
	IIIMP_FILE_OPERATION_STAT 	= 23,
	IIIMP_FILE_OPERATION_ACCESS 	= 24,

	IIIMP_FILE_OPERATION_CLOSEDIR 	= 25,
	IIIMP_FILE_OPERATION_OPENDIR 	= 26,
	IIIMP_FILE_OPERATION_READDIR 	= 27,
	IIIMP_FILE_OPERATION_REWINDDIR 	= 28,
	IIIMP_FILE_OPERATION_SEEKDIR 	= 29,
	IIIMP_FILE_OPERATION_TELLDIR 	= 30,

	IIIMP_FILE_OPERATION_MKDIR 	= 31,
	IIIMP_FILE_OPERATION_RMDIR 	= 32,

	IIIMP_FILE_OPERATION_FCNTL 	= 33,

	IIIMP_FILE_OPERATION_LAST 	= 34
};


/*
 * open flag
 */
#define IIIMP_FILE_OPERATION_OPEN_O_RDONLY		(0)
#define IIIMP_FILE_OPERATION_OPEN_O_WRONLY		(1)
#define IIIMP_FILE_OPERATION_OPEN_O_RDWR		(2)
#define IIIMP_FILE_OPERATION_OPEN_O_APPEND		(0x0008)
#define IIIMP_FILE_OPERATION_OPEN_O_CREAT		(0x0100)
#define IIIMP_FILE_OPERATION_OPEN_O_TRUNC		(0x0200)
#define IIIMP_FILE_OPERATION_OPEN_O_EXCL		(0x0400)

/*
 * fcntl request
 */
#define IIIMP_FILE_OPERATION_FCNTL_F_SETFD		(2)
#define IIIMP_FILE_OPERATION_FCNTL_F_SETFL		(4)
#define IIIMP_FILE_OPERATION_FCNTL_F_GETLK		(5)
#define IIIMP_FILE_OPERATION_FCNTL_F_SETLK		(6)
#define IIIMP_FILE_OPERATION_FCNTL_F_SETLKW		(7)


/*
 * fcntl file descriptor flags
 */
#define IIIMP_FILE_OPERATION_FCNTL_SETFD_FLAG_FD_CLOEXEC	(1)


/*
 * fcntl flock type
 */
#define IIIMP_FILE_OPERATION_FCNTL_FLOCK_TYPE_F_RDLCK	(1)
#define IIIMP_FILE_OPERATION_FCNTL_FLOCK_TYPE_F_WRLCK	(2)
#define IIIMP_FILE_OPERATION_FCNTL_FLOCK_TYPE_F_UNLCK	(3)
#define IIIMP_FILE_OPERATION_FCNTL_FLOCK_TYPE_F_UNLKSYS	(4)


/*
 * whence
 */
#define IIIMP_FILE_OPERATION_WHENCE_SEEK_SET		(0)
#define IIIMP_FILE_OPERATION_WHENCE_SEEK_CUR		(1)
#define IIIMP_FILE_OPERATION_WHENCE_SEEK_END		(2)


/*
 * access mode
 */
#define IIIMP_FILE_OPERATION_ACCESS_F_OK		(0)
#define IIIMP_FILE_OPERATION_ACCESS_X_OK		(1)
#define IIIMP_FILE_OPERATION_ACCESS_W_OK		(2)
#define IIIMP_FILE_OPERATION_ACCESS_R_OK		(4)


/*
 * error number
 */
#define IIIMP_FILE_OPERATION_ERRNO_NONE			(0)
#define IIIMP_FILE_OPERATION_ERRNO_EPERM		(1)
#define IIIMP_FILE_OPERATION_ERRNO_ENOENT		(2)
#define IIIMP_FILE_OPERATION_ERRNO_EINTR		(4)
#define IIIMP_FILE_OPERATION_ERRNO_EIO			(5)
#define IIIMP_FILE_OPERATION_ERRNO_ENXIO		(6)
#define IIIMP_FILE_OPERATION_ERRNO_EBADF		(9)
#define IIIMP_FILE_OPERATION_ERRNO_EAGAIN		(11)
#define IIIMP_FILE_OPERATION_ERRNO_ENOMEM		(12)
#define IIIMP_FILE_OPERATION_ERRNO_EACCES		(13)
#define IIIMP_FILE_OPERATION_ERRNO_EFAULT		(14)
#define IIIMP_FILE_OPERATION_ERRNO_EBUSY		(16)
#define IIIMP_FILE_OPERATION_ERRNO_EEXIST		(17)
#define IIIMP_FILE_OPERATION_ERRNO_EXDEV		(18)
#define IIIMP_FILE_OPERATION_ERRNO_ENOTDIR		(20)
#define IIIMP_FILE_OPERATION_ERRNO_EISDIR		(21)
#define IIIMP_FILE_OPERATION_ERRNO_EINVAL		(22)
#define IIIMP_FILE_OPERATION_ERRNO_ENFILE		(23)
#define IIIMP_FILE_OPERATION_ERRNO_EMFILE		(24)
#define IIIMP_FILE_OPERATION_ERRNO_ETXTBSY		(26)
#define IIIMP_FILE_OPERATION_ERRNO_EFBIG		(27)
#define IIIMP_FILE_OPERATION_ERRNO_ENOSPC		(28)
#define IIIMP_FILE_OPERATION_ERRNO_EROFS		(30)
#define IIIMP_FILE_OPERATION_ERRNO_EMLINK		(31)
#define IIIMP_FILE_OPERATION_ERRNO_EDEADLK		(45)
#define IIIMP_FILE_OPERATION_ERRNO_ENOLCK		(46)
#define IIIMP_FILE_OPERATION_ERRNO_EDQUOT		(49)
#define IIIMP_FILE_OPERATION_ERRNO_ENAMETOOLONG		(78)
#define IIIMP_FILE_OPERATION_ERRNO_EOVERFLOW		(79)
#define IIIMP_FILE_OPERATION_ERRNO_ENOSYS		(89)
#define IIIMP_FILE_OPERATION_ERRNO_ELOOP		(90)


#ifdef	__cplusplus
}
#endif

#endif /* !IIIMP_FILE_OPERATION_H */


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
