/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <string.h>

#include "codetable.h"
#include "unit_input.h"
#include "SunIM.h"
#include "logf.h"
#include "keymap.h"

#define LOOKUP_CHOICE_NUM   7

#define IME_Status  ime_buffer->return_status
#define Input_Buf  ime_buffer->inputkey_buf
#define Input_Len  ime_buffer->inputkey_len
#define Preedit_Buf  ime_buffer->preedit_buf
#define Preedit_Len  ime_buffer->preedit_len
#define Preedit_CaretPos ime_buffer->preedit_caretpos
#define Commit_Buf  ime_buffer->commit_buf
#define Commit_Len  ime_buffer->commit_len
#define Status_Buf  ime_buffer->status_buf
#define Status_Len  ime_buffer->status_len
#define Lookup_Buf  ime_buffer->lookup_buf
#define Lookup_Num  ime_buffer->lookup_num
#define Lookup_Pos  ime_buffer->cur_lookup_pos
#define Candidates_Buf  ime_buffer->candidates_buf
#define Additions_Buf  ime_buffer->additions_buf
#define DeadKey_Flag  ime_buffer->hotkey_flag

int Is_UsedCodes_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  if ( index(hztbl->UsedCodes, key) )
    return(1);
  else
    return(0);
}

int get_select_num(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  int ret = -1;
  switch(hztbl->nSelectKeyMode)
    {
    case NUMBER_MODE:
      if (key >= '0' && key <= '9')
	ret = (key - '0' + 9) % 10;
      break;

    case LOWER_MODE:
      if (key >= 'a' && key <= 'a' + 10)
	ret = key - 'a';
      break;

    case UPPER_MODE:
      if (key >= 'A' && key <= 'A' + 10)
	ret = key - 'A';
      break;
    }
  return(ret);
}

int Is_Select_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  int ret = get_select_num(hztbl, key);
  if (ret == -1)
    return(0);
  else
    return(1);
}

int Is_Commit_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  if (key == SPACE_KEY || key == RETURN_KEY)
    return(1);
  else
    return(0);
}

int Is_BackSpace_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[BACKSPACE_KEY_ID].keylist;

  if (key == BACKSPACE_KEY || key == DELETE_KEY)
    return(1);

  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }

  return(0);
}

int Is_ClearAll_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[CLEARALL_KEY_ID].keylist;

  if (key == ESC_KEY)
    return(1);

  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }
  return(0);
}

int Is_NextPage_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[PAGEDOWN_KEY_ID].keylist;

  if (key == PAGEDOWN_KEY)
    return(1);

  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }
  return(0);
}

int Is_PrevPage_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[PAGEUP_KEY_ID].keylist;

  if (key == PAGEUP_KEY)
    return(1);
 
  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }
  return(0);
}

int get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, pos, max_lookup_num)
     CodeTableStruct *hztbl;
     IMEBufferRec *ime_buffer;
     int nHelpInfoMode;
     int pos;
     int max_lookup_num;
{
  int i, lookup_num;

  log_f("get_lookup_result : Input_Len[%d]\n",Input_Len);
  lookup_num = codetable_search(hztbl, Input_Buf, Input_Len, Candidates_Buf, Additions_Buf, pos, max_lookup_num); 
  if (lookup_num > 0)
    {
      for (i=0; i<lookup_num; i++)
	{
	  log_f("%d: %s %s\n", i, Candidates_Buf[i], Additions_Buf[i]);
	  if (nHelpInfoMode)
	    sprintf((char *)Lookup_Buf[i], "%s %s", Candidates_Buf[i], Additions_Buf[i]);
	  else
	    strcpy(Lookup_Buf[i], Candidates_Buf[i]);
	}
    }
  return(lookup_num);
}

int commit_candidate(ime_buffer, id)
     IMEBufferRec *ime_buffer;
     int id;
{
  if (id >= Lookup_Num)
    return(-1);
 
  strcpy((char *)Commit_Buf, (char *)Candidates_Buf[id]);
  Commit_Len = strlen((char *)Commit_Buf);
  log_f("Inside commit_candidate, Commit_Buf <%s>\n",Commit_Buf);
  IME_Status = IME_COMMIT;
  Input_Len = 0;
  Input_Buf[Input_Len] = 0;
  Preedit_Len = 0;
  Lookup_Num = 0;
  Preedit_CaretPos = 0;
  IME_Status |= IME_PREEDIT_AREA | IME_LOOKUP_AREA;
  if (DeadKey_Flag == IME_HOTKEY_START)
    DeadKey_Flag = IME_HOTKEY_END;
  return(0);
}

int commit_candidate2(ime_buffer, key)
     IMEBufferRec *ime_buffer;
     int key;
{
  Commit_Len = 0;
  Commit_Buf[Commit_Len] = key;
  Commit_Len++;
  Commit_Buf[Commit_Len] = '\0';
  Commit_Len = strlen((char *)Commit_Buf);
  IME_Status = IME_COMMIT;
  Input_Len = 0;
  Input_Buf[Input_Len] = 0;
  Preedit_Len = 0;
  Lookup_Num = 0;
  Preedit_CaretPos = 0;
  IME_Status |= IME_PREEDIT_AREA | IME_LOOKUP_AREA;
  if (DeadKey_Flag == IME_HOTKEY_START)
    DeadKey_Flag = IME_HOTKEY_END;
  return(0);
}


void warning_bell()
{
}

/* return value:  IME_NOT_USED_KEY:  if IME not use this key, return this key to systerm directly */
/*                IME_USED_KEY:      if IME has used this key */
int codetable_filter(hztbl, key_event, ime_buffer)
     CodeTableStruct *hztbl;
     IMEKey key_event;
     IMEBufferRec *ime_buffer;
{
  int     i, hznum;
  int     keycode, modifier, pos;
  int nLookup_Pos_Save = 0;
  int  bNeedCheckMore = 0;
  int is_dead_key = 0;
  int prev_Input_Len;
  static int static_prev_Input_Buf[MAX_INPUT_KEY_NUM];
  int *prev_Input_Buf = static_prev_Input_Buf;
 
  int  Max_Lookup_Num = LOOKUP_CHOICE_NUM;
  int  nKeyByKeyMode = hztbl->nKeyByKeyMode;
  int  nHelpInfoMode = hztbl->nHelpInfoMode;
  int  nAutoSelectMode = hztbl->nAutoSelectMode;
  int  nKeyPromptMode = hztbl->nKeyPromptMode;
 
  ime_buffer->encode = hztbl->Encode;

  IME_Status = 0;

  if((key_event->keyCode >= 65) && (key_event->keyCode <= 90)){
    if (key_event->keyCode == key_event->keyChar && key_event->modifier == 0)
      /* CAPS_LOCK is pressed */
        modifier = 1;
      else
        modifier = key_event->modifier;
  }else{
    modifier = 0;
    /* for dead key support */
    if ((key_event->keyCode >= 128) && (key_event->keyCode <= 143))
      is_dead_key = 1;
  }

  keycode = map_keyevent_to_imekey(hztbl, key_event);
  log_f("ctfilter: map_keyevent_to_imekey: return keycode:0x%x\n", keycode);
 
  if (keycode == IME_NOT_USED_KEY)
    return(IME_NOT_USED_KEY);
  else if (keycode == 0xb1){ /* PlusMinus */
    key_event->keyCode = keycode = IM_VK_MINUS;
  } else if ((keycode == 0xd1) || (keycode == 0xf1)) {
     is_dead_key = 1;
     modifier = key_event->modifier;
  /*
  } else if (keycode == 0x7e) {
     is_dead_key = 1;
     key_event->keyCode = keycode = IM_VK_DEAD_TILDE ;
  */
  } else if ((keycode == IM_VK_4) || (keycode == IM_VK_5)) {
     if (key_event->modifier & IM_ALT_GRAPH_MASK)
       modifier = key_event->modifier;
  } else if ((keycode >= IM_VK_DEAD_GRAVE) && (keycode <= IM_VK_DEAD_SEMIVOICED_SOUND)) {
     is_dead_key = 1;
     key_event->keyCode = keycode;
  }
 
  switch(hztbl->nSelectKeyMode) {
  case NUMBER_MODE:
    ime_buffer->lookup_label_type = NUMERIC_LABEL;
    break;
  case LOWER_MODE:
    ime_buffer->lookup_label_type = LOWER_LABEL;
    break;
  case UPPER_MODE:
    ime_buffer->lookup_label_type = UPPER_LABEL;
    break;
  default:
    ime_buffer->lookup_label_type = NUMERIC_LABEL;
  }

  if((Is_UsedCodes_Key(hztbl, keycode)) || (Is_Wildchar_Key(hztbl, keycode)) || (keycode == IM_VK_COMPOSE) || (is_dead_key)) { 
    prev_Input_Buf = Input_Buf;
    prev_Input_Len = Input_Len;

    if (Input_Len >= hztbl->MaxCodes) {
      warning_bell();
      return (IME_USED_KEY);
    }

    /* if not key by key, and is selectkey, and Lookup Mode */
    /* directly select */

    if(!nKeyByKeyMode && (Is_Select_Key(hztbl, key_event->keyChar)) && (Lookup_Num>0)) { 

      /* select from candidata */
      /* here should see whether there is enough candidates */

      int select_num;
      select_num = get_select_num(hztbl, keycode);
      if ((select_num >= 0) && (select_num < Lookup_Num)) {
        commit_candidate(ime_buffer, select_num);
      }else warning_bell();

      return(IME_USED_KEY);
    }
  
    Input_Buf[Input_Len] = key_event->keyCode;
    /*
    Input_Buf[Input_Len] = keycode;
    */
    Input_Len ++;
    Input_Buf[Input_Len] = modifier ;
    Input_Len ++;
    Input_Buf[Input_Len] = 0;
    log_f("ctfilter: Input_Len[%d]\n", Input_Len);
    for(i=0;i<Input_Len;i++) 
      log_f("Input_Buf [%d]\n",Input_Buf[i]);

    if ((key_event->keyCode == 84) && (key_event->modifier == 3) && (Input_Len == 2)){
      return(IME_USED_KEY);
    }

    Lookup_Num = 0;
    bNeedCheckMore = 0;
    /* if need display key by key */
    if (nKeyByKeyMode) {
      nLookup_Pos_Save = Lookup_Pos;
      Lookup_Pos = 0;
      Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num); 
      log_f("Lookup_Num [%d]\n",Lookup_Num);
      log_f("Preedit_Len [%d]\n",Preedit_Len);
      if (Lookup_Num == 1 && nAutoSelectMode) {
        commit_candidate(ime_buffer, 0);
        return(IME_USED_KEY);
      }

      if (Lookup_Num == 0) {
        /* if key is also a seleck key */
        if (Is_Select_Key(hztbl, key_event->keyChar))
          bNeedCheckMore = 1;
        else {
          Input_Buf = prev_Input_Buf;
          Input_Len = prev_Input_Len;
          if (Input_Len == 0) {
            commit_candidate2(ime_buffer, key_event->keyChar);
            return(IME_NOT_USED_KEY);
          }
          nLookup_Pos_Save = Lookup_Pos;
          Lookup_Pos = 0;
          Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num);
          commit_candidate(ime_buffer, 0);
          Input_Len = 0;
          Input_Buf[Input_Len] = key_event->keyCode;
          // Input_Buf[Input_Len] = keycode;
          Input_Len ++;
          Input_Buf[Input_Len] = modifier;
          Input_Len ++;
          Input_Buf[Input_Len] = '\0';
          Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num);
          if (Lookup_Num == 0) {
            Commit_Len = 0;
            Commit_Buf[Commit_Len] = '\0';
            Input_Len = 0;
            Input_Buf[Input_Len] = 0;
            Preedit_Len = 0;
            Preedit_Buf[Preedit_Len] = '\0';
            return(IME_USED_KEY);
          }
          Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num);
          if (bNeedCheckMore == 0) {
	    size_t copy_length = strlen (Candidates_Buf[0]);
	    copy_length = (copy_length > MAX_PREEDIT_CHAR_NUM ?
		           MAX_PREEDIT_CHAR_NUM : copy_length);
	    strncpy (Preedit_Buf, Candidates_Buf[0], copy_length);
	    Preedit_Buf[copy_length] = 0;
	    Preedit_Len = strlen(Preedit_Buf);
            Preedit_CaretPos = Preedit_Len;
            return(IME_USED_KEY);
          }
        }
      }
      log_f("prev_Input_Len [%d], Input_Len [%d]\n",prev_Input_Len, Input_Len);
      if (prev_Input_Len != Input_Len) {
        /*
	      It seems that the code below which caused a memory leak by
	        Preedit_Buf = strdup(Candidates_Buf[0]);
        is not actually used.

        Anyway, we should avoid strdup here, as Preedit_Buf
        (ime_buffer->preedit_buf) is allocated in different place
        (ime_buffer_malloc). Let's do string copy.
        */
	      size_t copy_length = strlen (Candidates_Buf[0]);
	      copy_length = (copy_length > MAX_PREEDIT_CHAR_NUM ?
		             MAX_PREEDIT_CHAR_NUM : copy_length);
	      strncpy (Preedit_Buf, Candidates_Buf[0], copy_length);
	      Preedit_Buf[copy_length] = 0;
	      Preedit_Len = strlen(Preedit_Buf);
	      log_f("Preedit_Buf: [%s]\n",Preedit_Buf);
	      log_f("strlen of Preedit_Buf: [%d]\n",strlen(Preedit_Buf));
      }
    } else {
      Preedit_Buf[Preedit_Len] = key_event->keyChar;
      Preedit_Len = strlen(Preedit_Buf);
      Preedit_Buf[Preedit_Len] = '\0';
      log_f("Preedit_Buf: [%s]\n",Preedit_Buf);
      log_f("strlen of Preedit_Buf: [%d]\n",strlen(Preedit_Buf));
    }
    Preedit_CaretPos = Preedit_Len;
    IME_Status = IME_PREEDIT_AREA;

    if (bNeedCheckMore == 0) {
      IME_Status |= IME_LOOKUP_AREA;
      return(IME_USED_KEY);
    }
  }
  
  if (bNeedCheckMore == 1) {
    /* restore the original status that before into this function */
    IME_Status = 0;
    Input_Len-=2;
    if (Input_Len) {
      Input_Buf[Input_Len] = 0;
      Lookup_Pos = nLookup_Pos_Save;
      Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos,Max_Lookup_Num);
    }
    commit_candidate2(ime_buffer, key_event->keyChar);
    return(IME_NOT_USED_KEY);
  }

  if (Is_Select_Key(hztbl, keycode)) { /* select from candidata */
    /* here should see whether there is enough candidates */
    int select_num;

    /*  if no inputted key, directly return this key */
    if ((Input_Len==0) || (Lookup_Num==0)) return(IME_NOT_USED_KEY);
    log_f("Select Key, keycode:%c, Lookup_Num:%d\n", keycode, Lookup_Num);
    select_num = get_select_num(hztbl, keycode);
    log_f("select_num :%d\n",select_num);
    if (Lookup_Num>0 && (select_num >= 0) && (select_num < Lookup_Num)) {
      commit_candidate(ime_buffer, select_num);
    } else warning_bell();

    return(IME_USED_KEY);
  }

  if (Is_ClearAll_Key(hztbl, key_event->keyChar)) { 
    /* Esc , clear preedit, lookup choice pointer, and so on */
    log_f("ESC_KEY\n");
    /*  if no inputted key, directly return this key */
    if (Input_Len==0) return(IME_NOT_USED_KEY);
  
    Input_Len = 0;
    Preedit_Len = 0;
    Lookup_Num = 0;
    Preedit_CaretPos = 0;
    IME_Status = IME_PREEDIT_AREA | IME_LOOKUP_AREA;
    return (IME_USED_KEY);
  }

  if (Is_BackSpace_Key(hztbl, keycode)) { /* Back Space & Delete */
    log_f("BACKSPACE_KEY\n");
    /*  if no inputted key, directly return this key */
    if ((Input_Len==0) || (Preedit_Len==0) || (Lookup_Num==0)) return(IME_NOT_USED_KEY);
  
    /* Delete characters in pre-edit region */
    Input_Len -= 2;
    if (nKeyPromptMode) {
      Preedit_Len = 0;
      Preedit_Buf[Preedit_Len] = '\0';
    }else{
      Preedit_Len = 0;
      Preedit_Buf[Preedit_Len] = '\0';
    }

    Input_Buf[Input_Len] = 0;
    Preedit_CaretPos = Preedit_Len;
    IME_Status = IME_PREEDIT_AREA;

    Lookup_Num = 0;
  
    /* if still left some keys, and need display key by key, then search. */
    /* else undisplay the candidate window */
    if ((Input_Len > 0) && nKeyByKeyMode) {
      Lookup_Pos = 0;
      Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num); 
    }

    IME_Status |= IME_LOOKUP_AREA;
    return(IME_USED_KEY);
  }

  if (Is_NextPage_Key(hztbl, keycode)) { /* select from candidata */
    /*  if no inputted key, directly return this key */
    if (Input_Len==0) return(IME_NOT_USED_KEY);

    /* if any preedit key and not in Lookup status */
    log_f("NextPage:  Lookup_Num:%d\n", Lookup_Num);
    if (Lookup_Num==0) return(IME_USED_KEY);

    pos = Lookup_Pos + Max_Lookup_Num;
    log_f("NextPage: pos:%d\n", pos);
    hznum = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, pos, Max_Lookup_Num); 
    if (hznum > 0) {
      Lookup_Num = hznum;
      Lookup_Pos = pos;
      IME_Status = IME_LOOKUP_AREA;
    }else warning_bell();
    
    return(IME_USED_KEY);

  }

  if (Is_PrevPage_Key(hztbl, keycode)) { /* select from candidata */

    /*  if no inputted key, directly return this key */
    if (Input_Len==0) return(IME_NOT_USED_KEY);
    log_f("PrevPage:  Lookup_Num:%d\n", Lookup_Num);
    /* if any preedit key and not in Lookup status */
    if (Lookup_Num==0) return(IME_USED_KEY);
  
    /* if in beginning pos */
    if (Lookup_Pos<=0) {
      warning_bell();
      return(IME_USED_KEY);
    }

    pos = Lookup_Pos - Max_Lookup_Num;
    hznum = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, pos, Max_Lookup_Num); 
    log_f("hznum :%d\n", hznum);
    if (hznum > 0) {
      Lookup_Num = hznum;
      Lookup_Pos = pos;
      IME_Status = IME_LOOKUP_AREA;
    }else warning_bell();

    return(IME_USED_KEY);
  }

  if (Is_Commit_Key(hztbl, keycode)) { /* space or return key */
    log_f("Space or Return key, Commit Key ===\n");
    /* if no input keys and no candidates */
    if (Input_Len==0 && Lookup_Num==0)
      return(IME_NOT_USED_KEY);

    /* if any candidates, then commit the first candidate */
    if (Lookup_Num > 0) {
      log_f("Commit Key , Commit the first candidate===\n");
      commit_candidate(ime_buffer, 0);
      return(IME_USED_KEY);
    }

    /* if any keys and key is Space key and mode is not keybykey */
    /* then search and display the candidates */
    if (key_event->keyChar == SPACE_KEY && !nKeyByKeyMode) {
      Lookup_Pos = 0;
      Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num); 
      log_f("Lookup_Num:%d\n", Lookup_Num);
      if (Lookup_Num == 1 && nAutoSelectMode) {
        commit_candidate(ime_buffer, 0);
        return(IME_USED_KEY);
      }

      if (Lookup_Num == 0)
        warning_bell();

      IME_Status = IME_LOOKUP_AREA;
      return(IME_USED_KEY);
    }

    return(IME_USED_KEY);
  }

  /* for unnormal keys */
  log_f(" unnormal keycode:%d\n", keycode);
  if (Input_Len==0) return(IME_NOT_USED_KEY);
  else return(IME_USED_KEY);
}

