#include <stdio.h>
#include <stdlib.h>
#include <iiimcf.h>
#include <time.h>
#include "common.h"

IIIMCF_context context;

static void
create_context()
{
    check(iiimcf_create_context(handle, IIIMCF_ATTR_NULL, &context));
}

static void
destroy_context(
    IIIMCF_context c
)
{
    check(iiimcf_destroy_context(c));
}

static void
check_status(
    IIIMCF_context c
)
{
    int flag;

    check(iiimcf_is_UIstate_changed(c, &flag));

    if (flag & IIIMCF_STATE_PREEDIT_CHANGED) {
	test_show_preedit_info(c);
    }
    if (flag & IIIMCF_STATE_STATUS_CHANGED) {
	test_show_status_info(c);
    }
    if (flag & IIIMCF_STATE_LOOKUP_CHOICE_CHANGED) {
	test_show_lookup_choice_info(c);
    }
    if (flag & IIIMCF_STATE_COMMIT_REQUIRED) {
	test_show_commit_info(c);
    }
    test_show_incoming_events(c, 0);
}

int
main(
    int argc,
    char **argv
)
{
    test_init();
    create_context();
    test_forwardkey(context, IIIMF_KEYCODE_A, 'a', 0);
    check_status(context);
    test_trigger(context, 1);
    check_status(context);
    test_forwardkey(context, IIIMF_KEYCODE_K, 'k', 0);
    check_status(context);
    test_forwardkey(context, IIIMF_KEYCODE_U, 'u', 0);
    check_status(context);
    test_forwardkey(context, IIIMF_KEYCODE_1, '1', 0);
    check_status(context);
    test_forwardkey(context, IIIMF_KEYCODE_ENTER, 0, 0);
    check_status(context);
    test_trigger(context, 0);
    check_status(context);
    destroy_context(context);
    test_uninit();

    return 0;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */

