#if !defined(IIIMF_SEQUENCE_H)
#define IIIMF_SEQUENCE_H


#include <iiimp-data.h>
#include <iiimp.h>


#ifdef	__cplusplus
extern "C" {
#endif


#define IIIMF_MESSAGE_ATTR_ACTIVE_MASK			(0x000FFF00)
#define IIIMF_MESSAGE_ATTR_SEND				(0x00000000)
#define IIIMF_MESSAGE_ATTR_RECEIVE			(0x00000001)
#define IIIMF_MESSAGE_ATTR_ROLE_DIRECTION_MASK		(0x00000001)
#define IIIMF_MESSAGE_ATTR_NONE				(0x00000000)
#define IIIMF_MESSAGE_ATTR_ROLE_CLIENT			(0x00000000)
#define IIIMF_MESSAGE_ATTR_ROLE_SERVER			(0x00000001)
#define IIIMF_MESSAGE_ATTR_ROLE_BOTH			(0x00000002)
#define IIIMF_MESSAGE_ATTR_REQUEST			(0x00000010)
#define IIIMF_MESSAGE_ATTR_REPLY			(0x00000020)
#define IIIMF_MESSAGE_ATTR_NO_REPLY			(0x00000040)
#define IIIMF_MESSAGE_ATTR_IM_ACTIVE			(0x00000100)
#define IIIMF_MESSAGE_ATTR_IM_IM_CONNECT		(0x00000200)
#define IIIMF_MESSAGE_ATTR_IC_ACTIVE			(0x00001000)
#define IIIMF_MESSAGE_ATTR_STATUS_ACTIVE		(0x00002000)
#define IIIMF_MESSAGE_ATTR_PREEDIT_ACTIVE		(0x00004000)
#define IIIMF_MESSAGE_ATTR_LOOKUP_CHOICE_ACTIVE		(0x00008000)
#define IIIMF_MESSAGE_ATTR_AUX_ACTIVE			(0x00010000)


typedef struct {
    int		opcode;
    int		direction;
} IIIMF_message_pending;


extern IIIMF_status	iiimf_message_sequence(IIIMF_im *	im,
					       IIIMF_ic *	ic,
					       IIIMP_message *	message,
					       int		direction);


#ifdef	__cplusplus
}
#endif

#endif /* !IIIMF_SEQUENCE_H */


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
