/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#pragma ident	"$Id$"

#define		IM_AUX_CLASS_MAX	11

#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "iiimpAux.h"
#include "xaux_common.h"
#include "xaux_so_common.h"

extern aux_method_t xaux_so_methods;

static const CARD16	im_aux_utfname_palette[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'P','a','l','e','t','t','e','A','u','x',
};
static const CARD16	im_aux_utfname_systemline[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'S','y','s','t','e','m','L','i','n','e','A','u','x',
};
static const CARD16	im_aux_utfname_regword[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'R','e','g','W','o','r','d','A','u','x',
};
static const CARD16	im_aux_utfname_property[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'P','r','o','p','e','r','t','y','A','u','x',
};
static const CARD16	im_aux_utfname_dicut[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'D','i','c','U','T','A','u','x',
};
static const CARD16	im_aux_utfname_help[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'H','e','l','p','A','u','x',
};
static const CARD16	im_aux_utfname_error[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'W','a','r','n','i','n','g','M','s','g','A','u','x',
};
static const CARD16	im_aux_utfname_charpalette[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'C','h','a','r','P','a','l','e','t','t','e','A','u','x',
};
static const CARD16	im_aux_utfname_customizer[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'C','u','s','t','o','m','i','z','e','r','A','u','x',
};
static const CARD16	im_aux_utfname_lookup[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'L','o','o','k','u','p','A','u','x',
};

static const CARD16	im_aux_utfname_versionquery[] = {
			'c','o','m','.',
			's','u','n','.',
			's','a','m','p','l','e','j','a','4','.',
			'V','e','r','s','i','o','n','Q','u','e','r','y','A','u','x',
};

xaux_so_class_t xaux_classes[IM_AUX_CLASS_MAX + 1] = {
	{
		NULL,
		"com.sun.sampleja4.PaletteAux", NULL, 1,
		"PaletteAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_palette,
		Initial, False, NULL,
	},
	{
		NULL,
		"com.sun.sampleja4.SystemLineAux", NULL, 2,
		"SystemLineAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_systemline,
		Initial, False, NULL,
	},
	{
		NULL,
		"com.sun.sampleja4.RegWordAux", NULL, 3,
		"RegWordAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_regword,
		Initial, False, NULL,
	},
	{
		NULL,
		"com.sun.sampleja4.PropertyAux", NULL, 4,
		"PropertyAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_property,
		Initial, False, NULL,
	},
	{
		NULL,
		"com.sun.sampleja4.DicUTAux", NULL, 5,
		"DicUTAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_dicut,
		Initial, False, NULL,
	},
	{
		NULL,
		"com.sun.sampleja4.HelpAux", NULL, 6,
		"HelpAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_help,
		Initial, False, NULL,
	},
	{
		NULL,
		"com.sun.sampleja4.WarningMsgAux", NULL, 7,
		"WarningMsgAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_error,
		Initial, False, NULL,
	},
	{
		NULL,
		"com.sun.sampleja4.CharPaletteAux", NULL, 8,
		"CharPaletteAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_charpalette,
		Initial, False, NULL,
	},
	{
		NULL,
		"com.sun.sampleja4.CustomizerAux", NULL, 9,
		"CustomizerAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_customizer,
		Initial, False, NULL,
	},
	{
		NULL,
		"com.sun.sampleja4.LookupAux", NULL, 10,
		"LookupAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_lookup,
		Initial, False, NULL,
	},
	{
		NULL,
		"com.sun.sampleja4.VersionQueryAux", NULL, 0,
		NULL,
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		im_aux_utfname_versionquery,
		Initial, False, NULL,
	},
	{
		NULL,
		NULL, NULL, -1,
		NULL,
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, (Atom)0, (Atom)0,
		NULL, NULL, NULL,
		NULL,
		Initial, False, NULL,
	}
};

aux_dir_t aux_dir[IM_AUX_CLASS_MAX + 1] = {
	{
		{
			sizeof (im_aux_utfname_palette),
			(CARD16 *)im_aux_utfname_palette,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (im_aux_utfname_systemline),
			(CARD16 *)im_aux_utfname_systemline,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (im_aux_utfname_regword),
			(CARD16 *)im_aux_utfname_regword,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (im_aux_utfname_property),
			(CARD16 *)im_aux_utfname_property,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (im_aux_utfname_dicut),
			(CARD16 *)im_aux_utfname_dicut,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (im_aux_utfname_help),
			(CARD16 *)im_aux_utfname_help,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (im_aux_utfname_error),
			(CARD16 *)im_aux_utfname_error,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (im_aux_utfname_charpalette),
			(CARD16 *)im_aux_utfname_charpalette,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (im_aux_utfname_customizer),
			(CARD16 *)im_aux_utfname_customizer,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (im_aux_utfname_lookup),
			(CARD16 *)im_aux_utfname_lookup,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (im_aux_utfname_versionquery),
			(CARD16 *)im_aux_utfname_versionquery,
		},
		&VersionQueryAux_methods,
	},
	{0, NULL, NULL}
};

/*
 * default version (major, minor) of external modules
 */
const int xaux_so_default_extversion[2] = { 1, 0 };
const int xaux_so_setvalue_id_sendversion = 333;

/*
 * primary path for external executables
 */
const char *xaux_so_extexec_path = "/usr/lib/iiim/le/sampleja4/xaux";
