#ifndef IIIMSTATUS_HH_

#define IIIMSTATUS_HH_
#include <iiimcf.h>
#include <qframe.h>

class IIIMStatusWidget : public QFrame
{
    Q_OBJECT;

  public:
    enum LOCATION_REFERENCE {
	    TOP_LEFT,
	    TOP_RIGHT,
	    BOTTOM_LEFT,
	    BOTTOM_RIGHT
    };

  private:
    enum LOCATION_REFERENCE locref;
    QWidget *pwlocref;

    QSize currentsize;
    IIIMCF_context ctx;

    void drawContents(
	QPainter *p
    );

    QSize sizeHint() const;
    QSize minimumSizeHint() const;

    void adjust_location(
	const QSize& size
    );

    void resizeEvent(
	QResizeEvent *pre
    );

  public slots:
    void ref_change();
  
  public:
    void update_im();
    void place(
	QWidget *plocation_reference,
	enum LOCATION_REFERENCE ref
    );

    IIIMStatusWidget(
	IIIMCF_context ctx,
	QWidget *parent = 0,
	const char *name = 0,
	WFlags f = 0
    );
    ~IIIMStatusWidget();
};

#endif

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */


