#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"
#include "print-misc.h"


IIIMP_message *
iiimp_getimvalues_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16_list *	attr_list)
{
    IIIMP_message *	m;

    REQUIRE_PROTOCOL_VERSION(data_s, 3);

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_GETIMVALUES;
    m->im_id = im_id;
    m->ic_id = -1;
    m->v.getimvalues.attr_list = attr_list;
    return m;
}



void
iiimp_getimvalues_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_card16_list_delete(data_s, m->v.getimvalues.attr_list);
    free(m);
    return;
}


uchar_t *
iiimp_getimvalues_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16_list *	attr_list,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;

    nbyte = 0;
    nbyte += 2;	/* input method id */
    nbyte += 2;	/* PAD(2) */
    nbyte += 4;	/* byte length of data_s-attribute */
    nbyte += attr_list->nbyte;
    nbyte += PAD(nbyte);

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_GETIMVALUES, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(0, rest, p, data_s->byte_swap);
    PUTU32(attr_list->nbyte, rest, p, data_s->byte_swap);
    iiimp_card16_list_pack(data_s, attr_list, &rest, &p);
    if (0 != rest) {
        PUT16(0, rest, p, data_s->byte_swap);
    }

    return buf;

}


IIIMP_message *
iiimp_getimvalues_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *		m;
    IIIMP_getimvalues_v *	v;
    size_t			rest;
    const uchar_t *		p;
    int				len;
    int				pad;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.getimvalues);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    m->ic_id = -1;
    SKIP16(rest, p);
    GET32(len, rest, p, data_s->byte_swap);
    pad = PAD2(len);

    if ((len < 0) || (rest < (len + pad)) || (0 != (len & 0x01))) {
	iiimp_getimvalues_delete(data_s, m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    if (0 < len) {
	v->attr_list = iiimp_card16_list_unpack(data_s, &rest, &p, len);
	if (NULL == v->attr_list) {
	    iiimp_getimvalues_delete(data_s, m);
	    return NULL;
	}
    } else {
	v->attr_list = NULL;
    }

    *nbyte = (rest - len);
    *ptr = (p + len);

    return m;
}


void
iiimp_getimvalues_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    IIIMP_getimvalues_v *	v;
    int				i;
    int				id;
    int				id_pre;
    int				id_dyn;

    v = &(m->v.getimvalues);
    iiimp_message_header_print(data_s, m->opcode, m->im_id, -1);

    for (i = 0; i < v->attr_list->count; i++) {
	id = *(v->attr_list->ptr + i);
	if (0x1000 & id) {
	    id_pre = id;
	    id_dyn = 0;
	} else {
	    id_pre = iiimp_attribute_id_search(data_s, id);
	    id_dyn = id;
	}
	(void)fprintf(data_s->print_fp, "\t%s",
		      imattribute_id_string_get(id_pre));
	if (0 != id_dyn) {
	    (void)fprintf(data_s->print_fp, " (dynamic=%d)", id_dyn);
	}
	(void)fputc('\n', data_s->print_fp);
    }
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
