# ImVirt - I'm virtualized?
#
# $Id: pcidevs.pm 517 2010-03-29 17:58:20Z liske $
#
# Authors:
#   Thomas Liske <liske@ibh.de>
#
# Copyright Holder:
#   2009 - 2010 (C) IBH IT-Service GmbH [http://www.ibh.de/]
#
# License:
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this package; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
#

package ImVirt::Utils::pcidevs;

use strict;
use warnings;
use IO::Handle;
require Exporter;
our @ISA = qw(Exporter);

our @EXPORT = qw(
    pcidevs_get
);

our $VERSION = '0.1';

my %pcidevs;

pipe(PARENT_RDR, CHILD_WTR);
if(my $pid = fork()) {
    close(CHILD_WTR);
    foreach my $line (<PARENT_RDR>) {
	chomp($line);
	unless($line =~ /^([\da-f:.]+) "([^"]*)" "([^"]*)" "([^"]*)" ([^"]*) ?"([^"]*)" "([^"]*)"$/) {
	    warn "Unexpected output from lspci: $line\n";
	    next;
	}

	$pcidevs{$1} = {
	    'addr' => $1,
	    'type' => $2,
	    'vendor' => $3,
	    'device' => $4,
	    'rev' => $5,
	};
    }
    close(PARENT_RDR);
} else {
    die "Cannot fork: $!\n" unless defined($pid);

    close(PARENT_RDR);
    open(STDOUT, '>&CHILD_WTR') || die "Could not dup: $!\n";

    exec('lspci', '-m');

    die("Cannot exec lspci: $!\n");
}

sub pcidevs_get() {
    return %pcidevs;
}

1;
