/* music-player-bridge.c generated by valac 0.14.0, the Vala compiler
 * generated from music-player-bridge.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>


#define TYPE_MUSIC_PLAYER_BRIDGE (music_player_bridge_get_type ())
#define MUSIC_PLAYER_BRIDGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MUSIC_PLAYER_BRIDGE, MusicPlayerBridge))
#define MUSIC_PLAYER_BRIDGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MUSIC_PLAYER_BRIDGE, MusicPlayerBridgeClass))
#define IS_MUSIC_PLAYER_BRIDGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MUSIC_PLAYER_BRIDGE))
#define IS_MUSIC_PLAYER_BRIDGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MUSIC_PLAYER_BRIDGE))
#define MUSIC_PLAYER_BRIDGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MUSIC_PLAYER_BRIDGE, MusicPlayerBridgeClass))

typedef struct _MusicPlayerBridge MusicPlayerBridge;
typedef struct _MusicPlayerBridgeClass MusicPlayerBridgeClass;
typedef struct _MusicPlayerBridgePrivate MusicPlayerBridgePrivate;

#define TYPE_SETTINGS_MANAGER (settings_manager_get_type ())
#define SETTINGS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MANAGER, SettingsManager))
#define SETTINGS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MANAGER, SettingsManagerClass))
#define IS_SETTINGS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MANAGER))
#define IS_SETTINGS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MANAGER))
#define SETTINGS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MANAGER, SettingsManagerClass))

typedef struct _SettingsManager SettingsManager;
typedef struct _SettingsManagerClass SettingsManagerClass;

#define TYPE_PLAYER_CONTROLLER (player_controller_get_type ())
#define PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_CONTROLLER, PlayerController))
#define PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))
#define IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_CONTROLLER))
#define IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_CONTROLLER))
#define PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))

typedef struct _PlayerController PlayerController;
typedef struct _PlayerControllerClass PlayerControllerClass;

#define TYPE_MPRIS2_WATCHER (mpris2_watcher_get_type ())
#define MPRIS2_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS2_WATCHER, Mpris2Watcher))
#define MPRIS2_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS2_WATCHER, Mpris2WatcherClass))
#define IS_MPRIS2_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS2_WATCHER))
#define IS_MPRIS2_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS2_WATCHER))
#define MPRIS2_WATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS2_WATCHER, Mpris2WatcherClass))

typedef struct _Mpris2Watcher Mpris2Watcher;
typedef struct _Mpris2WatcherClass Mpris2WatcherClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define PLAYER_CONTROLLER_TYPE_STATE (player_controller_state_get_type ())
typedef struct _PlayerControllerPrivate PlayerControllerPrivate;

#define TYPE_PLAYER_ITEM (player_item_get_type ())
#define PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_ITEM, PlayerItem))
#define PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_ITEM, PlayerItemClass))
#define IS_PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_ITEM))
#define IS_PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_ITEM))
#define PLAYER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_ITEM, PlayerItemClass))

typedef struct _PlayerItem PlayerItem;
typedef struct _PlayerItemClass PlayerItemClass;

#define TYPE_MPRIS2_CONTROLLER (mpris2_controller_get_type ())
#define MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2Controller))
#define MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))
#define IS_MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS2_CONTROLLER))
#define IS_MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS2_CONTROLLER))
#define MPRIS2_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))

typedef struct _Mpris2Controller Mpris2Controller;
typedef struct _Mpris2ControllerClass Mpris2ControllerClass;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _MusicPlayerBridge {
	GObject parent_instance;
	MusicPlayerBridgePrivate * priv;
};

struct _MusicPlayerBridgeClass {
	GObjectClass parent_class;
};

struct _MusicPlayerBridgePrivate {
	SettingsManager* settings_manager;
	DbusmenuMenuitem* root_menu;
	GeeHashMap* registered_clients;
	Mpris2Watcher* watcher;
};

typedef enum  {
	PLAYER_CONTROLLER_STATE_OFFLINE,
	PLAYER_CONTROLLER_STATE_INSTANTIATING,
	PLAYER_CONTROLLER_STATE_READY,
	PLAYER_CONTROLLER_STATE_CONNECTED,
	PLAYER_CONTROLLER_STATE_DISCONNECTED
} PlayerControllerstate;

struct _PlayerController {
	GObject parent_instance;
	PlayerControllerPrivate * priv;
	gint current_state;
	DbusmenuMenuitem* root_menu;
	GeeArrayList* custom_items;
	Mpris2Controller* mpris_bridge;
	gboolean* use_playlists;
};

struct _PlayerControllerClass {
	GObjectClass parent_class;
};


static gpointer music_player_bridge_parent_class = NULL;

GType music_player_bridge_get_type (void) G_GNUC_CONST;
GType settings_manager_get_type (void) G_GNUC_CONST;
GType player_controller_get_type (void) G_GNUC_CONST;
GType mpris2_watcher_get_type (void) G_GNUC_CONST;
#define MUSIC_PLAYER_BRIDGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MUSIC_PLAYER_BRIDGE, MusicPlayerBridgePrivate))
enum  {
	MUSIC_PLAYER_BRIDGE_DUMMY_PROPERTY
};
#define MUSIC_PLAYER_BRIDGE_DEVICE_ITEMS_COUNT 3
MusicPlayerBridge* music_player_bridge_new (void);
MusicPlayerBridge* music_player_bridge_construct (GType object_type);
static void music_player_bridge_on_blacklist_update (MusicPlayerBridge* self, gchar** blacklist, int blacklist_length1);
static gchar* music_player_bridge_determine_key (gchar* desktop_or_interface);
void player_controller_remove_from_menu (PlayerController* self);
void mpris2_watcher_check_for_active_clients (Mpris2Watcher* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris2_watcher_check_for_active_clients_finish (Mpris2Watcher* self, GAsyncResult* _res_);
static void music_player_bridge_try_to_add_inactive_familiar_clients (MusicPlayerBridge* self);
GeeArrayList* settings_manager_fetch_interested (SettingsManager* self);
static GAppInfo* music_player_bridge_create_app_info (const gchar* desktop);
static gchar* music_player_bridge_fetch_icon_name (const gchar* desktop);
static gint music_player_bridge_calculate_menu_position (MusicPlayerBridge* self);
GType player_controller_state_get_type (void) G_GNUC_CONST;
PlayerController* player_controller_new (DbusmenuMenuitem* root, GAppInfo* app, const gchar* dbus_name, const gchar* icon_name, gint offset, gboolean* use_playlists, PlayerControllerstate initial_state);
PlayerController* player_controller_construct (GType object_type, DbusmenuMenuitem* root, GAppInfo* app, const gchar* dbus_name, const gchar* icon_name, gint offset, gboolean* use_playlists, PlayerControllerstate initial_state);
#define PLAYER_CONTROLLER_WIDGET_QUANTITY 4
void music_player_bridge_client_has_become_available (MusicPlayerBridge* self, const gchar* desktop, const gchar* dbus_name, gboolean use_playlists);
gchar** settings_manager_fetch_blacklist (SettingsManager* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void settings_manager_add_interested (SettingsManager* self, const gchar* app_desktop_name);
static gboolean* _bool_dup (gboolean* self);
GType player_item_get_type (void) G_GNUC_CONST;
GType mpris2_controller_get_type (void) G_GNUC_CONST;
void player_controller_update_state (PlayerController* self, PlayerControllerstate new_state);
void player_controller_activate (PlayerController* self, const gchar* dbus_name);
void music_player_bridge_client_has_vanished (MusicPlayerBridge* self, const gchar* mpris_root_interface);
void player_controller_hibernate (PlayerController* self);
void music_player_bridge_set_root_menu_item (MusicPlayerBridge* self, DbusmenuMenuitem* menu);
Mpris2Watcher* mpris2_watcher_new (void);
Mpris2Watcher* mpris2_watcher_construct (GType object_type);
static void _music_player_bridge_client_has_become_available_mpris2_watcher_client_appeared (Mpris2Watcher* _sender, const gchar* desktop_file_name, const gchar* dbus_name, gboolean use_playlists, gpointer self);
static void _music_player_bridge_client_has_vanished_mpris2_watcher_client_disappeared (Mpris2Watcher* _sender, const gchar* dbus_name, gpointer self);
void music_player_bridge_enable_player_specific_items_for_client (MusicPlayerBridge* self, const gchar* object_path, const gchar* desktop_id);
void player_controller_enable_player_specific_items (PlayerController* self, const gchar* object_path);
void music_player_bridge_enable_track_specific_items_for_client (MusicPlayerBridge* self, const gchar* object_path, const gchar* desktop_id);
void player_controller_enable_track_specific_items (PlayerController* self, const gchar* object_path);
static GObject * music_player_bridge_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
SettingsManager* settings_manager_new (void);
SettingsManager* settings_manager_construct (GType object_type);
static void _music_player_bridge_on_blacklist_update_settings_manager_blacklist_updates (SettingsManager* _sender, gchar** new_blacklist, int new_blacklist_length1, gpointer self);
static void music_player_bridge_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


MusicPlayerBridge* music_player_bridge_construct (GType object_type) {
	MusicPlayerBridge * self = NULL;
	self = (MusicPlayerBridge*) g_object_new (object_type, NULL);
	return self;
}


MusicPlayerBridge* music_player_bridge_new (void) {
	return music_player_bridge_construct (TYPE_MUSIC_PLAYER_BRIDGE);
}


static void music_player_bridge_on_blacklist_update (MusicPlayerBridge* self, gchar** blacklist, int blacklist_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	Mpris2Watcher* _tmp15_;
	g_return_if_fail (self != NULL);
	g_debug ("music-player-bridge.vala:45: some blacklist update");
	_tmp0_ = blacklist;
	_tmp0__length1 = blacklist_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp0_;
		s_collection_length1 = _tmp0__length1;
		for (s_it = 0; s_it < _tmp0__length1; s_it = s_it + 1) {
			gchar* _tmp1_;
			gchar* s = NULL;
			_tmp1_ = g_strdup (s_collection[s_it]);
			s = _tmp1_;
			{
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_ = NULL;
				gchar* key;
				GeeHashMap* _tmp5_;
				const gchar* _tmp6_;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = s;
				_tmp3_ = g_strdup (_tmp2_);
				_tmp4_ = music_player_bridge_determine_key (_tmp3_);
				key = _tmp4_;
				_tmp5_ = self->priv->registered_clients;
				_tmp6_ = key;
				_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp6_);
				if (_tmp7_) {
					const gchar* _tmp8_;
					GeeHashMap* _tmp9_;
					const gchar* _tmp10_;
					gpointer _tmp11_ = NULL;
					PlayerController* _tmp12_;
					GeeHashMap* _tmp13_;
					const gchar* _tmp14_;
					_tmp8_ = key;
					g_debug ("music-player-bridge.vala:50: Apparently %s is now blacklisted - remove" \
" thy self", _tmp8_);
					_tmp9_ = self->priv->registered_clients;
					_tmp10_ = key;
					_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
					_tmp12_ = (PlayerController*) _tmp11_;
					player_controller_remove_from_menu (_tmp12_);
					_g_object_unref0 (_tmp12_);
					_tmp13_ = self->priv->registered_clients;
					_tmp14_ = key;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, _tmp14_, NULL);
				}
				_g_free0 (key);
				_g_free0 (s);
			}
		}
	}
	_tmp15_ = self->priv->watcher;
	mpris2_watcher_check_for_active_clients (_tmp15_, NULL, NULL);
}


static void music_player_bridge_try_to_add_inactive_familiar_clients (MusicPlayerBridge* self) {
	g_return_if_fail (self != NULL);
	{
		SettingsManager* _tmp0_;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _desktop_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _desktop_size;
		gint _desktop_index;
		_tmp0_ = self->priv->settings_manager;
		_tmp1_ = settings_manager_fetch_interested (_tmp0_);
		_desktop_list = _tmp1_;
		_tmp2_ = _desktop_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_desktop_size = _tmp4_;
		_desktop_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* desktop;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			GAppInfo* _tmp15_ = NULL;
			GAppInfo* _tmp16_;
			GAppInfo* app_info;
			GAppInfo* _tmp17_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* mpris_key;
			DbusmenuMenuitem* _tmp22_;
			GAppInfo* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gint _tmp27_ = 0;
			PlayerController* _tmp28_;
			PlayerController* _tmp29_;
			PlayerController* ctrl;
			GeeHashMap* _tmp30_;
			const gchar* _tmp31_;
			PlayerController* _tmp32_;
			_tmp5_ = _desktop_index;
			_desktop_index = _tmp5_ + 1;
			_tmp6_ = _desktop_index;
			_tmp7_ = _desktop_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _desktop_list;
			_tmp9_ = _desktop_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			desktop = (gchar*) _tmp10_;
			_tmp11_ = desktop;
			g_debug ("music-player-bridge.vala:62: interested client found : %s", _tmp11_);
			_tmp12_ = desktop;
			_tmp13_ = g_strconcat (_tmp12_, ".desktop", NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = music_player_bridge_create_app_info (_tmp14_);
			_tmp16_ = _tmp15_;
			_g_free0 (_tmp14_);
			app_info = _tmp16_;
			_tmp17_ = app_info;
			if (_tmp17_ == NULL) {
				const gchar* _tmp18_;
				_tmp18_ = desktop;
				g_warning ("music-player-bridge.vala:65: Could not create app_info for path %s \n" \
" Getting out of here ", _tmp18_);
				_g_object_unref0 (app_info);
				_g_free0 (desktop);
				continue;
			}
			_tmp19_ = desktop;
			_tmp20_ = g_strdup (_tmp19_);
			_tmp21_ = music_player_bridge_determine_key (_tmp20_);
			mpris_key = _tmp21_;
			_tmp22_ = self->priv->root_menu;
			_tmp23_ = app_info;
			_tmp24_ = desktop;
			_tmp25_ = music_player_bridge_fetch_icon_name (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = music_player_bridge_calculate_menu_position (self);
			_tmp28_ = player_controller_new (_tmp22_, _tmp23_, NULL, _tmp26_, _tmp27_, NULL, PLAYER_CONTROLLER_STATE_OFFLINE);
			_tmp29_ = _tmp28_;
			_g_free0 (_tmp26_);
			ctrl = _tmp29_;
			_tmp30_ = self->priv->registered_clients;
			_tmp31_ = mpris_key;
			_tmp32_ = ctrl;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, _tmp31_, _tmp32_);
			_g_object_unref0 (ctrl);
			_g_free0 (mpris_key);
			_g_object_unref0 (app_info);
			_g_free0 (desktop);
		}
		_g_object_unref0 (_desktop_list);
	}
}


static gint music_player_bridge_calculate_menu_position (MusicPlayerBridge* self) {
	gint result = 0;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->registered_clients;
	_tmp1_ = gee_map_get_size ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = MUSIC_PLAYER_BRIDGE_DEVICE_ITEMS_COUNT;
		return result;
	} else {
		GeeHashMap* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->registered_clients;
		_tmp4_ = gee_map_get_size ((GeeMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		result = MUSIC_PLAYER_BRIDGE_DEVICE_ITEMS_COUNT + (_tmp5_ * PLAYER_CONTROLLER_WIDGET_QUANTITY);
		return result;
	}
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


void music_player_bridge_client_has_become_available (MusicPlayerBridge* self, const gchar* desktop, const gchar* dbus_name, gboolean use_playlists) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	const gchar* _tmp5_;
	SettingsManager* _tmp6_;
	gint _tmp7_ = 0;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gboolean _tmp10_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	GAppInfo* _tmp16_ = NULL;
	GAppInfo* _tmp17_;
	GAppInfo* app_info;
	GAppInfo* _tmp18_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* mpris_key;
	GeeHashMap* _tmp23_;
	const gchar* _tmp24_;
	gboolean _tmp25_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (desktop != NULL);
	g_return_if_fail (dbus_name != NULL);
	_tmp1_ = desktop;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = desktop;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		_tmp4_ = dbus_name;
		g_warning ("music-player-bridge.vala:96: Client %s attempting to register without " \
"desktop entry being set on the mpris root", _tmp4_);
		return;
	}
	_tmp5_ = desktop;
	_tmp6_ = self->priv->settings_manager;
	_tmp8_ = settings_manager_fetch_blacklist (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp7_;
	_tmp10_ = _vala_string_array_contains (_tmp9_, _tmp7_, _tmp5_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp10_) {
		const gchar* _tmp11_;
		_tmp11_ = desktop;
		g_debug ("music-player-bridge.vala:101: Client %s attempting to register but I'm" \
" afraid it is blacklisted", _tmp11_);
		return;
	}
	_tmp12_ = desktop;
	g_debug ("music-player-bridge.vala:106: client_has_become_available %s", _tmp12_);
	_tmp13_ = desktop;
	_tmp14_ = g_strconcat (_tmp13_, ".desktop", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = music_player_bridge_create_app_info (_tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	app_info = _tmp17_;
	_tmp18_ = app_info;
	if (_tmp18_ == NULL) {
		const gchar* _tmp19_;
		_tmp19_ = desktop;
		g_warning ("music-player-bridge.vala:109: Could not create app_info for path %s \n" \
" Getting out of here ", _tmp19_);
		_g_object_unref0 (app_info);
		return;
	}
	_tmp20_ = desktop;
	_tmp21_ = g_strdup (_tmp20_);
	_tmp22_ = music_player_bridge_determine_key (_tmp21_);
	mpris_key = _tmp22_;
	_tmp23_ = self->priv->registered_clients;
	_tmp24_ = mpris_key;
	_tmp25_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp23_, _tmp24_);
	if (_tmp25_ == FALSE) {
		const gchar* _tmp26_;
		DbusmenuMenuitem* _tmp27_;
		GAppInfo* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		gint _tmp33_ = 0;
		gboolean _tmp34_;
		PlayerController* _tmp35_;
		PlayerController* _tmp36_;
		PlayerController* ctrl;
		GeeHashMap* _tmp37_;
		const gchar* _tmp38_;
		PlayerController* _tmp39_;
		const gchar* _tmp40_;
		SettingsManager* _tmp41_;
		const gchar* _tmp42_;
		_tmp26_ = dbus_name;
		g_debug ("music-player-bridge.vala:117: New client has registered that we have n" \
"ot seen before: %s", _tmp26_);
		_tmp27_ = self->priv->root_menu;
		_tmp28_ = app_info;
		_tmp29_ = dbus_name;
		_tmp30_ = desktop;
		_tmp31_ = music_player_bridge_fetch_icon_name (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = music_player_bridge_calculate_menu_position (self);
		_tmp34_ = use_playlists;
		_tmp35_ = player_controller_new (_tmp27_, _tmp28_, _tmp29_, _tmp32_, _tmp33_, &_tmp34_, PLAYER_CONTROLLER_STATE_READY);
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp32_);
		ctrl = _tmp36_;
		_tmp37_ = self->priv->registered_clients;
		_tmp38_ = mpris_key;
		_tmp39_ = ctrl;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp37_, _tmp38_, _tmp39_);
		_tmp40_ = desktop;
		g_debug ("music-player-bridge.vala:126: Have not seen this %s before, new contro" \
"ller created.", _tmp40_);
		_tmp41_ = self->priv->settings_manager;
		_tmp42_ = desktop;
		settings_manager_add_interested (_tmp41_, _tmp42_);
		g_debug ("music-player-bridge.vala:128: application added to the interested list");
		_g_object_unref0 (ctrl);
	} else {
		GeeHashMap* _tmp43_;
		const gchar* _tmp44_;
		gpointer _tmp45_ = NULL;
		PlayerController* _tmp46_;
		gboolean _tmp47_;
		gboolean* _tmp48_;
		GeeHashMap* _tmp49_;
		const gchar* _tmp50_;
		gpointer _tmp51_ = NULL;
		PlayerController* _tmp52_;
		GeeHashMap* _tmp53_;
		const gchar* _tmp54_;
		gpointer _tmp55_ = NULL;
		PlayerController* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		gboolean _tmp59_;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_;
		_tmp43_ = self->priv->registered_clients;
		_tmp44_ = mpris_key;
		_tmp45_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp43_, _tmp44_);
		_tmp46_ = (PlayerController*) _tmp45_;
		_tmp47_ = use_playlists;
		_tmp48_ = __bool_dup0 (&_tmp47_);
		_g_free0 (_tmp46_->use_playlists);
		_tmp46_->use_playlists = _tmp48_;
		_g_object_unref0 (_tmp46_);
		_tmp49_ = self->priv->registered_clients;
		_tmp50_ = mpris_key;
		_tmp51_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp49_, _tmp50_);
		_tmp52_ = (PlayerController*) _tmp51_;
		player_controller_update_state (_tmp52_, PLAYER_CONTROLLER_STATE_READY);
		_g_object_unref0 (_tmp52_);
		_tmp53_ = self->priv->registered_clients;
		_tmp54_ = mpris_key;
		_tmp55_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp53_, _tmp54_);
		_tmp56_ = (PlayerController*) _tmp55_;
		_tmp57_ = dbus_name;
		player_controller_activate (_tmp56_, _tmp57_);
		_g_object_unref0 (_tmp56_);
		_tmp58_ = dbus_name;
		_tmp59_ = use_playlists;
		_tmp60_ = bool_to_string (_tmp59_);
		_tmp61_ = _tmp60_;
		g_debug ("music-player-bridge.vala:134: Application has already registered - awa" \
"ken the hibernation: %s with playlists %s \n", _tmp58_, _tmp61_);
		_g_free0 (_tmp61_);
	}
	_g_free0 (mpris_key);
	_g_object_unref0 (app_info);
}


void music_player_bridge_client_has_vanished (MusicPlayerBridge* self, const gchar* mpris_root_interface) {
	const gchar* _tmp0_;
	DbusmenuMenuitem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mpris_root_interface != NULL);
	_tmp0_ = mpris_root_interface;
	g_debug ("music-player-bridge.vala:140: MusicPlayerBridge -> client with dbus in" \
"terface %s has vanished", _tmp0_);
	_tmp1_ = self->priv->root_menu;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* mpris_key;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		gboolean _tmp11_;
		_tmp2_ = mpris_root_interface;
		g_debug ("music-player-bridge.vala:143: attempt to remove %s", _tmp2_);
		_tmp3_ = mpris_root_interface;
		_tmp4_ = g_strdup (_tmp3_);
		_tmp5_ = music_player_bridge_determine_key (_tmp4_);
		mpris_key = _tmp5_;
		_tmp7_ = mpris_key;
		if (_tmp7_ != NULL) {
			GeeHashMap* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			_tmp8_ = self->priv->registered_clients;
			_tmp9_ = mpris_key;
			_tmp10_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp8_, _tmp9_);
			_tmp6_ = _tmp10_;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp11_ = _tmp6_;
		if (_tmp11_) {
			GeeHashMap* _tmp12_;
			const gchar* _tmp13_;
			gpointer _tmp14_ = NULL;
			PlayerController* _tmp15_;
			const gchar* _tmp16_;
			_tmp12_ = self->priv->registered_clients;
			_tmp13_ = mpris_key;
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
			_tmp15_ = (PlayerController*) _tmp14_;
			player_controller_hibernate (_tmp15_);
			_g_object_unref0 (_tmp15_);
			_tmp16_ = mpris_key;
			g_debug ("music-player-bridge.vala:147: Successively offlined client %s", _tmp16_);
		}
		_g_free0 (mpris_key);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _music_player_bridge_client_has_become_available_mpris2_watcher_client_appeared (Mpris2Watcher* _sender, const gchar* desktop_file_name, const gchar* dbus_name, gboolean use_playlists, gpointer self) {
	music_player_bridge_client_has_become_available (self, desktop_file_name, dbus_name, use_playlists);
}


static void _music_player_bridge_client_has_vanished_mpris2_watcher_client_disappeared (Mpris2Watcher* _sender, const gchar* dbus_name, gpointer self) {
	music_player_bridge_client_has_vanished (self, dbus_name);
}


void music_player_bridge_set_root_menu_item (MusicPlayerBridge* self, DbusmenuMenuitem* menu) {
	DbusmenuMenuitem* _tmp0_;
	DbusmenuMenuitem* _tmp1_;
	Mpris2Watcher* _tmp2_;
	Mpris2Watcher* _tmp3_;
	Mpris2Watcher* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = menu;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->root_menu);
	self->priv->root_menu = _tmp1_;
	music_player_bridge_try_to_add_inactive_familiar_clients (self);
	_tmp2_ = mpris2_watcher_new ();
	_g_object_unref0 (self->priv->watcher);
	self->priv->watcher = _tmp2_;
	_tmp3_ = self->priv->watcher;
	g_signal_connect_object (_tmp3_, "client-appeared", (GCallback) _music_player_bridge_client_has_become_available_mpris2_watcher_client_appeared, self, 0);
	_tmp4_ = self->priv->watcher;
	g_signal_connect_object (_tmp4_, "client-disappeared", (GCallback) _music_player_bridge_client_has_vanished_mpris2_watcher_client_disappeared, self, 0);
}


void music_player_bridge_enable_player_specific_items_for_client (MusicPlayerBridge* self, const gchar* object_path, const gchar* desktop_id) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* mpris_key;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeHashMap* _tmp7_;
	const gchar* _tmp8_;
	gpointer _tmp9_ = NULL;
	PlayerController* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (desktop_id != NULL);
	_tmp0_ = desktop_id;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = music_player_bridge_determine_key (_tmp1_);
	mpris_key = _tmp2_;
	_tmp3_ = self->priv->registered_clients;
	_tmp4_ = mpris_key;
	_tmp5_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp4_);
	if (_tmp5_ == FALSE) {
		const gchar* _tmp6_;
		_tmp6_ = desktop_id;
		g_warning ("music-player-bridge.vala:166: we don't have a client with desktop id %" \
"s registered", _tmp6_);
		_g_free0 (mpris_key);
		return;
	}
	_tmp7_ = self->priv->registered_clients;
	_tmp8_ = mpris_key;
	_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _tmp8_);
	_tmp10_ = (PlayerController*) _tmp9_;
	_tmp11_ = object_path;
	player_controller_enable_player_specific_items (_tmp10_, _tmp11_);
	_g_object_unref0 (_tmp10_);
	_g_free0 (mpris_key);
}


void music_player_bridge_enable_track_specific_items_for_client (MusicPlayerBridge* self, const gchar* object_path, const gchar* desktop_id) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* mpris_key;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeHashMap* _tmp7_;
	const gchar* _tmp8_;
	gpointer _tmp9_ = NULL;
	PlayerController* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (desktop_id != NULL);
	_tmp0_ = desktop_id;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = music_player_bridge_determine_key (_tmp1_);
	mpris_key = _tmp2_;
	_tmp3_ = self->priv->registered_clients;
	_tmp4_ = mpris_key;
	_tmp5_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp4_);
	if (_tmp5_ == FALSE) {
		const gchar* _tmp6_;
		_tmp6_ = desktop_id;
		g_warning ("music-player-bridge.vala:177: we don't have a client with desktop id %" \
"s registered", _tmp6_);
		_g_free0 (mpris_key);
		return;
	}
	_tmp7_ = self->priv->registered_clients;
	_tmp8_ = mpris_key;
	_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _tmp8_);
	_tmp10_ = (PlayerController*) _tmp9_;
	_tmp11_ = object_path;
	player_controller_enable_track_specific_items (_tmp10_, _tmp11_);
	_g_object_unref0 (_tmp10_);
	_g_free0 (mpris_key);
}


static GAppInfo* music_player_bridge_create_app_info (const gchar* desktop) {
	GAppInfo* result = NULL;
	const gchar* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* info;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	GDesktopAppInfo* _tmp7_;
	GAppInfo* _tmp8_;
	GAppInfo* app_info;
	g_return_val_if_fail (desktop != NULL, NULL);
	_tmp0_ = desktop;
	_tmp1_ = g_desktop_app_info_new (_tmp0_);
	info = _tmp1_;
	_tmp3_ = desktop;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GDesktopAppInfo* _tmp4_;
		_tmp4_ = info;
		_tmp2_ = _tmp4_ == NULL;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		_tmp6_ = desktop;
		g_warning ("music-player-bridge.vala:187: Could not create a desktopappinfo instan" \
"ce from app: %s", _tmp6_);
		result = NULL;
		_g_object_unref0 (info);
		return result;
	}
	_tmp7_ = info;
	_tmp8_ = _g_object_ref0 (G_IS_APP_INFO (_tmp7_) ? ((GAppInfo*) _tmp7_) : NULL);
	app_info = _tmp8_;
	result = app_info;
	_g_object_unref0 (info);
	return result;
}


static gchar* music_player_bridge_fetch_icon_name (const gchar* desktop) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	GDesktopAppInfo* _tmp4_;
	GDesktopAppInfo* info;
	GKeyFile* _tmp5_;
	GKeyFile* desktop_keyfile;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (desktop != NULL, NULL);
	_tmp0_ = desktop;
	_tmp1_ = g_strconcat (_tmp0_, ".desktop", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_desktop_app_info_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	info = _tmp4_;
	_tmp5_ = g_key_file_new ();
	desktop_keyfile = _tmp5_;
	{
		GKeyFile* _tmp6_;
		GDesktopAppInfo* _tmp7_;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = desktop_keyfile;
		_tmp7_ = info;
		_tmp8_ = g_desktop_app_info_get_filename (_tmp7_);
		g_key_file_load_from_file (_tmp6_, _tmp8_, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_key_file_free0 (desktop_keyfile);
			_g_object_unref0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("music-player-bridge.vala:203: Error loading keyfile - FileError");
		result = NULL;
		_g_error_free0 (_error_);
		_g_key_file_free0 (desktop_keyfile);
		_g_object_unref0 (info);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("music-player-bridge.vala:207: Error loading keyfile - KeyFileError");
		result = NULL;
		_g_error_free0 (_error_);
		_g_key_file_free0 (desktop_keyfile);
		_g_object_unref0 (info);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (desktop_keyfile);
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GKeyFile* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp9_ = desktop_keyfile;
		_tmp10_ = g_key_file_get_string (_tmp9_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ICON, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_key_file_free0 (desktop_keyfile);
			_g_object_unref0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp11_;
		_g_key_file_free0 (desktop_keyfile);
		_g_object_unref0 (info);
		return result;
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("music-player-bridge.vala:216: Error trying to fetch the icon name from" \
" the keyfile");
		result = NULL;
		_g_error_free0 (_error_);
		_g_key_file_free0 (desktop_keyfile);
		_g_object_unref0 (info);
		return result;
	}
	__finally1:
	_g_key_file_free0 (desktop_keyfile);
	_g_object_unref0 (info);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gchar* music_player_bridge_determine_key (gchar* desktop_or_interface) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _result_;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_ = NULL;
	gchar** temp;
	gint temp_length1;
	gint _temp_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp17_;
	g_return_val_if_fail (desktop_or_interface != NULL, NULL);
	_tmp0_ = desktop_or_interface;
	_tmp1_ = g_strdup (_tmp0_);
	_result_ = _tmp1_;
	_tmp2_ = desktop_or_interface;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ".", 0);
	tokens = _tmp4_;
	tokens_length1 = _vala_array_length (_tmp3_);
	_tokens_size_ = tokens_length1;
	_tmp5_ = tokens;
	_tmp5__length1 = tokens_length1;
	if (_tmp5__length1 > 1) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = tokens;
		_tmp6__length1 = tokens_length1;
		_tmp7_ = tokens;
		_tmp7__length1 = tokens_length1;
		_tmp8_ = _tmp6_[_tmp7__length1 - 1];
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (_result_);
		_result_ = _tmp9_;
	}
	_tmp10_ = _result_;
	_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "-", 0);
	temp = _tmp12_;
	temp_length1 = _vala_array_length (_tmp11_);
	_temp_size_ = temp_length1;
	_tmp13_ = temp;
	_tmp13__length1 = temp_length1;
	if (_tmp13__length1 > 1) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = temp;
		_tmp14__length1 = temp_length1;
		_tmp15_ = _tmp14_[0];
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (_result_);
		_result_ = _tmp16_;
	}
	_tmp17_ = _result_;
	g_debug ("music-player-bridge.vala:239: determine key result = %s", _tmp17_);
	result = _result_;
	temp = (_vala_array_free (temp, temp_length1, (GDestroyNotify) g_free), NULL);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (desktop_or_interface);
	return result;
}


static void _music_player_bridge_on_blacklist_update_settings_manager_blacklist_updates (SettingsManager* _sender, gchar** new_blacklist, int new_blacklist_length1, gpointer self) {
	music_player_bridge_on_blacklist_update (self, new_blacklist, new_blacklist_length1);
}


static GObject * music_player_bridge_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MusicPlayerBridge * self;
	GeeHashMap* _tmp0_;
	SettingsManager* _tmp1_;
	SettingsManager* _tmp2_;
	parent_class = G_OBJECT_CLASS (music_player_bridge_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MUSIC_PLAYER_BRIDGE (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_PLAYER_CONTROLLER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->registered_clients);
	self->priv->registered_clients = _tmp0_;
	_tmp1_ = settings_manager_new ();
	_g_object_unref0 (self->priv->settings_manager);
	self->priv->settings_manager = _tmp1_;
	_tmp2_ = self->priv->settings_manager;
	g_signal_connect_object (_tmp2_, "blacklist-updates", (GCallback) _music_player_bridge_on_blacklist_update_settings_manager_blacklist_updates, self, 0);
	return obj;
}


static void music_player_bridge_class_init (MusicPlayerBridgeClass * klass) {
	music_player_bridge_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MusicPlayerBridgePrivate));
	G_OBJECT_CLASS (klass)->constructor = music_player_bridge_constructor;
	G_OBJECT_CLASS (klass)->finalize = music_player_bridge_finalize;
}


static void music_player_bridge_instance_init (MusicPlayerBridge * self) {
	self->priv = MUSIC_PLAYER_BRIDGE_GET_PRIVATE (self);
}


static void music_player_bridge_finalize (GObject* obj) {
	MusicPlayerBridge * self;
	self = MUSIC_PLAYER_BRIDGE (obj);
	_g_object_unref0 (self->priv->settings_manager);
	_g_object_unref0 (self->priv->root_menu);
	_g_object_unref0 (self->priv->registered_clients);
	_g_object_unref0 (self->priv->watcher);
	G_OBJECT_CLASS (music_player_bridge_parent_class)->finalize (obj);
}


GType music_player_bridge_get_type (void) {
	static volatile gsize music_player_bridge_type_id__volatile = 0;
	if (g_once_init_enter (&music_player_bridge_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MusicPlayerBridgeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) music_player_bridge_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MusicPlayerBridge), 0, (GInstanceInitFunc) music_player_bridge_instance_init, NULL };
		GType music_player_bridge_type_id;
		music_player_bridge_type_id = g_type_register_static (G_TYPE_OBJECT, "MusicPlayerBridge", &g_define_type_info, 0);
		g_once_init_leave (&music_player_bridge_type_id__volatile, music_player_bridge_type_id);
	}
	return music_player_bridge_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



