<?php

// IPplan v4.91a
// Aug 24, 2001
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

require_once("../ipplanlib.php");
require_once("../adodb/adodb.inc.php");
require_once("../class.dbflib.php");
require_once("../layout/class.layout");
require_once("../auth.php");

$auth = new BasicAuthenticator(ADMINREALM, REALMERROR);

$auth->addUser(ADMINUSER, ADMINPASSWD);

// And now perform the authentication
$auth->authenticate();

// set language
isset($_COOKIE["ipplanLanguage"]) && myLanguage($_COOKIE['ipplanLanguage']);

//setdefault("window",array("bgcolor"=>"white"));
//setdefault("table",array("cellpadding"=>"0"));
//setdefault("text",array("size"=>"2"));

$title=my_("Import IP details data");
newhtml($p);
$w=myheading($p, $title);

// display opening text
insert($w,heading(3, "$title."));
insert($w,block("<br>".my_("Import IP details data in XML format. The data is in the same format generated by <a HREF=\"http://www.insecure.org\">NMAP's</a> -oX parameter. This is useful to scan and obtain records for sites that have no previous information.")));
insert($w,block("<p>"));
insert($w,text(my_("Import IP details data from flat ascii files.  The file should contain a minimum of seven columns each delimited by TAB: ")));
insert($w,text(my_("The columns are imported in the following order: IP address, user, location, description, hostname, telephone number and mac address.")));
insert($w,block("<p>"));
insert($w,text(my_("If the import file has more than six columns, each additional column will be added to the user defined fields defined in the iptemplate.xml file in the order specified in the template.")));
insert($w,block("<p>"));
insert($w,text(my_("If an error occurs during the import, the process will stop. Records that have been successfully imported should be deleted from the import file, the error corrected and the import resumed.")));
insert($w,block("<p>"));
insert($w,text(my_("NOTE: Any number of IP address records for various subnets can be in the file.  Any existing information will be overwritten.")." "));
insert($w,text(my_("Imported addresses will only be added to existing subnets.")." "));
insert($w,textbr(my_("If the append flag is set, any fields that are empty or contain NULL will not be overwritten.")));

$ds=new IPplanDbf() or myError($w,$p, my_("Could not connect to database"));

// start form
insert($w, $f = form(array("method"=>"post",
                           "enctype"=>"multipart/form-data",
                           "action"=>"importip.php")));

$cust=myCustomerDropDown($ds, $f, 0, 0, FALSE) or myError($w,$p, my_("No customers"));

insert($f,textbrbr(my_("File name")));

insert($f,hidden(array("name"=>"MAX_FILE_SIZE",
                       "value"=>MAXUPLOADSIZE)));
insert($f,inputfile(array("name"=>"userfile")));

insert($f,textbrbr(my_("Format")));
insert($f,selectbox(array("text"=>my_("Standard fields - text format"),
                          "xml"=>my_("Standard fields - NMAP XML format")),
                    array("name"=>"format")));

insert($f,generic("br"));
insert($f,generic("br"));
insert($f,checkbox(array("NAME"=>"append")," Append",$c = ""));
insert($f,generic("br"));
insert($f,generic("br"));
insert($f,submit(array("value"=>my_("Submit"))));
insert($f,freset(array("value"=>my_("Clear"))));

printhtml($p);

?>
