#include <stdio.h>
#include <string.h>

#include "autosocket.h"

#include "libcompat.h"

/* Error messages shamelessly nabbed from the Linux man page getaddrinfo(3) */

const char *gai_strerror(int err)
{
#define msgcase(n, m) case n: return m
    static char msg[1024];

    switch(err) {
	msgcase(EAI_FAMILY, "The requested address family is not supported");
	msgcase(EAI_SOCKTYPE, "The requested socket type is not supported");
	msgcase(EAI_BADFLAGS, "ai_flags contains invalid flags");
	msgcase(EAI_NONAME, "The node or service is not known");
	msgcase(EAI_SERVICE, "The requested service is not available for the "
		"requested socket type");
#ifdef EAI_ADDRFAMILY
	msgcase(EAI_ADDRFAMILY, "The specified network host does not have any "
		"network addresses in the requested address family");
#endif
	msgcase(EAI_NODATA, "The specified network host exists, but does not "
		"have any network addresses defined");
	msgcase(EAI_MEMORY, "Out of memory");
	msgcase(EAI_FAIL, "The name server returned a permanent failure "
		"indication");
	msgcase(EAI_AGAIN, "The name server returned a temporary  failure "
		"indication.  Try again later");
#ifdef EAI_OVERFLOW
	msgcase(EAI_OVERFLOW, "Argument buffer overflow");
#endif
#ifdef EAI_SYSTEM
	msgcase(EAI_SYSTEM, "Other system error, check errno for details");
#endif
    default:
	sprintf(msg, "Unknown address lookup error %d", err);
	return msg;
    }
}
