/*
   Copyright (C) 2002-2010 Karl J. Runge <runge@karlrunge.com> 
   All rights reserved.

This file is part of x11vnc.

x11vnc is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

x11vnc is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with x11vnc; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
or see <http://www.gnu.org/licenses/>.

In addition, as a special exception, Karl J. Runge
gives permission to link the code of its release of x11vnc with the
OpenSSL project's "OpenSSL" library (or with modified versions of it
that use the same license as the "OpenSSL" library), and distribute
the linked executables.  You must obey the GNU General Public License
in all respects for all of the code used other than "OpenSSL".  If you
modify this file, you may extend this exception to your version of the
file, but you are not obligated to do so.  If you do not wish to do
so, delete this exception statement from your version.
*/

/* -- help.c -- */

#include "x11vnc.h"
#include "xdamage.h"
#include "cursor.h"

/*
 * text printed out under -help option
 */

void print_help(int mode);
void print_license(void);
void xopen_display_fail_message(char *disp);
void nopassword_warning_msg(int gotloc);


void print_help(int mode) {
#if !SKIP_HELP
	char help[] = 
"\n"
"x11vnc: allow VNC connections to real X11 displays. %s\n"
"\n"
"(type \"x11vnc -opts\" to just list the options.)\n"
"\n"
"Typical usage is:\n"
"\n"
"   Run this command in a shell on the remote machine \"far-host\"\n"
"   with X session you wish to view:\n"
"\n"
"       x11vnc -display :0\n"
"\n"
"   Then run this in another window on the machine you are sitting at:\n"
"\n"
"       vncviewer far-host:0\n"
"\n"
"Once x11vnc establishes connections with the X11 server and starts listening\n"
"as a VNC server it will print out a string: PORT=XXXX where XXXX is typically\n"
"5900 (the default VNC server port).  One would next run something like\n"
"this on the local machine: \"vncviewer hostname:N\" where \"hostname\" is\n"
"the name of the machine running x11vnc and N is XXXX - 5900, i.e. usually\n"
"\"vncviewer hostname:0\".\n"
"\n"
"By default x11vnc will not allow the screen to be shared and it will exit\n"
"as soon as the client disconnects.  See -shared and -forever below to override\n"
"these protections.  See the FAQ for details how to tunnel the VNC connection\n"
"through an encrypted channel such as ssh(1).  In brief:\n"
"\n"
"       ssh -t -L 5900:localhost:5900 far-host 'x11vnc -localhost -display :0'\n"
"\n"
"       vncviewer -encodings 'copyrect tight zrle hextile' localhost:0\n"
"\n"
"Also, use of a VNC password (-rfbauth or -passwdfile) is strongly recommended.\n"
"\n"
"For additional info see: http://www.karlrunge.com/x11vnc/\n"
"                    and  http://www.karlrunge.com/x11vnc/faq.html\n"
"\n"
"\n"
"Config file support: if the file $HOME/.x11vncrc exists then each line in\n"
"it is treated as a single command line option.  Disable with -norc.  For\n"
"each option name, the leading character \"-\" is not required.  E.g. a line\n"
"that is either \"forever\" or \"-forever\" may be used and are equivalent.\n"
"Likewise \"wait 100\" or \"-wait 100\" are acceptable and equivalent lines.\n"
"The \"#\" character comments out to the end of the line in the usual way\n"
"(backslash it for a literal).  Leading and trailing whitespace is trimmed off.\n"
"Lines may be continued with a \"\\\" as the last character of a line (it\n"
"becomes a space character).\n"
"\n"
"Options:\n"
"\n"
"-display disp          X11 server display to connect to, usually :0.  The X\n"
"                       server process must be running on same machine and\n"
"                       support MIT-SHM.  Equivalent to setting the DISPLAY\n"
"                       environment variable to \"disp\".\n"
"\n"
"                       See the description below of the \"-display WAIT:...\"\n"
"                       extensions, where alias \"-find\" will find the user's\n"
"                       display automatically, and \"-create\" will create a\n"
"                       Xvfb session if no session is found.\n"
"\n"
"-auth file             Set the X authority file to be \"file\", equivalent to\n"
"                       setting the XAUTHORITY environment variable to \"file\"\n"
"                       before startup.  Same as -xauth file.  See Xsecurity(7),\n"
"                       xauth(1) man pages for more info.\n"
"\n"
"                       Use '-auth guess' to have x11vnc use its -findauth\n"
"                       mechanism (described below) to try to guess the\n"
"                       XAUTHORITY filename and use it.\n"
"\n"
"                       XDM/GDM/KDM: if you are running x11vnc as root and want\n"
"                       to find the XAUTHORITY before anyone has logged into an\n"
"                       X session yet, use: x11vnc -env FD_XDM=1 -auth guess ...\n"
"                       (This will also find the XAUTHORITY if a user is already\n"
"                       logged into the X session.)  When running as root,\n"
"                       FD_XDM=1 will be tried if the initial -auth guess fails.\n"
"\n"
"-N                     If the X display is :N, try to set the VNC display to\n"
"                       also be :N This just sets the -rfbport option to 5900+N\n"
"                       The program will exit immediately if that port is not\n"
"                       available. The -N option only works with normal -display\n"
"                       usage, e.g. :0 or :8, -N is ignored in the -display\n"
"                       WAIT:..., -create, -find, -svc, -redirect, etc modes.\n"
"\n"
"-autoport n            Automatically probe for a free VNC port starting at n.\n"
"                       The default is to start probing at 5900.  Use this to\n"
"                       stay away from other VNC servers near 5900.\n"
"\n"
"-rfbport str           The VNC port to listen on (a LibVNCServer option), e.g.\n"
"                       5900, 5901, etc.  If specified as \"-rfbport PROMPT\"\n"
"                       then the x11vnc -gui is used to prompt the user to\n"
"                       enter the port number.\n"
"\n"
#if X11VNC_IPV6
"-6                     IPv6 listening support.  In addition to IPv4, the\n"
"                       IPv6 address is listened on for incoming connections.\n"
"                       The same port number as IPv4 is used.\n"
"\n"
#if X11VNC_LISTEN6
"                       NOTE:  This x11vnc binary was compiled to have the\n"
"                       \"-6\" IPv6 listening mode ENABLED by default (CPPFLAGS\n"
"                       -DX11VNC_LISTEN6=1).  So to disable IPv6 listening mode\n"
"                       you MUST supply the \"-no6\" option (see below.)\n"
#else
"                       NOTE:  This x11vnc binary was compiled to have\n"
"                       the \"-6\" IPv6 listening mode DISABLED by default\n"
"                       (CPPFLAGS -DX11VNC_LISTEN6=0).\n"
#endif
"\n"
"                       The \"-6\" mode works for both normal connections and\n"
"                       -ssl encrypted ones.  Nearly everything is supported\n"
"                       for the IPv6 case, but there are a few exceptions.\n"
"                       See -stunnel for its IPv6 support.\n"
"\n"
"                       Currently, for absolutely everything to work correctly\n"
"                       the machine may need to have some IPv4 support, at the\n"
"                       least for the loopback interface.  However, for nearly\n"
"                       all usage modes no IPv4 support is required. See -nopiv4.\n"
"\n"
"                       If you have trouble compiling or running in IPv6 mode,\n"
"                       set -DX11VNC_IPV6=0 in CPPFLAGS when configuring to\n"
"                       disable IPv6 support.\n"
"\n"
"-no6                   Disable IPv6 listening support (only useful if the\n"
"                       \"-6\" mode is compiled in to be the default; see the\n"
"                       X11VNC_LISTEN6 description above under \"-6\".)\n"
"\n"
"-noipv6                Do not try to use IPv6 for any listening or connecting\n"
"                       sockets.  This includes both the listening service\n"
"                       port(s) and outgoing connections from -connect,\n"
"                       -connect_or_exit, or -proxy.  Use this if you are having\n"
"                       problems due to IPv6.\n"
"\n"
"-noipv4                Do not try to use IPv4 for any listening or connecting\n"
"                       sockets.  This is mainly for exploring the behavior of\n"
"                       x11vnc on an IPv6-only system, but may have other uses.\n"
"\n"
#endif
"-reopen                If the X server connection is disconnected, try to\n"
"                       reopen the X display (up to one time.)  This is of use\n"
"                       for display managers like GDM (KillInitClients option)\n"
"                       that kill x11vnc just after the user logs into the\n"
"                       X session.  Note: the reopened state may be unstable.\n"
"                       Set X11VNC_REOPEN_DISPLAY=n to reopen n times and\n"
"                       set X11VNC_REOPEN_SLEEP_MAX to the number of seconds,\n"
"                       default 10, to keep trying to reopen the display (once\n"
"                       per second.)\n"
"\n"
"                       Update: as of 0.9.9, x11vnc tries to automatically avoid\n"
"                       being killed by the display manager by delaying creating\n"
"                       windows or using XFIXES.  So you shouldn't need to use\n"
"                       KillInitClients=false as long as you log in quickly\n"
"                       enough (within 45 seconds of connecting.)  You can\n"
"                       disable this by setting X11VNC_AVOID_WINDOWS=never.\n"
"                       You can also set it to the number of seconds to delay.\n"
"\n"
"-reflect host:N        Instead of connecting to and polling an X display,\n"
"                       connect to the remote VNC server host:N and be a\n"
"                       reflector/repeater for it.  This is useful for trying\n"
"                       to manage the case of many simultaneous VNC viewers\n"
"                       (e.g. classroom broadcasting) where, e.g. you put\n"
"                       a repeater on each network switch, etc, to improve\n"
"                       performance by distributing the load and network\n"
"                       traffic.  Implies -shared (use -noshared as a later\n"
"                       option to disable). See the discussion below under\n"
"                       -rawfb vnc:host:N for more details.\n"
"\n"
"-id windowid           Show the X window corresponding to \"windowid\" not\n"
"                       the entire display.  New windows like popup menus,\n"
"                       transient toplevels, etc, may not be seen or may be\n"
"                       clipped.  Disabling SaveUnders or BackingStore in the\n"
"                       X server may help show them.  x11vnc may crash if the\n"
"                       window is initially partially obscured, changes size,\n"
"                       is iconified, etc.  Some steps are taken to avoid this\n"
"                       and the -xrandr mechanism is used to track resizes.  Use\n"
"                       xwininfo(1) to get the window id, or use \"-id pick\"\n"
"                       to have x11vnc run xwininfo(1) for you and extract\n"
"                       the id.  The -id option is useful for exporting very\n"
"                       simple applications (e.g. the current view on a webcam).\n"
"-sid windowid          As -id, but instead of using the window directly it\n"
"                       shifts a root view to it: this shows SaveUnders menus,\n"
"                       etc, although they will be clipped if they extend beyond\n"
"                       the window.\n"
"\n"
"-appshare              Simple application sharing based on the -id/-sid\n"
"                       mechanism.  Every new toplevel window that the\n"
"                       application creates induces a new viewer window via\n"
"                       a reverse connection.  The -id/-sid and -connect\n"
"                       options are required.  Run 'x11vnc -appshare -help'\n"
"                       for more info.\n"
"\n"
#if 0
"-freeze_when_obscured  Probably only of use in -appshare mode: if the -id/-sid\n"
"                       window is partially or fully obscured by other windows,\n"
"                       stop checking for framebuffer updates.  Mouse and\n"
"                       keyboard events are still processed and injected.\n"
"\n"
#endif
"-clip WxH+X+Y          Only show the sub-region of the full display that\n"
"                       corresponds to the rectangle geometry with size WxH and\n"
"                       offset +X+Y.  The VNC display has size WxH (i.e. smaller\n"
"                       than the full display).  This also works for -id/-sid\n"
"                       mode where the offset is relative to the upper left\n"
"                       corner of the selected window.  An example use of this\n"
"                       option would be to split a large (e.g. Xinerama) display\n"
"                       into two parts to be accessed via separate viewers by\n"
"                       running a separate x11vnc on each part.\n"
"\n"
"                       Use '-clip xinerama0' to clip to the first xinerama\n"
"                       sub-screen (if xinerama is active).  xinerama1 for the\n"
"                       2nd sub-screen, etc.  This way you don't need to figure\n"
"                       out the WxH+X+Y of the desired xinerama sub-screen.\n"
"                       screens are sorted in increasing distance from the\n"
"                       (0,0) origin (I.e. not the Xserver's order).\n"
"\n"
"-flashcmap             In 8bpp indexed color, let the installed colormap flash\n"
"                       as the pointer moves from window to window (slow).\n"
"                       Also try the -8to24 option to avoid flash altogether.\n"
"-shiftcmap n           Rare problem, but some 8bpp displays use less than 256\n"
"                       colorcells (e.g. 16-color grayscale, perhaps the other\n"
"                       bits are used for double buffering) *and* also need to\n"
"                       shift the pixels values away from 0, .., ncells.  \"n\"\n"
"                       indicates the shift to be applied to the pixel values.\n"
"                       To see the pixel values set DEBUG_CMAP=1 to print out\n"
"                       a colormap histogram.  Example: -shiftcmap 240\n"
"-notruecolor           For 8bpp displays, force indexed color (i.e. a colormap)\n"
"                       even if it looks like 8bpp TrueColor (rare problem).\n"
"-advertise_truecolor   If the X11 display is indexed color, lie to clients\n"
"                       when they first connect by telling them it is truecolor.\n"
"                       To workaround RealVNC: inPF has colourMap but not 8bpp\n"
"                       Use '-advertise_truecolor reset' to reset client fb too.\n"
"\n"
"-visual n              This option probably does not do what you think.\n"
"                       It simply *forces* the visual used for the framebuffer;\n"
"                       this may be a bad thing... (e.g. messes up colors or\n"
"                       cause a crash). It is useful for testing and for some\n"
"                       workarounds.  n may be a decimal number, or 0x hex.\n"
"                       Run xdpyinfo(1) for the values.  One may also use\n"
"                       \"TrueColor\", etc. see <X11/X.h> for a list.  If the\n"
"                       string ends in \":m\" then for better or for worse\n"
"                       the visual depth is forced to be m.  You may want to\n"
"                       use -noshm when using this option (so XGetImage may\n"
"                       automatically translate the pixel data).\n"
"\n"
"-overlay               Handle multiple depth visuals on one screen, e.g. 8+24\n"
"                       and 24+8 overlay visuals (the 32 bits per pixel are\n"
"                       packed with 8 for PseudoColor and 24 for TrueColor).\n"
"\n"
"                       Currently -overlay only works on Solaris via\n"
"                       XReadScreen(3X11) and IRIX using XReadDisplay(3).\n"
"                       On Solaris there is a problem with image \"bleeding\"\n"
"                       around transient popup menus (but not for the menu\n"
"                       itself): a workaround is to disable SaveUnders\n"
"                       by passing the \"-su\" argument to Xsun (in\n"
"                       /etc/dt/config/Xservers).\n"
"\n"
"                       Use -overlay as a workaround for situations like these:\n"
"                       Some legacy applications require the default visual to\n"
"                       be 8bpp (8+24), or they will use 8bpp PseudoColor even\n"
"                       when the default visual is depth 24 TrueColor (24+8).\n"
"                       In these cases colors in some windows will be incorrect\n"
"                       in x11vnc unless -overlay is used.  Another use of\n"
"                       -overlay is to enable showing the exact mouse cursor\n"
"                       shape (details below).\n"
"\n"
"                       Under -overlay, performance will be somewhat slower\n"
"                       due to the extra image transformations required.\n"
"                       For optimal performance do not use -overlay, but rather\n"
"                       configure the X server so that the default visual is\n"
"                       depth 24 TrueColor and try to have all apps use that\n"
"                       visual (e.g. some apps have -use24 or -visual options).\n"
"-overlay_nocursor      Sets -overlay, but does not try to draw the exact mouse\n"
"                       cursor shape using the overlay mechanism.\n"
"\n"
"-8to24 [opts]          Try this option if -overlay is not supported on your\n"
"                       OS, and you have a legacy 8bpp app that you want to\n"
"                       view on a multi-depth display with default depth 24\n"
"                       (and is 32 bpp) OR have a default depth 8 display with\n"
"                       depth 24 overlay windows for some apps.  This option\n"
"                       may not work on all X servers and hardware (tested\n"
"                       on XFree86/Xorg mga driver and Xsun).  The \"opts\"\n"
"                       string is not required and is described below.\n"
"\n"
"                       This mode enables a hack where x11vnc monitors windows\n"
"                       within 3 levels from the root window.  If it finds\n"
"                       any that are 8bpp it extracts the indexed color\n"
"                       pixel values using XGetImage() and then applies a\n"
"                       transformation using the colormap(s) to create TrueColor\n"
"                       RGB values that it in turn inserts into bits 1-24 of\n"
"                       the framebuffer.  This creates a depth 24 \"view\"\n"
"                       of the display that is then exported via VNC.\n"
"\n"
"                       Conversely, for default depth 8 displays, the depth\n"
"                       24 regions are read by XGetImage() and everything is\n"
"                       transformed and inserted into a depth 24 TrueColor\n"
"                       framebuffer.\n"
"\n"
"                       Note that even if there are *no* depth 24 visuals or\n"
"                       windows (i.e. pure 8bpp), this mode is potentially\n"
"                       an improvement over -flashcmap because it avoids the\n"
"                       flashing and shows each window in the correct color.\n"
"\n"
"                       This method works OK, but may still have bugs and it\n"
"                       does hog resources.  If there are multiple 8bpp windows\n"
"                       using different colormaps, one may have to iconify all\n"
"                       but one for the colors to be correct.\n"
"\n"
"                       There may be painting errors for clipping and switching\n"
"                       between windows of depths 8 and 24.  Heuristics are\n"
"                       applied to try to minimize the painting errors.  One can\n"
"                       also press 3 Alt_L's in a row to refresh the screen\n"
"                       if the error does not repair itself.  Also the option\n"
"                       -fixscreen 8=3.0 or -fixscreen V=3.0 may be used to\n"
"                       periodically refresh the screen at the cost of bandwidth\n"
"                       (every 3 sec for this example).\n"
"\n"
"                       The [opts] string can contain the following settings.\n"
"                       Multiple settings are separated by commas.\n"
"\n"
"                       For for some X servers with default depth 24 a\n"
"                       speedup may be achieved via the option \"nogetimage\".\n"
"                       This enables a scheme were XGetImage() is not used\n"
"                       to retrieve the 8bpp data.  Instead, it assumes that\n"
"                       the 8bpp data is in bits 25-32 of the 32bit X pixels.\n"
"                       There is no requirement that the X server should put\n"
"                       the data there for our poll requests, but some do and\n"
"                       so the extra steps to retrieve it can be skipped.\n"
"                       Tested with mga driver with XFree86/Xorg.  For the\n"
"                       default depth 8 case this option is ignored.\n"
"\n"
"                       To adjust how often XGetImage() is used to poll the\n"
"                       non-default visual regions for changes, use the option\n"
"                       \"poll=t\" where \"t\" is a floating point time.\n"
"                       (default: %.2f)\n"
"\n"
"                       Setting the option \"level2\" will limit the search\n"
"                       for non-default visual windows to two levels from the\n"
"                       root window.  Do this on slow machines where you know\n"
"                       the window manager only imposes one extra window between\n"
"                       the app window and the root window.\n"
"\n"
"                       Also for very slow machines use \"cachewin=t\"\n"
"                       where t is a floating point amount of time to cache\n"
"                       XGetWindowAttributes results.  E.g. cachewin=5.0.\n"
"                       This may lead to the windows being unnoticed for this\n"
"                       amount of time when deiconifying, painting errors, etc.\n"
"\n"
"                       While testing on a very old SS20 these options gave\n"
"                       tolerable response: -8to24 poll=0.2,cachewin=5.0. For\n"
"                       this machine -overlay is supported and gives better\n"
"                       response.\n"
"\n"
"                       Debugging for this mode can be enabled by setting\n"
"                       \"dbg=1\", \"dbg=2\", or \"dbg=3\".\n"
"\n"
"-24to32                Very rare problem: if the framebuffer (X display\n"
"                       or -rawfb) is 24bpp instead of the usual 32bpp, then\n"
"                       dynamically transform the pixels to 32bpp.  This will be\n"
"                       slower, but can be used to work around problems where\n"
"                       VNC viewers cannot handle 24bpp (e.g. \"main: setPF:\n"
"                       not 8, 16 or 32 bpp?\").  See the FAQ for more info.\n"
"\n"
"                       In the case of -rawfb mode, the pixels are directly\n"
"                       modified by inserting a 0 byte to pad them out to 32bpp.\n"
"                       For X displays, a kludge is done that is equivalent to\n"
"                       \"-noshm -visual TrueColor:32\".  (If better performance\n"
"                       is needed for the latter, feel free to ask).\n"
"\n"
"-scale fraction        Scale the framebuffer by factor \"fraction\".  Values\n"
"                       less than 1 shrink the fb, larger ones expand it. Note:\n"
"                       the image may not be sharp and response may be slower.\n"
"                       If \"fraction\" contains a decimal point \".\" it\n"
"                       is taken as a floating point number, alternatively\n"
"                       the notation \"m/n\" may be used to denote fractions\n"
"                       exactly, e.g. -scale 2/3\n"
"\n"
"                       To scale asymmetrically in the horizontal and vertical\n"
"                       directions, specify a WxH geometry to stretch to:\n"
"                       e.g. '-scale 1024x768', or also '-scale 0.9x0.75'\n"
"\n"
"                       Scaling Options: can be added after \"fraction\" via\n"
"                       \":\", to supply multiple \":\" options use commas.\n"
"                       If you just want a quick, rough scaling without\n"
"                       blending, append \":nb\" to \"fraction\" (e.g. -scale\n"
"                       1/3:nb).  No blending is the default for 8bpp indexed\n"
"                       color, to force blending for this case use \":fb\".\n"
"\n"
"                       To disable -scrollcopyrect and -wirecopyrect under\n"
"                       -scale use \":nocr\".  If you need to to enable them use\n"
"                       \":cr\" or specify them explicitly on the command line.\n"
"                       If a slow link is detected, \":nocr\" may be applied\n"
"                       automatically.  Default: %s\n"
"\n"
"                       More esoteric options: for compatibility with vncviewers\n"
"                       the scaled width is adjusted to be a multiple of 4:\n"
"                       to disable this use \":n4\".  \":in\" use interpolation\n"
"                       scheme even when shrinking, \":pad\" pad scaled width\n"
"                       and height to be multiples of scaling denominator\n"
"                       (e.g. 3 for 2/3).\n"
"\n"
"-geometry WxH          Same as -scale WxH\n"
"\n"
"-scale_cursor frac     By default if -scale is supplied the cursor shape is\n"
"                       scaled by the same factor.  Depending on your usage,\n"
"                       you may want to scale the cursor independently of the\n"
"                       screen or not at all.  If you specify -scale_cursor\n"
"                       the cursor will be scaled by that factor.  When using\n"
"                       -scale mode to keep the cursor at its \"natural\" size\n"
"                       use \"-scale_cursor 1\".  Most of the \":\" scaling\n"
"                       options apply here as well.\n"
"\n"
"-viewonly              All VNC clients can only watch (default %s).\n"
"-shared                VNC display is shared, i.e. more than one viewer can\n"
"                       connect at the same time (default %s).\n"
"-once                  Exit after the first successfully connected viewer\n"
"                       disconnects, opposite of -forever. This is the Default.\n"
"-forever               Keep listening for more connections rather than exiting\n"
"                       as soon as the first client(s) disconnect. Same as -many\n"
"\n"
"                       To get the standard non-shared VNC behavior where when\n"
"                       a new VNC client connects the existing VNC client is\n"
"                       dropped use:  -nevershared -forever   This method can\n"
"                       also be used to guard against hung TCP connections that\n"
"                       do not go away.\n"
"\n"
"-loop                  Create an outer loop restarting the x11vnc process\n"
"                       whenever it terminates.  -bg and -inetd are ignored\n"
"                       in this mode (however see -loopbg below).\n"
"\n"
"                       Useful for continuing even if the X server terminates\n"
"                       and restarts (at that moment the process will need\n"
"                       permission to reconnect to the new X server of course).\n"
"\n"
"                       Use, e.g., -loop100 to sleep 100 millisecs between\n"
"                       restarts, etc.  Default is 2000ms (i.e. 2 secs) Use,\n"
"                       e.g. -loop300,5 to sleep 300 ms and only loop 5 times.\n"
"\n"
"                       If -loopbg (plus any numbers) is specified instead,\n"
"                       the \"-bg\" option is implied and the mode approximates\n"
"                       inetd(8) usage to some degree.  In this case when\n"
"                       it goes into the background any listening sockets\n"
"                       (i.e. ports 5900, 5800) are closed, so the next one\n"
"                       in the loop can use them.  This mode will only be of\n"
"                       use if a VNC client (the only client for that process)\n"
"                       is already connected before the process goes into the\n"
"                       background, for example, usage of -display WAIT:..,\n"
"                       -svc, and -connect can make use of this \"poor man's\"\n"
"                       inetd mode.  The default wait time is 500ms in this\n"
"                       mode.  This usage could use useful:  -svc -bg -loopbg\n"
"\n"
"-timeout n             Exit unless a client connects within the first n seconds\n"
"                       after startup.\n"
"\n"
"                       If there have been no connection attempts after n\n"
"                       seconds x11vnc exits immediately.  If a client is\n"
"                       trying to connect but has not progressed to the normal\n"
"                       operating state, x11vnc gives it a few more seconds\n"
"                       to finish and exits if it does not make it to the\n"
"                       normal state.\n"
"\n"
"                       For reverse connections via -connect or -connect_or_exit\n"
"                       a timeout of n seconds will be set for all reverse\n"
"                       connects.  If the connect timeout alarm goes off,\n"
"                       x11vnc will exit immediately.\n"
"\n"
"-sleepin n             At startup sleep n seconds before proceeding (e.g. to\n"
"                       allow redirs and listening clients to start up)\n"
"\n"
"                       If a range is given: '-sleepin min-max', a random value\n"
"                       between min and max is slept. E.g. '-sleepin 0-20' and\n"
"                       '-sleepin 10-30'.  Floats are allowed too.\n"
"\n"
"-inetd                 Launched by inetd(8): stdio instead of listening socket.\n"
"                       Note: if you are not redirecting stderr to a log file\n"
"                       (via shell 2> or -o option) you MUST also specify the -q\n"
"                       option, otherwise the stderr goes to the viewer which\n"
"                       will cause it to abort.  Specifying both -inetd and -q\n"
"                       and no -o will automatically close the stderr.\n"
"\n"
"-tightfilexfer         Enable the TightVNC file transfer extension. Note that\n"
"                       that when the -viewonly option is supplied all file\n"
"                       transfers are disabled.  Also clients that log in\n"
"                       viewonly cannot transfer files.  However, if the remote\n"
"                       control mechanism is used to change the global or\n"
"                       per-client viewonly state the filetransfer permissions\n"
"                       will NOT change.\n"
"\n"
"                       IMPORTANT: please understand if -tightfilexfer is\n"
"                       specified and you run x11vnc as root for, say, inetd\n"
"                       or display manager (gdm, kdm, ...) access and you do\n"
"                       not have it switch users via the -users option, then\n"
"                       VNC Viewers that connect are able to do filetransfer\n"
"                       reads and writes as *root*.\n"
"\n"
"                       Also, tightfilexfer is disabled in -unixpw mode.\n"
"\n"
"-ultrafilexfer         Note: to enable UltraVNC filetransfer and to get it to\n"
"                       work you probably need to supply these LibVNCServer\n"
"                       options: \"-rfbversion 3.6 -permitfiletransfer\"\n"
"                       \"-ultrafilexfer\" is an alias for this combination.\n"
"\n"
"                       IMPORTANT: please understand if -ultrafilexfer is\n"
"                       specified and you run x11vnc as root for, say, inetd\n"
"                       or display manager (gdm, kdm, ...) access and you do\n"
"                       not have it switch users via the -users option, then\n"
"                       VNC Viewers that connect are able to do filetransfer\n"
"                       reads and writes as *root*.\n"
"\n"
"                       Note that sadly you cannot do both -tightfilexfer and\n"
"                       -ultrafilexfer at the same time because the latter\n"
"                       requires setting the version to 3.6 and tightvnc will\n"
"                       not do filetransfer when it sees that version number.\n"
"\n"
"-http                  Instead of using -httpdir (see below) to specify\n"
"                       where the Java vncviewer applet is, have x11vnc try\n"
"                       to *guess* where the directory is by looking relative\n"
"                       to the program location and in standard locations\n"
"                       (/usr/local/share/x11vnc/classes, etc).  Under -ssl or\n"
"                       -stunnel the ssl classes subdirectory is sought.\n"
"-http_ssl              As -http, but force lookup for ssl classes subdir.\n"
"\n"
"                       Note that for HTTPS, single-port Java applet delivery\n"
"                       you can set X11VNC_HTTPS_DOWNLOAD_WAIT_TIME to the\n"
"                       max number of seconds to wait for the applet download\n"
"                       to finish.  The default is 15.\n"
"\n"
"-avahi                 Use the Avahi/mDNS ZeroConf protocol to advertise\n"
"                       this VNC server to the local network. (Related terms:\n"
"                       Rendezvous, Bonjour).  Depending on your setup, you\n"
"                       may need to start avahi-daemon and open udp port 5353\n"
"                       in your firewall.\n"
"\n"
"                       You can set X11VNC_AVAHI_NAME, X11VNC_AVAHI_HOST,\n"
"                       and/or X11VNC_AVAHI_PORT environment variables\n"
"                       to override the default values.  For example:\n"
"                       -env X11VNC_AVAHI_NAME=wally\n"
"\n"
"                       If the avahi API cannot be found at build time, a helper\n"
"                       program like avahi-publish(1) or dns-sd(1) will be tried\n"
"\n"
"-mdns                  Same as -avahi.\n"
"-zeroconf              Same as -avahi.\n"
"\n"
"-connect string        For use with \"vncviewer -listen\" reverse connections.\n"
"                       If \"string\" has the form \"host\" or \"host:port\"\n"
"                       the connection is made once at startup.\n"
"\n"
"                       Use commas for a list of host's and host:port's.\n"
"                       E.g. -connect host1,host2 or host1:0,host2:5678.\n"
"                       Note that to reverse connect to multiple hosts at the\n"
"                       same time you will likely need to also supply: -shared\n"
"\n"
"                       Note that unlike most vnc servers, x11vnc will require a\n"
"                       password for reverse as well as for forward connections.\n"
"                       (provided password auth has been enabled, -rfbauth, etc)\n"
"                       If you do not want to require a password for reverse\n"
"                       connections set X11VNC_REVERSE_CONNECTION_NO_AUTH=1 in\n"
"                       your environment before starting x11vnc.\n"
"\n"
"                       If \"string\" contains \"/\" it is instead interpreted\n"
"                       as a file to periodically check for new hosts.\n"
"                       The first line is read and then the file is truncated.\n"
"                       Be careful about the location of this file if x11vnc\n"
"                       is running as root (e.g. via gdm(1), etc).\n"
"\n"
"\n"
"                       Repeater mode: Some services provide an intermediate\n"
"                       \"vnc repeater\": http://www.uvnc.com/addons/repeater.html\n"
"                       (and also http://koti.mbnet.fi/jtko/ for linux port)\n"
"                       that acts as a proxy/gateway.  Modes like these require\n"
"                       an initial string to be sent for the reverse connection\n"
"                       before the VNC protocol is started.  Here are the ways\n"
"                       to do this:\n"
"\n"
"                         -connect pre=some_string+host:port\n"
"                         -connect pre128=some_string+host:port\n"
"                         -connect repeater=ID:1234+host:port\n"
"                         -connect repeater=23.45.67.89::5501+host:port\n"
"\n"
"                       SSVNC notation is also supported:\n"
"\n"
"                         -connect repeater://host:port+ID:1234\n"
"\n"
"                       As with normal -connect usage, if the repeater port is\n"
"                       not supplied 5500 is assumed.\n"
"\n"
"                       The basic idea is between the special tag, e.g. \"pre=\"\n"
"                       and \"+\" is the pre-string to be sent.  Note that in\n"
"                       this case host:port is the repeater server, NOT the\n"
"                       vnc viewer.  Somehow the pre-string tells the repeater\n"
"                       server how to find the vnc viewer and connect you to it.\n"
"\n"
"                       In the case pre=some_string+host:port, \"some_string\"\n"
"                       is simply sent. In the case preNNN=some_string+host:port\n"
"                       \"some_string\" is sent in a null padded buffer of\n"
"                       length NNN.  repeater= is the same as pre250=, this is\n"
"                       the ultravnc repeater buffer size.\n"
"\n"
"                       Strings like \"\\n\" and \"\\r\", etc. are expanded to\n"
"                       newline and carriage return.  \"\\c\" is expanded to\n"
"                       \",\" since the connect string is comma separated.\n"
"\n"
"                       See also the -proxy option below for additional ways\n"
"                       to plumb reverse connections.\n"
"\n"
"                       Reverse SSL: using -connect in -ssl mode makes x11vnc\n"
"                       act as an SSL client (initiates SSL connection) rather\n"
"                       than an SSL server.  The idea is x11vnc might be\n"
"                       connecting to stunnel on the viewer side with the\n"
"                       viewer in listening mode.  If you do not want this\n"
"                       behavior, use -env X11VNC_DISABLE_SSL_CLIENT_MODE=1.\n"
"                       With this the viewer side can act as the SSL client\n"
"                       as it normally does for forward connections.\n"
"\n"
"                       Reverse SSL Repeater mode:  This will work, but note\n"
"                       that if the VNC Client does any sort of a 'Fetch Cert'\n"
"                       action before connecting, then the Repeater will\n"
"                       likely drop the connection and both sides will need\n"
"                       to restart.  Consider the use of -connect_or_exit\n"
"                       and -loop300,2 to have x11vnc reconnect once to the\n"
"                       repeater after the fetch.  You will probably also want\n"
"                       to supply -sslonly to avoid x11vnc thinking the delay\n"
"                       in response means the connection is VeNCrypt.  The env\n"
"                       var X11VNC_DISABLE_SSL_CLIENT_MODE=1 discussed above\n"
"                       may also be useful (i.e. the viewer can do a forward\n"
"                       connection as it normally does.)\n"
"\n"
"                       IPv6: as of x11vnc 0.9.10 the -connect option should\n"
"                       connect to IPv6 hosts properly.  If there are problems\n"
"                       you can disable IPv6 by setting -DX11VNC_IPV6=0\n"
"                       in CPPFLAGS when configuring.  If there problems\n"
"                       connecting to IPv6 hosts consider a relay like the\n"
"                       included inet6to4 script or the -proxy option.\n"
"\n"
"-connect_or_exit str   As with -connect, except if none of the reverse\n"
"                       connections succeed, then x11vnc shuts down immediately\n"
"\n"
"                       An easier to type alias for this option is '-coe'\n"
"\n"
"                       By the way, if you do not want x11vnc to listen on\n"
"                       ANY interface use -rfbport 0  which is handy for the\n"
"                       -connect_or_exit mode.\n"
"\n"
"-proxy string          Use proxy in string (e.g. host:port) as a proxy for\n"
"                       making reverse connections (-connect or -connect_or_exit\n"
"                       options).\n"
"\n"
"                       Web proxies are supported, but note by default most of\n"
"                       them only support destination connections to ports 443\n"
"                       or 563, so this might not be very useful (the viewer\n"
"                       would need to listen on that port or the router would\n"
"                       have to do a port redirection).\n"
"\n"
"                       A web proxy may be specified by either \"host:port\"\n"
"                       or \"http://host:port\" (the port is required even if\n"
"                       it is the common choices 80 or 8080)\n"
"\n"
"                       SOCKS4, SOCKS4a, and SOCKS5 are also supported.\n"
"                       SOCKS proxies normally do not have restrictions on the\n"
"                       destination port number.\n"
"\n"
"                       Use a format like this: socks://host:port or\n"
"                       socks5://host:port.  Note that ssh -D does not support\n"
"                       SOCKS4a, so use socks5://.  For socks:// SOCKS4 is used\n"
"                       on a numerical IP and \"localhost\", otherwise SOCKS4a\n"
"                       is used (and so the proxy tries to do the DNS lookup).\n"
"\n"
"                       An experimental mode is \"-proxy http://host:port/...\"\n"
"                       Note the \"/\" after the port that distinguishes it from\n"
"                       a normal web proxy.  The port must be supplied even if\n"
"                       it is the default 80.  For this mode a GET is done to\n"
"                       the supplied URL with the string host=H&port=P appended.\n"
"                       H and P will be the -connect reverse connect host\n"
"                       and port.  Use the string \"__END__\" to disable the\n"
"                       appending.  The basic idea here is that maybe some cgi\n"
"                       script provides the actual viewer hookup and tunnelling.\n"
"                       How to actually achieve this within cgi, php, etc. is\n"
"                       not clear...  A custom web server or apache module\n"
"                       would be straight-forward.\n"
"\n"
"                       Another experimental mode is \"-proxy ssh://user@host\"\n"
"                       in which case a SSH tunnel is used for the proxying.\n"
"                       \"user@\" is not needed unless your unix username is\n"
"                       different on \"host\".  For a non-standard SSH port\n"
"                       use ssh://user@host:port.  If proxies are chained (see\n"
"                       next paragraph) then the ssh one must be the first one.\n"
"                       If ssh-agent is not active, then the ssh password needs\n"
"                       to be entered in the terminal where x11vnc is running.\n"
"                       Examples:\n"
"\n"
"                         -connect localhost:0 -proxy ssh://me@friends-pc:2222\n"
"\n"
"                         -connect snoopy:0 -proxy ssh://ssh.company.com\n"
"\n"
"                       Multiple proxies may be chained together in case one\n"
"                       needs to ricochet off of a number of hosts to finally\n"
"                       reach the VNC viewer.  Up to 3 may be chained, separate\n"
"                       them by commas in the order they are to be connected to.\n"
"                       E.g.:  http://host1:port1,socks5://host2:port2 or three\n"
"                       like:  first,second,third\n"
"\n"
"                       IPv6: as of x11vnc 0.9.10 the -proxy option should\n"
"                       connect to IPv6 hosts properly.  If there are problems\n"
"                       you can disable IPv6 by setting -DX11VNC_IPV6=0\n"
"                       in CPPFLAGS when configuring.  If there problems\n"
"                       connecting to IPv6 hosts consider a relay like the\n"
"                       included inet6to4 script.\n"
"\n"
"-vncconnect            Monitor the VNC_CONNECT X property set by the standard\n"
"-novncconnect          VNC program vncconnect(1).  When the property is\n"
"                       set to \"host\" or \"host:port\" establish a reverse\n"
"                       connection.  Using xprop(1) instead of vncconnect may\n"
"                       work (see the FAQ).  The -remote control mechanism uses\n"
"                       X11VNC_REMOTE channel, and this option disables/enables\n"
"                       it as well.  Default: %s\n"
"\n"
"                       To use different names for these X11 properties (e.g. to\n"
"                       have separate communication channels for multiple\n"
"                       x11vnc's on the same display) set the VNC_CONNECT or\n"
"                       X11VNC_REMOTE env. vars. to the string you want, for\n"
"                       example: -env X11VNC_REMOTE=X11VNC_REMOTE_12345\n"
"                       Both sides of the channel must use the same unique name.\n"
"                       The same can be done for the internal X11VNC_TICKER\n"
"                       property (heartbeat and timestamp) if desired.\n"
"\n"
"-allow host1[,host2..] Only allow client connections from hosts matching\n"
"                       the comma separated list of hostnames or IP addresses.\n"
"                       Can also be a numerical IP prefix, e.g. \"192.168.100.\"\n"
"                       to match a simple subnet, for more control build\n"
"                       LibVNCServer with libwrap support (See the FAQ).  If the\n"
"                       list contains a \"/\" it instead is a interpreted\n"
"                       as a file containing addresses or prefixes that is\n"
"                       re-read each time a new client connects.  Lines can be\n"
"                       commented out with the \"#\" character in the usual way.\n"
"\n"
"                       -allow applies in -ssl mode, but not in -stunnel mode.\n"
"\n"
"                       IPv6: as of x11vnc 0.9.10 a host can be specified\n"
"                       in IPv6 numerical format, e.g. 2001:4860:b009::93.\n"
"\n"
"-localhost             Basically the same as \"-allow 127.0.0.1\".\n"
"\n"
"                       Note: if you want to restrict which network interface\n"
"                       x11vnc listens on, see the -listen option below.\n"
"                       E.g. \"-listen localhost\" or \"-listen 192.168.3.21\".\n"
"                       As a special case, the option \"-localhost\" implies\n"
"                       \"-listen localhost\".\n"
"\n"
"                       A rare case, but for non-localhost -listen usage, if\n"
"                       you use the remote control mechanism (-R) to change\n"
"                       the -listen interface you may need to manually adjust\n"
"                       the -allow list (and vice versa) to avoid situations\n"
"                       where no connections (or too many) are allowed.\n"
"\n"
"                       If you do not want x11vnc to listen on ANY interface\n"
"                       (evidently you are using -connect or -connect_or_exit,\n"
"                       or plan to use remote control: -R connect:host), use\n"
"                       -rfbport 0\n"
"\n"
"                       IPv6: if IPv6 is supported, this option automatically\n"
"                       implies the IPv6 loopback address '::1' as well.\n"
"\n"
#if X11VNC_IPV6
"-listen6 str           When in IPv6 listen mode \"-6\", listen only on the\n"
"                       network interface with address \"str\".  It also works\n"
"                       for link scope addresses (fe80::219:dbff:fee5:3f92%%eth0)\n"
"                       and IPv6 hostname strings (e.g. ipv6.google.com.)\n"
"                       Use LibVNCServer -listen option for the IPv4 interface.\n"
"\n"
#endif
"-nolookup              Do not use gethostbyname() or gethostbyaddr() to look up\n"
"                       host names or IP numbers.  Use this if name resolution\n"
"                       is incorrectly set up and leads to long pauses as name\n"
"                       lookups time out, etc.\n"
"\n"
"-input string          Fine tuning of allowed user input.  If \"string\" does\n"
"                       not contain a comma \",\" the tuning applies only to\n"
"                       normal clients.  Otherwise the part before \",\" is\n"
"                       for normal clients and the part after for view-only\n"
"                       clients.  \"K\" is for Keystroke input, \"M\" for\n"
"                       Mouse-motion input, \"B\" for Button-click input, \"C\"\n"
"                       is for Clipboard input, and \"F\" is for File transfer\n"
"                       (ultravnc only).  Their presence in the string enables\n"
"                       that type of input.  E.g. \"-input M\" means normal\n"
"                       users can only move the mouse and  \"-input KMBCF,M\"\n"
"                       lets normal users do anything and enables view-only\n"
"                       users to move the mouse.  This option is ignored when\n"
"                       a global -viewonly is in effect (all input is discarded\n"
"                       in that case).\n"
"\n"
"-grabkbd               When VNC viewers are connected, attempt to the grab\n"
"                       the keyboard so a (non-malicious) user sitting at the\n"
"                       physical display is not able to enter keystrokes.\n"
"                       This method uses XGrabKeyboard(3X11) and so it is\n"
"                       not secure and does not rule out the person at the\n"
"                       physical display injecting keystrokes by flooding the\n"
"                       server with them, grabbing the keyboard himself, etc.\n"
"                       Some degree of cooperation from the person at the\n"
"                       display is assumed.  This is intended for remote\n"
"                       help-desk or educational usage modes.\n"
"-grabptr               As -grabkbd, but for the mouse pointer using\n"
"                       XGrabPointer(3X11).  Unfortunately due to the way the X\n"
"                       server works, the mouse can still be moved around by the\n"
"                       user at the physical display, but he will not be able to\n"
"                       change window focus with it.  Also some window managers\n"
"                       that call XGrabServer(3X11) for resizes, etc, will\n"
"                       act on the local user's input.  Again, some degree of\n"
"                       cooperation from the person at the display is assumed.\n"
"\n"
"-grabalways            Apply both -grabkbd and -grabptr even when no VNC\n"
"                       viewers are connected.  If you only want one of them,\n"
"                       use the -R remote control to turn the other back on,\n"
"                       e.g. -R nograbptr.\n"
"\n"
#ifdef ENABLE_GRABLOCAL
"-grablocal n           If it appears that a user sitting at the physical\n"
"                       display has injected a keystroke or mouse event ignore\n"
"                       any VNC client inputs for the next n seconds.  The idea\n"
"                       is that during a demonstration, etc, the local user\n"
"                       will not be interrupted by viewers accidentally moving\n"
"                       the mouse, etc.  The detection of local user input is\n"
"                       approximate and so at times gives unexpected results.\n"
"\n"
#endif
"-viewpasswd string     Supply a 2nd password for view-only logins.  The -passwd\n"
"                       (full-access) password must also be supplied.\n"
"\n"
"-passwdfile filename   Specify the LibVNCServer password via the first line\n"
"                       of the file \"filename\" (instead of via -passwd on\n"
"                       the command line where others might see it via ps(1)).\n"
"\n"
"                       See the descriptions below for how to supply multiple\n"
"                       passwords, view-only passwords, to specify external\n"
"                       programs for the authentication, and other features.\n"
"\n"
"                       If the filename is prefixed with \"rm:\" it will be\n"
"                       removed after being read.  Perhaps this is useful in\n"
"                       limiting the readability of the file.  In general, the\n"
"                       password file should not be readable by untrusted users\n"
"                       (BTW: neither should the VNC -rfbauth file: it is NOT\n"
"                       encrypted, only obscured with a fixed key).\n"
"\n"
"                       If the filename is prefixed with \"read:\" it will\n"
"                       periodically be checked for changes and reread.  It is\n"
"                       guaranteed to be reread just when a new client connects\n"
"                       so that the latest passwords will be used.\n"
"\n"
"                       If \"filename\" is prefixed with \"cmd:\" then the\n"
"                       string after the \":\" is run as an external command:\n"
"                       the output of the command will be interpreted as if it\n"
"                       were read from a password file (see below).  If the\n"
"                       command does not exit with 0, then x11vnc terminates\n"
"                       immediately.  To specify more than 1000 passwords this\n"
"                       way set X11VNC_MAX_PASSWDS before starting x11vnc.\n"
"                       The environment variables are set as in -accept.\n"
"\n"
"                       Note that due to the VNC protocol only the first 8\n"
"                       characters of a password are used (DES key).\n"
"\n"
"                       If \"filename\" is prefixed with \"custom:\" then a\n"
"                       custom password checker is supplied as an external\n"
"                       command following the \":\". The command will be run\n"
"                       when a client authenticates.  If the command exits with\n"
"                       0 the client is accepted, otherwise it is rejected.\n"
"                       The environment variables are set as in -accept.\n"
"\n"
"                       The standard input to the custom command will be a\n"
"                       decimal digit \"len\" followed by a newline. \"len\"\n"
"                       specifies the challenge size and is usually 16 (the\n"
"                       VNC spec).  Then follows len bytes which is the random\n"
"                       challenge string that was sent to the client. This is\n"
"                       then followed by len more bytes holding the client's\n"
"                       response (i.e. the challenge string encrypted via DES\n"
"                       with the user password in the standard situation).\n"
"\n"
"                       The \"custom:\" scheme can be useful to implement\n"
"                       dynamic passwords or to implement methods where longer\n"
"                       passwords and/or different encryption algorithms\n"
"                       are used.  The latter will require customizing the VNC\n"
"                       client as well.  One could create an MD5SUM based scheme\n"
"                       for example.\n"
"\n"
"                       File format for -passwdfile:\n"
"\n"
"                       If multiple non-blank lines exist in the file they are\n"
"                       all taken as valid passwords.  Blank lines are ignored.\n"
"                       Password lines may be \"commented out\" (ignored) if\n"
"                       they begin with the character \"#\" or the line contains\n"
"                       the string \"__SKIP__\".  Lines may be annotated by use\n"
"                       of the \"__COMM__\" string: from it to the end of the\n"
"                       line is ignored.  An empty password may be specified\n"
"                       via the \"__EMPTY__\" string on a line by itself (note\n"
"                       your viewer might not accept empty passwords).\n"
"\n"
"                       If the string \"__BEGIN_VIEWONLY__\" appears on a\n"
"                       line by itself, the remaining passwords are used for\n"
"                       viewonly access.  For compatibility, as a special case\n"
"                       if the file contains only two password lines the 2nd\n"
"                       one is automatically taken as the viewonly password.\n"
"                       Otherwise the \"__BEGIN_VIEWONLY__\" token must be\n"
"                       used to have viewonly passwords.  (tip: make the 3rd\n"
"                       and last line be \"__BEGIN_VIEWONLY__\" to have 2\n"
"                       full-access passwords)\n"
"\n"
"-showrfbauth filename  Print to the screen the obscured VNC password kept in\n"
"                       the rfbauth file \"filename\" and then exit.\n"
"\n"
"-unixpw [list]         Use Unix username and password authentication.  x11vnc\n"
"                       will use the su(1) program to verify the user's\n"
"                       password.  [list] is an optional comma separated list\n"
"                       of allowed Unix usernames.  If the [list] string begins\n"
"                       with the character \"!\" then the entire list is taken\n"
"                       as an exclude list.  See below for per-user options\n"
"                       that can be applied.\n"
"\n"
"                       A familiar \"login:\" and \"Password:\" dialog is\n"
"                       presented to the user on a black screen inside the\n"
"                       vncviewer.  The connection is dropped if the user fails\n"
"                       to supply the correct password in 3 tries or does not\n"
"                       send one before a 45 second timeout.  Existing clients\n"
"                       are view-only during this period.\n"
"\n"
"                       If the first character received is \"Escape\" then the\n"
"                       unix username will not be displayed after \"login:\"\n"
"                       as it is typed.  This could be of use for VNC viewers\n"
"                       that automatically type the username and password.\n"
"\n"
"                       Since the detailed behavior of su(1) can vary from\n"
"                       OS to OS and for local configurations, test the mode\n"
"                       before deployment to make sure it is working properly.\n"
"                       x11vnc will attempt to be conservative and reject a\n"
"                       login if anything abnormal occurs.\n"
"\n"
"                       One case to note: FreeBSD and the other BSD's by\n"
"                       default it is impossible for the user running x11vnc to\n"
"                       validate his *own* password via su(1) (commenting out\n"
"                       the pam_self.so entry in /etc/pam.d/su eliminates this\n"
"                       behavior).  So the x11vnc login will always *FAIL* for\n"
"                       this case (even when the correct password is supplied).\n"
"\n"
"                       A possible workaround for this on *BSD would be to\n"
"                       start x11vnc as root with the \"-users +nobody\" option\n"
"                       to immediately switch to user nobody where the su'ing\n"
"                       will proceed normally.\n"
"\n"
"                       Another source of potential problems are PAM modules\n"
"                       that prompt for extra info, e.g. password aging modules.\n"
"                       These logins will fail as well even when the correct\n"
"                       password is supplied.\n"
"\n"
"                       **IMPORTANT**: to prevent the Unix password being sent\n"
"                       in *clear text* over the network, one of two schemes\n"
"                       will be enforced: 1) the -ssl builtin SSL mode, or 2)\n"
"                       require both -localhost and -stunnel be enabled.\n"
"\n"
"                       Method 1) ensures the traffic is encrypted between\n"
"                       viewer and server.  A PEM file will be required, see the\n"
"                       discussion under -ssl below (under some circumstances\n"
"                       a temporary one can be automatically generated).\n"
"\n"
"                       Method 2) requires the viewer connection to appear\n"
"                       to come from the same machine x11vnc is running on\n"
"                       (e.g. from a ssh -L port redirection).  And that the\n"
"                       -stunnel SSL mode be used for encryption over the\n"
"                       network. (see the description of -stunnel below).\n"
"\n"
"                       Note: as a convenience, if you ssh(1) in and start\n"
"                       x11vnc it will check if the environment variable\n"
"                       SSH_CONNECTION is set and appears reasonable.  If it\n"
"                       does, then the -ssl or -stunnel requirement will be\n"
"                       dropped since it is assumed you are using ssh for the\n"
"                       encrypted tunnelling.  -localhost is still enforced.\n"
"                       Use -ssl or -stunnel to force SSL usage even if\n"
"                       SSH_CONNECTION is set.\n"
"\n"
"                       To override the above restrictions you can set\n"
"                       environment variables before starting x11vnc:\n"
"\n"
"                       Set UNIXPW_DISABLE_SSL=1 to disable requiring either\n"
"                       -ssl or -stunnel (as under SSH_CONNECTION.)  Evidently\n"
"                       you will be using a different method to encrypt the\n"
"                       data between the vncviewer and x11vnc: perhaps ssh(1)\n"
"                       or an IPSEC VPN. -localhost is still enforced (however,\n"
"                       see the next paragraph.)\n"
"\n"
"                       Set UNIXPW_DISABLE_LOCALHOST=1 to disable the -localhost\n"
"                       requirement in -unixpw modes.  One should never do this\n"
"                       (i.e. allow the Unix passwords to be sniffed on the\n"
"                       network.)  This also disables the localhost requirement\n"
"                       for reverse connections (see below.)\n"
"\n"
"                       Note that use of -localhost with ssh(1) (and no -unixpw)\n"
"                       is roughly the same as requiring a Unix user login\n"
"                       (since a Unix password or the user's public key\n"
"                       authentication is used by sshd on the machine where\n"
"                       x11vnc runs and only local connections from that machine\n"
"                       are accepted).\n"
"\n"
"                       Regarding reverse connections (e.g. -R connect:host\n"
"                       and -connect host), when the -localhost constraint is\n"
"                       in effect then reverse connections can only be used\n"
"                       to connect to the same machine x11vnc is running on\n"
"                       (default port 5500).  Please use a ssh or stunnel port\n"
"                       redirection to the viewer machine to tunnel the reverse\n"
"                       connection over an encrypted channel.\n"
"\n"
"                       In -inetd mode the Method 1) will be enforced (not\n"
"                       Method 2).  With -ssl in effect reverse connections\n"
"                       are disabled.  If you override this via env. var, be\n"
"                       sure to also use encryption from the viewer to inetd.\n"
"                       Tip: you can also have your own stunnel spawn x11vnc\n"
"                       in -inetd mode (thereby bypassing inetd).  See the FAQ\n"
"                       for details.\n"
"\n"
"                       The user names in the comma separated [list] may have\n"
"                       per-user options after a \":\", e.g. \"fred:opts\"\n"
"                       where \"opts\" is a \"+\" separated list of\n"
"                       \"viewonly\", \"fullaccess\", \"input=XXXX\", or\n"
"                       \"deny\", e.g. \"karl,wally:viewonly,boss:input=M\".\n"
"                       For \"input=\" it is the K,M,B,C described under -input.\n"
"\n"
"                       If an item in the list is \"*\" that means those\n"
"                       options apply to all users.  It ALSO implies all users\n"
"                       are allowed to log in after supplying a valid password.\n"
"                       Use \"deny\" to explicitly deny some users if you use\n"
"                       \"*\" to set a global option.  If [list] begins with the\n"
"                       \"!\" character then \"*\" is ignored for checking if\n"
"                       the user is allowed, but the option values associated\n"
"                       with it do apply as normal.\n"
"\n"
"                       There are also some utilities for checking passwords\n"
"                       if [list] starts with the \"%%\" character.  See the\n"
"                       quick_pw() function for more details.  Description:\n"
"                       \"%%-\" or \"%%stdin\" means read one line from stdin.\n"
"                       \"%%env\" means it is in $UNIXPW env var.  A leading\n"
"                       \"%%/\" or \"%%.\" means read the first line from the\n"
"                       filename that follows after the %% character. %% by\n"
"                       itself means prompt for the username and password.\n"
"                       Otherwise: %%user:pass   E.g. -unixpw %%fred:swordfish\n"
"                       For the other cases user:pass is read from the indicated\n"
"                       source.  If the password is correct 'Y user' is printed\n"
"                       and the program exit code is 0.  If the password is\n"
"                       incorrect it prints 'N user' and the exit code is 1.\n"
"                       If there is some other error the exit code is 2.\n"
"                       This feature enables x11vnc to be a general unix user\n"
"                       password checking tool; it could be used from scripts\n"
"                       or other programs.  These %% password checks also apply\n"
"                       to the -unixpw_nis and -unixpw_cmd options.\n"
"\n"
"                       For the %% password check, if the env. var. UNIXPW_CMD\n"
"                       is set to a command then it is run as the user (assuming\n"
"                       the password is correct.)  The output of the command is\n"
"                       not printed, the program or script must manage that by\n"
"                       some other means.  The exit code of x11vnc will depend\n"
"                       on the exit code of the command that is run.\n"
"\n"
"                       Use -nounixpw to disable unixpw mode if it was enabled\n"
"                       earlier in the cmd line (e.g. -svc mode)\n"
"\n"
"-unixpw_nis [list]     As -unixpw above, however do not use su(1) but rather\n"
"                       use the traditional getpwnam(3) + crypt(3) method to\n"
"                       verify passwords. All of the above -unixpw options and\n"
"                       constraints apply.\n"
"\n"
"                       This mode requires that the encrypted passwords be\n"
"                       readable.  Encrypted passwords stored in /etc/shadow\n"
"                       will be inaccessible unless x11vnc is run as root.\n"
"\n"
"                       This is called \"NIS\" mode simply because in most\n"
"                       NIS setups user encrypted passwords are accessible\n"
"                       (e.g. \"ypcat passwd\") by an ordinary user and so that\n"
"                       user can authenticate ANY user.\n"
"\n"
"                       NIS is not required for this mode to work (only that\n"
"                       getpwnam(3) return the encrypted password is required),\n"
"                       but it is unlikely it will work (as an ordinary user)\n"
"                       for most modern environments unless NIS is available.\n"
"                       On the other hand, when x11vnc is run as root it will\n"
"                       be able to to access /etc/shadow even if NIS is not\n"
"                       available (note running as root is often done when\n"
"                       running x11vnc from inetd and xdm/gdm/kdm).\n"
"\n"
"                       Looked at another way, if you do not want to use the\n"
"                       su(1) method provided by -unixpw (i.e. su_verify()), you\n"
"                       can run x11vnc as root and use -unixpw_nis.  Any users\n"
"                       with passwords in /etc/shadow can then be authenticated.\n"
"\n"
"                       In -unixpw_nis mode, under no circumstances is x11vnc's\n"
"                       user password verifying function based on su called\n"
"                       (i.e. the function su_verify() that runs /bin/su\n"
"                       in a pseudoterminal to verify passwords.)  However,\n"
"                       if -unixpw_nis is used in conjunction with the -find\n"
"                       and -create -display WAIT:... modes then, if x11vnc is\n"
"                       running as root, /bin/su may be called externally to\n"
"                       run the find or create commands.\n"
"\n"
"-unixpw_cmd cmd        As -unixpw above, however do not use su(1) but rather\n"
"                       run the externally supplied command \"cmd\".  The first\n"
"                       line of its stdin will be the username and the second\n"
"                       line the received password.  If the command exits\n"
"                       with status 0 (success) the VNC user will be accepted.\n"
"                       It will be rejected for any other return status.\n"
"\n"
"                       Dynamic passwords and non-unix passwords, e.g. LDAP,\n"
"                       can be implemented this way by providing your own custom\n"
"                       helper program.  Note that the remote viewer is given 3\n"
"                       tries to enter the correct password, and so the program\n"
"                       may be called in a row that many (or more) times.\n"
"\n"
"                       If a list of allowed users is needed to limit who can\n"
"                       log in, use -unixpw [list] in addition to this option.\n"
"\n"
"                       In FINDDISPLAY and FINDCREATEDISPLAY modes the \"cmd\"\n"
"                       will also be run with the RFB_UNIXPW_CMD_RUN env. var.\n"
"                       non-empty and set to the corresponding display\n"
"                       find/create command.  The first two lines of input are\n"
"                       the username and passwd as in the normal case described\n"
"                       above.  To support FINDDISPLAY and FINDCREATEDISPLAY,\n"
"                       \"cmd\" should run the requested command as the user\n"
"                       (and most likely refusing to run it if the password is\n"
"                       not correct.)  Here is an example script (note it has\n"
"                       a hardwired bogus password \"abc\"!)\n"
"\n"
"                         #!/bin/sh\n"
"                         # Example x11vnc -unixpw_cmd script.\n"
"                         # Read the first two lines of stdin (user and passwd)\n"
"                         read user\n"
"                         read pass\n"
"                         \n"
"                         debug=0\n"
"                         if [ $debug = 1 ]; then\n"
"                         	echo \"user: $user\" 1>&2\n"
"                         	echo \"pass: $pass\" 1>&2\n"
"                         	env | egrep -i 'rfb|vnc' 1>&2\n"
"                         fi\n"
"                         \n"
"                         # Check if the password is valid.\n"
"                         # (A real example would use ldap lookup, etc!)\n"
"                         if [ \"X$pass\" != \"Xabc\" ]; then\n"
"                         	exit 1	# incorrect password\n"
"                         fi\n"
"                         \n"
"                         if [ \"X$RFB_UNIXPW_CMD_RUN\" = \"X\" ]; then\n"
"                         	exit 0	# correct password\n"
"                         else\n"
"                         	# Run the requested command (finddisplay)\n"
"                         	if [ $debug = 1 ]; then\n"
"                         		echo \"run: $RFB_UNIXPW_CMD_RUN\" 1>&2\n"
"                         	fi\n"
"                         	exec /bin/su - \"$user\" -c \"$RFB_UNIXPW_CMD_RUN\"\n"
"                         fi\n"
"\n"
"                       In -unixpw_cmd mode, under no circumstances is x11vnc's\n"
"                       user password verifying function based on su called\n"
"                       (i.e. the function su_verify() that runs /bin/su in a\n"
"                       pseudoterminal to verify passwords.)  It is up to the\n"
"                       supplied unixpw_cmd to do user switching if desired\n"
"                       and if it has the permissions to do so.\n"
"\n"
"-find                  Find the user's display using FINDDISPLAY. This\n"
"                       is an alias for \"-display WAIT:cmd=FINDDISPLAY\".\n"
"\n"
"                       Note: if a -display occurs later on the command line\n"
"                       it will override the -find setting.\n"
"\n"
"                       For this and the next few options see -display WAIT:...\n"
"                       below for all of the details.\n"
"\n"
"-finddpy               Run the FINDDISPLAY program, print out the found\n"
"                       display (if any) and exit.  Output is like: DISPLAY=:0.0\n"
"                       DISPLAY=:0.0,XPID=12345 or DISPLAY=:0.0,VT=7.  XPID is\n"
"                       the process ID of the found X server.  VT is the Linux\n"
"                       virtual terminal of the X server.\n"
"-listdpy               Have the FINDDISPLAY program list all of your displays\n"
"                       (i.e. all the X displays on the local machine that you\n"
"                       have access rights to).  x11vnc then exits.\n"
"\n"
"-findauth [disp]       Apply the -find/-finddpy heuristics to try to guess\n"
"                       the XAUTHORITY file for DISPLAY 'disp'.  If 'disp'\n"
"                       is not supplied, then the value in the -display on\n"
"                       the cmdline is used; failing that $DISPLAY is used;\n"
"                       and failing that \":0\" is used.  x11vnc then exits.\n"
"\n"
"                       If nothing is printed out, that means no XAUTHORITY was\n"
"                       found for 'disp'; i.e. failure.  If \"XAUTHORITY=\"\n"
"                       is printed out, that means use the default (i.e. do\n"
"                       not set XAUTHORITY).  If \"XAUTHORITY=/path/to/file\"\n"
"                       is printed out, then use that file.\n"
"\n"
"                       XDM/GDM/KDM: if you are running x11vnc as root and want\n"
"                       to find the XAUTHORITY before anyone has logged into an\n"
"                       X session yet, use: x11vnc -env FD_XDM=1 -findauth ...\n"
"                       (This will also find the XAUTHORITY if a user is already\n"
"                       logged into the X session.)  When running as root,\n"
"                       FD_XDM=1 will be tried if the initial -findauth fails.\n"
"\n"
"-create                First try to find the user's display using FINDDISPLAY,\n"
"                       if that doesn't succeed create an X session via the\n"
"                       FINDCREATEDISPLAY method.  This is an alias for\n"
"                       \"-display WAIT:cmd=FINDCREATEDISPLAY-Xvfb\".\n"
"\n"
"                       Note: if a -display occurs later on the command line\n"
"                       it will override the -create setting.\n"
"\n"
"                       SSH NOTE: for both -find and -create you can (should!)\n"
"                       add the \"-localhost\" option to force SSH tunnel access.\n"
"\n"
"-xdummy                As in -create, except Xdummy instead of Xvfb.\n"
"-xvnc                  As in -create, except Xvnc instead of Xvfb.\n"
"-xvnc_redirect         As in -create, except Xvnc.redirect instead of Xvfb.\n"
"-xdummy_xvfb           Sets WAIT:cmd=FINDCREATEDISPLAY-Xdummy,Xvfb\n"
"\n"
"-create_xsrv str       Sets WAIT:cmd=FINDCREATEDISPLAY-<str>  Can be on cmdline\n"
"                       after anything that sets WAIT:.. and other things\n"
"                       (e.g. -svc, -xdmsvc) to adjust the X server list.\n"
"                       Example: -svc ... -create_xsrv Xdummy,X\n"
"\n"
"-svc                   Terminal services mode based on SSL access.  Alias for\n"
"                       -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb -unixpw -users\n"
"                       unixpw= -ssl SAVE   Also \"-service\".\n"
"\n"
"                       Note: if a -display, -unixpw, -users, or -ssl occurs\n"
"                       later on the command line it will override the -svc\n"
"                       setting.\n"
"\n"
"-svc_xdummy            As -svc except Xdummy instead of Xvfb.\n"
"-svc_xvnc              As -svc except Xvnc instead of Xvfb.\n"
"-svc_xdummy_xvfb       As -svc with Xdummy,Xvfb.\n"
"\n"
"-xdmsvc                Display manager Terminal services mode based on SSL.\n"
"                       Alias for -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb.xdmcp\n"
"                       -unixpw -users unixpw= -ssl SAVE  Also \"-xdm_service\".\n"
"\n"
"                       Note: if a -display, -unixpw, -users, or -ssl occurs\n"
"                       later on the command line it will override the -xdmsvc\n"
"                       setting.\n"
"\n"
"                       To create a session a user will have to first log in\n"
"                       to the -unixpw dialog and then log in again to the\n"
"                       XDM/GDM/KDM prompt.  Subsequent re-connections will\n"
"                       only require the -unixpw password.  See the discussion\n"
"                       under -display WAIT:... for more details about XDM,\n"
"                       etc configuration.\n"
"\n"
"                       Remember to enable XDMCP in the xdm-config, gdm.conf,\n"
"                       or kdmrc configuration file.  See -display WAIT: for\n"
"                       more info.\n"
"\n"
"-sshxdmsvc             Display manager Terminal services mode based on SSH.\n"
"                       Alias for -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb.xdmcp\n"
"                       -localhost.\n"
"\n"
"                       The -localhost option constrains connections to come\n"
"                       in via a SSH tunnel (which will require a login).\n"
"                       To create a session a user will also have to log into\n"
"                       the XDM GDM KDM prompt. Subsequent re-connections will\n"
"                       only only require the SSH login.  See the discussion\n"
"                       under -display WAIT:... for more details about XDM,\n"
"                       etc configuration.\n"
"\n"
"                       Remember to enable XDMCP in the xdm-config, gdm.conf,\n"
"                       or kdmrc configuration file.  See -display WAIT: for\n"
"                       more info.\n"
"\n"
"-unixpw_system_greeter Present a \"Press 'Escape' for System Greeter\" option\n"
"                       to the connecting VNC client in combined -unixpw\n"
"                       and xdmcp FINDCREATEDISPLAY modes (e.g. -xdmsvc).\n"
"\n"
"                       Normally in a -unixpw mode the VNC client must\n"
"                       supply a valid username and password to gain access.\n"
"                       However, if -unixpw_system_greeter is supplied AND\n"
"                       the FINDCREATEDISPLAY command matches 'xdmcp', then\n"
"                       the user has the option to press Escape and then get a\n"
"                       XDM/GDM/KDM login/greeter panel instead. They will then\n"
"                       supply a username and password directly to the greeter.\n"
"\n"
"                       Otherwise, in xdmcp FINDCREATEDISPLAY mode the user\n"
"                       must supply his username and password TWICE.  First to\n"
"                       the initial unixpw login dialog, and second to the\n"
"                       subsequent XDM/GDM/KDM greeter.  Note that if the user\n"
"                       re-connects and supplies his username and password in\n"
"                       the unixpw dialog the xdmcp greeter is skipped and\n"
"                       he is connected directly to his existing X session.\n"
"                       So the -unixpw_system_greeter option avoids the extra\n"
"                       password at X session creation time.\n"
"\n"
"                       Example:  x11vnc -xdmsvc -unixpw_system_greeter\n"
"                       See -unixpw and -display WAIT:... for more info.\n"
"\n"
"                       The special options after a colon at the end of the\n"
"                       username (e.g. user:solid) described under -display\n"
"                       WAIT: are also applied in this mode if they are typed\n"
"                       in before the user hits Escape.  The username is ignored\n"
"                       but the colon options are not.\n"
"\n"
"                       The default message is 2 lines in a small font, set\n"
"                       the env. var. X11VNC_SYSTEM_GREETER1=true for a 1 line\n"
"                       message in a larger font.\n"
"\n"
"                       If the user pressed Escape the FINDCREATEDISPLAY command\n"
"                       will be run with the env. var. X11VNC_XDM_ONLY=1.\n"
"\n"
"                       Remember to enable XDMCP in the xdm-config, gdm.conf,\n"
"                       or kdmrc configuration file.  See -display WAIT: for\n"
"                       more info.\n"
"\n"
"-redirect port         As in FINDCREATEDISPLAY-Xvnc.redirect mode except\n"
"                       redirect immediately (i.e. without X session finding\n"
"                       or creation) to a VNC server listening on port. You\n"
"                       can also supply host:port to redirect to a different\n"
"                       machine.\n"
"\n"
"                       If 0 <= port < 200 it is taken as a VNC display (5900 is\n"
"                       added to get the actual port), if port < 0 then -port\n"
"                       is used.\n"
"\n"
"                       Probably the only reason to use the -redirect option\n"
"                       is in conjunction with SSL support, e.g. -ssl SAVE.\n"
"                       This provides an easy way to add SSL encryption to a VNC\n"
"                       server that does not support SSL (e.g. Xvnc or vnc.so)\n"
"                       In fact, the protocol does not even need to be VNC,\n"
"                       and so \"-rfbport port1 -ssl SAVE -redirect host:port2\"\n"
"                       can act as a replacement for stunnel(1).\n"
"\n"
"                       This mode only allows one redirected connection.\n"
"                       The -forever option does not apply.  Use -inetd or\n"
"                       -loop for persistent service.\n"
"\n"
"-display WAIT:...      A special usage mode for the normal -display option.\n"
"                       Useful with -unixpw, but can be used independently\n"
"                       of it.  If the display string begins with WAIT: then\n"
"                       x11vnc waits until a VNC client connects before opening\n"
"                       the X display (or -rawfb device).\n"
"\n"
"                       This could be useful for delaying opening the display\n"
"                       for certain usage modes (say if x11vnc is started at\n"
"                       boot time and no X server is running or users logged\n"
"                       in yet).\n"
"\n"
"                       If the string is, e.g. WAIT:0.0 or WAIT:1, i.e. \"WAIT\"\n"
"                       in front of a normal X display, then that indicated\n"
"                       display is used.\n"
"\n"
"                       One can also insert a geometry between colons, e.g.\n"
"                       WAIT:1280x1024:... to set the size of the display the\n"
"                       VNC client first attaches to since some VNC viewers\n"
"                       will not automatically adjust to a new framebuffer size.\n"
"\n"
"                       A more interesting case is like this:\n"
"\n"
"                            WAIT:cmd=/usr/local/bin/find_display\n"
"\n"
"                       in which case the command after \"cmd=\" is run to\n"
"                       dynamically work out the DISPLAY and optionally the\n"
"                       XAUTHORITY data.  The first line of the command output\n"
"                       must be of the form DISPLAY=<xdisplay>.  On Linux\n"
"                       if the virtual terminal is known append \",VT=n\" to\n"
"                       this string and the chvt(1) program will also be run.\n"
"                       Any remaining output is taken as XAUTHORITY data.\n"
"                       It can be either of the form XAUTHORITY=<file> or raw\n"
"                       xauthority data for the display. For example;\n"
"\n"
"                            xauth extract - $DISPLAY\"\n"
"\n"
"                       In the case of -unixpw (and -unixpw_nis only if x11vnc\n"
"                       is running as root), then the cmd= command is run\n"
"                       as the user who just authenticated via the login and\n"
"                       password prompt.\n"
"\n"
"                       In the case of -unixpw_cmd, the commands will also be\n"
"                       run as the logged-in user, as long as the user-supplied\n"
"                       helper program supports RFB_UNIXPW_CMD_RUN (see the\n"
"                       -unixpw_cmd option.)\n"
"\n"
"                       Also in the case of -unixpw, the user logging in can\n"
"                       place a colon at the end of her username and supply\n"
"                       a few options: scale=, scale_cursor= (or sc=), solid\n"
"                       (or so), id=, clear_mods (or cm), clear_keys (or\n"
"                       ck), clear_all (or ca), repeat, speeds= (or sp=),\n"
"                       readtimeout= (or rd=), viewonly (or vo), nodisplay=\n"
"                       (or nd=), rotate= (or ro=), or noncache (or nc),\n"
"                       all separated by commas if there is more than one.\n"
"                       After the user logs in successfully, these options will\n"
"                       be applied to the VNC screen.  For example,\n"
"\n"
"                          login: fred:scale=3/4,sc=1,repeat\n"
"                          Password: ...\n"
"\n"
"                          login: runge:sp=modem,rd=120,solid\n"
"\n"
"                       for convenience m/n implies scale= e.g. fred:3/4  If you\n"
"                       type and enter your password incorrectly, to retrieve\n"
"                       your long \"login:\" line press the Up arrow once\n"
"                       (before typing anything else).\n"
"\n"
"                       In the login panel, press F1 to get a list of the\n"
"                       available options that you can add after the username.\n"
"\n"
"                       Another option is \"geom=WxH\" or \"geom=WxHxD\" (or\n"
"                       ge=). This only has an effect in FINDCREATEDISPLAY\n"
"                       mode when a virtual X server such as Xvfb is going\n"
"                       to be created.  It sets the width and height of\n"
"                       the new display, and optionally the color depth as\n"
"                       well.\n"
"\n"
"                       You can also supply \"gnome\", \"kde\", \"twm\",\n"
"                       \"fvwm\", \"mwm\", \"dtwm\", \"wmaker\", \"xfce\",\n"
"                       \"lxde\", \"enlightenment\", \"Xsession\", or\n"
"                       \"failsafe\" (same as \"xterm\") to have the created\n"
"                       display use that mode for the user session.\n"
"\n"
"                       Specify \"tag=...\" to set the unique FD_TAG desktop\n"
"                       session tag described below.  Note: this option will\n"
"                       be ignored if the FD_TAG env. var. is already set or\n"
"                       if the viewer-side supplied value is not completely\n"
"                       composed of alphanumeric or '_' or '-' characters.\n"
"\n"
"                       User preferences file: Instead of having the user type\n"
"                       in geom=WxH,... etc. every time he logs in to find\n"
"                       or create his X session, if you set FD_USERPREFS to\n"
"                       a string that does not contain the \"/\" character,\n"
"                       then the user's home directory is prepended to that\n"
"                       string and if the file exists its first line is read\n"
"                       and appended to any options he supplied at the login:\n"
"                       prompt.  For example -env FD_USERPREFS=.x11vnc_create\n"
"                       and the user put \"geom=1600x1200\" in his\n"
"                       ~/.x11vnc_create file.\n"
"\n"
"                       To troubleshoot the FINDCREATEDISPLAY mechanism,\n"
"                       set the following env. var. to an output log file,\n"
"                       e.g -env CREATE_DISPLAY_OUTPUT=/tmp/mydebug.txt\n"
"\n"
"                       To disable the option setting set the environment\n"
"                       variable X11VNC_NO_UNIXPW_OPTS=1 before starting x11vnc.\n"
"                       To set any other options, the user can use the gui\n"
"                       (x11vnc -gui connect) or the remote control method\n"
"                       (x11vnc -R opt:val) during his VNC session.\n"
"\n"
"                       The combination of -display WAIT:cmd=... and -unixpw\n"
"                       allows automatic pairing of an unix authenticated VNC\n"
"                       user with his desktop.  This could be very useful on\n"
"                       SunRays and also any system where multiple users share\n"
"                       a given machine.  The user does not need to remember\n"
"                       special ports or passwords set up for his desktop\n"
"                       and VNC.\n"
"\n"
"                       A nice way to use WAIT:cmd=... is out of inetd(8)\n"
"                       (it automatically forks a new x11vnc for each user).\n"
"                       You can have the x11vnc inetd spawned process run as,\n"
"                       say, root or nobody.  When run as root (for either inetd\n"
"                       or display manager), you can also supply the option\n"
"                       \"-users unixpw=\" to have the x11vnc process switch to\n"
"                       the user as well.  Note: there will be a 2nd SSL helper\n"
"                       process that will not switch, but it is only encoding\n"
"                       and decoding the encrypted stream at that point.\n"
"\n"
"                       Automatic Finding of User X Sessions:\n"
"\n"
"                       As a special case, WAIT:cmd=FINDDISPLAY will run a\n"
"                       script that works on most Unixes to determine a user's\n"
"                       DISPLAY variable and xauthority data (see who(1)).\n"
"\n"
"                       The option \"-find\" is an alias for this mode.\n"
"\n"
"                       To have this default script printed to stdout (e.g. for\n"
"                       customization) run with WAIT:cmd=FINDDISPLAY-print To\n"
"                       have the script run to print what display it would find\n"
"                       use \"-finddpy\" or WAIT:cmd=FINDDISPLAY-run\n"
"\n"
"                       The standard script runs xdpyinfo(1) run on potential\n"
"                       displays.  If your X server(s) have a login greeter\n"
"                       that exclusively grabs the Xserver, then xdpyinfo\n"
"                       blocks forever and this mode will not work.  See\n"
"                       www.karlrunge.com/x11vnc/faq.html#faq-display-manager\n"
"                       for how to disable this for dtgreet on Solaris and\n"
"                       possibly for other greeters.\n"
"\n"
"                       In -find/cmd=FINDDISPLAY mode, if you set FD_XDM=1,\n"
"                       e.g. 'x11vnc -env FD_XDM=1 -find ...' and x11vnc is\n"
"                       running as root (e.g. inetd) then it will try to find\n"
"                       the XAUTHORITY file of a running XDM/GDM/KDM login\n"
"                       greeter (i.e. no user has logged into an X session yet.)\n"
"\n"
"                       As another special case, WAIT:cmd=HTTPONCE will allow\n"
"                       x11vnc to service one http request and then exit.\n"
"                       This is usually done in -inetd mode to run on, say,\n"
"                       port 5800 and allow the Java vncviewer to be downloaded\n"
"                       by client web browsers.  For example:\n"
"\n"
"                        5815 stream tcp nowait root /usr/sbin/tcpd /.../x11vnc \\\n"
"                          -inetd -q -http_ssl -prog /.../x11vnc \\\n"
"                          -display WAIT:cmd=HTTPONCE\n"
"\n"
"                       Where /.../x11vnc is the full path to x11vnc.\n"
"                       It is used in the Apache SSL-portal example (see FAQ).\n"
"\n"
"                       In this mode you can set X11VNC_SKIP_DISPLAY to a\n"
"                       comma separated list of displays (e.g. \":0,:1\") to\n"
"                       ignore in the finding process.  The \":\" is optional.\n"
"                       Ranges n-m e.g. 0-20 can also be supplied. This string\n"
"                       can also be set by the connecting user via \"nd=\"\n"
"                       using \"+\" instead of \",\"  If \"nd=all\" or you set\n"
"                       X11VNC_SKIP_DISPLAY=all then all display finding fails\n"
"                       as if you set X11VNC_FINDDISPLAY_ALWAYS_FAILS=1 (below.)\n"
"\n"
"                       Automatic Creation of User X Sessions:\n"
"\n"
"                       An interesting option is WAIT:cmd=FINDCREATEDISPLAY\n"
"                       that is like FINDDISPLAY in that is uses the same method\n"
"                       to find an existing display.  However, if it does not\n"
"                       find one it will try to *start* up an X server session\n"
"                       for the user.  This is the only time x11vnc tries to\n"
"                       actually start up an X server.\n"
"\n"
"                       The option \"-create\" is an alias for this mode.\n"
"\n"
"                       It will start looking for an open display number at :20\n"
"                       Override via X11VNC_CREATE_STARTING_DISPLAY_NUMBER=n\n"
"                       By default 80 X displays are allowed (i.e. going to :99)\n"
"                       Override via X11VNC_CREATE_MAX_DISPLAYS=n\n"
"\n"
"                       By default FINDCREATEDISPLAY will try Xvfb and then\n"
"                       Xdummy:\n"
"\n"
"                       The Xdummy wrapper is part of the x11vnc source code\n"
"                       (x11vnc/misc/Xdummy)  It should be available in PATH\n"
"                       and have run \"Xdummy -install\" once to create the\n"
"                       shared library.  Xdummy only works on Linux.  As of\n"
"                       12/2009 it no longer needs to be run as root, and the\n"
"                       default is to not run as root.  In some circumstances\n"
"                       permissions may require running it as root, in these\n"
"                       cases specify FD_XDUMMY_RUN_AS_ROOT=1, this is the same\n"
"                       as supplying -root to the Xdummy cmdline.\n"
"\n"
"                       Xvfb is available on most platforms and does not\n"
"                       require root.\n"
"\n"
"                       An advantage of Xdummy over Xvfb is that Xdummy supports\n"
"                       RANDR dynamic screen resizing.\n"
"\n"
"                       When x11vnc exits (i.e. user disconnects) the X\n"
"                       server session stays running in the background.\n"
"                       The FINDDISPLAY will find it directly next time.\n"
"                       The user must exit the X session in the usual way for\n"
"                       it to terminate (or kill the X server process if all\n"
"                       else fails).\n"
"\n"
"                       So this is a somewhat odd mode for x11vnc in that it\n"
"                       will start up and poll virtual X servers!  This can\n"
"                       be used from, say, inetd(8) to provide a means of\n"
"                       definitely getting a desktop (either real or virtual)\n"
"                       on the machine.  E.g. a desktop service:\n"
"\n"
"                         5900 stream tcp nowait root /usr/sbin/tcpd /.../x11vnc\n"
"                          -inetd -q -http -ssl SAVE -unixpw -users unixpw=\\\n"
"                          -passwd secret -prog /.../x11vnc \\\n"
"                          -display WAIT:cmd=FINDCREATEDISPLAY\n"
"\n"
"                       Where /.../x11vnc is the full path to x11vnc.\n"
"\n"
"                       See the -svc/-service option alias above.\n"
"\n"
"                       If for some reason you do not want x11vnc to ever\n"
"                       try to find an existing display set the env. var\n"
"                       X11VNC_FINDDISPLAY_ALWAYS_FAILS=1 (also -env ...)\n"
"                       This is the same as setting X11VNC_SKIP_DISPLAY=all or\n"
"                       supplying \"nd=all\" after \"username:\"\n"
"\n"
"                       Use WAIT:cmd=FINDCREATEDISPLAY-print to print out the\n"
"                       script that is used for this.\n"
"\n"
"                       You can specify the preferred X server order via e.g.,\n"
"                       WAIT:cmd=FINDCREATEDISPLAY-Xdummy,Xvfb,X  and/or leave\n"
"                       out ones you do not want.  The the case \"X\" means try\n"
"                       to start up a real, hardware X server using xinit(1)\n"
"                       or startx(1).  If there is already an X server running\n"
"                       the X case may only work on Linux (see startx(1)).\n"
"\n"
"                       \"Xvnc\" will start up a VNC X server (real-\n"
"                       or tight-vnc, e.g. use if Xvfb is not available).\n"
"                       \"Xsrv\" will start up the server program in the\n"
"                       variable \"FD_XSRV\" if it is non-empty. You can make\n"
"                       this be a wrapper script if you like (it must handle :N,\n"
"                       -geometry, and -depth and other X server options).\n"
"\n"
"                       You can set the environment variable FD_GEOM (or\n"
"                       X11VNC_CREATE_GEOM) to WxH or WxHxD to set the width\n"
"                       and height and optionally the color depth of the\n"
"                       created display.  You can also set FD_SESS to be the\n"
"                       session (short name of the windowmanager: kde, gnome,\n"
"                       twm, failsafe, etc.). FD_OPTS contains extra options\n"
"                       to pass to the X server. You can also set FD_PROG to\n"
"                       be the full path to the session/windowmanager program.\n"
"\n"
"                       More FD tricks:  FD_CUPS=port or FD_CUPS=host:port\n"
"                       will set the cups printing environment.  Similarly for\n"
"                       FD_ESD=port or FD_ESD=host:port for esddsp sound\n"
"                       redirection.  Set FD_EXTRA to a command to be run a\n"
"                       few seconds after the X server starts up.  Set FD_TAG\n"
"                       to be a unique name for the session, it is set as an\n"
"                       X property, that makes FINDDISPLAY only find sessions\n"
"                       with that tag value.\n"
"\n"
"                       Set FD_XDMCP_IF to the network interface that the\n"
"                       display manager is running on; default is 'localhost'\n"
"                       but you may need to set it to '::1' on some IPv6 only\n"
"                       systems or misconfigured display managers.\n"
"\n"
"                       If you want the FINDCREATEDISPLAY session to contact an\n"
"                       XDMCP login manager (xdm/gdm/kdm) on the same machine,\n"
"                       then use \"Xvfb.xdmcp\" instead of \"Xvfb\", etc.\n"
"                       The user will have to supply his username and password\n"
"                       one more time (but he gets to select his desktop type\n"
"                       so that can be useful).  For this to work, you will\n"
"                       need to enable localhost XDMCP (udp port 177) for the\n"
"                       display manager.  This seems to be:\n"
"\n"
"                        for gdm in gdm.conf:   Enable=true in section [xdmcp]\n"
"                        for kdm in kdmrc:      Enable=true in section [Xdmcp]\n"
"                        for xdm in xdm-config: DisplayManager.requestPort: 177\n"
"\n"
"                       See the shorthand options above \"-svc\", \"-xdmsvc\"\n"
"                       and \"-sshxdmsvc\" that specify the above options for\n"
"                       some useful cases.\n"
"\n"
"                       If you set the env. var WAITBG=1 x11vnc will go into\n"
"                       the background once listening in wait mode.\n"
"\n"
"                       Another special mode is FINDCREATEDISPLAY-Xvnc.redirect,\n"
"                       (or FINDDISPLAY-Xvnc.redirect).  In this case it will\n"
"                       start up Xvnc as above if needed, but instead of\n"
"                       polling it in its normal way, it simply does a socket\n"
"                       redirection of the connected VNC viewer to the Xvnc.\n"
"\n"
"                       So in Xvnc.redirect x11vnc does no VNC but merely\n"
"                       transfers the data back and forth.  This should be\n"
"                       faster then x11vnc's polling method, but not as fast\n"
"                       as connecting directly to the Xvnc with the VNC Viewer.\n"
"                       The idea here is to take advantage of x11vnc's display\n"
"                       finding/creating scheme, SSL, and perhaps a few others.\n"
"                       Most of x11vnc's options do not apply in this mode.\n"
"\n"
"                       Xvnc.redirect should also work for the vnc.so X server\n"
"                       module for the h/w display however it will work only\n"
"                       for finding the display and the user must already be\n"
"                       logged into the X console.\n"
"\n"
"-vencrypt mode         The VeNCrypt extension to the VNC protocol allows\n"
"                       encrypted SSL/TLS connections.  If the -ssl mode is\n"
"                       enabled, then VeNCrypt is enabled as well BY DEFAULT\n"
"                       (they both use a SSL/TLS tunnel, only the protocol\n"
"                       handshake is a little different.)\n"
"\n"
"                       To control when and how VeNCrypt is used, specify the\n"
"                       mode string.  If mode is \"never\", then VeNCrypt is\n"
"                       not used.  If mode is \"support\" (the default) then\n"
"                       VeNCrypt is supported.  If mode is \"only\", then the\n"
"                       similar and older ANONTLS protocol is not simultaneously\n"
"                       supported.  x11vnc's normal SSL mode (vncs://) will be\n"
"                       supported under -ssl unless you set mode to \"force\".\n"
"\n"
"                       If mode is prefixed with \"nodh:\", then Diffie Hellman\n"
"                       anonymous key exchange is disabled.  If mode is prefixed\n"
"                       with \"nox509:\", then X509 key exchange is disabled.\n"
"\n"
"                       To disable all Anonymous Diffie-Hellman access\n"
"                       (susceptible to Man-In-The-Middle attack) you will need\n"
"                       to supply \"-vencrypt nodh:support -anontls never\"\n"
"                       or \"-vencrypt nodh:only\"\n"
"\n"
"                       If mode is prefixed with \"newdh:\", then new Diffie\n"
"                       Hellman parameters are generated for each connection\n"
"                       (this can be time consuming: 1-60 secs; see -dhparams\n"
"                       below for a faster way) rather than using the\n"
"                       fixed values in the program.  Using fixed, publicly\n"
"                       known values is not known to be a security problem.\n"
"                       This setting applies to ANONTLS as well.\n"
"\n"
"                       Long example: -vencrypt newdh:nox509:support\n"
"\n"
"                       Also, if mode is prefixed with \"plain:\", then\n"
"                       if -unixpw mode is active the VeNCrypt \"*Plain\"\n"
"                       username+passwd method is enabled for Unix logins.\n"
"                       Otherwise in -unixpw mode the normal login panel is\n"
"                       provided.\n"
"\n"
"                       You *MUST* supply the -ssl option for VeNCrypt to\n"
"                       be active.  The -vencrypt option only fine-tunes its\n"
"                       operation.\n"
"\n"
"-anontls mode          The ANONTLS extension to the VNC protocol allows\n"
"                       encrypted SSL/TLS connections.  If the -ssl mode is\n"
"                       enabled, then ANONTLS is enabled as well BY DEFAULT\n"
"                       (they both use a SSL/TLS tunnel, only the protocol\n"
"                       handshake is a little different.)\n"
"\n"
"                       ANONTLS is an older SSL/TLS mode introduced by vino.\n"
"\n"
"                       It is referred to as 'TLS' for its registered VNC\n"
"                       security-type name, but we use the more descriptive\n"
"                       'ANONTLS' here because it provides only Anonymous\n"
"                       Diffie-Hellman encrypted connections, and hence no\n"
"                       possibility for certificate authentication.\n"
"\n"
"                       To control when and how ANONTLS is used, specify the\n"
"                       mode string.  If mode is \"never\", then ANONTLS is not\n"
"                       used.  If mode is \"support\" (the default) then ANONTLS\n"
"                       is supported.  If mode is \"only\", then the similar\n"
"                       VeNCrypt protocol is not simultaneously supported.\n"
"                       x11vnc's normal SSL mode (vncs://) will be supported\n"
"                       under -ssl unless you set mode to \"force\".\n"
"\n"
"                       If mode is prefixed with \"newdh:\", then new Diffie\n"
"                       Hellman parameters are generated for each connection\n"
"                       (this can be time consuming: 1-60 secs; see -dhparams\n"
"                       below for a faster way) rather than using the\n"
"                       fixed values in the program.  Using fixed, publicly\n"
"                       known values is not known to be a security problem.\n"
"                       This setting applies to VeNCrypt as well.  See the\n"
"                       description of \"plain:\" under -vencrypt.\n"
"\n"
"                       Long example: -anontls newdh:plain:support\n"
"\n"
"                       You *MUST* supply the -ssl option for ANONTLS to\n"
"                       be active.  The -anontls option only fine-tunes its\n"
"                       operation.\n"
"\n"
"-sslonly               Same as: \"-vencrypt never -anontls never\"  i.e. it\n"
"                       disables the VeNCrypt and ANONTLS encryption methods\n"
"                       and only allows standard SSL tunneling.  You must also\n"
"                       supply the -ssl ... option (see below.)\n"
"\n"
"\n"
"-dhparams file         For some operations a set of Diffie Hellman parameters\n"
"                       (prime and generator) is needed.  If so, use the\n"
"                       parameters in \"file\". In particular, the VeNCrypt and\n"
"                       ANONTLS anonymous DH mode need them.  By default a\n"
"                       fixed set is used. If you do not want to do that you\n"
"                       can specify \"newdh:\" to the -vencrypt and -anontls\n"
"                       options to generate a new set each session.  If that\n"
"                       is too slow for you, use -dhparams file to a set you\n"
"                       created manually via \"openssl dhparam -out file 1024\"\n"
"\n"
"-nossl                 Disable the -ssl option (see below). Since -ssl is off\n"
"                       by default -nossl would only be used on the commandline\n"
"                       to unset any *earlier* -ssl option (or -svc...)\n"
"\n"
"-ssl [pem]             Use the openssl library (www.openssl.org) to provide a\n"
"                       built-in encrypted SSL/TLS tunnel between VNC viewers\n"
"                       and x11vnc.  This requires libssl support to be\n"
"                       compiled into x11vnc at build time.  If x11vnc is not\n"
"                       built with libssl support it will exit immediately when\n"
"                       -ssl is prescribed.  See the -stunnel option below for\n"
"                       an alternative.\n"
"\n"
"                       The VNC Viewer-side needs to support SSL/TLS as well.\n"
"                       See this URL and also the discussion below for\n"
"                       ideas on how to enable SSL support for the viewer:\n"
"                       http://www.karlrunge.com/x11vnc/faq.html#faq-ssl-tun\n"
"                       nel-viewers .  x11vnc provides an SSL enabled Java\n"
"                       viewer applet in the classes/ssl directory (-http or\n"
"                       -httpdir options.)  The SSVNC viewer package supports\n"
"                       SSL tunnels too.\n"
"\n"
"                       If the VNC Viewer supports VeNCrypt or ANONTLS (vino's\n"
"                       encryption mode) they are also supported by the -ssl\n"
"                       mode (see the -vencrypt and -anontls options for more\n"
"                       info; use -sslonly to disable both of them.)\n"
"\n"
"                       Use \"-ssl /path/to/mycert.pem\" to specify an SSL\n"
"                       certificate file in PEM format to use to identify and\n"
"                       provide a key for this server.  See openssl(1) for more\n"
"                       info about PEMs and the -sslGenCert and \"-ssl SAVE\"\n"
"                       options below for how to create them.\n"
"\n"
"                       The connecting VNC viewer SSL tunnel can (at its option)\n"
"                       authenticate this server if it has the public key part\n"
"                       of the certificate (or a common certificate authority,\n"
"                       CA, is a more sophisticated way to verify this server's\n"
"                       cert, see -sslGenCA below).  This authentication is\n"
"                       done to prevent Man-In-The-Middle attacks.  Otherwise,\n"
"                       if the VNC viewer simply accepts this server's key\n"
"                       WITHOUT verification, the traffic is protected from\n"
"                       passive sniffing on the network, but *NOT* from\n"
"                       Man-In-The-Middle attacks. There are hacker tools\n"
"                       like dsniff/webmitm and cain that implement SSL\n"
"                       Man-In-The-Middle attacks.\n"
"\n"
"                       If [pem] is empty or the string \"SAVE\" then the\n"
"                       openssl(1) command must be available to generate the\n"
"                       certificate the first time.  A self-signed certificate\n"
"                       is generated (see -sslGenCA and -sslGenCert for use\n"
"                       of a Certificate Authority.)  It will be saved to the\n"
"                       file ~/.vnc/certs/server.pem.  On subsequent calls if\n"
"                       that file already exists it will be used directly.\n"
"\n"
"                       Use \"SAVE_NOPROMPT\" to avoid being prompted to\n"
"                       protect the generated key with a passphrase.  However in\n"
"                       -inetd and -bg modes there will be no prompting for a\n"
"                       passphrase in either case.\n"
"\n"
"                       If [pem] is \"SAVE_PROMPT\" the server.pem certificate\n"
"                       will be created based on your answers to its prompts for\n"
"                       all info such as OrganizationalName, CommonName, etc.\n"
"\n"
"                       Use \"SAVE-<string>\" and \"SAVE_PROMPT-<string>\"\n"
"                       to refer to the file ~/.vnc/certs/server-<string>.pem\n"
"                       instead (it will be generated if it does not already\n"
"                       exist).  E.g. \"SAVE-charlie\" will store to the file\n"
"                       ~/.vnc/certs/server-charlie.pem\n"
"\n"
"                       Examples: x11vnc -ssl SAVE -display :0 ...\n"
"                                 x11vnc -ssl SAVE-someother -display :0 ...\n"
"\n"
"                       If [pem] is \"TMP\" and the openssl(1) utility\n"
"                       command exists in PATH, then a temporary, self-signed\n"
"                       certificate will be generated for this session.  If\n"
"                       openssl(1) cannot be used to generate a temporary\n"
"                       certificate x11vnc exits immediately.  The temporary\n"
"                       cert will be discarded when x11vnc exits.\n"
"\n"
"                       If successful in using openssl(1) to generate a\n"
"                       temporary certificate in \"SAVE\" or \"TMP\" creation\n"
"                       modes, the public part of it will be displayed to stderr\n"
"                       (e.g. one could copy it to the client-side to provide\n"
"                       authentication of the server to VNC viewers.)\n"
"\n"
"                       NOTE: In \"TMP\" mode, unless you safely copy the\n"
"                       public part of the temporary Cert to the viewer for\n"
"                       authenticate *every time* (unlikely...), then only\n"
"                       passive sniffing attacks are prevented and you are\n"
"                       still open to Man-In-The-Middle attacks.  This is\n"
"                       why the default \"SAVE\" mode is preferred (and more\n"
"                       sophisticated CA mode too).  Only with saved keys AND\n"
"                       the VNC viewer authenticating them (via the public\n"
"                       certificate), are Man-In-The-Middle attacks prevented.\n"
"\n"
"                       If [pem] is \"ANON\" then the Diffie-Hellman anonymous\n"
"                       key exchange method is used.  In this mode there\n"
"                       are *no* SSL certificates and so it is not possible\n"
"                       to authenticate either the VNC server or VNC client.\n"
"                       Thus only passive network sniffing attacks are avoided:\n"
"                       the \"ANON\" method is susceptible to Man-In-The-Middle\n"
"                       attacks.  \"ANON\" is not recommended; instead use\n"
"                       a SSL PEM you created or the default \"SAVE\" method.\n"
"\n"
"                       See -ssldir below to use a directory besides the\n"
"                       default ~/.vnc/certs\n"
"\n"
"                       If your x11vnc binary was not compiled with OpenSSL\n"
"                       library support, use of the -ssl option will induce an\n"
"                       immediate failure and exit.  For such binaries, consider\n"
"                       using the -stunnel option for SSL encrypted connections.\n"
"\n"
"                       Misc Info: In temporary cert creation mode \"TMP\", set\n"
"                       the env. var. X11VNC_SHOW_TMP_PEM=1 to have x11vnc print\n"
"                       out the entire certificate, including the PRIVATE KEY\n"
"                       part, to stderr.  There are better ways to get/save this\n"
"                       info.  See \"SAVE\" above and \"-sslGenCert\" below.\n"
"\n"
"-ssltimeout n          Set SSL read timeout to n seconds.  In some situations\n"
"                       (i.e. an iconified viewer in Windows) the viewer stops\n"
"                       talking and the connection is dropped after the default\n"
"                       timeout (25s for about the first minute, 43200s later).\n"
"                       Set to zero to poll forever.  Set to a negative value\n"
"                       to use the builtin setting.\n"
"\n"
"                       Note that this value does NOT apply to the *initial* ssl\n"
"                       init connection.  The default timeout for that is 20sec.\n"
"                       Use -env SSL_INIT_TIMEOUT=n to modify it.\n"
"\n"
"-sslnofail             Exit at the first SSL connection failure. Useful when\n"
"                       scripting SSL connections (e.g. x11vnc is started via\n"
"                       ssh) and you do not want x11vnc waiting around for more\n"
"                       connections, tying up ports, etc.\n"
"\n"
"-ssldir dir            Use \"dir\" as an alternate ssl certificate and key\n"
"                       management toplevel directory.  The default is\n"
"                       ~/.vnc/certs\n"
"\n"
"                       This directory is used to store server and other\n"
"                       certificates and keys and also other materials.  E.g. in\n"
"                       the simplest case, \"-ssl SAVE\" will store the x11vnc\n"
"                       server cert in dir/server.pem\n"
"\n"
"                       Use of alternate directories via -ssldir allows you to\n"
"                       manage multiple VNC Certificate Authority (CA) keys.\n"
"                       Another use is if ~/.vnc/cert is on an NFS share you\n"
"                       might want your certificates and keys to be on a local\n"
"                       filesystem to prevent network snooping (for example\n"
"                       -ssldir /var/lib/x11vnc-certs).\n"
"\n"
"                       -ssldir affects nearly all of the other -ssl* options,\n"
"                       e.g. -ssl SAVE, -sslGenCert, etc..\n"
"\n"
"-sslverify path        For either of the -ssl or -stunnel modes, use \"path\"\n"
"                       to provide certificates to authenticate incoming VNC\n"
"                       *Client* connections (normally only the server is\n"
"                       authenticated in SSL.)  This can be used as a method\n"
"                       to replace standard password authentication of clients.\n"
"\n"
"                       If \"path\" is a directory it contains the client (or CA)\n"
"                       certificates in separate files.  If path is a file,\n"
"                       it contains one or more certificates. See special tokens\n"
"                       below.  These correspond to the \"CApath = dir\" and\n"
"                       \"CAfile = file\" stunnel options.  See the stunnel(8)\n"
"                       manpage for details.\n"
"\n"
"                       Examples:\n"
"                              x11vnc -ssl -sslverify ~/my.crt\n"
"                              x11vnc -ssl -sslverify ~/my_pem_dir/\n"
"\n"
"                       Note that if path is a directory, it must contain\n"
"                       the certs in separate files named like <HASH>.0, where\n"
"                       the value of <HASH> is found by running the command\n"
"                       \"openssl x509 -hash -noout -in file.crt\". Evidently\n"
"                       one uses <HASH>.1 if there is a collision...\n"
"\n"
"                       The the key-management utility \"-sslCertInfo HASHON\"\n"
"                       and \"-sslCertInfo HASHOFF\" will create/delete these\n"
"                       hashes for you automatically (via symlink) in the HASH\n"
"                       subdirs it manages.  Then you can point -sslverify to\n"
"                       the HASH subdir.\n"
"\n"
"                       Special tokens: in -ssl mode, if \"path\" is not a file or\n"
"                       a directory, it is taken as a comma separated list of\n"
"                       tokens that are interpreted as follows:\n"
"\n"
"                       If a token is \"CA\" that means load the CA/cacert.pem\n"
"                       file from the ssl directory.  If a token is \"clients\"\n"
"                       then all the files clients/*.crt in the ssl directory\n"
"                       are loaded.  Otherwise the file clients/token.crt\n"
"                       is attempted to be loaded.  As a kludge, use a token\n"
"                       like ../server-foo to load a server cert if you find\n"
"                       that necessary.\n"
"\n"
"                       Use -ssldir to use a directory different from the\n"
"                       ~/.vnc/certs default.\n"
"\n"
"                       Note that if the \"CA\" cert is loaded you do not need\n"
"                       to load any of the certs that have been signed by it.\n"
"                       You will need to load any additional self-signed certs\n"
"                       however.\n"
"\n"
"                       Examples:\n"
"                              x11vnc -ssl -sslverify CA\n"
"                              x11vnc -ssl -sslverify self:fred,self:jim\n"
"                              x11vnc -ssl -sslverify CA,clients\n"
"\n"
"                       Usually \"-sslverify CA\" is the most effective.\n"
"                       See the -sslGenCA and -sslGenCert options below for\n"
"                       how to set up and manage the CA framework.\n"
"\n"
"\n"
"\n"
"                       NOTE: the following utilities, -sslGenCA, -sslGenCert,\n"
"                       -sslEncKey, -sslCertInfo, and -sslCRL are provided for\n"
"                       completeness, but for casual usage they are overkill.\n"
"\n"
"                       They provide VNC Certificate Authority (CA) key creation\n"
"                       and server / client key generation and signing.  So they\n"
"                       provide a basic Public Key management framework for\n"
"                       VNC-ing with x11vnc. (note that they require openssl(1)\n"
"                       be installed on the system)\n"
"\n"
"                       However, the simplest usage mode, \"-ssl TMP\" (where\n"
"                       x11vnc automatically generates its own, self-signed,\n"
"                       temporary key and the VNC viewers always accept it,\n"
"                       e.g. accepting via a dialog box) is probably safe enough\n"
"                       for most scenarios.  CA management is not needed.\n"
"\n"
"                       To protect against Man-In-The-Middle attacks the \"TMP\"\n"
"                       mode can be improved by using \"-ssl SAVE\" (same as\n"
"                       \"-ssl\", i.e. the default) to have x11vnc create a\n"
"                       longer term self-signed certificate, and then (safely)\n"
"                       copy the corresponding public key cert to the desired\n"
"                       client machines (care must be taken the private key part\n"
"                       is not stolen; you will be prompted for a passphrase).\n"
"\n"
"                       So keep in mind no CA key creation or management\n"
"                       (-sslGenCA and -sslGenCert) is needed for either of\n"
"                       the above two common usage modes.\n"
"\n"
"                       One might want to use -sslGenCA and -sslGenCert\n"
"                       if you had a large number of VNC client and server\n"
"                       workstations.  That way the administrator could generate\n"
"                       a single CA key with -sslGenCA and distribute its\n"
"                       certificate part to all of the workstations.\n"
"\n"
"                       Next, he could create signed VNC server keys\n"
"                       (-sslGenCert server ...) for each workstation or user\n"
"                       that then x11vnc would use to authenticate itself to\n"
"                       any VNC client that has the CA cert.\n"
"\n"
"                       Optionally, the admin could also make it so the\n"
"                       VNC clients themselves are authenticated to x11vnc\n"
"                       (-sslGenCert client ...)  For this -sslverify would be\n"
"                       pointed to the CA cert (and/or self-signed certs).\n"
"\n"
"                       x11vnc will be able to use all of these cert and\n"
"                       key files.  On the VNC client side, they will need to\n"
"                       be \"imported\" somehow.  Web browsers have \"Manage\n"
"                       Certificates\" actions as does the Java applet plugin\n"
"                       Control Panel.  stunnel can also use these files (see\n"
"                       the ss_vncviewer example script in the FAQ and SSVNC.)\n"
"\n"
"-sslCRL path           Set the Certificate Revocation Lists (CRL) to \"path\".\n"
"                       This setting applies for both -ssl and -stunnel modes.\n"
"\n"
"                       If path is a file, the file contains one or more CRLs\n"
"                       in PEM format.  If path is a directory, it contains\n"
"                       hash named files of CRLs in the usual OpenSSL manner.\n"
"                       See the OpenSSL and stunnel(8) documentation for\n"
"                       more info.\n"
"\n"
"                       This option only applies if -sslverify has been\n"
"                       supplied: it checks for revocation along the\n"
"                       certificate chain used to verify the VNC client.\n"
"                       The -sslCRL setting will be ignored when -sslverify is\n"
"                       not specified.\n"
"\n"
"                       Note that if a CRL's expiration date has passed, all\n"
"                       SSL connections will fail regardless of if they are\n"
"                       related to the subject of the CRL or not.\n"
"\n"
"                       Only rarely will one's x11vnc -ssl infrastructure be so\n"
"                       large that this option would be useful (since normally\n"
"                       maintaining the contents of the -sslverify file or\n"
"                       directory should be enough.)  However, when using\n"
"                       x11vnc with a Certificate Authority (see -sslGenCA)\n"
"                       to authenticate Clients via SSL/TLS, the -sslCRL option\n"
"                       can be useful to revoke users' certs whose private SSL\n"
"                       keys were lost or stolen (e.g. laptop.)  This way a new\n"
"                       CA cert+key does not need to be created and new signed\n"
"                       client keys generated and distributed to all users.\n"
"\n"
"                       To create a CRL file with revoked certificates the\n"
"                       commands 'openssl ca -revoke ...' and 'openssl ca\n"
"                       -gencrl ...' are useful.  (Run them in ~/.vnc/certs)\n"
"\n"
"-sslGenCA [dir]        Generate your own Certificate Authority private key,\n"
"                       certificate, and other files in directory [dir].\n"
"                       x11vnc then exits.\n"
"\n"
"                       If [dir] is not supplied, a -ssldir setting is used,\n"
"                       or otherwise ~/.vnc/certs is used.\n"
"\n"
"                       This command also creates directories where server and\n"
"                       client certs and keys will be stored.  The openssl(1)\n"
"                       program must be installed on the system and available\n"
"                       in PATH.\n"
"\n"
"                       After the CA files and directories are created the\n"
"                       x11vnc command exits; the VNC server is not run.\n"
"\n"
"                       You will be prompted for information to put into the CA\n"
"                       certificate.  The info does not have to be accurate just\n"
"                       as long as clients accept the cert for VNC connections.\n"
"                       You will also need to supply a passphrase of at least\n"
"                       4 characters for the CA private key.\n"
"\n"
"                       Once you have generated the CA you can distribute\n"
"                       its certificate part, [dir]/CA/cacert.pem, to other\n"
"                       workstations where VNC viewers will be run.  One will\n"
"                       need to \"import\" this certificate in the applications,\n"
"                       e.g. Web browser, Java applet plugin, stunnel, etc.\n"
"                       Next, you can create and sign keys using the CA with\n"
"                       the -sslGenCert option below.\n"
"\n"
"                       Examples:\n"
"                                x11vnc -sslGenCA\n"
"                                x11vnc -sslGenCA  ~/myCAdir\n"
"                                x11vnc -ssldir ~/myCAdir -sslGenCA\n"
"\n"
"                       (the last two lines are equivalent)\n"
"\n"
"-sslGenCert type name  Generate a VNC server or client certificate and private\n"
"                       key pair signed by the CA created previously with\n"
"                       -sslGenCA.  The openssl(1) program must be installed\n"
"                       on the system and available in PATH.\n"
"\n"
"                       After the Certificate is generated x11vnc exits; the\n"
"                       VNC server is not run.\n"
"\n"
"                       The type of key to be generated is the string \"type\".\n"
"                       It is either \"server\" (i.e. for use by x11vnc) or\n"
"                       \"client\" (for a VNC viewer).  Note that typically\n"
"                       only \"server\" is used: the VNC clients authenticate\n"
"                       themselves by a non-public-key method (e.g. VNC or\n"
"                       unix password).  \"type\" is required.\n"
"\n"
"                       An arbitrary default name you want to associate with\n"
"                       the key is supplied by the \"name\" string.  You can\n"
"                       change it at the various prompts when creating the key.\n"
"                       \"name\" is optional.\n"
"\n"
"                       If name is left blank for clients keys then \"nobody\"\n"
"                       is used.  If left blank for server keys, then the\n"
"                       primary server key: \"server.pem\" is created (this\n"
"                       is the saved one referenced by \"-ssl SAVE\" when the\n"
"                       server is started)\n"
"\n"
"                       If \"name\" begins with the string \"self:\" then\n"
"                       a self-signed certificate is created instead of one\n"
"                       signed by your CA key.\n"
"\n"
"                       If \"name\" begins with the string \"req:\" then only a\n"
"                       key (.key) and a certificate signing *request* (.req)\n"
"                       are generated.  You can then send the .req file to\n"
"                       an external CA (even a professional one, e.g. Thawte)\n"
"                       and then combine the .key and the received cert into\n"
"                       the .pem file with the same basename.\n"
"\n"
"                       The distinction between \"server\" and \"client\" is\n"
"                       simply the choice of output filenames and sub-directory.\n"
"                       This makes it so the -ssl SAVE-name option can easily\n"
"                       pick up the x11vnc PEM file this option generates.\n"
"                       And similarly makes it easy for the -sslverify option\n"
"                       to pick up your client certs.\n"
"\n"
"                       There is nothing special about the filename or directory\n"
"                       location of either the \"server\" and \"client\" certs.\n"
"                       You can rename the files or move them to wherever\n"
"                       you like.\n"
"\n"
"                       Precede this option with -ssldir [dir] to use a\n"
"                       directory other than the default ~/.vnc/certs You will\n"
"                       need to run -sslGenCA on that directory first before\n"
"                       doing any -sslGenCert key creation.\n"
"\n"
"                       Note you cannot recreate a cert with exactly the same\n"
"                       distiguished name (DN) as an existing one.  To do so,\n"
"                       you will need to edit the [dir]/CA/index.txt file to\n"
"                       delete the line.\n"
"\n"
"                       Similar to -sslGenCA, you will be prompted to fill\n"
"                       in some information that will be recorded in the\n"
"                       certificate when it is created.\n"
"\n"
"                       Tip: if you know the fully-qualified hostname other\n"
"                       people will be connecting to, you can use that as the\n"
"                       CommonName \"CN\" to avoid some applications (e.g. web\n"
"                       browsers and java plugin) complaining that it does not\n"
"                       match the hostname.\n"
"\n"
"                       You will also need to supply the CA private key\n"
"                       passphrase to unlock the private key created from\n"
"                       -sslGenCA.  This private key is used to sign the server\n"
"                       or client certificate.\n"
"\n"
"                       The \"server\" certs can be used by x11vnc directly by\n"
"                       pointing to them via the -ssl [pem] option.  The default\n"
"                       file will be ~/.vnc/certs/server.pem.  This one would\n"
"                       be used by simply typing -ssl SAVE.  The pem file\n"
"                       contains both the certificate and the private key.\n"
"                       server.crt file contains the cert only.\n"
"\n"
"                       The \"client\" cert + private key file will need\n"
"                       to be copied and imported into the VNC viewer\n"
"                       side applications (Web browser, Java plugin,\n"
"                       stunnel, etc.)  Once that is done you can delete the\n"
"                       \"client\" private key file on this machine since\n"
"                       it is only needed on the VNC viewer side.  The,\n"
"                       e.g. ~/.vnc/certs/clients/<name>.pem contains both\n"
"                       the cert and private key.  The <name>.crt contains the\n"
"                       certificate only.\n"
"\n"
"                       NOTE: It is very important to know one should\n"
"                       generate new keys with a passphrase.  Otherwise if an\n"
"                       untrusted user steals the key file he could use it to\n"
"                       masquerade as the x11vnc server (or VNC viewer client).\n"
"                       You will be prompted whether to encrypt the key with\n"
"                       a passphrase or not.  It is recommended that you do.\n"
"                       One inconvenience to a passphrase is that it must\n"
"                       be typed in EVERY time x11vnc or the client app is\n"
"                       started up.\n"
"\n"
"                       Examples:\n"
"\n"
"                               x11vnc -sslGenCert server\n"
"                               x11vnc -ssl SAVE -display :0 ...\n"
"\n"
"                       and then on viewer using ss_vncviewer stunnel wrapper\n"
"                       (see the FAQ):\n"

"                               ss_vncviewer -verify ./cacert.crt hostname:0\n"
"\n"
"                       (this assumes the cacert.crt cert from -sslGenCA\n"
"                       was safely copied to the VNC viewer machine where\n"
"                       ss_vncviewer is run)\n"
"\n"
"                       Example using a name:\n"
"\n"
"                               x11vnc -sslGenCert server charlie\n"
"                               x11vnc -ssl SAVE-charlie -display :0 ...\n"
"\n"
"                       Example for a client certificate (rarely used):\n"
"\n"
"                               x11vnc -sslGenCert client roger\n"
"                               scp ~/.vnc/certs/clients/roger.pem somehost:.\n"
"                               rm  ~/.vnc/certs/clients/roger.pem\n"
"\n"
"                       x11vnc is then started with the option -sslverify\n"
"                       ~/.vnc/certs/clients/roger.crt (or simply -sslverify\n"
"                       roger), and on the viewer user on somehost could do\n"
"                       for example:\n"
"\n"
"                               ss_vncviewer -mycert ./roger.pem hostname:0\n"
"\n"
"                       If you set the env. var REQ_ARGS='...' it will be\n"
"                       passed to openssl req(1).  A common use would be\n"
"                       REQ_ARGS='-days 1095' to bump up the expiration date\n"
"                       (3 years in this case).\n"
"\n"
"-sslEncKey pem         Utility to encrypt an existing PEM file with a\n"
"                       passphrase you supply when prompted.  For that key to be\n"
"                       used (e.g. by x11vnc) the passphrase must be supplied\n"
"                       each time.\n"
"\n"
"                       The \"SAVE\" notation described under -ssl applies as\n"
"                       well. (precede this option with -ssldir [dir] to refer\n"
"                       a directory besides the default ~/.vnc/certs)\n"
"\n"
"                       The openssl(1) program must be installed on the system\n"
"                       and available in PATH.  After the Key file is encrypted\n"
"                       the x11vnc command exits; the VNC server is not run.\n"
"\n"
"                       Examples:\n"
"                               x11vnc -sslEncKey /path/to/foo.pem\n"
"                               x11vnc -sslEncKey SAVE\n"
"                               x11vnc -sslEncKey SAVE-charlie\n"
"\n"
"-sslCertInfo pem       Prints out information about an existing PEM file.\n"
"                       In addition the public certificate is also printed.\n"
"                       The openssl(1) program must be in PATH. Basically the\n"
"                       command \"openssl x509 -text\" is run on the pem.\n"
"\n"
"                       After the info is printed the x11vnc command exits;\n"
"                       the VNC server is not run.\n"
"\n"
"                       The \"SAVE\" notation described under -ssl applies\n"
"                       as well.\n"
"\n"
"                       Using  \"LIST\" will give a list of all certs being\n"
"                       managed (in the ~/.vnc/certs dir, use -ssldir to refer\n"
"                       to another dir).  \"ALL\" will print out the info for\n"
"                       every managed key (this can be very long).  Giving a\n"
"                       client or server cert shortname will also try a lookup\n"
"                       (e.g. -sslCertInfo charlie).  Use \"LISTL\" or \"LL\"\n"
"                       for a long (ls -l style) listing.\n"
"\n"
"                       Using \"HASHON\" will create subdirs [dir]/HASH and\n"
"                       [dir]/HASH with OpenSSL hash filenames (e.g. 0d5fbbf1.0)\n"
"                       symlinks pointing up to the corresponding *.crt file.\n"
"                       ([dir] is ~/.vnc/certs or one given by -ssldir.)\n"
"                       This is a useful way for other OpenSSL applications\n"
"                       (e.g. stunnel) to access all of the certs without\n"
"                       having to concatenate them.  x11vnc will not use them\n"
"                       unless you specifically reference them.  \"HASHOFF\"\n"
"                       removes these HASH subdirs.\n"
"\n"
"                       The LIST, LISTL, LL, ALL, HASHON, HASHOFF words can\n"
"                       also be lowercase, e.g. \"list\".\n"
"\n"
"-sslDelCert pem        Prompts you to delete all .crt .pem .key .req files\n"
"                       associated with [pem].  x11vnc then exits. \"SAVE\"\n"
"                       and lookups as in -sslCertInfo apply as well.\n"
"\n"
"-sslScripts            Prints out both the 'genCA' and 'genCert' x11vnc\n"
"                       openssl wrapper scripts for you to examine, modify, etc.\n"
"                       The scripts are printed to stdout and then the x11vnc\n"
"                       program exits.\n"
"\n"
"\n"
"-stunnel [pem]         Use the stunnel(8) (stunnel.mirt.net) to provide an\n"
"                       encrypted SSL tunnel between viewers and x11vnc.\n"
"\n"
"                       This external tunnel method was implemented prior to the\n"
"                       integrated -ssl encryption described above.  It still\n"
"                       works well and avoids the requirement of linking with\n"
"                       the OpenSSL libraries.  This mode requires stunnel\n"
"                       to be installed on the system and available via PATH\n"
"                       (n.b. stunnel is often installed in sbin directories).\n"
"                       Version 4.x of stunnel is assumed (but see -stunnel3\n"
"                       below.)\n"
"\n"
"                       [pem] is optional, use \"-stunnel /path/to/stunnel.pem\"\n"
"                       to specify a PEM certificate file to pass to stunnel.\n"
"                       See the -ssl option for more info on certificate files.\n"
"\n"
"                       Whether or not your stunnel has its own certificate\n"
"                       depends on your stunnel configuration; stunnel often\n"
"                       generates one at install time.  See your stunnel\n"
"                       documentation for details.  In any event, if you want to\n"
"                       use this certificate you must supply the full path to it\n"
"                       as [pem].  Note: the file may only be readable by root.\n"
"\n"
"                       [pem] may also be the special strings \"TMP\", \"SAVE\",\n"
"                       and \"SAVE...\" as described in the -ssl option.\n"
"                       If [pem] is not supplied, \"SAVE\" is assumed.\n"
"\n"
"                       Note that the VeNCrypt, ANONTLS, and \"ANON\" modes\n"
"                       are not supported in -stunnel mode.\n"
"\n"
"                       stunnel is started up as a child process of x11vnc and\n"
"                       any SSL connections stunnel receives are decrypted and\n"
"                       sent to x11vnc over a local socket.  The strings\n"
"                       \"The SSL VNC desktop is ...\" and \"SSLPORT=...\"\n"
"                       are printed out at startup to indicate this.\n"
"\n"
"                       The -localhost option is enforced by default to avoid\n"
"                       people routing around the SSL channel.  Use -env\n"
"                       STUNNEL_DISABLE_LOCALHOST=1 to disable this security\n"
"                       requirement.\n"
"\n"
"                       Set -env STUNNEL_DEBUG=1 for more debugging printout.\n"
"\n"
"                       Set -env STUNNEL_PROG=xxx to the full path of stunnel\n"
"                       program you want to be used (e.g. /usr/bin/stunnel4).\n"
"\n"
"                       Set -env STUNNEL_LISTEN=xxx to the address of the\n"
"                       network interface to listen on (the default is to listen\n"
"                       on all interfaces), e.g. STUNNEL_LISTEN=192.168.1.100.\n"
"\n"
"                       A simple way to add IPv6 support is STUNNEL_LISTEN=::\n"
"\n"
"                       Your VNC viewer will also need to be able to connect\n"
"                       via SSL.  Unfortunately not too many do this.  See the\n"
"                       information about SSL viewers under the -ssl option.\n"
"                       The x11vnc project's SSVNC is an option.\n"
"\n"
"                       Also, in the x11vnc distribution, patched TightVNC\n"
"                       and UltraVNC Java applet jar files are provided in\n"
"                       the classes/ssl directory that do SSL connections.\n"
"                       Enable serving them with the -http, -http_ssl, or\n"
"                       -httpdir (see the option descriptions for more info.)\n"
"\n"
"                       Note that for the Java viewer applet usage the\n"
"                       \"?PORT=xxxx\" in the various URLs printed at startup\n"
"                       will need to be supplied to the web browser to connect\n"
"                       properly.\n"
"\n"
"                       Currently the automatic \"single port\" HTTPS mode of\n"
"                       -ssl is not fully supported in -stunnel mode.  However,\n"
"                       it can be emulated via:\n"
"\n"
"                         %% x11vnc -stunnel -http_ssl -http_oneport ...\n"
"\n"
"                       In general, it is also not too difficult to set up\n"
"                       an stunnel or other SSL tunnel on the viewer side.\n"
"                       A simple example on Unix using stunnel 3.x is:\n"
"\n"
"                         %% stunnel -c -d localhost:5901 -r remotehost:5900\n"
"                         %% vncviewer localhost:1\n"
"\n"
"                       For Windows, stunnel has been ported to it and there\n"
"                       are probably other such tools available.  See the FAQ\n"
"                       and SSVNC for more examples.\n"
"\n"
"-stunnel3  [pem]       Use version 3.x stunnel command line syntax instead of\n"
"                       version 4.x.  The -http/-httpdir Java applet serving\n"
"                       is currently not available in this mode.\n"
"\n"
"-enc cipher:keyfile    Use symmetric encryption with cipher \"cipher\"\n"
"                       and secret key data in \"keyfile\".  If keyfile is\n"
"                       pw=<string> then \"string\" is used as the key data.\n"
"\n"
"                       NOTE: It is recommended that you use SSL via the -ssl\n"
"                       option instead of this option because SSL is well\n"
"                       understood and takes great care to establish unique\n"
"                       session keys and is more compatible with other software.\n"
"                       Use this option if you do not want to deal with SSL\n"
"                       certificates for authentication and do not want to\n"
"                       use SSH but want some encryption for your VNC session.\n"
"                       Or if you must interface with a symmetric key tunnel\n"
"                       that you do not have control over.\n"
"\n"
"                       Note that this mode will NOT work with the UltraVNC DSM\n"
"                       plugins because they alter the RFB protocol in addition\n"
"                       to tunnelling with the symmetric cipher (an unfortunate\n"
"                       choice of implementation...)\n"
"\n"
"                       cipher can be one of:  arc4, aesv2, aes-cfb, blowfish,\n"
"                       aes256, or 3des.  See the OpenSSL documentation for\n"
"                       more info.  The keysize is 128 bits (except for aes256).\n"
"                       Here is one way to make a keyfile with that many bits:\n"
"\n"
"                            dd if=/dev/random of=./my.key bs=16 count=1\n"
"\n"
"                       you will need to securely share this key with the other\n"
"                       side of the VNC connection (See SSVNC for examples).\n"
"\n"
"                       Example:  -enc blowfish:./my.key\n"
"                       Example:  -enc blowfish:pw=swordfish\n"
"\n"
"                       By default 16 bytes of random salt followed by 16 bytes\n"
"                       of random initialization vector are sent at the very\n"
"                       beginning of the stream.  The other side must read these\n"
"                       and initialize their cipher with them.  These values\n"
"                       make the session key unique (without them the security\n"
"                       is minimal).  Similarly, the other side must send us\n"
"                       its random salt and IV with those same lengths.\n"
"\n"
"                       The salt and key data are combined to create a session\n"
"                       key using an md5 hash as described in EVP_BytesToKey(3).\n"
"\n"
"                       The exact call is: EVP_BytesToKey(Cipher, EVP_md5(),\n"
"                       salt, keydata, len, 1, keystr, NULL);  where salt is\n"
"                       the random data as described above, and keydata is the\n"
"                       shared secret key data.  keystr is the resulting session\n"
"                       key.  The cipher is then seeded with keystr and uses\n"
"                       the random initialization vector as its first block.\n"
"\n"
"                       To modify the amount of random salt and initialization\n"
"                       vector use cipher@n,m where n is the salt length and\n"
"                       m the initialization vector length.  E.g.\n"
"\n"
"                                 -enc aes-cfb@8,16:./my.key\n"
"\n"
"                       It is not a good idea to set either one to zero,\n"
"                       although you may be forced to if the other side of the\n"
"                       tunnel is not under your control.\n"
"\n"
"                       To skip the salt and EVP_BytesToKey MD5 entirely (no\n"
"                       hashing is done: the keydata is directly inserted into\n"
"                       the cipher) specify \"-1\" for the salt, e.g.\n"
"\n"
"                                 -enc blowfish@-1,16:./my.key\n"
"\n"
"                       The message digest can also be changed to something\n"
"                       besides the default MD5.  Use cipher@md+n,m where \"md\"\n"
"                       can be one of sha, sha1, md5, or ripe.  For example:\n"
"\n"
"                                 -enc arc4@sha+8,16:./my.key\n"
"\n"
"                       The SSVNC vnc viewer project supplies a symmetric\n"
"                       encryption tool named \"ultravnc_dsm_helper\" that can\n"
"                       be used on the viewer side.  For example:\n"
"\n"
"                       ssvncviewer exec='ultravnc_dsm_helper arc4 my.key 0 h:p'\n"
"\n"
"                       where h:p is the hostname and port of the x11vnc server.\n"
"                       ultravnc_dsm_helper may also be used standalone to\n"
"                       provide a symmetric encryption tunnel for any viewer\n"
"                       or server (VNC or otherwise.) The cipher (1st arg)\n"
"                       is basically the same syntax as we use above.\n"
"\n"
"                       Also see the 'Non-Ultra DSM' SSVNC option for the\n"
"                       'UltraVNC DSM Encryption Plugin' advanced option.\n"
"\n"
"                       For both ways of using the viewer, you can specify the\n"
"                       salt,ivec sizes (in GUI or, e.g. arc4@8,16).\n"
"\n"
"-https [port]          Use a special, separate HTTPS port (-ssl and\n"
"                       -stunnel modes only) for HTTPS Java viewer applet\n"
"                       downloading. I.e. not 5900 and not 5800 (the defaults.)\n"
"\n"
"                       BACKGROUND: In -ssl mode, it turns out you can use the\n"
"                       single VNC port (e.g. 5900) for both VNC and HTTPS\n"
"                       connections. (HTTPS is used to retrieve a SSL-aware\n"
"                       VncViewer.jar applet that is provided with x11vnc).\n"
"                       Since both use SSL the implementation was extended to\n"
"                       detect if HTTP traffic (i.e. GET) is taking place and\n"
"                       handle it accordingly.  The URL would be, e.g.:\n"
"\n"
"                       https://mymachine.org:5900/\n"
"\n"
"                       This is convenient for firewalls, etc, because only one\n"
"                       port needs to be allowed in.  However, this heuristic\n"
"                       adds a few seconds delay to each connection and can be\n"
"                       unreliable (especially if the user takes much time to\n"
"                       ponder the Certificate dialogs in his browser, Java VM,\n"
"                       or VNC Viewer applet.  That's right 3 separate \"Are\n"
"                       you sure you want to connect?\" dialogs!)\n"
"\n"
"                       END OF BACKGROUND.\n"
"\n"
"                       USAGE: So use the -https option to provide a separate,\n"
"                       more reliable HTTPS port that x11vnc will listen on.  If\n"
"                       [port] is not provided (or is 0), one is autoselected.\n"
"                       The URL to use is printed out at startup.\n"
"\n"
"                       The SSL Java applet directory is specified via the\n"
"                       -httpdir option.  If not supplied, -https will try\n"
"                       to guess the directory as though the -http option\n"
"                       was supplied.\n"
"\n"
"-httpsredir [port]     In -ssl mode with the Java applet retrieved via HTTPS,\n"
"                       when the HTML file containing applet parameters\n"
"                       ('index.vnc' or 'proxy.vnc') is sent do NOT set the\n"
"                       applet PORT parameter to the actual VNC port but set it\n"
"                       to \"port\" instead.  If \"port\" is not supplied, then\n"
"                       the port number is guessed from the Host: HTTP header.\n"
"\n"
"                       This is useful when an incoming TCP connection\n"
"                       redirection is performed by a router/gateway/firewall\n"
"                       from one port to an internal machine where x11vnc is\n"
"                       listening on a different port. The Java applet needs to\n"
"                       connect to the firewall/router port, not the VNC port\n"
"                       on the internal workstation. For example, one could\n"
"                       redir from mygateway.com:443 to workstation:5900.\n"
"\n"
"                       This spares the user from having to type in\n"
"                       https://mygateway.com/?PORT=443 into their web\n"
"                       browser. Note that port 443 is the default https port;\n"
"                       other ports must be explicitly indicated, for example:\n"
"                       https://mygateway.com:8000/?PORT=8000.  To avoid having\n"
"                       to include the PORT= in the browser URL, simply supply\n"
"                       \"-httpsredir\" to x11vnc.\n"
"\n"
"                       This option does not work in -stunnel mode.\n"
"\n"
"                       More tricks: set the env var X11VNC_EXTRA_HTTPS_PARAMS\n"
"                       to be extra URL parameters to use.  This way you do\n"
"                       not need to specify extra PARAMS in the index.vnc file.\n"
"                       E.g. x11vnc -env X11VNC_EXTRA_HTTPS_PARAMS='?GET=1' ...\n"
"\n"
"                       If you do not want to expose the non-SSL HTTP port to\n"
"                       the network (i.e. you just want the single VNC/HTTPS\n"
"                       port, e.g. 5900, open for connections) then specify the\n"
"                       option -env X11VNC_HTTP_LISTEN_LOCALHOST=1  This way\n"
"                       the connection to the LibVNCServer httpd server will\n"
"                       only be available on localhost (note that in -ssl mode,\n"
"                       HTTPS requests are redirected from SSL to the non-SSL\n"
"                       LibVNCServer HTTP server.)\n"
"\n"
"-http_oneport          For UN-encrypted connections mode (i.e. no -ssl,\n"
"                       -stunnel, or -enc options), allow the Java VNC Viewer\n"
"                       applet to be downloaded thru the VNC port via HTTP.\n"
"\n"
"                       That is to say, you can use a single port for Java\n"
"                       applet viewer connections by using a URL in your web\n"
"                       browser like this, for example:\n"
"\n"
"                       http://hostname:5900\n"
"\n"
"                       The regular, two-port mode, URL http://hostname:5800\n"
"                       will continue to work as well.\n"
"\n"
"                       As mentioned above, this mode will NOT work with\n"
"                       the -ssl, -stunnel, or -enc encryption options.\n"
"                       Note that is it equivalent to '-enc none' (i.e. it\n"
"                       uses the same detection mechanism as for HTTPS, but\n"
"                       with no encryption.)\n"
"\n"
"                       HTTPS single-port is on by default in -ssl encrypted\n"
"                       mode (and -enc too), so you only need -http_oneport\n"
"                       when doing non-SSL encrypted connections.\n"
"\n"
"                       This mode could also be useful for SSH tunnels since\n"
"                       it means only one port needs to be redirected.\n"
"\n"
"                       The -httpsredir option may also be useful for this\n"
"                       mode when using an SSH tunnel as well as for router\n"
"                       port redirections.\n"
"\n"
"                       Note that the -env X11VNC_HTTP_LISTEN_LOCALHOST=1\n"
"                       option described above under -httpsredir applies for\n"
"                       the LibVNCServer httpd server in all cases (ssl or not.)\n"
"\n"
"-ssh user@host:disp    Create a remote listening port on machine \"host\"\n"
"                       via a SSH tunnel using the -R rport:localhost:lport\n"
"                       method. lport will be the local x11vnc listening port,\n"
"                       so a connection to rport (5900+disp) on \"host\"\n"
"                       will reach x11vnc.  E.g. fred@snoopy.com:0\n"
"\n"
"                       This could be useful if a firewall/router prevents\n"
"                       incoming connections to the x11vnc machine, but\n"
"                       the ssh machine \"host\" can be reached by the VNC\n"
"                       viewer. \"user@\" is not needed unless the remote unix\n"
"                       username differs from the current one.\n"
"\n"
"                       By default the remote sshd is usually configured to\n"
"                       listen only on localhost for rport, so the viewer may\n"
"                       need to ssh -L redir to \"host\" as well (See SSVNC to\n"
"                       automate this).  The sshd setting GatewayPorts enables\n"
"                       listening on all interfaces for rport; viewers can\n"
"                       reach it more easily.\n"
"\n"
"                       \"disp\" is the VNC display for the remote SSH side,\n"
"                       e.g. 0 corresponds to port 5900, etc.  If disp is\n"
"                       greater than 200 the value is used as the port.  Use a\n"
"                       negative value to force a low port, e.g. host:-80 will\n"
"                       use port 80.\n"
"\n"
"                       If ssh-agent is not active, then the ssh password needs\n"
"                       to be entered in the terminal where x11vnc is running.\n"
"\n"
"                       By default the remote ssh will issue a 'sleep 300' to\n"
"                       wait for the incoming connection for 5 mins.  To modify\n"
"                       this use user@host:disp+secs.\n"
"\n"
"                       If the remote SSH server is on a non-standard port\n"
"                       (i.e. not 22) use user@host:port:disp+secs.\n"
"\n"
"                       Note that the ssh process MAY NOT be killed when\n"
"                       x11vnc exits.  It tries by looking at ps(1) output.\n"
"\n"
"-usepw                 If no other password method was supplied on the command\n"
"                       line, first look for ~/.vnc/passwd and if found use it\n"
"                       with -rfbauth; next, look for ~/.vnc/passwdfile and\n"
"                       use it with -passwdfile; otherwise, prompt the user\n"
"                       for a password to create ~/.vnc/passwd and use it with\n"
"                       the -rfbauth option.  If none of these succeed x11vnc\n"
"                       exits immediately.\n"
"\n"
"-storepasswd pass file Store password \"pass\" as the VNC password in the\n"
"                       file \"file\".  Once the password is stored the\n"
"                       program exits.  Use the password via \"-rfbauth file\"\n"
"\n"
"                       If called with no arguments, \"x11vnc -storepasswd\",\n"
"                       the user is prompted for a password and it is stored\n"
"                       in the file ~/.vnc/passwd.  Called with one argument,\n"
"                       that will be the file to store the prompted password in.\n"
"\n"
"-nopw                  Disable the big warning message when you use x11vnc\n"
"                       without some sort of password.\n"
"\n"
"-accept string         Run a command (possibly to prompt the user at the\n"
"                       X11 display) to decide whether an incoming client\n"
"                       should be allowed to connect or not.  \"string\" is\n"
"                       an external command run via system(3) or some special\n"
"                       cases described below.  Be sure to quote \"string\"\n"
"                       if it contains spaces, shell characters, etc.  If the\n"
"                       external command returns 0 the client is accepted,\n"
"                       otherwise the client is rejected.  See below for an\n"
"                       extension to accept a client view-only.\n"
"\n"
"                       If x11vnc is running as root (say from inetd(8) or from\n"
"                       display managers xdm(1), gdm(1), etc), think about the\n"
"                       security implications carefully before supplying this\n"
"                       option (likewise for the -gone option).\n"
"\n"
"                       Environment: The RFB_CLIENT_IP environment variable will\n"
"                       be set to the incoming client IP number and the port\n"
"                       in RFB_CLIENT_PORT (or -1 if unavailable).  Similarly,\n"
"                       RFB_SERVER_IP and RFB_SERVER_PORT (the x11vnc side\n"
"                       of the connection), are set to allow identification\n"
"                       of the tcp virtual circuit.  The x11vnc process\n"
"                       id will be in RFB_X11VNC_PID, a client id number in\n"
"                       RFB_CLIENT_ID, and the number of other connected clients\n"
"                       in RFB_CLIENT_COUNT.  RFB_MODE will be \"accept\".\n"
"                       RFB_STATE will be PROTOCOL_VERSION, SECURITY_TYPE,\n"
"                       AUTHENTICATION, INITIALISATION, NORMAL, or UNKNOWN\n"
"                       indicating up to which state the client has achieved.\n"
"                       RFB_LOGIN_VIEWONLY will be 0, 1, or -1 (unknown).\n"
"                       RFB_USERNAME, RFB_LOGIN_TIME, and RFB_CURRENT_TIME may\n"
"                       also be set.\n"
"\n"
"                       If \"string\" is \"popup\" then a builtin popup window\n"
"                       is used.  The popup will time out after 120 seconds,\n"
"                       use \"popup:N\" to modify the timeout to N seconds\n"
"                       (use 0 for no timeout).\n"
"\n"
"                       In the case of \"popup\" and when the -unixpw option\n"
"                       is specified, then a *second* window will be popped\n"
"                       up after the user successfully logs in via his UNIX\n"
"                       password.  This time the user will be identified as\n"
"                       UNIX:username@hostname, the \"UNIX:\" prefix indicates\n"
"                       which user the viewer logged as via -unixpw.  The first\n"
"                       popup is only for whether to allow him to even *try*\n"
"                       to login via unix password.\n"
"\n"
"                       If \"string\" is \"xmessage\" then an xmessage(1)\n"
"                       invocation is used for the command.  xmessage must be\n"
"                       installed on the machine for this to work.\n"
"\n"
"                       Both \"popup\" and \"xmessage\" will present an option\n"
"                       for accepting the client \"View-Only\" (the client\n"
"                       can only watch).  This option will not be presented if\n"
"                       -viewonly has been specified, in which case the entire\n"
"                       display is view only.\n"
"\n"
"                       If the user supplied command is prefixed with something\n"
"                       like \"yes:0,no:*,view:3 mycommand ...\" then this\n"
"                       associates the numerical command return code with\n"
"                       the actions: accept, reject, and accept-view-only,\n"
"                       respectively.  Use \"*\" instead of a number to indicate\n"
"                       the default action (in case the command returns an\n"
"                       unexpected value).  E.g. \"no:*\" is a good choice.\n"
"\n"
"                       Note that x11vnc blocks while the external command\n"
"                       or popup is running (other clients may see no updates\n"
"                       during this period).  So a person sitting a the physical\n"
"                       display is needed to respond to an popup prompt. (use\n"
"                       a 2nd x11vnc if you lock yourself out).\n"
"\n"
"                       More -accept tricks: use \"popupmouse\" to only allow\n"
"                       mouse clicks in the builtin popup to be recognized.\n"
"                       Similarly use \"popupkey\" to only recognize\n"
"                       keystroke responses.  These are to help avoid the\n"
"                       user accidentally accepting a client by typing or\n"
"                       clicking. All 3 of the popup keywords can be followed\n"
"                       by +N+M to supply a position for the popup window.\n"
"                       The default is to center the popup window.\n"
"-afteraccept string    As -accept, except to run a user supplied command after\n"
"                       a client has been accepted and authenticated. RFB_MODE\n"
"                       will be set to \"afteraccept\" and the other RFB_*\n"
"                       variables are as in -accept.  Unlike -accept, the\n"
"                       command return code is not interpreted by x11vnc.\n"
"                       Example: -afteraccept 'killall xlock &'\n"
"-gone string           As -accept, except to run a user supplied command when\n"
"                       a client goes away (disconnects).  RFB_MODE will be\n"
"                       set to \"gone\" and the other RFB_* variables are as\n"
"                       in -accept.  The \"popup\" actions apply as well.\n"
"                       Unlike -accept, the command return code is not\n"
"                       interpreted by x11vnc.  Example: -gone 'xlock &'\n"
"\n"
"-users list            If x11vnc is started as root (say from inetd(8) or from\n"
"                       display managers xdm(1), gdm(1), etc), then as soon\n"
"                       as possible after connections to the X display are\n"
"                       established try to switch to one of the users in the\n"
"                       comma separated \"list\".  If x11vnc is not running as\n"
"                       root this option is ignored.\n"
"\n"
"                       Why use this option?  In general it is not needed since\n"
"                       x11vnc is already connected to the X display and can\n"
"                       perform its primary functions.  The option was added\n"
"                       to make some of the *external* utility commands x11vnc\n"
"                       occasionally runs work properly.  In particular under\n"
"                       GNOME and KDE to implement the \"-solid color\" feature\n"
"                       external commands (gconftool-2 and dcop) unfortunately\n"
"                       must be run as the user owning the desktop session.\n"
"                       Since this option switches userid it also affects the\n"
"                       userid used to run the processes for the -accept and\n"
"                       -gone options.  It also affects the ability to read\n"
"                       files for options such as -connect, -allow, and -remap\n"
"                       and also the ultra and tight filetransfer feature if\n"
"                       enabled.  Note that the -connect file is also sometimes\n"
"                       written to.\n"
"\n"
"                       So be careful with this option since in some situations\n"
"                       its use can decrease security.\n"
"\n"
"                       In general the switch to a user will only take place\n"
"                       if the display can still be successfully opened as that\n"
"                       user (this is primarily to try to guess the actual owner\n"
"                       of the session). Example: \"-users fred,wilma,betty\".\n"
"                       Note that a malicious local user \"barney\" by\n"
"                       quickly using \"xhost +\" when logging in may possibly\n"
"                       get the x11vnc process to switch to user \"fred\".\n"
"                       What happens next?\n"
"\n"
"                       Under display managers it may be a long time before\n"
"                       the switch succeeds (i.e. a user logs in).  To instead\n"
"                       make it switch immediately regardless if the display\n"
"                       can be reopened prefix the username with the \"+\"\n"
"                       character. E.g. \"-users +bob\" or \"-users +nobody\".\n"
"\n"
"                       The latter (i.e. switching immediately to user\n"
"                       \"nobody\") is the only obvious use of the -users option\n"
"                       that increases security.\n"
"\n"
"                       Use the following notation to associate a group with\n"
"                       a user: user1.group1,user2.group2,...  Note that\n"
"                       initgroups(2) will still be called first to try to\n"
"                       switch to ALL of a user's groups (primary and additional\n"
"                       groups).  Only if that fails or it is not available\n"
"                       then the single group specified as above (or the user's\n"
"                       primary group if not specified) is switched to with\n"
"                       setgid(2).  Use -env X11VNC_SINGLE_GROUP=1 to prevent\n"
"                       trying initgroups(2) and only switch to the single\n"
"                       group.  This sort of setting is only really needed to\n"
"                       make the ultra or tight filetransfer permissions work\n"
"                       properly. This format applies to any comma separated list\n"
"                       of users, even the special \"=\" modes described below.\n"
"\n"
"                       In -unixpw mode, if \"-users unixpw=\" is supplied\n"
"                       then after a user authenticates himself via the\n"
"                       -unixpw mechanism, x11vnc will try to switch to that\n"
"                       user as though \"-users +username\" had been supplied.\n"
"                       If you want to limit which users this will be done for,\n"
"                       provide them as a comma separated list after \"unixpw=\"\n"
"                       Groups can also be specified as described above.\n"
"\n"
"                       Similarly, in -ssl mode, if \"-users sslpeer=\" is\n"
"                       supplied then after an SSL client authenticates with his\n"
"                       cert (the -sslverify option is required for this) x11vnc\n"
"                       will extract a UNIX username from the \"emailAddress\"\n"
"                       field (username@hostname.com) of the \"Subject\" of the\n"
"                       x509 SSL cert and then try to switch to that user as\n"
"                       though \"-users +username\" had been supplied.  If you\n"
"                       want to limit which users this will be done for, provide\n"
"                       them as a comma separated list after \"sslpeer=\".\n"
"                       Set the env. var X11VNC_SSLPEER_CN to use the Common\n"
"                       Name (normally a hostname) instead of the Email field.\n"
"\n"
"                       NOTE: for sslpeer= mode the x11vnc administrator must\n"
"                       take care that any client certs he adds to -sslverify\n"
"                       have the intended UNIX username in the \"emailAddress\"\n"
"                       field of the cert.  Otherwise a user may be able to\n"
"                       log in as another.  This command can be of use in\n"
"                       checking: \"openssl x509 -text -in file.crt\", see the\n"
"                       \"Subject:\" line.  Also, along with the normal RFB_*\n"
"                       env. vars. (see -accept) passed to external cmd=\n"
"                       commands, RFB_SSL_CLIENT_CERT will be set to the\n"
"                       client's x509 certificate string.\n"
"\n"
"                       The sslpeer= mode can aid finding X sessions via the\n"
"                       FINDDISPLAY and FINDCREATEDISPLAY mechanisms.\n"
"\n"
"                       To immediately switch to a user *before* connections\n"
"                       to the X display are made or any files opened use the\n"
"                       \"=\" character: \"-users =bob\".  That user needs to\n"
"                       be able to open the X display and any files of course.\n"
"\n"
"                       The special user \"guess=\" means to examine the utmpx\n"
"                       database (see who(1)) looking for a user attached to\n"
"                       the display number (from DISPLAY or -display option)\n"
"                       and try him/her.  To limit the list of guesses, use:\n"
"                       \"-users guess=bob,betty\".\n"
"\n"
"                       Even more sinister is the special user \"lurk=\"\n"
"                       that means to try to guess the DISPLAY from the utmpx\n"
"                       login database as well.  So it \"lurks\" waiting for\n"
"                       anyone to log into an X session and then connects to it.\n"
"                       Specify a list of users after the = to limit which users\n"
"                       will be tried.  To enable a different searching mode, if\n"
"                       the first user in the list is something like \":0\" or\n"
"                       \":0-2\" that indicates a range of DISPLAY numbers that\n"
"                       will be tried (regardless of whether they are in the\n"
"                       utmpx database) for all users that are logged in.  Also\n"
"                       see the \"-display WAIT:...\" functionality.  Examples:\n"
"                       \"-users lurk=\" and also \"-users lurk=:0-1,bob,mary\"\n"
"\n"
"                       Be especially careful using the \"guess=\" and \"lurk=\"\n"
"                       modes.  They are not recommended for use on machines\n"
"                       with untrustworthy local users.\n"
"\n"
"-noshm                 Do not use the MIT-SHM extension for the polling.\n"
"                       Remote displays can be polled this way: be careful this\n"
"                       can use large amounts of network bandwidth.  This is\n"
"                       also of use if the local machine has a limited number\n"
"                       of shm segments and -onetile is not sufficient.\n"
"-flipbyteorder         Sometimes needed if remotely polled host has different\n"
"                       endianness.  Ignored unless -noshm is set.\n"
"-onetile               Do not use the new copy_tiles() framebuffer mechanism,\n"
"                       just use 1 shm tile for polling.  Limits shm segments\n"
"                       used to 3.\n"
"\n"
"                       To disable any automatic shm reduction set the\n"
"                       env. var. X11VNC_NO_LIMIT_SHM.\n"
"\n"
"-solid [color]         To improve performance, when VNC clients are connected\n"
"                       try to change the desktop background to a solid color.\n"
"                       The [color] is optional: the default color is \"cyan4\".\n"
"                       For a different one specify the X color (rgb.txt name,\n"
"                       e.g. \"darkblue\" or numerical \"#RRGGBB\").\n"
"\n"
"                       Currently this option only works on GNOME, KDE, CDE,\n"
"                       XFCE, and classic X (i.e. with the background image\n"
"                       on the root window).  The \"gconftool-2\", \"dcop\"\n"
"                       and \"xfconf-query\" external commands are run for\n"
"                       GNOME, KDE, and XFCE respectively.  This also works\n"
"                       on native MacOSX.  (There is no color selection for\n"
"                       MacOSX or XFCE.)  Other desktops won't work, (send\n"
"                       us the corresponding commands if you find them).\n"
"                       If x11vnc is running as root (inetd(8) or gdm(1)),\n"
"                       the -users option may be needed for GNOME, KDE, XFCE.\n"
"                       If x11vnc guesses your desktop incorrectly, you can\n"
"                       force it by prefixing color with \"gnome:\", \"kde:\",\n"
"                       \"cde:\", \"xfce:\", or \"root:\".\n"
"\n"
"                       Update: -solid no longer works on KDE4.\n"
"\n"
"                       This mode works in a limited way on the Mac OS X Console\n"
"                       with one color ('kelp') using the screensaver writing\n"
"                       to the background.  Look in \"~/Library/Screen Savers\"\n"
"                       for VncSolidColor.png to change the color.\n"
"\n"
"-blackout string       Black out rectangles on the screen. \"string\" is a\n"
"                       comma separated list of WxH+X+Y type geometries for\n"
"                       each rectangle.  If one of the items on the list is the\n"
"                       string \"noptr\" the mouse pointer will not be allowed\n"
"                       to go into a blacked out region.\n"
"-xinerama              If your screen is composed of multiple monitors\n"
"-noxinerama            glued together via XINERAMA, and that screen is\n"
"                       not a rectangle this option will try to guess the\n"
"                       areas to black out (if your system has libXinerama).\n"
"                       default: %s\n"
"\n"
"                       In general, we have noticed on XINERAMA displays you may\n"
"                       need to use the \"-xwarppointer\" option if the mouse\n"
"                       pointer misbehaves and it is enabled by default. Use\n"
"                       \"-noxwarppointer\" if you do not want this.\n"
"\n"
"-xtrap                 Use the DEC-XTRAP extension for keystroke and mouse\n"
"                       input insertion.  For use on legacy systems, e.g. X11R5,\n"
"                       running an incomplete or missing XTEST extension.\n"
"                       By default DEC-XTRAP will be used if XTEST server grab\n"
"                       control is missing, use -xtrap to do the keystroke and\n"
"                       mouse insertion via DEC-XTRAP as well.\n"
"\n"
"-xrandr [mode]         If the display supports the XRANDR (X Resize, Rotate\n"
"                       and Reflection) extension, and you expect XRANDR events\n"
"                       to occur to the display while x11vnc is running, this\n"
"                       options indicates x11vnc should try to respond to\n"
"                       them (as opposed to simply crashing by assuming the\n"
"                       old screen size).  See the xrandr(1) manpage and run\n"
"                       'xrandr -q' for more info.  [mode] is optional and\n"
"                       described below.\n"
"\n"
"                       Since watching for XRANDR events and trapping errors\n"
"                       increases polling overhead, only use this option if\n"
"                       XRANDR changes are expected.  For example on a rotatable\n"
"                       screen PDA or laptop, or using a XRANDR-aware Desktop\n"
"                       where you resize often.  It is best to be viewing with a\n"
"                       vncviewer that supports the NewFBSize encoding, since it\n"
"                       knows how to react to screen size changes.  Otherwise,\n"
"                       LibVNCServer tries to do so something reasonable for\n"
"                       viewers that cannot do this (portions of the screen\n"
"                       may be clipped, unused, etc).\n"
"\n"
"                       Note: the default now is to check for XRANDR events, but\n"
"                       do not trap every X call that may fail due to resize.\n"
"                       If a resize event is received, the full -xrandr mode\n"
"                       is enabled.  To disable even checking for events supply:\n"
"                       -noxrandr.\n"
"\n"
"                       \"mode\" defaults to \"resize\", which means create a\n"
"                       new, resized, framebuffer and hope all viewers can cope\n"
"                       with the change.  \"newfbsize\" means first disconnect\n"
"                       all viewers that do not support the NewFBSize VNC\n"
"                       encoding, and then resize the framebuffer.  \"exit\"\n"
"                       means disconnect all viewer clients, and then terminate\n"
"                       x11vnc.\n"
"\n"
"-rotate string         Rotate and/or flip the framebuffer view exported by VNC.\n"
"                       This transformation is independent of XRANDR and is\n"
"                       done in software in main memory and so may be slower.\n"
"                       This mode could be useful on a handheld with portrait or\n"
"                       landscape modes that do not correspond to the scanline\n"
"                       order of the actual framebuffer.  \"string\" can be:\n"
"\n"
"                             x     flip along x-axis\n"
"                             y     flip along y-axis\n"
"                            xy     flip along x- and y-axes\n"
"                           +90     rotate 90 degrees clockwise\n"
"                           -90     rotate 90 degrees counter-clockwise\n"
"                          +90x     rotate 90 degrees CW, then flip along x\n"
"                          +90y     rotate 90 degrees CW, then flip along y\n"
"\n"
"                       these give all possible rotations and reflections.\n"
"\n"
"                       Aliases: same as xy:  yx, +180, -180, 180\n"
"                                same as -90: +270, 270\n"
"                                same as +90: 90, (ditto for 90x, 90y)\n"
"\n"
"                       Like -scale, this transformation is applied at the very\n"
"                       end of any chain of framebuffer transformations and so\n"
"                       any options with geometries, e.g. -blackout, -clip, etc.\n"
"                       are relative to the original X (or -rawfb) framebuffer,\n"
"                       not the final one sent to VNC viewers.\n"
"\n"
"                       If you do not want the cursor shape to be rotated\n"
"                       prefix \"string\" with \"nc:\", e.g. \"nc:+90\",\n"
"                       \"nc:xy\", etc.\n"
"\n"
"-padgeom WxH           Whenever a new vncviewer connects, the framebuffer is\n"
"                       replaced with a fake, solid black one of geometry WxH.\n"
"                       Shortly afterwards the framebuffer is replaced with the\n"
"                       real one.  This is intended for use with vncviewers\n"
"                       that do not support NewFBSize and one wants to make\n"
"                       sure the initial viewer geometry will be big enough\n"
"                       to handle all subsequent resizes (e.g. under -xrandr,\n"
"                       -remote id:windowid, rescaling, etc.)\n"
"\n"
"                       In -unixpw mode this sets the size of the login screen.\n"
"                       Use \"once:WxH\" it ignore padgeom after the login\n"
"                       screen is set up.\n"
"\n"
"-o logfile             Write stderr messages to file \"logfile\" instead of to\n"
"                       the terminal.  Same as \"-logfile file\".  To append\n"
"                       to the file use \"-oa file\" or \"-logappend file\".\n"
"                       If \"logfile\" contains the string \"%%VNCDISPLAY\"\n"
"                       it is expanded to the vnc display (the name may need\n"
"                       to be guessed at.)  \"%%HOME\" works too.\n"
"\n"
"-flag file             Write the \"PORT=NNNN\" (e.g. PORT=5900) string to\n"
"                       \"file\" in addition to stdout.  This option could be\n"
"                       useful by wrapper script to detect when x11vnc is ready.\n"
"\n"
"-rmflag file           Remove \"file\" at exit to signal when x11vnc is done.\n"
"                       The file is created at startup if it does not already\n"
"                       exist or if \"file\" is prefixed with \"create:\".\n"
"                       If the file is created, the x11vnc PID is placed in\n"
"                       the file.  Otherwise the files contents is not changed.\n"
"                       Use prefix \"nocreate:\" to prevent creation.\n"
"\n"
"-rc filename           Use \"filename\" instead of $HOME/.x11vncrc for rc file.\n"
"-norc                  Do not process any .x11vncrc file for options.\n"
"\n"
"-env VAR=VALUE         Set the environment variable 'VAR' to value 'VALUE'\n"
"                       at x11vnc startup.  This is a convenience utility to\n"
"                       avoid shell script wrappers, etc. to set the env. var.\n"
"                       You may specify as many of these as needed on the\n"
"                       command line.\n"
"-prog /path/to/x11vnc  Set the full path to the x11vnc program for cases when\n"
"                       it cannot be determined from argv[0] (e.g. tcpd/inetd)\n"
"\n"
"-h, -help              Print this help text.\n"
"-?, -opts              Only list the x11vnc options.\n"
"-V, -version           Print program version and last modification date.\n"
"-license               Print out license information.  Same as -copying and\n"
"                       -warranty.\n"
"\n"
"-dbg                   Instead of exiting after cleaning up, run a simple\n"
"                       \"debug crash shell\" when fatal errors are trapped.\n"
"\n"
"-q, -quiet             Be quiet by printing less informational output to\n"
"                       stderr. (use -noquiet to undo an earlier -quiet.)\n"
"\n"
"                       The -quiet option does not eliminate all informational\n"
"                       output, it only reduces it.  It is ignored in most\n"
"                       auxiliary usage modes, e.g. -storepasswd.  To eliminate\n"
"                       all output use: 2>/dev/null 1>&2, etc.\n"
"\n"
"-v, -verbose           Print out more information to stderr.\n"
"\n"
"-bg                    Go into the background after screen setup.  Messages to\n"
"                       stderr are lost unless -o logfile is used.  Something\n"
"                       like this could be useful in a script:\n"
"                        port=`ssh -t $host \"x11vnc -display :0 -bg\" | grep PORT`\n"
"                        port=`echo \"$port\" | sed -e 's/PORT=//'`\n"
"                        port=`expr $port - 5900`\n"
"                        vncviewer $host:$port\n"
"\n"
"-modtweak              Option -modtweak automatically tries to adjust the AltGr\n"
"-nomodtweak            and Shift modifiers for differing language keyboards\n"
"                       between client and host.  Otherwise, only a single key\n"
"                       press/release of a Keycode is simulated (i.e. ignoring\n"
"                       the state of the modifiers: this usually works for\n"
"                       identical keyboards).  Also useful in resolving cases\n"
"                       where a Keysym is bound to multiple keys (e.g. \"<\" + \">\"\n"
"                       and \",\" + \"<\" keys).  Default: %s\n"
"\n"
"                       If you are having trouble with with keys and -xkb or\n"
"                       -noxkb, and similar things don't help, try -nomodtweak.\n"
"\n"
"                       On some HP-UX systems it is been noted that they have\n"
"                       an odd keymapping where a single keycode will have a\n"
"                       keysym, e.g. \"#\", up to three times.  You can check\n"
"                       via \"xmodmap -pk\" or the -dk option.  The failure\n"
"                       is when you try to type \"#\" it yields \"3\".  If you\n"
"                       see this problem try setting the environment variable\n"
"                       MODTWEAK_LOWEST=1 to see if it helps.\n"
"\n"
"-xkb                   When in modtweak mode, use the XKEYBOARD extension (if\n"
"-noxkb                 the X display supports it) to do the modifier tweaking.\n"
"                       This is powerful and should be tried if there are still\n"
"                       keymapping problems when using -modtweak by itself.\n"
"                       The default is to check whether some common keysyms,\n"
"                       e.g. !, @, [, are only accessible via -xkb mode and if\n"
"                       so then automatically enable the mode.  To disable this\n"
"                       automatic detection use -noxkb.\n"
"\n"
"                       When -xkb mode is active you can set these env. vars.\n"
"                       They apply only when there is ambiguity as to which\n"
"                       key to choose (i.e the mapping is not one-to-one).\n"
"                       NOKEYHINTS=1: for up ascii keystrokes do not use score\n"
"                       hints saved when the key was pressed down. NOANYDOWN=1:\n"
"                       for up keystrokes do not resort to searching through\n"
"                       keys that are currently pressed down.  KEYSDOWN=N:\n"
"                       remember the last N keys press down for tie-breaking\n"
"                       when an up keystroke comes in.\n"
"\n"
"-capslock              When in -modtweak (the default) or -xkb mode,\n"
"                       if a keysym in the range A-Z comes in check the X\n"
"                       server to see if the Caps_Lock is set.  If it is do\n"
"                       not artificially press Shift to generate the keysym.\n"
"                       This will enable the CapsLock key to behave correctly\n"
"                       in some circumstances: namely *both* the VNC viewer\n"
"                       machine and the x11vnc X server are in the CapsLock\n"
"                       on state.  If one side has CapsLock on and the other\n"
"                       off and the keyboard is not behaving as you think it\n"
"                       should you should correct the CapsLock states (hint:\n"
"                       pressing CapsLock inside and outside of the viewer can\n"
"                       help toggle them both to the correct state).  However,\n"
"                       for best results do not use this option, but rather\n"
"                       *only* enable CapsLock on the VNC viewer side (i.e. by\n"
"                       pressing CapsLock outside of the viewer window, also\n"
"                       -skip_lockkeys below).  Also try -nomodtweak for a\n"
"                       possible workaround.\n"
"\n"
"-skip_lockkeys         Have x11vnc ignore all Caps_Lock, Shift_Lock, Num_Lock,\n"
"-noskip_lockkeys       Scroll_Lock keysyms received from viewers.  The idea is\n"
"                       you press Caps_Lock on the VNC Viewer side but that does\n"
"                       not change the lock state in the x11vnc-side X server.\n"
"                       Nevertheless your capitalized letters come in over\n"
"                       the wire and are applied correctly to the x11vnc-side\n"
"                       X server.  Note this mode probably won't do what you\n"
"                       want in -nomodtweak mode.  Also, a kludge for KP_n\n"
"                       digits is always done in this mode: they are mapped to\n"
"                       regular digit keysyms.  See also -capslock above.\n"
"                       The default is -noskip_lockkeys.\n"
"\n"
"-skip_keycodes string  Ignore the comma separated list of decimal keycodes.\n"
"                       Perhaps these are keycodes not on your keyboard but\n"
"                       your X server thinks exist.  Currently only applies\n"
"                       to -xkb mode.  Use this option to help x11vnc in the\n"
"                       reverse problem it tries to solve: Keysym -> Keycode(s)\n"
"                       when ambiguities exist (more than one Keycode per\n"
"                       Keysym).  Run 'xmodmap -pk' to see your keymapping.\n"
"                       Example: \"-skip_keycodes 94,114\"\n"
"-sloppy_keys           Experimental option that tries to correct some\n"
"                       \"sloppy\" key behavior.  E.g. if at the viewer you\n"
"                       press Shift+Key but then release the Shift before\n"
"                       Key that could give rise to extra unwanted characters\n"
"                       (usually only between keyboards of different languages).\n"
"                       Only use this option if you observe problems with\n"
"                       some keystrokes.\n"
"-skip_dups             Some VNC viewers send impossible repeated key events,\n"
"-noskip_dups           e.g. key-down, key-down, key-up, key-up all for the same\n"
"                       key, or 20 downs in a row for the same modifier key!\n"
"                       Setting -skip_dups means to skip these duplicates and\n"
"                       just process the first event. Note: some VNC viewers\n"
"                       assume they can send down's without the corresponding\n"
"                       up's and so you should not set this option for\n"
"                       these viewers (symptom: some keys do not autorepeat)\n"
"                       Default: %s\n"
"-add_keysyms           If a Keysym is received from a VNC viewer and that\n"
"-noadd_keysyms         Keysym does not exist in the X server, then add the\n"
"                       Keysym to the X server's keyboard mapping on an unused\n"
"                       key.  Added Keysyms will be removed periodically and\n"
"                       also when x11vnc exits.  Default: %s\n"
"-clear_mods            At startup and exit clear the modifier keys by sending\n"
"                       KeyRelease for each one. The Lock modifiers are skipped.\n"
"                       Used to clear the state if the display was accidentally\n"
"                       left with any pressed down.\n"
"-clear_keys            As -clear_mods, except try to release ANY pressed key.\n"
"                       Note that this option and -clear_mods can interfere\n"
"                       with a person typing at the physical keyboard.\n"
"-clear_all             As -clear_keys, except try to release any CapsLock,\n"
"                       NumLock, etc. locks as well.\n"
"\n"
"-remap string          Read Keysym remappings from file named \"string\".\n"
"                       Format is one pair of Keysyms per line (can be name\n"
"                       or hex value) separated by a space.  If no file named\n"
"                       \"string\" exists, it is instead interpreted as this\n"
"                       form: key1-key2,key3-key4,...  See <X11/keysymdef.h>\n"
"                       header file for a list of Keysym names, or use xev(1).\n"
"\n"
"                       To map a key to a button click, use the fake Keysyms\n"
"                       \"Button1\", ..., etc. E.g: \"-remap Super_R-Button2\"\n"
"                       (useful for pasting on a laptop)\n"
"\n"
"                       I use these if the machine I am viewing from does not\n"
"                       have a scrollwheel or I don't like using the one it has:\n"
"\n"
"                              -remap Super_R-Button4,Menu-Button5\n"
"                              -remap KP_Add-Button4,KP_Enter-Button5\n"
"\n"
"                       the former would be used on a PC, the latter on a\n"
"                       MacBook.  This way those little used keys can be used\n"
"                       to generate bigger hops than the Up and Down arrows\n"
"                       provide.  One can scroll through text or web pages more\n"
"                       quickly this way (especially if x11vnc scroll detection\n"
"                       is active.)\n"
"\n"
"                       Use Button44, Button12, etc. for multiple clicks.\n"
"\n"
"                       To disable a keysym (i.e. make it so it will not be\n"
"                       injected), remap it to \"NoSymbol\" or \"None\".\n"
"\n"
"                       Dead keys: \"dead\" (or silent, mute) keys are keys that\n"
"                       do not produce a character but must be followed by a 2nd\n"
"                       keystroke.  This is often used for accenting characters,\n"
"                       e.g. to put \"`\" on top of \"a\" by pressing the dead\n"
"                       key and then \"a\".  Note that this interpretation\n"
"                       is not part of core X11, it is up to the toolkit or\n"
"                       application to decide how to react to the sequence.\n"
"                       The X11 names for these keysyms are \"dead_grave\",\n"
"                       \"dead_acute\", etc.  However some VNC viewers send the\n"
"                       keysyms \"grave\", \"acute\" instead thereby disabling\n"
"                       the accenting.  To work around this -remap can be used.\n"
"                       For example \"-remap grave-dead_grave,acute-dead_acute\"\n"
"                       As a convenience, \"-remap DEAD\" applies these remaps:\n"
"\n"
"                               g     grave-dead_grave\n"
"                               a     acute-dead_acute\n"
"                               c     asciicircum-dead_circumflex\n"
"                               t     asciitilde-dead_tilde\n"
"                               m     macron-dead_macron\n"
"                               b     breve-dead_breve\n"
"                               D     abovedot-dead_abovedot\n"
"                               d     diaeresis-dead_diaeresis\n"
"                               o     degree-dead_abovering\n"
"                               A     doubleacute-dead_doubleacute\n"
"                               r     caron-dead_caron\n"
"                               e     cedilla-dead_cedilla\n"
"\n"
"                       If you just want a subset use the first letter\n"
"                       label, e.g. \"-remap DEAD=ga\" to get the first two.\n"
"                       Additional remaps may also be supplied via commas,\n"
"                       e.g.  \"-remap DEAD=ga,Super_R-Button2\".  Finally,\n"
"                       \"DEAD=missing\" means to apply all of the above as\n"
"                       long as the left hand member is not already in the\n"
"                       X11 keymap.\n"
"\n"
"-norepeat              Option -norepeat disables X server key auto repeat when\n"
"-repeat                VNC clients are connected and VNC keyboard input is\n"
"                       not idle for more than 5 minutes.  This works around a\n"
"                       repeating keystrokes bug (triggered by long processing\n"
"                       delays between key down and key up client events:\n"
"                       either from large screen changes or high latency).\n"
"                       Default: %s\n"
"\n"
"                       You can set the env. var. X11VNC_IDLE_TIMEOUT to the\n"
"                       number of idle seconds you want (5min = 300secs).\n"
"\n"
"                       Note: your VNC viewer side will likely do autorepeating,\n"
"                       so this is no loss unless someone is simultaneously at\n"
"                       the real X display.\n"
"\n"
"                       Use \"-norepeat N\" to set how many times norepeat will\n"
"                       be reset if something else (e.g. X session manager)\n"
"                       undoes it.  The default is 2.  Use a negative value\n"
"                       for unlimited resets.\n"
"\n"
"-nofb                  Ignore video framebuffer: only process keyboard and\n"
"                       pointer.  Intended for use with Win2VNC and x2vnc\n"
"                       dual-monitor setups.\n"
"-nobell                Do not watch for XBell events. (no beeps will be heard)\n"
"                       Note: XBell monitoring requires the XKEYBOARD extension.\n"
"-nosel                 Do not manage exchange of X selection/cutbuffer between\n"
"                       VNC viewers and the X server at all.\n"
"-noprimary             Do not poll the PRIMARY selection for changes to send\n"
"                       back to clients.  (PRIMARY is still set on received\n"
"                       changes, however).\n"
"-nosetprimary          Do not set the PRIMARY selection for changes received\n"
"                       from VNC clients.\n"
"-noclipboard           Do not poll the CLIPBOARD selection for changes to send\n"
"                       back to clients.  (CLIPBOARD is still set on received\n"
"                       changes, however).\n"
"-nosetclipboard        Do not set the CLIPBOARD selection for changes\n"
"                       received from VNC clients.\n"
"-seldir string         If direction string is \"send\", only send the selection\n"
"                       to viewers, and if it is \"recv\" only receive it from\n"
"                       viewers.  To work around apps setting the selection\n"
"                       too frequently and messing up the other end.  You can\n"
"                       actually supply a comma separated list of directions,\n"
"                       including \"debug\" to turn on debugging output.\n"
"\n"
"-cursor [mode]         Sets how the pointer cursor shape (little icon at the\n"
"-nocursor              mouse pointer) should be handled.  The \"mode\" string\n"
"                       is optional and is described below.  The default\n"
"                       is to show some sort of cursor shape(s).  How this\n"
"                       is done depends on the VNC viewer and the X server.\n"
"                       Use -nocursor to disable cursor shapes completely.\n"
"\n"
"                       Some VNC viewers support the TightVNC CursorPosUpdates\n"
"                       and CursorShapeUpdates extensions (cuts down on\n"
"                       network traffic by not having to send the cursor image\n"
"                       every time the pointer is moved), in which case these\n"
"                       extensions are used (see -nocursorshape and -nocursorpos\n"
"                       below to disable).  For other viewers the cursor shape\n"
"                       is written directly to the framebuffer every time the\n"
"                       pointer is moved or changed and gets sent along with\n"
"                       the other framebuffer updates.  In this case, there\n"
"                       will be some lag between the vnc viewer pointer and\n"
"                       the remote cursor position.\n"
"\n"
"                       If the X display supports retrieving the cursor shape\n"
"                       information from the X server, then the default is\n"
"                       to use that mode.  On Solaris this can be done with\n"
"                       the SUN_OVL extension using -overlay (see also the\n"
"                       -overlay_nocursor option).  A similar overlay scheme\n"
"                       is used on IRIX.  Xorg (e.g. Linux) and recent Solaris\n"
"                       Xsun servers support the XFIXES extension to retrieve\n"
"                       the exact cursor shape from the X server.  If XFIXES\n"
"                       is present it is preferred over Overlay and is used by\n"
"                       default (see -noxfixes below).  This can be disabled\n"
"                       with -nocursor, and also some values of the \"mode\"\n"
"                       option below.\n"
"\n"
"                       Note that under XFIXES cursors with transparency (alpha\n"
"                       channel) will usually not be exactly represented and one\n"
"                       may find Overlay preferable.  See also the -alphacut\n"
"                       and -alphafrac options below as fudge factors to try\n"
"                       to improve the situation for cursors with transparency\n"
"                       for a given theme.\n"
"\n"
"                       The \"mode\" string can be used to fine-tune the\n"
"                       displaying of cursor shapes.  It can be used the\n"
"                       following ways:\n"
"\n"
"                       \"-cursor arrow\" - just show the standard arrow\n"
"                       nothing more or nothing less.\n"
"\n"
"                       \"-cursor none\" - same as \"-nocursor\"\n"
"\n"
"                       \"-cursor X\" - when the cursor appears to be on the\n"
"                       root window, draw the familiar X shape.  Some desktops\n"
"                       such as GNOME cover up the root window completely,\n"
"                       and so this will not work, try \"X1\", etc, to try to\n"
"                       shift the tree depth.  On high latency links or slow\n"
"                       machines there will be a time lag between expected and\n"
"                       the actual cursor shape.\n"
"\n"
"                       \"-cursor some\" - like \"X\" but use additional\n"
"                       heuristics to try to guess if the window should have\n"
"                       a windowmanager-like resizer cursor or a text input\n"
"                       I-beam cursor.  This is a complete hack, but may be\n"
"                       useful in some situations because it provides a little\n"
"                       more feedback about the cursor shape.\n"
"\n"
"                       \"-cursor most\" - try to show as many cursors as\n"
"                       possible.  Often this will only be the same as \"some\"\n"
"                       unless the display has overlay visuals or XFIXES\n"
"                       extensions available.  On Solaris and IRIX if XFIXES\n"
"                       is not available, -overlay mode will be attempted.\n"
"\n"
"-cursor_drag           Show cursor shape changes even when the mouse is being\n"
"                       dragged with a mouse button down.  This is useful if you\n"
"                       want to be able to see Drag-and-Drop cursor icons, etc.\n"
"\n"
"-arrow n               Choose an alternate \"arrow\" cursor from a set of\n"
"                       some common ones.  n can be 1 to %d.  Default is: %d\n"
"                       Ignored when in XFIXES cursor-grabbing mode.\n"
"\n"
"-noxfixes              Do not use the XFIXES extension to draw the exact cursor\n"
"                       shape even if it is available.\n"
"\n"
"                       Note: To work around a crash in Xorg 1.5 and later\n"
"                       some people needed to use -noxfixes.  The Xorg crash\n"
"                       occurred right after a Display Manager (e.g. GDM) login.\n"
"                       Starting with x11vnc 0.9.9 it tries to automatically\n"
"                       avoid using XFIXES until it is sure a window manager\n"
"                       is running.  See the -reopen option for more info and\n"
"                       how to use X11VNC_AVOID_WINDOWS=never to disable it.\n"
"\n"
"-alphacut n            When using the XFIXES extension for the cursor shape,\n"
"                       cursors with transparency will not usually be displayed\n"
"                       exactly (but opaque ones will).  This option sets n as\n"
"                       a cutoff for cursors that have transparency (\"alpha\n"
"                       channel\" with values ranging from 0 to 255) Any cursor\n"
"                       pixel with alpha value less than n becomes completely\n"
"                       transparent.  Otherwise the pixel is completely opaque.\n"
"                       Default %d\n"
"\n"
"-alphafrac fraction    With the threshold in -alphacut some cursors will become\n"
"                       almost completely transparent because their alpha values\n"
"                       are not high enough.  For those cursors adjust the\n"
"                       alpha threshold until fraction of the non-zero alpha\n"
"                       channel pixels become opaque.  Default %.2f\n"
"-alpharemove           By default, XFIXES cursors pixels with transparency have\n"
"                       the alpha factor multiplied into the RGB color values\n"
"                       (i.e. that corresponding to blending the cursor with a\n"
"                       black background).  Specify this option to remove the\n"
"                       alpha factor. (useful for light colored semi-transparent\n"
"                       cursors).\n"
"-noalphablend          In XFIXES mode do not send cursor alpha channel data\n"
"                       to LibVNCServer.  The default is to send it.  The\n"
"                       alphablend effect will only be visible in -nocursorshape\n"
"                       mode or for clients with cursorshapeupdates turned\n"
"                       off. (However there is a hack for 32bpp with depth 24,\n"
"                       it uses the extra 8 bits to store cursor transparency\n"
"                       for use with a hacked vncviewer that applies the\n"
"                       transparency locally.  See the FAQ for more info).\n"
"\n"
"-nocursorshape         Do not use the TightVNC CursorShapeUpdates extension\n"
"                       even if clients support it.  See -cursor above.\n"
"-cursorpos             Option -cursorpos enables sending the X cursor position\n"
"-nocursorpos           back to all vnc clients that support the TightVNC\n"
"                       CursorPosUpdates extension.  Other clients will be able\n"
"                       to see the pointer motions. Default: %s\n"
"-xwarppointer          Move the pointer with XWarpPointer(3X) instead of\n"
"-noxwarppointer        the XTEST extension.  Use this as a workaround\n"
"                       if the pointer motion behaves incorrectly, e.g.\n"
"                       on touchscreens or other non-standard setups.\n"
"\n"
"                       It is also sometimes needed on XINERAMA displays and is\n"
"                       enabled by default if XINERAMA is found to be active.\n"
"                       To prevent this, use -noxwarppointer.\n"
"\n"
"-always_inject         Even if there is no displacement (dx = dy = 0) for a\n"
"                       VNC mouse event force the pointer to the indicated x,y\n"
"                       position anyway.  Recent (2009) gui toolkits (gnome)\n"
"                       have problems with x11vnc's original mouse input\n"
"                       injection method.  So x11vnc's mouse input injection\n"
"                       method has been modified.  To regain the OLD behavior\n"
"                       use this option: -always_inject.  Then x11vnc will\n"
"                       always force positioning the mouse to the x,y position\n"
"                       even if that position has not changed since the previous\n"
"                       VNC input event.\n"
"\n"
"                       The first place this problem was noticed was in gnome\n"
"                       terminal: if you pressed and released mouse button 3, a\n"
"                       menu was posted and then its first element 'New Terminal\n"
"                       Window' was activated.  This was because x11vnc injected\n"
"                       the mouse position twice: once on ButtonPress and again\n"
"                       on ButtonRelease.  The toolkit interpreted the 2nd one\n"
"                       as mouse motion even though the mouse hadn't moved.\n"
"                       So now by default x11vnc tries to avoid injecting the\n"
"                       2nd one.\n"
"\n"
"                       Note that with the new default x11vnc will be oblivious\n"
"                       to applications moving the pointer (warping) or the\n"
"                       user at the physical display moving it.  So it might,\n"
"                       e.g., inject ButtonRelease at the wrong position.\n"
"                       If this (or similar scenarios) causes problems in your\n"
"                       environment, specify -always_inject for the old method.\n"
"\n"
"-buttonmap string      String to remap mouse buttons.  Format: IJK-LMN, this\n"
"                       maps buttons I -> L, etc., e.g.  -buttonmap 13-31\n"
"\n"
"                       Button presses can also be mapped to keystrokes: replace\n"
"                       a button digit on the right of the dash with :<sym>:\n"
"                       or :<sym1>+<sym2>: etc. for multiple keys. For example,\n"
"                       if the viewing machine has a mouse-wheel (buttons 4 5)\n"
"                       but the x11vnc side does not, these will do scrolls:\n"
"                              -buttonmap 12345-123:Prior::Next:\n"
"                              -buttonmap 12345-123:Up+Up+Up::Down+Down+Down:\n"
"\n"
"                       See <X11/keysymdef.h> header file for a list of Keysyms,\n"
"                       or use the xev(1) program.  Note: mapping of button\n"
"                       clicks to Keysyms may not work if -modtweak or -xkb is\n"
"                       needed for the Keysym.\n"
"\n"
"                       If you include a modifier like \"Shift_L\" the\n"
"                       modifier's up/down state is toggled, e.g. to send\n"
"                       \"The\" use :Shift_L+t+Shift_L+h+e: (the 1st one is\n"
"                       shift down and the 2nd one is shift up). (note: the\n"
"                       initial state of the modifier is ignored and not reset)\n"
"                       To include button events use \"Button1\", ... etc.\n"
"\n"
"                       -buttonmap currently does not work on MacOSX console\n"
"                       or in -rawfb mode.\n"
"\n"
"                       Workaround: use -buttonmap IJ...-LM...=n to limit the\n"
"                       number of mouse buttons to n, e.g. 123-123=3.  This will\n"
"                       prevent x11vnc from crashing if the X server reports\n"
"                       there are 5 buttons (4/5 scroll wheel), but there are\n"
"                       only really 3.\n"
"\n"
"-nodragging            Do not update the display during mouse dragging events\n"
"                       (mouse button held down).  Greatly improves response on\n"
"                       slow setups, but you lose all visual feedback for drags,\n"
"                       text selection, and some menu traversals.  It overrides\n"
"                       any -pointer_mode setting.\n"
"\n"
#ifndef NO_NCACHE
"-ncache n              Client-side caching scheme.  Framebuffer memory \"n\"\n"
"                       (an integer) times that of the full display is allocated\n"
"                       below the actual framebuffer to cache screen contents\n"
"                       for rapid retrieval.  So a W x H frambuffer is expanded\n"
"                       to a W x (n+1)*H one.  Use 0 to disable.\n"
"\n"
"                       The \"n\" is actually optional, the default is 10.\n"
"\n"
"                       For this and the other -ncache* options below you can\n"
"                       abbreviate \"-ncache\" with \"-nc\".  Also, \"-nonc\"\n"
"                       is the same as \"-ncache 0\"\n"
"\n"
"                       This is an experimental option, currently implemented in\n"
"                       an awkward way in that in the VNC Viewer you can see the\n"
"                       pixel cache contents if you scroll down, etc.  So you\n"
"                       will have to set things up so you can't see that region.\n"
"                       If this method is successful, the changes required for\n"
"                       clients to do this less awkwardly will be investigated.\n"
"\n"
"                       The SSVNC viewer does a good job at automatically hiding\n"
"                       the pixel cache region.  Or use SSVNC's -ycrop option\n"
"                       to explicitly hide the region.\n"
"\n"
"                       Note that this mode consumes a huge amount of memory,\n"
"                       both on the x11vnc server side and on the VNC Viewer\n"
"                       side.  If n=2 then the amount of RAM used is roughly\n"
"                       tripled for both x11vnc and the VNC Viewer.  As a rule\n"
"                       of thumb, note that 1280x1024 at depth 24 is about 5MB\n"
"                       of pixel data.\n"
"\n"
"                       For reasonable response when cycling through 4 to 6\n"
"                       large (e.g. web browser) windows a value n of 6 to 12\n"
"                       is recommended. (that's right: ~10X more memory...)\n"
"\n"
"                       Because of the way window backingstore and saveunders\n"
"                       are implemented, n must be even.  It will be incremented\n"
"                       by 1 if it is not.\n"
"\n"
"                       This mode also works for native MacOS X, but may not\n"
"                       be as effective as the X version.  This is due to a\n"
"                       number of things, one is the drop-shadow compositing\n"
"                       that leaves extra areas that need to be repaired (see\n"
"                       -ncache_pad).  Another is the window iconification\n"
"                       animations need to be avoided (see -macicontime).\n"
"                       It appears the that the 'Scale' animation mode gives\n"
"                       better results than the 'Genie' one.  Also, window event\n"
"                       detection not as accurate as the X version.\n"
"\n"
"-ncache_cr             In -ncache mode, try to do copyrect opaque window\n"
"                       moves/drags instead of wireframes (this can induce\n"
"                       painting errors).  The wireframe will still be used when\n"
"                       moving a window whose save-unders has not yet been set\n"
"                       or has been invalidated.\n"
"\n"
"                       Some VNC Viewers provide better response than others\n"
"                       with this option.  On Unix, realvnc viewer gives\n"
"                       smoother drags than tightvnc viewer.  Response may also\n"
"                       be choppy if the server side machine is too slow.\n"
"\n"
"                       Sometimes on very slow modem connections, this actually\n"
"                       gives an improvement because no pixel data at all\n"
"                       (not even the box animation) is sent during the drag.\n"
"\n"
"-ncache_no_moveraise   In -ncache mode, do not assume that moving a window\n"
"                       will cause the window manager to raise it to the top\n"
"                       of the stack.  The default is to assume it does, and\n"
"                       so at the beginning of any wireframe, etc, window moves\n"
"                       the window will be pushed to top in the VNC viewer.\n"
"\n"
"-ncache_no_dtchange    In -ncache mode, do not try to guess when the desktop\n"
"                       (viewport) changes to another one (i.e. another\n"
"                       workarea).  The default is to try to guess and when\n"
"                       detected try to make the transistion more smoothly.\n"
"\n"
"-ncache_no_rootpixmap  In -ncache mode, do not try to snapshot the desktop\n"
"                       background to use in guessing or reconstructing window\n"
"                       save-unders.\n"
"\n"
"-ncache_keep_anims     In -ncache mode, do not try to disable window\n"
"                       manager animations and other effects (that usually\n"
"                       degrade ncache performance or cause painting errors).\n"
"                       The default is to try to disable them on KDE (but not\n"
"                       GNOME) when VNC clients are connected.\n"
"\n"
"                       For other window managers or desktops that provide\n"
"                       animations, effects, compositing, translucency,\n"
"                       etc. that interfere with the -ncache method you will\n"
"                       have to disable them manually.\n"
"\n"
"-ncache_old_wm         In -ncache mode, enable some heuristics for old style\n"
"                       window managers such as fvwm and twm.\n"
"\n"
"-ncache_pad n          In -ncache mode, pad each window with n pixels for the\n"
"                       caching rectangles.  This can be used to try to improve\n"
"                       the situation with dropshadows or other compositing\n"
"                       (e.g. MacOS X window manager), although it could make\n"
"                       things worse.  The default is 0 on Unix and 24 on\n"
"                       MacOS X.\n"
"-debug_ncache          Turn on debugging and profiling output under -ncache.\n"
"\n"
#endif
"-wireframe [str]       Try to detect window moves or resizes when a mouse\n"
"-nowireframe           button is held down and show a wireframe instead of\n"
"                       the full opaque window.  This is based completely on\n"
"                       heuristics and may not always work: it depends on your\n"
"                       window manager and even how you move things around.\n"
"                       See -pointer_mode below for discussion of the \"bogging\n"
"                       down\" problem this tries to avoid.\n"
"                       Default: %s\n"
"\n"
"                       Shorter aliases:  -wf [str]  and -nowf\n"
"\n"
"                       The value \"str\" is optional and, of course, is\n"
"                       packed with many tunable parameters for this scheme:\n"
"\n"
"                       Format: shade,linewidth,percent,T+B+L+R,mod,t1+t2+t3+t4\n"
"                       Default: %s\n"
"\n"
"                       If you leave nothing between commas: \",,\" the default\n"
"                       value is used.  If you don't specify enough commas,\n"
"                       the trailing parameters are set to their defaults.\n"
"\n"
"                       \"shade\" indicate the \"color\" for the wireframe,\n"
"                       usually a greyscale: 0-255, however for 16 and 32bpp you\n"
"                       can specify an rgb.txt X color (e.g. \"dodgerblue\") or\n"
"                       a value > 255 is treated as RGB (e.g. red is 0xff0000).\n"
"                       \"linewidth\" sets the width of the wireframe in pixels.\n"
"                       \"percent\" indicates to not apply the wireframe scheme\n"
"                       to windows with area less than this percent of the\n"
"                       full screen.\n"
"\n"
"                       \"T+B+L+R\" indicates four integers for how close in\n"
"                       pixels the pointer has to be from the Top, Bottom, Left,\n"
"                       or Right edges of the window to consider wireframing.\n"
"                       This is a speedup to quickly exclude a window from being\n"
"                       wireframed: set them all to zero to not try the speedup\n"
"                       (scrolling and selecting text will likely be slower).\n"
"\n"
"                       \"mod\" specifies if a button down event in the\n"
"                       interior of the window with a modifier key (Alt, Shift,\n"
"                       etc.) down should indicate a wireframe opportunity.\n"
"                       It can be \"0\" or \"none\" to skip it, \"1\" or \"all\"\n"
"                       to apply it to any modifier, or \"Shift\", \"Alt\",\n"
"                       \"Control\", \"Meta\", \"Super\", or \"Hyper\" to only\n"
"                       apply for that type of modifier key.\n"
"\n"
"                       \"t1+t2+t3+t4\" specify four floating point times in\n"
"                       seconds: t1 is how long to wait for the pointer to move,\n"
"                       t2 is how long to wait for the window to start moving\n"
"                       or being resized (for some window managers this can be\n"
"                       rather long), t3 is how long to keep a wireframe moving\n"
"                       before repainting the window. t4 is the minimum time\n"
"                       between sending wireframe \"animations\".  If a slow\n"
"                       link is detected, these values may be automatically\n"
"                       changed to something better for a slow link.\n"
"\n"
"-nowireframelocal      By default, mouse motion and button presses of a\n"
"                       user sitting at the LOCAL display are monitored for\n"
"                       wireframing opportunities (so that the changes will be\n"
"                       sent efficiently to the VNC clients).  Use this option\n"
"                       to disable this behavior.\n"
"\n"
"-wirecopyrect mode     Since the -wireframe mechanism evidently tracks moving\n"
"-nowirecopyrect        windows accurately, a speedup can be obtained by\n"
"                       telling the VNC viewers to locally copy the translated\n"
"                       window region.  This is the VNC CopyRect encoding:\n"
"                       the framebuffer update doesn't need to send the actual\n"
"                       new image data.\n"
"\n"
"                       Shorter aliases:  -wcr [mode]  and -nowcr\n"
"\n"
"                       \"mode\" can be \"never\" (same as -nowirecopyrect)\n"
"                       to never try the copyrect, \"top\" means only do it if\n"
"                       the window was not covered by any other windows, and\n"
"                       \"always\" means to translate the orginally unobscured\n"
"                       region (this may look odd as the remaining pieces come\n"
"                       in, but helps on a slow link).  Default: \"%s\"\n"
"\n"
"                       Note: there can be painting errors or slow response\n"
"                       when using -scale so you may want to disable CopyRect\n"
"                       in this case \"-wirecopyrect never\" on the command\n"
"                       line or by remote-control.  Or you can also use the\n"
"                       \"-scale xxx:nocr\" scale option.\n"
"\n"
"-debug_wireframe       Turn on debugging info printout for the wireframe\n"
"                       heuristics.  \"-dwf\" is an alias.  Specify multiple\n"
"                       times for more output.\n"
"\n"
"-scrollcopyrect mode   Like -wirecopyrect, but use heuristics to try to guess\n"
"-noscrollcopyrect      if a window has scrolled its contents (either vertically\n"
"                       or horizontally).  This requires the RECORD X extension\n"
"                       to \"snoop\" on X applications (currently for certain\n"
"                       XCopyArea and XConfigureWindow X protocol requests).\n"
"                       Examples: Hitting <Return> in a terminal window when the\n"
"                       cursor was at the bottom, the text scrolls up one line.\n"
"                       Hitting <Down> arrow in a web browser window, the web\n"
"                       page scrolls up a small amount.  Or scrolling with a\n"
"                       scrollbar or mouse wheel.\n"
"\n"
"                       Shorter aliases:  -scr [mode]  and -noscr\n"
"\n"
"                       This scheme will not always detect scrolls, but when\n"
"                       it does there is a nice speedup from using the VNC\n"
"                       CopyRect encoding (see -wirecopyrect).  The speedup\n"
"                       is both in reduced network traffic and reduced X\n"
"                       framebuffer polling/copying.  On the other hand, it may\n"
"                       induce undesired transients (e.g. a terminal cursor\n"
"                       being scrolled up when it should not be) or other\n"
"                       painting errors (window tearing, bunching-up, etc).\n"
"                       These are automatically repaired in a short period\n"
"                       of time.  If this is unacceptable disable the feature\n"
"                       with -noscrollcopyrect.\n"
"\n"
"                       Screen clearing kludges:  for testing at least, there\n"
"                       are some \"magic key sequences\" (must be done in less\n"
"                       than 1 second) to aid repairing painting errors that\n"
"                       may be seen when using this mode:\n"
"\n"
"                       3 Alt_L's   in a row: resend whole screen,\n"
"                       4 Alt_L's   in a row: reread and resend whole screen,\n"
"                       3 Super_L's in a row: mark whole screen for polling,\n"
"                       4 Super_L's in a row: reset RECORD context,\n"
"                       5 Super_L's in a row: try to push a black screen\n"
"\n"
"                       note: Alt_L is the Left \"Alt\" key (a single key)\n"
"                       Super_L is the Left \"Super\" key (Windows flag).\n"
"                       Both of these are modifier keys, and so should not\n"
"                       generate characters when pressed by themselves.  Also,\n"
"                       your VNC viewer may have its own refresh hot-key\n"
"                       or button.\n"
"\n"
"                       \"mode\" can be \"never\" (same as -noscrollcopyrect)\n"
"                       to never try the copyrect, \"keys\" means to try it\n"
"                       in response to keystrokes only, \"mouse\" means to\n"
"                       try it in response to mouse events only, \"always\"\n"
"                       means to do both. Default: \"%s\"\n"
"\n"
"                       Note: there can be painting errors or slow response\n"
"                       when using -scale so you may want to disable CopyRect\n"
"                       in this case \"-scrollcopyrect never\" on the command\n"
"                       line or by remote-control.  Or you can also use the\n"
"                       \"-scale xxx:nocr\" scale option.\n"
"\n"
"-scr_area n            Set the minimum area in pixels for a rectangle\n"
"                       to be considered for the -scrollcopyrect detection\n"
"                       scheme.  This is to avoid wasting the effort on small\n"
"                       rectangles that would be quickly updated the normal way.\n"
"                       E.g. suppose an app updated the position of its skinny\n"
"                       scrollbar first and then shifted the large panel\n"
"                       it controlled.  We want to be sure to skip the small\n"
"                       scrollbar and get the large panel. Default: %d\n"
"\n"
"-scr_skip list         Skip scroll detection for applications matching\n"
"                       the comma separated list of strings in \"list\".\n"
"                       Some applications implement their scrolling in\n"
"                       strange ways where the XCopyArea, etc, also applies\n"
"                       to invisible portions of the window: if we CopyRect\n"
"                       those areas it looks awful during the scroll and\n"
"                       there may be painting errors left after the scroll.\n"
"                       Soffice.bin is the worst known offender.\n"
"\n"
"                       Use \"##\" to denote the start of the application class\n"
"                       (e.g. \"##XTerm\") and \"++\" to denote the start\n"
"                       of the application instance name (e.g. \"++xterm\").\n"
"                       The string your list is matched against is of the form\n"
"                       \"^^WM_NAME##Class++Instance<same-for-any-subwindows>\"\n"
"                       The \"xlsclients -la\" command will provide this info.\n"
"\n"
"                       If a pattern is prefixed with \"KEY:\" it only applies\n"
"                       to Keystroke generated scrolls (e.g. Up arrow).  If it\n"
"                       is prefixed with \"MOUSE:\" it only applies to Mouse\n"
"                       induced scrolls (e.g. dragging on a scrollbar).\n"
"                       Default: %s\n"
"\n"
"-scr_inc list          Opposite of -scr_skip: this list is consulted first\n"
"                       and if there is a match the window will be monitored\n"
"                       via RECORD for scrolls irrespective of -scr_skip.\n"
"                       Use -scr_skip '*' to skip anything that does not match\n"
"                       your -scr_inc.  Use -scr_inc '*' to include everything.\n"
"\n"
"-scr_keys list         For keystroke scroll detection, only apply the RECORD\n"
"                       heuristics to the comma separated list of keysyms in\n"
"                       \"list\".  You may find the RECORD overhead for every\n"
"                       one of your keystrokes disrupts typing too much, but you\n"
"                       don't want to turn it off completely with \"-scr mouse\"\n"
"                       and -scr_parms does not work or is too confusing.\n"
"\n"
"                       The listed keysyms can be numeric or the keysym\n"
"                       names in the <X11/keysymdef.h> header file or from the\n"
"                       xev(1) program.  Example: \"-scr_keys Up,Down,Return\".\n"
"                       One probably wants to have application specific lists\n"
"                       (e.g. for terminals, etc) but that is too icky to think\n"
"                       about for now...\n"
"\n"
"                       If \"list\" begins with the \"-\" character the list\n"
"                       is taken as an exclude list: all keysyms except those\n"
"                       list will be considered.  The special string \"builtin\"\n"
"                       expands to an internal list of keysyms that are likely\n"
"                       to cause scrolls.  BTW, by default modifier keys,\n"
"                       Shift_L, Control_R, etc, are skipped since they almost\n"
"                       never induce scrolling by themselves.\n"
"\n"
"-scr_term list         Yet another cosmetic kludge.  Apply shell/terminal\n"
"                       heuristics to applications matching comma separated\n"
"                       list (same as for -scr_skip/-scr_inc).  For example an\n"
"                       annoying transient under scroll detection is if you\n"
"                       hit Enter in a terminal shell with full text window,\n"
"                       the solid text cursor block will be scrolled up.\n"
"                       So for a short time there are two (or more) block\n"
"                       cursors on the screen.  There are similar scenarios,\n"
"                       (e.g. an output line is duplicated).\n"
"\n"
"                       These transients are induced by the approximation of\n"
"                       scroll detection (e.g. it detects the scroll, but not\n"
"                       the fact that the block cursor was cleared just before\n"
"                       the scroll).  In nearly all cases these transient errors\n"
"                       are repaired when the true X framebuffer is consulted\n"
"                       by the normal polling.  But they are distracting, so\n"
"                       what this option provides is extra \"padding\" near the\n"
"                       bottom of the terminal window: a few extra lines near\n"
"                       the bottom will not be scrolled, but rather updated\n"
"                       from the actual X framebuffer.  This usually reduces\n"
"                       the annoying artifacts.  Use \"none\" to disable.\n"
"                       Default: \"%s\"\n"
"\n"
"-scr_keyrepeat lo-hi   If a key is held down (or otherwise repeats rapidly) and\n"
"                       this induces a rapid sequence of scrolls (e.g. holding\n"
"                       down an Arrow key) the \"scrollcopyrect\" detection\n"
"                       and overhead may not be able to keep up.  A time per\n"
"                       single scroll estimate is performed and if that estimate\n"
"                       predicts a sustainable scrollrate of keys per second\n"
"                       between \"lo\" and \"hi\" then repeated keys will be\n"
"                       DISCARDED to maintain the scrollrate. For example your\n"
"                       key autorepeat may be 25 keys/sec, but for a large\n"
"                       window or slow link only 8 scrolls per second can be\n"
"                       sustained, then roughly 2 out of every 3 repeated keys\n"
"                       will be discarded during this period. Default: \"%s\"\n"
"\n"
"-scr_parms string      Set various parameters for the scrollcopyrect mode.\n"
"                       The format is similar to that for -wireframe and packed\n"
"                       with lots of parameters:\n"
"\n"
"                       Format: T+B+L+R,t1+t2+t3,s1+s2+s3+s4+s5\n"
"                       Default: %s\n"
"\n"
"                       If you leave nothing between commas: \",,\" the default\n"
"                       value is used.  If you don't specify enough commas,\n"
"                       the trailing parameters are set to their defaults.\n"
"\n"
"                       \"T+B+L+R\" indicates four integers for how close in\n"
"                       pixels the pointer has to be from the Top, Bottom, Left,\n"
"                       or Right edges of the window to consider scrollcopyrect.\n"
"                       If -wireframe overlaps it takes precedence.  This is a\n"
"                       speedup to quickly exclude a window from being watched\n"
"                       for scrollcopyrect: set them all to zero to not try\n"
"                       the speedup (things like selecting text will likely\n"
"                       be slower).\n"
"\n"
"                       \"t1+t2+t3\" specify three floating point times in\n"
"                       seconds that apply to scrollcopyrect detection with\n"
"                       *Keystroke* input: t1 is how long to wait after a key\n"
"                       is pressed for the first scroll, t2 is how long to keep\n"
"                       looking after a Keystroke scroll for more scrolls.\n"
"                       t3 is how frequently to try to update surrounding\n"
"                       scrollbars outside of the scrolling area (0.0 to\n"
"                       disable)\n"
"\n"
"                       \"s1+s2+s3+s4+s5\" specify five floating point times\n"
"                       in seconds that apply to scrollcopyrect detection with\n"
"                       *Mouse* input: s1 is how long to wait after a mouse\n"
"                       button is pressed for the first scroll, s2 is how long\n"
"                       to keep waiting for additional scrolls after the first\n"
"                       Mouse scroll was detected.  s3 is how frequently to\n"
"                       try to update surrounding scrollbars outside of the\n"
"                       scrolling area (0.0 to disable).  s4 is how long to\n"
"                       buffer pointer motion (to try to get fewer, bigger\n"
"                       mouse scrolls). s5 is the maximum time to spend just\n"
"                       updating the scroll window without updating the rest\n"
"                       of the screen.\n"
"\n"
"-fixscreen string      Periodically \"repair\" the screen based on settings\n"
"                       in \"string\".  Hopefully you won't need this option,\n"
"                       it is intended for cases when the -scrollcopyrect or\n"
"                       -wirecopyrect features leave too many painting errors,\n"
"                       but it can be used for any scenario.  This option\n"
"                       periodically performs costly operations and so\n"
"                       interactive response may be reduced when it is on.\n"
"                       You can use 3 Alt_L's (the Left \"Alt\" key) taps in\n"
"                       a row (as described under -scrollcopyrect) instead to\n"
"                       manually request a screen repaint when it is needed.\n"
"\n"
"                       \"string\" is a comma separated list of one or more of\n"
"                       the following: \"V=t\", \"C=t\", \"X=t\", and \"8=t\".\n"
"                       In these \"t\" stands for a time in seconds (it is\n"
"                       a floating point even though one should usually use\n"
"                       values > 2 to avoid wasting resources).  V sets how\n"
"                       frequently the entire screen should be sent to viewers\n"
"                       (it is like the 3 Alt_L's).  C sets how long to wait\n"
"                       after a CopyRect to repaint the full screen.  X sets\n"
"                       how frequently to reread the full X11 framebuffer from\n"
"                       the X server and push it out to connected viewers.\n"
"                       Use of X should be rare, please report a bug if you\n"
"                       find you need it. 8= applies only for -8to24 mode: it\n"
"                       sets how often the non-default visual regions of the\n"
"                       screen (e.g. 8bpp windows) are refreshed.  Examples:\n"
"                       -fixscreen V=10 -fixscreen C=10\n"
"\n"
"-debug_scroll          Turn on debugging info printout for the scroll\n"
"                       heuristics.  \"-ds\" is an alias.  Specify it multiple\n"
"                       times for more output.\n"
"\n"
"-noxrecord             Disable any use of the RECORD extension.  This is\n"
"                       currently used by the -scrollcopyrect scheme and to\n"
"                       monitor X server grabs.\n"
"\n"
"-grab_buster           Some of the use of the RECORD extension can leave a\n"
"-nograb_buster         tiny window for XGrabServer deadlock.  This is only if\n"
"                       the whole-server grabbing application expects mouse or\n"
"                       keyboard input before releasing the grab.  It is usually\n"
"                       a window manager that does this.  x11vnc takes care to\n"
"                       avoid the problem, but if caught x11vnc will freeze.\n"
"                       Without -grab_buster, the only solution is to go the\n"
"                       physical display and give it some input to satisfy the\n"
"                       grabbing app.  Or manually kill and restart the window\n"
"                       manager if that is feasible.  With -grab_buster, x11vnc\n"
"                       will fork a helper thread and if x11vnc appears to be\n"
"                       stuck in a grab after a period of time (20-30 sec) then\n"
"                       it will inject some user input: button clicks, Escape,\n"
"                       mouse motion, etc to try to break the grab.  If you\n"
"                       experience a lot of grab deadlock, please report a bug.\n"
"\n"
"-debug_grabs           Turn on debugging info printout with respect to\n"
"                       XGrabServer() deadlock for -scrollcopyrect mode.\n"
"\n"
"-debug_sel             Turn on debugging info printout with respect to\n"
"                       PRIMARY, CLIPBOARD, and CUTBUFFER0 selections.\n"
"\n"
"-pointer_mode n        Various pointer motion update schemes. \"-pm\" is\n"
"                       an alias.  The problem is pointer motion can cause\n"
"                       rapid changes on the screen: consider the rapid\n"
"                       changes when you drag a large window around opaquely.\n"
"                       Neither x11vnc's screen polling and vnc compression\n"
"                       routines nor the bandwidth to the vncviewers can keep\n"
"                       up these rapid screen changes: everything will bog down\n"
"                       when dragging or scrolling.  So a scheme has to be used\n"
"                       to \"eat\" much of that pointer input before re-polling\n"
"                       the screen and sending out framebuffer updates. The\n"
"                       mode number \"n\" can be 0 to %d and selects one of\n"
"                       the schemes desribed below.\n"
"\n"
"                       Note that the -wireframe and -scrollcopyrect modes\n"
"                       complement -pointer_mode by detecting (and improving)\n"
"                       certain periods of \"rapid screen change\".\n"
"\n"
"                       n=0: does the same as -nodragging. (all screen polling\n"
"                       is suspended if a mouse button is pressed.)\n"
"\n"
"                       n=1: was the original scheme used to about Jan 2004:\n"
"                       it basically just skips -input_skip keyboard or pointer\n"
"                       events before repolling the screen.\n"
"\n"
"                       n=2 is an improved scheme: by watching the current rate\n"
"                       of input events it tries to detect if it should try to\n"
"                       \"eat\" additional pointer events before continuing.\n"
"\n"
"                       n=3 is basically a dynamic -nodragging mode: it detects\n"
"                       when the mouse motion has paused and then refreshes\n"
"                       the display.\n"
"\n"
"                       n=4 attempts to measures network rates and latency,\n"
"                       the video card read rate, and how many tiles have been\n"
"                       changed on the screen.  From this, it aggressively tries\n"
"                       to push screen \"frames\" when it decides it has enough\n"
"                       resources to do so.  NOT FINISHED.\n"
"\n"
"                       The default n is %d. Note that modes 2, 3, 4 will skip\n"
"                       -input_skip keyboard events (but it will not count\n"
"                       pointer events).  Also note that these modes are not\n"
"                       available in -threads mode which has its own pointer\n"
"                       event handling mechanism.\n"
"\n"
"                       To try out the different pointer modes to see which\n"
"                       one gives the best response for your usage, it is\n"
"                       convenient to use the remote control function, for\n"
"                       example \"x11vnc -R pm:4\" or the tcl/tk gui (Tuning ->\n"
"                       pointer_mode -> n).\n"
"\n"
"-input_skip n          For the pointer handling when non-threaded: try to\n"
"                       read n user input events before scanning display. n < 0\n"
"                       means to act as though there is always user input.\n"
"                       Default: %d\n"
"\n"
"-allinput              Have x11vnc read and process all available client input\n"
"                       before proceeding.\n"
"\n"
"-input_eagerly         Similar to -allinput but use the handleEventsEagerly\n"
"                       mechanism built into LibVNCServer.\n"
"\n"
"-speeds rd,bw,lat      x11vnc tries to estimate some speed parameters that\n"
"                       are used to optimize scheduling (e.g. -pointer_mode\n"
"                       4, -wireframe, -scrollcopyrect) and other things.\n"
"                       Use the -speeds option to set these manually.\n"
"                       The triple \"rd,bw,lat\" corresponds to video h/w\n"
"                       read rate in MB/sec, network bandwidth to clients in\n"
"                       KB/sec, and network latency to clients in milliseconds,\n"
"                       respectively.  If a value is left blank, e.g. \"-speeds\n"
"                       ,100,15\", then the internal scheme is used to estimate\n"
"                       the empty value(s).\n"
"\n"
"                       Typical PC video cards have read rates of 5-10 MB/sec.\n"
"                       If the framebuffer is in main memory instead of video\n"
"                       h/w (e.g. SunRay, shadowfb, dummy driver, Xvfb), the\n"
"                       read rate may be much faster.  \"x11perf -getimage500\"\n"
"                       can be used to get a lower bound (remember to factor\n"
"                       in the bytes per pixel).  It is up to you to estimate\n"
"                       the network bandwith and latency to clients.  For the\n"
"                       latency the ping(1) command can be used.\n"
"\n"
"                       For convenience there are some aliases provided,\n"
"                       e.g. \"-speeds modem\".  The aliases are: \"modem\" for\n"
"                       6,4,200; \"dsl\" for 6,100,50; and \"lan\" for 6,5000,1\n"
"\n"
"-wmdt string           For some features, e.g. -wireframe and -scrollcopyrect,\n"
"                       x11vnc has to work around issues for certain window\n"
"                       managers or desktops (currently kde and xfce).\n"
"                       By default it tries to guess which one, but it can\n"
"                       guess incorrectly.  Use this option to indicate which\n"
"                       wm/dt.  \"string\" can be \"gnome\", \"kde\", \"cde\",\n"
"                       \"xfce\", or \"root\" (classic X wm).  Anything else\n"
"                       is interpreted as \"root\".\n"
"\n"
"-debug_pointer         Print debugging output for every pointer event.\n"
"-debug_keyboard        Print debugging output for every keyboard event.\n"
"                       Same as -dp and -dk, respectively.  Use multiple\n"
"                       times for more output.\n"
"\n"
"-defer time            Time in ms to delay sending updates to connected clients\n"
"                       (deferUpdateTime)  Default: %d\n"
"\n"
"-wait time             Time in ms to pause between screen polls.  Used to cut\n"
"                       down on load.  Default: %d\n"
"\n"
"-extra_fbur n          Perform extra FrameBufferUpdateRequests checks to\n"
"                       try to be in better sync with the client's requests.\n"
"                       What this does is perform extra polls of the client\n"
"                       socket at critical times (before '-defer' and '-wait'\n"
"                       calls.)  The default is n=1.  Set to a larger number to\n"
"                       insert more checks or set to n=0 to disable.  A downside\n"
"                       of these extra calls is that more mouse input may be\n"
"                       processed than desired.\n"
"\n"
"-wait_ui factor        Factor by which to cut the -wait time if there\n"
"                       has been recent user input (pointer or keyboard).\n"
"                       Improves response, but increases the load whenever you\n"
"                       are moving the mouse or typing.  Default: %.2f\n"
"-setdefer n            When the -wait_ui mechanism cuts down the wait time ms,\n"
"                       set the defer time to the same ms value. n=1 to enable,\n"
"                       0 to disable, and -1 to set defer to 0 (no delay).\n"
"                       Similarly, 2 and -2 indicate 'urgent_update' mode should\n"
"                       be used to push the updates even sooner.  Default: 1\n"
"-nowait_bog            Do not detect if the screen polling is \"bogging down\"\n"
"                       and sleep more.  Some activities with no user input can\n"
"                       slow things down a lot: consider a large terminal window\n"
"                       with a long build running in it continuously streaming\n"
"                       text output.  By default x11vnc will try to detect this\n"
"                       (3 screen polls in a row each longer than 0.25 sec with\n"
"                       no user input), and sleep up to 1.5 secs to let things\n"
"                       \"catch up\".  Use this option to disable that detection.\n"
"-slow_fb time          Floating point time in seconds to delay all screen\n"
"                       polling.  For special purpose usage where a low frame\n"
"                       rate is acceptable and desirable, but you want the\n"
"                       user input processed at the normal rate so you cannot\n"
"                       use -wait.\n"
"-xrefresh time         Floating point time in seconds to indicate how often to\n"
"                       do the equivalent of xrefresh(1) to force all windows\n"
"                       (in the viewable area if -id, -sid, or -clip is used)\n"
"                       to repaint themselves.  Use this only if applications\n"
"                       misbehave by not repainting themselves properly.\n"
"                       See also -noxdamage.\n"
"-nap                   Monitor activity and if it is low take longer naps\n"
"-nonap                 between screen polls to really cut down load when idle.\n"
"                       Default: %s\n"
"-sb time               Time in seconds after NO activity (e.g. screen blank)\n"
"                       to really throttle down the screen polls (i.e. sleep\n"
"                       for about 1.5 secs). Use 0 to disable.  Default: %d\n"
"\n"
"-readtimeout n         Set LibVNCServer rfbMaxClientWait to n seconds. On\n"
"                       slow links that take a long time to paint the first\n"
"                       screen LibVNCServer may hit the timeout and drop the\n"
"                       connection.  Default: %d seconds.\n"
"-ping n                Send a 1x1 framebuffer update to all clients every n\n"
"                       seconds (e.g. to try to keep a network connection alive)\n"
"\n"
"-nofbpm                If the system supports the FBPM (Frame Buffer Power\n"
"-fbpm                  Management) extension (i.e. some Sun systems), then\n"
"                       prevent the video h/w from going into a reduced power\n"
"                       state when VNC clients are connected.\n"
"\n"
"                       FBPM capable video h/w save energy when the workstation\n"
"                       is idle by going into low power states (similar to DPMS\n"
"                       for monitors).  This interferes with x11vnc's polling\n"
"                       of the framebuffer data.\n"
"\n"
"                       \"-nofbpm\" means prevent FBPM low power states whenever\n"
"                       VNC clients are connected, while \"-fbpm\" means to not\n"
"                       monitor the FBPM state at all.  See the xset(1) manpage\n"
"                       for details.  -nofbpm is basically the same as running\n"
"                       \"xset fbpm force on\" periodically.  Default: %s\n"
"\n"
"-nodpms                If the system supports the DPMS (Display Power Management\n"
"-dpms                  Signaling) extension, then prevent the monitor from\n"
"                       going into a reduced power state when VNC clients\n"
"                       are connected.\n"
"\n"
"                       DPMS reduced power monitor states are a good thing\n"
"                       and you normally want the power down to take place\n"
"                       (usually x11vnc has no problem exporting the display in\n"
"                       this state).  You probably only want to use \"-nodpms\"\n"
"                       to work around problems with Screen Savers kicking\n"
"                       on in DPMS low power states.  There is known problem\n"
"                       with kdesktop_lock on KDE where the screen saver keeps\n"
"                       kicking in every time user input stops for a second\n"
"                       or two.  Specifying \"-nodpms\" works around it.\n"
"\n"
"                       \"-nodpms\" means prevent DPMS low power states whenever\n"
"                       VNC clients are connected, while \"-dpms\" means to not\n"
"                       monitor the DPMS state at all.  See the xset(1) manpage\n"
"                       for details.  -nodpms is basically the same as running\n"
"                       \"xset dpms force on\" periodically.  Default: %s\n"
"\n"
"-forcedpms             If the system supports the DPMS (Display Power\n"
"                       Management Signaling) extension, then try to keep the\n"
"                       monitor in a powered off state.  This is to prevent\n"
"                       nosey people at the physical display from viewing what\n"
"                       is on the screen.  Be sure to lock the screen before\n"
"                       disconnecting.\n"
"\n"
"                       This method is far from bullet proof, e.g. suppose\n"
"                       someone attaches a non-DPMS monitor, or loads the\n"
"                       machine so that there is a gap of time before x11vnc\n"
"                       restores the powered off state?  On many machines if\n"
"                       he floods it with keyboard and mouse input he can see\n"
"                       flashes of what is on the screen before the DPMS off\n"
"                       state is reestablished.  For this to work securely\n"
"                       there would need to be support in the X server to do\n"
"                       this exactly rather than approximately with DPMS.\n"
"\n"
"-clientdpms            As -forcedpms but only when VNC clients are connected.\n"
"\n"
"-noserverdpms          The UltraVNC ServerInput extension is supported.\n"
"                       This allows the VNC viewer to click a button that will\n"
"                       cause the server (x11vnc) to try to disable keyboard\n"
"                       and mouse input at the physical display and put the\n"
"                       monitor in dpms powered off state.  Use this option to\n"
"                       skip powering off the monitor.\n"
"\n"
"-noultraext            Disable the following UltraVNC extensions: SingleWindow\n"
"                       and ServerInput.  The others managed by LibVNCServer\n"
"                       (textchat, 1/n scaling, rfbEncodingUltra) are not.\n"
"\n"
"-chatwindow            Place a local UltraVNC chat window on the X11 display\n"
"                       that x11vnc is polling.  That way the person on the VNC\n"
"                       viewer-side can chat with the person at the physical\n"
"                       X11 console. (e.g. helpdesk w/o telephone)\n"
"\n"
"                       For this to work the SSVNC package (version 1.0.21 or\n"
"                       later) MUST BE installed on the system where x11vnc runs\n"
"                       and the 'ssvnc' command must be available in $PATH.\n"
"                       The ssvncviewer is used as a chat window helper.\n"
"                       See http://www.karlrunge.com/x11vnc/ssvnc.html\n"
"\n"
"                       This option implies '-rfbversion 3.6' so as to trick\n"
"                       UltraVNC viewers, otherwise they assume chat is not\n"
"                       available.  To specify a different rfbversion, place\n"
"                       it after the -chatwindow option on the cmdline.\n"
"\n"
"                       See also the remote control 'chaton' and 'chatoff'\n"
"                       actions.  These can also be set from the tkx11vnc GUI.\n"
"\n"
"-noxdamage             Do not use the X DAMAGE extension to detect framebuffer\n"
"                       changes even if it is available.  Use -xdamage if your\n"
"                       default is to have it off.\n"
"\n"
"                       x11vnc's use of the DAMAGE extension: 1) significantly\n"
"                       reduces the load when the screen is not changing much,\n"
"                       and 2) detects changed areas (small ones by default)\n"
"                       more quickly.\n"
"\n"
"                       Currently the DAMAGE extension is overly conservative\n"
"                       and often reports large areas (e.g. a whole terminal\n"
"                       or browser window) as damaged even though the actual\n"
"                       changed region is much smaller (sometimes just a few\n"
"                       pixels).  So heuristics were introduced to skip large\n"
"                       areas and use the damage rectangles only as \"hints\"\n"
"                       for the traditional scanline polling.  The following\n"
"                       tuning parameters are introduced to adjust this\n"
"                       behavior:\n"
"\n"
"-xd_area A             Set the largest DAMAGE rectangle area \"A\" (in\n"
"                       pixels: width * height) to trust as truly damaged:\n"
"                       the rectangle will be copied from the framebuffer\n"
"                       (slow) no matter what.  Set to zero to trust *all*\n"
"                       rectangles. Default: %d\n"
"-xd_mem f              Set how long DAMAGE rectangles should be \"remembered\",\n"
"                       \"f\" is a floating point number and is in units of the\n"
"                       scanline repeat cycle time (%d iterations).  The default\n"
"                       (%.1f) should give no painting problems. Increase it if\n"
"                       there are problems or decrease it to live on the edge\n"
"                       (perhaps useful on a slow machine).\n"
"\n"
"-sigpipe string        Broken pipe (SIGPIPE) handling.  \"string\" can be\n"
"                       \"ignore\" or \"exit\".  For \"ignore\" LibVNCServer\n"
"                       will handle the abrupt loss of a client and continue,\n"
"                       for \"exit\" x11vnc will cleanup and exit at the 1st\n"
"                       broken connection.\n"
"\n"
"                       This option is not really needed since LibVNCServer\n"
"                       is doing the correct thing now for quite some time.\n"
"                       However, for convenience you can use it to ignore other\n"
"                       signals, e.g. \"-sigpipe ignore:HUP,INT,TERM\" in case\n"
"                       that would be useful for some sort of application.\n"
"                       You can also put \"exit:..\" in the list to have x11vnc\n"
"                       cleanup on the listed signals. \"-sig\" is an alias\n"
"                       for this option if you don't like the 'pipe'. Example:\n"
"                       -sig ignore:INT,TERM,exit:USR1\n"
"\n"
"-threads               Whether or not to use the threaded LibVNCServer\n"
"-nothreads             algorithm [rfbRunEventLoop] if libpthread is available.\n"
"                       In this mode new threads (one for input and one\n"
"                       for output) are created to handle each new client.\n"
"                       Default: %s.\n"
"\n"
"                       Thread stability is much improved in version 0.9.8.\n"
"\n"
"                       Multiple clients in threaded mode should be stable\n"
"                       for the ZRLE encoding on all platforms.  The Tight and\n"
"                       Zlib encodings are currently only stable on Linux for\n"
"                       multiple clients.  Compile with -DTLS=__thread if your\n"
"                       OS and compiler and linker support it.\n"
"\n"
"                       For resizes (randr, etc.) set this env. var. to the number\n"
"                       of milliseconds to sleep: X11VNC_THREADS_NEW_FB_SLEEP\n"
"                       at various places in the do_new_fb() action.  This is to\n"
"                       let various activities settle.  Default is about 500ms.\n"
"\n"
"                       Multiple clients in threaded mode could yield better\n"
"                       performance for 'class-room' broadcasting usage; also in\n"
"                       -appshare broadcast mode.  See also the -reflect option.\n"
"\n"
"-fs f                  If the fraction of changed tiles in a poll is greater\n"
"                       than f, the whole screen is updated.  Default: %.2f\n"
"-gaps n                Heuristic to fill in gaps in rows or cols of n or\n"
"                       less tiles.  Used to improve text paging.  Default: %d\n"
"-grow n                Heuristic to grow islands of changed tiles n or wider\n"
"                       by checking the tile near the boundary.  Default: %d\n"
"-fuzz n                Tolerance in pixels to mark a tiles edges as changed.\n"
"                       Default: %d\n"
"-debug_tiles           Print debugging output for tiles, fb updates, etc.\n"
"\n"
"-snapfb                Instead of polling the X display framebuffer (fb)\n"
"                       for changes, periodically copy all of X display fb\n"
"                       into main memory and examine that copy for changes.\n"
"                       (This setting also applies for non-X -rawfb modes).\n"
"                       Under some circumstances this will improve interactive\n"
"                       response, or at least make things look smoother, but in\n"
"                       others (most!) it will make the response worse.  If the\n"
"                       video h/w fb is such that reading small tiles is very\n"
"                       slow this mode could help.  To keep the \"framerate\"\n"
"                       up the screen size x bpp cannot be too large.  Note that\n"
"                       this mode is very wasteful of memory I/O resources\n"
"                       (it makes full screen copies even if nothing changes).\n"
"                       It may be of use in video capture-like applications,\n"
"                       webcams, or where window tearing is a problem.\n"
"\n"
"-rawfb string          Instead of polling X, poll the memory object specified\n"
"                       in \"string\".\n"
"\n"
"                       For file polling, to memory map mmap(2) a file use:\n"
"                       \"map:/path/to/a/file@WxHxB\", with framebuffer Width,\n"
"                       Height, and Bits per pixel.  \"mmap:...\" is the\n"
"                       same.\n"
"\n"
"                       If there is trouble with mmap, use \"file:/...\"\n"
"                       for slower lseek(2) based reading.\n"
"\n"
"                       Use \"snap:...\" to imply -snapfb mode and the \"file:\"\n"
"                       access (this is for unseekable devices that only provide\n"
"                       the fb all at once, e.g. a video camera provides the\n"
"                       whole frame).\n"
"\n"
"                       For shared memory segments string is of the form:\n"
"                       \"shm:N@WxHxB\" which specifies a shmid N and with\n"
"                       WxHxB as above.  See shmat(1) and ipcs(1)\n"
"\n"
"                       If you do not supply a type \"map\" is assumed if\n"
"                       the file exists (see the next paragraphs for some\n"
"                       exceptions to this.)\n"
"\n"
"                       If string is \"setup:cmd\", then the command \"cmd\"\n"
"                       is run and the first line from it is read and used\n"
"                       as \"string\".  This allows initializing the device,\n"
"                       determining WxHxB, etc. These are often done as root\n"
"                       so take care.\n"
"\n"
"                       If the string begins with \"video\", see the VIDEO4LINUX\n"
"                       discussion below where the device may be queried for\n"
"                       (and possibly set) the framebuffer parameters.\n"
"\n"
"                       If the string begins with \"console\", \"/dev/fb\",\n"
"                       \"fb\", or \"vt\", see the LINUX CONSOLE discussion\n"
"                       below where the framebuffer device is opened and\n"
"                       keystrokes (and possibly mouse events) are inserted\n"
"                       into the console.\n"
"\n"
"                       If the string begins with \"vnc\", see the VNC HOST\n"
"                       discussion below where the framebuffer is taken as that\n"
"                       of another remote VNC server.\n"
"\n"
"                       Optional suffixes are \":R/G/B\" and \"+O\" to specify\n"
"                       red, green, and blue masks (in hex) and an offset into\n"
"                       the memory object.  If the masks are not provided x11vnc\n"
"                       guesses them based on the bpp (if the colors look wrong,\n"
"                       you need to provide the masks.)\n"
"\n"
"                       Another optional suffix is the Bytes Per Line which in\n"
"                       some cases is not WxB/8.  Specify it as WxHxB-BPL\n"
"                       e.g. 800x600x16-2048.  This could be a normal width\n"
"                       1024 at 16bpp fb, but only width 800 shows up.\n"
"\n"
"                       So the full format is: mode:file@WxHxB:R/G/B+O-BPL\n"
"\n"
"                       Examples:\n"
"                           -rawfb shm:210337933@800x600x32:ff/ff00/ff0000\n"
"                           -rawfb map:/dev/fb0@1024x768x32\n"
"                           -rawfb map:/tmp/Xvfb_screen0@640x480x8+3232\n"
"                           -rawfb file:/tmp/my.pnm@250x200x24+37\n"
"                           -rawfb file:/dev/urandom@128x128x8\n"
"                           -rawfb snap:/dev/video0@320x240x24 -24to32\n"
"                           -rawfb video0\n"
"                           -rawfb video -pipeinput VID\n"
"                           -rawfb console\n"
"                           -rawfb vt2\n"
"                           -rawfb vnc:somehost:0\n"
"\n"
"                       (see ipcs(1) and fbset(1) for the first two examples)\n"
"\n"
"                       In general all user input is discarded by default (see\n"
"                       the -pipeinput option for how to use a helper program\n"
"                       to insert).  Most of the X11 (screen, keyboard, mouse)\n"
"                       options do not make sense and many will cause this\n"
"                       mode to crash, so please think twice before setting or\n"
"                       changing them in a running x11vnc.\n"
"\n"
"                       If you DO NOT want x11vnc to close the X DISPLAY in\n"
"                       rawfb mode, prepend a \"+\" e.g. +file:/dev/fb0...\n"
"                       Keeping the display open enables the default\n"
"                       remote-control channel, which could be useful.\n"
"                       Alternatively, if you specify -noviewonly, then the\n"
"                       mouse and keyboard input are STILL sent to the X\n"
"                       display, this usage should be very rare, i.e. doing\n"
"                       something strange with /dev/fb0.\n"
"\n"
"                       If the device is not \"seekable\" (e.g. webcam) try\n"
"                       reading it all at once in full snaps via the \"snap:\"\n"
"                       mode (note: this is a resource hog).  If you are using\n"
"                       file: or map: AND the device needs to be reopened for\n"
"                       *every* snapfb snapshot, set the environment variable:\n"
"                       SNAPFB_RAWFB_RESET=1 as well.\n"
"\n"
"                       If you want x11vnc to dynamically transform a 24bpp\n"
"                       rawfb to 32bpp (note that this will be slower) also\n"
"                       supply the -24to32 option.  This would be useful for,\n"
"                       say, a video camera that delivers the pixel data as\n"
"                       24bpp packed RGB.  This is the default under \"video\"\n"
"                       mode if the bpp is 24.\n"
"\n"
"                       Normally the bits per pixel, B, is 8, 16, or 32 (or\n"
"                       rarely 24), however there is also some support for\n"
"                       B < 8 (e.g. old graphics displays 4 bpp or 1 bpp).\n"
"                       In this case you certainly must supply the masks as\n"
"                       well: WxHxB:R/G/B.  The pixels will be padded out to\n"
"                       8 bpp using depth 8 truecolor.  The scheme currently\n"
"                       does not work with snap fb (ask if interested.) B=1\n"
"                       monochrome example: file:/dev/urandom@128x128x1:1/1/1\n"
"                       Some other like this are 128x128x2:3/3/3 128x128x4:7/7/7\n"
"\n"
"                       For B < 8 framebuffers you can also set the env. var\n"
"                       RAWFB_CGA=1 to try a CGA mapping for B=4 (e.g. linux\n"
"                       vga16fb driver.)  Note with low bpp and/or resolution\n"
"                       VGA and VGA16 modes on the Linux console one's attempt\n"
"                       to export them via x11vnc can often be thwarted due to\n"
"                       special color palettes, pixel packings, and even video\n"
"                       painting buffering.  OTOH, often experimenting with the\n"
"                       RGB masks can yield something recognizable.\n"
"\n"
"                       VIDEO4LINUX: on Linux some attempt is made to handle\n"
"                       video devices (webcams or TV tuners) automatically.\n"
"                       The idea is the WxHxB will be extracted from the\n"
"                       device itself.  So if you do not supply \"@WxHxB...\n"
"                       parameters x11vnc will try to determine them.  It first\n"
"                       tries the v4l API if that support has been compiled in.\n"
"                       Otherwise it will run the v4l-info(1) external program\n"
"                       if it is available.\n"
"\n"
"                       The simplest examples are \"-rawfb video\" and \"-rawfb\n"
"                       video1\" which imply the device file /dev/video and\n"
"                       /dev/video1, respectively.  You can also supply the\n"
"                       /dev if you like, e.g. \"-rawfb /dev/video0\"\n"
"\n"
"                       Since the video capture device framebuffer usually\n"
"                       changes continuously (e.g. brightness fluctuations),\n"
"                       you may want to use the -wait, -slow_fb, or -defer\n"
"                       options to lower the \"framerate\" to cut down on\n"
"                       network VNC traffic.\n"
"\n"
"                       A more sophisticated video device scheme allows\n"
"                       initializing the device's settings using:\n"
"\n"
"                           -rawfb video:<settings>\n"
"\n"
"                       The prefix could also be, as above, e.g. \"video1:\" to\n"
"                       specify the device file.  The v4l API must be available\n"
"                       for this to work.  Otherwise, you will need to try\n"
"                       to initialize the device with an external program,\n"
"                       e.g. xawtv, spcaview, and hope they persist when x11vnc\n"
"                       re-opens the device.\n"
"\n"
"                       <settings> is a comma separated list of key=value pairs.\n"
"                       The device's brightness, color, contrast, and hue can\n"
"                       be set to percentages, e.g. br=80,co=50,cn=44,hu=60.\n"
"\n"
"                       The device filename can be set too if needed (if it\n"
"                       does not start with \"video\"), e.g. fn=/dev/qcam.\n"
"\n"
"                       The width, height and bpp of the framebuffer can be\n"
"                       set via, e.g., w=160,h=120,bpp=16.\n"
"\n"
"                       Related to the bpp above, the pixel format can be set\n"
"                       via the fmt=XXX, where XXX can be one of: GREY, HI240,\n"
"                       RGB555, RGB565, RGB24, and RGB32 (with bpp 8, 8, 16, 16,\n"
"                       24, and 32 respectively).  See http://www.linuxtv.org\n"
"                       for more info (V4L api).\n"
"\n"
"                       For TV/rf tuner cards one can set the tuning mode\n"
"                       via tun=XXX where XXX can be one of PAL, NTSC, SECAM,\n"
"                       or AUTO.\n"
"\n"
"                       One can switch the input channel by the inp=XXX setting,\n"
"                       where XXX is the name of the input channel (Television,\n"
"                       Composite1, S-Video, etc).  Use the name that is in the\n"
"                       information about the device that is printed at startup.\n"
"\n"
"                       For input channels with tuners (e.g. Television) one\n"
"                       can change which station is selected by the sta=XXX\n"
"                       setting.  XXX is the station number.  Currently only\n"
"                       the ntsc-cable-us (US cable) channels are built into\n"
"                       x11vnc.  See the -freqtab option below to supply one\n"
"                       from xawtv. If XXX is greater than 500, then it is\n"
"                       interpreted as a raw frequency in KHz.\n"
"\n"
"                       Example:\n"
"\n"
"                       -rawfb video:br=80,w=320,h=240,fmt=RGB32,tun=NTSC,sta=47\n"
"\n"
"                       one might need to add inp=Television too for the input\n"
"                       channel to be TV if the card doesn't come up by default\n"
"                       in that one.\n"
"\n"
"                       Note that not all video capture devices will support\n"
"                       all of the above settings.\n"
"\n"
"                       See the -pipeinput VID option below for a way to control\n"
"                       the settings through the VNC Viewer via keystrokes.\n"
"                       As a shortcut, if the string begins \"Video..\" instead\n"
"                       of \"video..\" then -pipeinput VID is implied.\n"
"\n"
"                       As above, if you specify a \"@WxHxB...\" after the\n"
"                       <settings> string they are used verbatim: the device\n"
"                       is not queried for the current values.  Otherwise the\n"
"                       device will be queried.\n"
"\n"
"                       LINUX CONSOLE:  The following describes some ways to\n"
"                       view and possibly interact with the Linux text/graphics\n"
"                       console (i.e. not X11 XFree86/Xorg)\n"
"\n"
"                       Note: If the LibVNCServer LinuxVNC program is on your\n"
"                       system you may want to use that instead of the following\n"
"                       method because it will be faster and more accurate\n"
"                       for the Linux text console and includes mouse support.\n"
"                       There is, however, the basic LinuxVNC functionality in\n"
"                       x11vnc if you replace \"console\" with \"vt\" in the\n"
"                       examples below.\n"
"\n"
"                       If the rawfb string begins with \"console\" the\n"
"                       framebuffer device /dev/fb0 is opened and /dev/tty0 is\n"
"                       opened too.  The latter is used to inject keystrokes\n"
"                       (not all are supported, but the basic ones are).\n"
"                       You will need to be root to inject keystrokes, but\n"
"                       not necessarily to open /dev/fb0.  /dev/tty0 refers to\n"
"                       the active VT, to indicate one explicitly, use, e.g.,\n"
"                       \"console2\" for /dev/tty2, etc. by indicating the\n"
"                       specific VT number.\n"
"\n"
"                       For the Linux framebuffer device, /dev/fb0, (fb1,\n"
"                       etc) to be enabled the appropriate kernel drivers must\n"
"                       be loaded.  E.g. vesafb or vga16fb and also by setting\n"
"                       the boot parameter vga=0x301 (or 0x314, 0x317, etc.)\n"
"                       (The vga=... method is the preferred way; set your\n"
"                       machines up that way.)  Otherwise there will be a\n"
"                       'No such device' error.  You can also load a Linux\n"
"                       framebuffer driver specific to your make of video card\n"
"                       for more functionality.  Once the machine is booted one\n"
"                       can often 'modprobe' the fb driver as root to obtain\n"
"                       a framebuffer device.\n"
"\n"
"                       If you cannot get /dev/fb0 working on Linux, try\n"
"                       using the LinuxVNC emulation mode by \"-rawfb vtN\"\n"
"                       where N = 1, ... 6 is the Linux Virtual Terminal (aka\n"
"                       virtual console) you wish to view, e.g. \"-rawfb vt2\".\n"
"                       Unlike /dev/fb mode, it need not be the active Virtual\n"
"                       Terminal.  Note that this mode can only show text and\n"
"                       not graphics.  x11vnc polls the text in /dev/vcsaN\n"
"\n"
"                       Set the env. var. RAWFB_VCSA_BW=1 to disable colors in\n"
"                       the \"vtN\" mode (i.e. black and white only.)  If you\n"
"                       do not prefer the default 16bpp set RAWFB_VCSA_BPP to\n"
"                       8 or 32.  If you need to tweak the rawfb parameters by\n"
"                       using the 'console_guess' string printed at startup,\n"
"                       be sure to indicate the snap: method.\n"
"\n"
"                       uinput: If the Linux version appears to be 2.6 or\n"
"                       later and the \"uinput\" module appears to be present\n"
"                       (modprobe uinput), then the uinput method will be used\n"
"                       instead of /dev/ttyN.  uinput allows insertion of BOTH\n"
"                       keystrokes and mouse input and so it preferred when\n"
"                       accessing graphical (e.g. QT-embedded) linux console\n"
"                       apps.  See -pipeinput UINPUT below for more information\n"
"                       on this mode; you will have to use -pipeinput if you\n"
"                       want to tweak any UINPUT parameters.  You may also want\n"
"                       to also use the -nodragging and -cursor none options.\n"
"                       Use \"console0\", etc  or -pipeinput CONSOLE to force\n"
"                       the /dev/ttyN method.\n"
"\n"
"                       Note you can change the Linux VT remotely using the\n"
"                       chvt(1) command to make the one you want be the active\n"
"                       one (e.g. 'chvt 3').  Sometimes switching out and back\n"
"                       corrects the framebuffer's graphics state.  For the\n"
"                       \"-rawfb vtN\" mode there is no need to switch the VT's.\n"
"\n"
"                       To skip input injecting entirely use \"consolex\"\n"
"                       or \"vtx\".\n"
"\n"
"                       The string \"/dev/fb0\" (1, etc.) can be used instead\n"
"                       of \"console\".  This can be used to specify a different\n"
"                       framebuffer device, e.g. /dev/fb1.  As a shortcut the\n"
"                       \"/dev/\" can be dropped.  If the name is something\n"
"                       nonstandard, use \"console:/dev/foofb\"\n"
"\n"
"                       If you do not want x11vnc to guess the framebuffer's\n"
"                       WxHxB and masks automatically (sometimes the kernel\n"
"                       gives incorrect information), specify them with a @WxHxB\n"
"                       (and optional :R/G/B masks) at the end of the string.\n"
"\n"
"                       Examples:\n"
"                           -rawfb console\n"
"                           -rawfb /dev/fb0           (same)\n"
"                           -rawfb console3           (force /dev/tty3)\n"
"                           -rawfb consolex           (no keystrokes or mouse)\n"
"                           -rawfb console:/dev/nonstd\n"
"                           -rawfb console -pipeinput UINPUT:accel=4.0\n"
"                           -rawfb vt3                (/dev/tty3 w/o /dev/fb0)\n"
"\n"
"                       VNC HOST: if the -rawfb string is of the form\n"
"                       \"vnc:host:N\" then the VNC display \"N\" on the remote\n"
"                       VNC server \"host\" is connected to (i.e. x11vnc acts as\n"
"                       a VNC client itself) and that framebuffer is exported.\n"
"\n"
"                       This mode is really only of use if you are trying\n"
"                       to improve performance in the case of many (e.g. >\n"
"                       10) simultaneous VNC viewers, and you try a divide\n"
"                       and conquer scheme to reduce bandwidth and improve\n"
"                       responsiveness.\n"
"\n"
"                       For example, if there will be 64 simultaneous VNC\n"
"                       viewers this can lead to a lot of redundant VNC traffic\n"
"                       to and from the server host:N, extra CPU usage,\n"
"                       and all viewers response can be reduced by having\n"
"                       to wait for writes to the slowest client to finish.\n"
"                       However, if you set up 8 reflectors/repeaters started\n"
"                       with option -rawfb vnc:host:N, then there are only\n"
"                       8 connections to host:N.  Each repeater then handles\n"
"                       8 vnc viewer connections thereby spreading the load\n"
"                       around.  In classroom broadcast usage, try to put the\n"
"                       repeaters on different switches.  This mode is the same\n"
"                       as -reflect host:N.  Replace \"host:N\" by \"listen\"\n"
"                       or \"listen:port\" for a reverse connection.\n"
"\n"
"                       Overall performance will not be as good as a single\n"
"                       direct connection because, among other things,\n"
"                       there is an additional level of framebuffer polling\n"
"                       and pointer motion can still induce many changes per\n"
"                       second that must be propagated.  Tip: if the remote VNC\n"
"                       is x11vnc doing wireframing, or an X display that does\n"
"                       wireframing that gives much better response than opaque\n"
"                       window dragging.  Consider the -nodragging option if\n"
"                       the problem is severe.\n"
"\n"
"                       The env. var. X11VNC_REFLECT_PASSWORD can be set to\n"
"                       the password needed to log into the vnc host server, or\n"
"                       to \"file:path_to_file\" to indicate a file containing\n"
"                       the password as its first line.\n"
"\n"
"                       The VNC HOST mode implies -shared.  Use -noshared as\n"
"                       a subsequent cmdline option to disable sharing.\n"
"\n"
"-freqtab file          For use with \"-rawfb video\" for TV tuner devices to\n"
"                       specify station frequencies.  Instead of using the built\n"
"                       in ntsc-cable-us mapping of station number to frequency,\n"
"                       use the data in file.  For stations that are not\n"
"                       numeric, e.g. SE20, they are placed above the highest\n"
"                       numbered station in the order they are found.  Example:\n"
"                       \"-freqtab /usr/X11R6/share/xawtv/europe-west.list\"\n"
"                       You can make your own freqtab by copying the xawtv\n"
"                       format.\n"
"\n"
"-pipeinput cmd         This option lets you supply an external command in\n"
"                       \"cmd\" that x11vnc will pipe all of the user input\n"
"                       events to in a simple format.  In -pipeinput mode by\n"
"                       default x11vnc will not process any of the user input\n"
"                       events.  If you prefix \"cmd\" with \"tee:\" it will\n"
"                       both send them to the pipe command and process them.\n"
"                       For a description of the format run \"-pipeinput\n"
"                       tee:/bin/cat\".  Another prefix is \"reopen\" which\n"
"                       means to reopen pipe if it exits.  Separate multiple\n"
"                       prefixes with commas.\n"
"\n"
"                       In combination with -rawfb one might be able to\n"
"                       do amusing things (e.g. control non-X devices).\n"
"                       To facilitate this, if -rawfb is in effect then the\n"
"                       value is stored in X11VNC_RAWFB_STR for the pipe command\n"
"                       to use if it wants. Do 'env | grep X11VNC' for more.\n"
"\n"
"                       Built-in pipeinput modes (no external program required):\n"
"\n"
"                       If cmd is \"VID\" and you are using the -rawfb for a\n"
"                       video capture device, then an internal list of keyboard\n"
"                       mappings is used to set parameters of the video.\n"
"                       The mappings are:\n"
"\n"
"                         \"B\" and \"b\" adjust the brightness up and down.\n"
"                         \"H\" and \"h\" adjust the hue.\n"
"                         \"C\" and \"c\" adjust the colour.\n"
"                         \"N\" and \"n\" adjust the contrast.\n"
"                         \"S\" and \"s\" adjust the size of the capture screen.\n"
"                         \"I\" and \"i\" cycle through input channels.\n"
"                         Up and Down arrows adjust the station (if a tuner)\n"
"                         F1, F2, ..., F6 will switch the video capture pixel\n"
"                         format to HI240, RGB565, RGB24, RGB32, RGB555, and\n"
"                         GREY respectively.  See -rawfb video for details.\n"
"\n"
"                       If cmd is \"CONSOLE\" or \"CONSOLEn\" where n\n"
"                       is a Linux console number, then the linux console\n"
"                       keystroke insertion to /dev/ttyN (see -rawfb console)\n"
"                       is performed.\n"
"\n"
"                       If cmd begins with \"UINPUT\" then the Linux uinput\n"
"                       module is used to insert both keystroke and mouse events\n"
"                       to the Linux console (see -rawfb above).  This usually\n"
"                       is the /dev/input/uinput device file (you may need to\n"
"                       create it with \"mknod /dev/input/uinput c 10 223\"\n"
"                       and insert the module with \"modprobe uinput\".\n"
"\n"
"                       The UINPUT mode currently only does US keyboards (a\n"
"                       scan code option may be added), and not all keysyms\n"
"                       are supported.\n"
"\n"
"                       You may want to use the options -cursor none and\n"
"                       -nodragging in this mode.\n"
"\n"
"                       Additional tuning options may be supplied via:\n"
"                       UINPUT:opt1,opt2,... (a comma separated list). If an\n"
"                       option begins with \"/\" it is taken as the uinput\n"
"                       device file.\n"
"                       \n"
"                       Which uinput is injected can be controlled by an option\n"
"                       string made of the characters \"K\", \"M\", and \"B\"\n"
"                       (see the -input option), e.g. \"KM\" allows keystroke\n"
"                       and motion but not button clicks.\n"
"\n"
"                       A UINPUT option of the form: accel=f, or accel=fx+fy\n"
"                       sets the mouse motion \"acceleration\".  This is used\n"
"                       to correct raw mouse relative motion into how much the\n"
"                       application cursor moves (x11vnc has no control over,\n"
"                       or knowledge of how the windowing application interprets\n"
"                       the raw mouse motions).  Typically the acceleration\n"
"                       for an X display is 2 (see xset \"m\" option).  \"f\"\n"
"                       is a floating point number, e.g. 3.0.  Use \"fx+fy\"\n"
"                       if you need to supply different corrections for x and y.\n"
"\n"
"                       Note: the default acceleration is 2.0 since it seems\n"
"                       both X and qt-embedded often (but not always) use\n"
"                       this value.\n"
"\n"
"                       Even with a correct accel setting the mouse position\n"
"                       will get out of sync (probably due to a mouse\n"
"                       \"threshold\" setting where the acceleration doe not\n"
"                       apply, set xset(1)).  The option reset=N sets the\n"
"                       number of ms (default 150) after which the cursor is\n"
"                       attempted to be reset (by forcing the mouse to (0,\n"
"                       0) via small increments and then back out to (x, y)\n"
"                       in 1 jump), This correction seems to be needed but can\n"
"                       cause jerkiness or unexpected behavior with menus, etc.\n"
"                       Use reset=0 to disable.\n"
"\n"
"                       If the uinput device has an absolute pointer (as opposed\n"
"                       to a normal mouse that is a relative pointer) you can\n"
"                       specify the option \"abs\".  Note that a touchpad\n"
"                       on a laptop is an absolute device to some degree.\n"
"                       This (usually) avoids all the problems with mouse\n"
"                       acceleration.  If x11vnc has trouble deducing the size\n"
"                       of the device, use \"abs=WxH\".  Furthermore, if the\n"
"                       device is a touchscreen (assumed to have an absolute\n"
"                       pointer) use \"touch\" or \"touch=WxH\".\n"
"\n"
"                       If you set the env. var X11VNC_UINPUT_THRESHOLDS then\n"
"                       the thresh=n mode will be enabled.  It is currently\n"
"                       not working well.  If |dx| <= thresh and |dy| < thresh\n"
"                       no acceleration is applied.  Use \"thresh=+n\" |dx| +\n"
"                       |dy| < thresh to be used instead (X11?)\n"
"\n"
"                       Example:\n"
"                           -pipeinput UINPUT:accel=4.0 -cursor none\n"
"\n"
"                       You can also set the env. var X11VNC_UINPUT_DEBUG=1 or\n"
"                       higher to get debugging output for UINPUT mode.\n"
"\n"
"-macnodim              For the native MacOSX server, disable dimming. \n"
"-macnosleep            For the native MacOSX server, disable display sleep.\n"
"-macnosaver            For the native MacOSX server, disable screensaver.\n"
"-macnowait             For the native MacOSX server, do not wait for the\n"
"                       user to switch back to his display.\n"
"-macwheel n            For the native MacOSX server, set the mouse wheel\n"
"                       speed to n (default 5).\n"
"-macnoswap             For the native MacOSX server, do not swap mouse\n"
"                       buttons 2 and 3.\n"
"-macnoresize           For the native MacOSX server, do not resize or reset\n"
"                       the framebuffer even if it is detected that the screen\n"
"                       resolution or depth has changed.\n"
"-maciconanim n         For the native MacOSX server, set n to the number\n"
"                       of milliseconds that the window iconify/deiconify\n"
"                       animation takes.  In -ncache mode this value will be\n"
"                       used to skip the animation if possible. (default 400)\n"
"-macmenu               For the native MacOSX server, in -ncache client-side\n"
"                       caching mode, try to cache pull down menus (not perfect\n"
"                       because they have animated fades, etc.)\n"
"-macuskbd              For the native MacOSX server, use the original\n"
"                       keystroke insertion code based on a US keyboard.\n"
"\n"
"-gui [gui-opts]        Start up a simple tcl/tk gui based on the remote\n"
"                       control options -remote/-query described below.\n"
"                       Requires the \"wish\" program to be installed on the\n"
"                       machine.  \"gui-opts\" is not required: the default\n"
"                       is to start up both the full gui and x11vnc with the\n"
"                       gui showing up on the X display in the environment\n"
"                       variable DISPLAY.\n"
"\n"
"                       \"gui-opts\" can be a comma separated list of items.\n"
"                       Currently there are these types of items: 1) a gui\n"
"                       mode, a 2) gui \"simplicity\", 3) the X display the\n"
"                       gui should display on, 4) a \"tray\" or \"icon\" mode,\n"
"                       and 5) a gui geometry.\n"
"\n"
"                       1) The gui mode can be \"start\", \"conn\", or \"wait\"\n"
"                       \"start\" is the default mode above and is not required.\n"
"                       \"conn\" means do not automatically start up x11vnc,\n"
"                       but instead just try to connect to an existing x11vnc\n"
"                       process.  \"wait\" means just start the gui and nothing\n"
"                       else (you will later instruct the gui to start x11vnc\n"
"                       or connect to an existing one.)\n"
"\n"
"                       2) The gui simplicity is off by default (a power-user\n"
"                       gui with all options is presented) To start with\n"
"                       something less daunting supply the string \"simple\"\n"
"                       (\"ez\" is an alias for this).  Once the gui is\n"
"                       started you can toggle between the two with \"Misc ->\n"
"                       simple_gui\".\n"
"\n"
"                       3) Note the possible confusion regarding the potentially\n"
"                       two different X displays: x11vnc polls one, but you\n"
"                       may want the gui to appear on another.  For example, if\n"
"                       you ssh in and x11vnc is not running yet you may want\n"
"                       the gui to come back to you via your ssh redirected X\n"
"                       display (e.g. localhost:10).\n"
"\n"
"                       If you do not specify a gui X display in \"gui-opts\"\n"
"                       then the DISPLAY environment variable and -display\n"
"                       option are tried (in that order).  Regarding the x11vnc\n"
"                       X display the gui will try to communication with, it\n"
"                       first tries -display and then DISPLAY.  For example,\n"
"                       \"x11vnc -display :0 -gui otherhost:0\", will remote\n"
"                       control an x11vnc polling :0 and display the gui on\n"
"                       otherhost:0 The \"tray/icon\" mode below reverses this\n"
"                       preference, preferring to display on the x11vnc display.\n"
"\n"
"                       4) When \"tray\" or \"icon\" is specified, the gui\n"
"                       presents itself as a small icon with behavior typical\n"
"                       of a \"system tray\" or \"dock applet\".  The color\n"
"                       of the icon indicates status (connected clients) and\n"
"                       there is also a balloon status.  Clicking on the icon\n"
"                       gives a menu from which properties, etc, can be set and\n"
"                       the full gui is available under \"Advanced\".  To be\n"
"                       fully functional, the gui mode should be \"start\"\n"
"                       (the default).\n"
"\n"
"                       Note that tray or icon mode will imply the -forever\n"
"                       x11vnc option (if the x11vnc server is started along\n"
"                       with the gui) unless -connect or -connect_or_exit has\n"
"                       been specified.  So x11vnc (and the tray/icon gui)\n"
"                       will wait for more connections after the first client\n"
"                       disconnects.  If you want only one viewer connection\n"
"                       include the -once option.\n"
"\n"
"                       For \"icon\" the gui just a small standalone window.\n"
"                       For \"tray\" it will attempt to embed itself in the\n"
"                       \"system tray\" if possible. If \"=setpass\" is appended then\n"
"                       at startup the X11 user will be prompted to set the\n"
"                       VNC session password.  If =<hexnumber> is appended\n"
"                       that icon will attempt to embed itself in the window\n"
"                       given by hexnumber.  Use =noadvanced to disable the\n"
"                       full gui. (To supply more than one, use \"+\" sign).\n"
"                       E.g. -gui tray=setpass and -gui icon=0x3600028\n"
"\n"
"                       Other modes: \"full\", the default and need not be\n"
"                       specified.  \"-gui none\", do not show a gui, useful\n"
"                       to override a ~/.x11vncrc setting, etc.\n"
"\n"
"                       5) When \"geom=+X+Y\" is specified, that geometry\n"
"                       is passed to the gui toplevel.  This is the icon in\n"
"                       icon/tray mode, or the full gui otherwise.  You can\n"
"                       also specify width and height, i.e. WxH+X+Y, but it\n"
"                       is not recommended.  In \"tray\" mode the geometry is\n"
"                       ignored unless the system tray manager does not seem\n"
"                       to be running.  One could imagine using something like\n"
"                       \"-gui tray,geom=+4000+4000\" with a display manager\n"
"                       to keep the gui invisible until someone logs in...\n"
"\n"
"                       More icon tricks, \"icon=minimal\" gives an icon just\n"
"                       with the VNC display number.  You can also set the font\n"
"                       with \"iconfont=...\".  The following could be useful:\n"
"                       \"-gui icon=minimal,iconfont=5x8,geom=24x10+0-0\"\n"
"\n"
"                       General examples of the -gui option: \"x11vnc -gui\",\n"
"                       \"x11vnc -gui ez\" \"x11vnc -gui localhost:10\",\n"
"                       \"x11vnc -gui conn,host:0\", \"x11vnc -gui tray,ez\"\n"
"                       \"x11vnc -gui tray=setpass\"\n"
"\n"
"                       If you do not intend to start x11vnc from the gui\n"
"                       (i.e. just remote control an existing one), then the\n"
"                       gui process can run on a different machine from the\n"
"                       x11vnc server as long as X permissions, etc. permit\n"
"                       communication between the two.\n"
"\n"
"                       FONTS: On some systems the tk fonts can be too small,\n"
"                       jagged, or otherwise unreadable.  There are 4 env vars\n"
"                       you can set to be the tk font you prefer:\n"
"\n"
"                       X11VNC_FONT_BOLD   main font for menus and buttons.\n"
"                       X11VNC_FONT_FIXED  font for fixed width text.\n"
"\n"
"                       X11VNC_FONT_BOLD_SMALL  tray icon font.\n"
"                       X11VNC_FONT_REG_SMALL   tray icon menu font.\n"
"\n"
"                       The last two only apply for the tray icon mode.\n"
"\n"
"                       Here are some examples:\n"
"\n"
"                       -env X11VNC_FONT_BOLD='Helvetica -16 bold'\n"
"                       -env X11VNC_FONT_FIXED='Courier -14'\n"
"                       -env X11VNC_FONT_REG_SMALL='Helvetica -12'\n"
"\n"
"                       You can put the lines like the above (without the\n"
"                       quotes) in your ~/.x11vncrc file to avoid having to\n"
"                       specify them on the x11vnc command line.\n"
"\n"
"-remote command        Remotely control some aspects of an already running\n"
"                       x11vnc server.  \"-R\" and \"-r\" are aliases for\n"
"                       \"-remote\".  After the remote control command is\n"
"                       sent to the running server the 'x11vnc -remote ...'\n"
"                       x11vnc command exits.  You can often use the -query\n"
"                       command (see below) to see if the x11vnc server\n"
"                       processed your -remote command.\n"
"\n"
"                       The default communication channel is that of X\n"
"                       properties (specifically X11VNC_REMOTE), and so this\n"
"                       command must be run with correct settings for DISPLAY\n"
"                       and possibly XAUTHORITY to connect to the X server\n"
"                       and set the property.  Alternatively, use the -display\n"
"                       and -auth options to set them to the correct values.\n"
"                       The running server cannot use the -novncconnect option\n"
"                       because that disables the communication channel.\n"
"                       See below for alternate channels.\n"
"\n"
"                       For example: 'x11vnc -remote stop' (which is the same as\n"
"                       'x11vnc -R stop') will close down the x11vnc server.\n"
"                       'x11vnc -R shared' will enable shared connections, and\n"
"                       'x11vnc -R scale:3/4' will rescale the desktop.\n"
"\n"
"                       To use a different name for the X11 property (e.g. to\n"
"                       have separate communication channels for multiple\n"
"                       x11vnc's on the same display) set the X11VNC_REMOTE\n"
"                       environment variable to the string you want, for\n"
"                       example: -env X11VNC_REMOTE=X11VNC_REMOTE_12345\n"
"                       Both sides of the channel must use the same unique name.\n"
"\n"
"                       To run a bunch of commands in a sequence use something\n"
"                       like: x11vnc -R 'script:firstcmd;secondcmd;...'\n"
"\n"
"                       Use x11vnc -R script:file=/path/to/file to read commands\n"
"                       from a file (can be multi-line and use the comment '#'\n"
"                       character in the normal way.  The ';' separator must\n"
"                       still be used to separate each command.)\n"
"\n"
"                       To not try to contact another x11vnc process and instead\n"
"                       just run the command (or query) directly, prefix the\n"
"                       command with the string \"DIRECT:\"\n"
"\n"
"                       The following -remote/-R commands are supported:\n"
"\n"
"                       stop            terminate the server, same as \"quit\"\n"
"                                       \"exit\" or \"shutdown\".\n"
"                       ping            see if the x11vnc server responds.\n"
"                                       return is: ans=ping:<display>\n"
"                       ping:mystring   as above, but use your own unique string.\n"
"                                       return is: ans=ping:mystring:<xdisplay>\n"
"                       blacken         try to push a black fb update to all\n"
"                                       clients (due to timings a client\n"
"                                       could miss it). Same as \"zero\", also\n"
"                                       \"zero:x1,y1,x2,y2\" for a rectangle.\n"
"                       refresh         send the entire fb to all clients.\n"
"                       reset           recreate the fb, polling memory, etc.\n"
/* ext. cmd. */
"                       id:windowid     set -id window to \"windowid\". empty\n"
"                                       or \"root\" to go back to root window\n"
"                       sid:windowid    set -sid window to \"windowid\"\n"
"                       id_cmd:cmd      cmds: raise, lower, map, unmap, iconify,\n"
"                                       move:dXdY, resize:dWdH, geom:WxH+X+Y. dX\n"
"                                       dY, dW, and dH must have a leading \"+\"\n"
"                                       or \"-\" e.g.: move:-30+10 resize:+20+35\n"
"                                       also: wm_delete, wm_name:string and\n"
"                                       icon_name:string. Also id_cmd:win=N:cmd\n"
"                       waitmapped      wait until subwin is mapped.\n"
"                       nowaitmapped    do not wait until subwin is mapped.\n"
"                       clip:WxH+X+Y    set -clip mode to \"WxH+X+Y\"\n"
"                       flashcmap       enable  -flashcmap mode.\n"
"                       noflashcmap     disable -flashcmap mode.\n"
"                       shiftcmap:n     set -shiftcmap to n.\n"
"                       notruecolor     enable  -notruecolor mode.\n"
"                       truecolor       disable -notruecolor mode.\n"
"                       overlay         enable  -overlay mode (if applicable).\n"
"                       nooverlay       disable -overlay mode.\n"
"                       overlay_cursor  in -overlay mode, enable cursor drawing.\n"
"                       overlay_nocursor disable cursor drawing. same as\n"
"                                        nooverlay_cursor.\n"
"                       8to24           enable  -8to24 mode (if applicable).\n"
"                       no8to24         disable -8to24 mode.\n"
"                       8to24_opts:str  set the -8to24 opts to \"str\".\n"
"                       24to32          enable  -24to32 mode (if applicable).\n"
"                       no24to32        disable -24to32 mode.\n"
"                       visual:vis      set -visual to \"vis\"\n"
"                       scale:frac      set -scale to \"frac\"\n"
"                       scale_cursor:f  set -scale_cursor to \"f\"\n"
"                       viewonly        enable  -viewonly mode.\n"
/* access view,share,forever */
"                       noviewonly      disable -viewonly mode.\n"
"                       shared          enable  -shared mode.\n"
"                       noshared        disable -shared mode.\n"
"                       forever         enable  -forever mode.\n"
"                       noforever       disable -forever mode.\n"
"                       timeout:n       reset -timeout to n, if there are\n"
"                                       currently no clients, exit unless one\n"
"                                       connects in the next n secs.\n"
"                       tightfilexfer   enable  filetransfer for NEW clients.\n"
"                       notightfilexfer disable filetransfer for NEW clients.\n"
"                       ultrafilexfer   enable  filetransfer for clients.\n"
"                       noultrafilexfer disable filetransfer for clients.\n"
"                       rfbversion:n.m  set -rfbversion for new clients.\n"
/* access */
"                       http            enable  http client connections.\n"
"                       nohttp          disable http client connections.\n"
"                       deny            deny any new connections, same as \"lock\"\n"
"                       nodeny          allow new connections, same as \"unlock\"\n"
"                       avahi           enable  avahi service advertising.\n"
"                       noavahi         disable avahi service advertising.\n"
"                       mdns            enable  avahi service advertising.\n"
"                       nomdns          disable avahi service advertising.\n"
"                       zeroconf        enable  avahi service advertising.\n"
"                       nozeroconf      disable avahi service advertising.\n"
/* access, filename */
"                       connect:host    do reverse connection to host, \"host\"\n"
"                                       may be a comma separated list of hosts\n"
"                                       or host:ports.  See -connect.  Passwords\n"
"                                       required as with fwd connections.\n"
"                                       See X11VNC_REVERSE_CONNECTION_NO_AUTH=1\n"
"                       disconnect:host disconnect any clients from \"host\"\n"
"                                       same as \"close:host\".  Use host\n"
"                                       \"all\" to close all current clients.\n"
"                                       If you know the client internal hex ID,\n"
"                                       e.g. 0x3 (returned by \"-query clients\"\n"
"                                       and RFB_CLIENT_ID) you can use that too.\n"
"                       proxy:host:port set reverse connection proxy (empty to\n"
"                                       disable).\n"
/* access */
"                       allowonce:host  For the next connection only, allow\n"
"                                       connection from \"host\". In -ssl mode\n"
"                                       two connections are allowed (i.e. Fetch\n"
"                                       Cert) unless X11VNC_NO_SSL_ALLOW_TWICE=1\n"
/* access */
"                       allow:hostlist  set -allow list to (comma separated)\n"
"                                       \"hostlist\". See -allow and -localhost.\n"
"                                       Do not use with -allow /path/to/file\n"
"                                       Use \"+host\" to add a single host, and\n"
"                                       use \"-host\" to delete a single host\n"
"                       localhost       enable  -localhost mode\n"
"                       nolocalhost     disable -localhost mode\n"
"                       listen:str      set -listen to str, empty to disable.\n"
"                       noipv6          enable  -noipv6 mode.\n"
"                       ipv6            disable -noipv6 mode.\n"
"                       noipv4          enable  -noipv4 mode.\n"
"                       ipv4            disable -noipv4 mode.\n"
"                       6               enable  -6 IPv6 listening mode.\n"
"                       no6             disable -6 IPv6 listening mode.\n"
"                       lookup          disable -nolookup mode.\n"
"                       nolookup        enable  -nolookup mode.\n"
"                       lookup          disable -nolookup mode.\n"
"                       input:str       set -input to \"str\", empty to disable.\n"
"                       grabkbd         enable  -grabkbd mode.\n"
"                       nograbkbd       disable -grabkbd mode.\n"
"                       grabptr         enable  -grabptr mode.\n"
"                       nograbptr       disable -grabptr mode.\n"
"                       grabalways      enable  -grabalways mode.\n"
"                       nograbalways    disable -grabalways mode.\n"
"                       grablocal:n     set -grablocal to n.\n"
"                       client_input:str set the K, M, B -input on a per-client\n"
"                                       basis.  select which client as for\n"
"                                       disconnect, e.g. client_input:host:MB\n"
"                                       or client_input:0x2:K\n"
/* ext. cmd. */
"                       accept:cmd      set -accept \"cmd\" (empty to disable).\n"
"                       afteraccept:cmd set -afteraccept (empty to disable).\n"
"                       gone:cmd        set -gone \"cmd\" (empty to disable).\n"
"                       noshm           enable  -noshm mode.\n"
"                       shm             disable -noshm mode (i.e. use shm).\n"
"                       flipbyteorder   enable -flipbyteorder mode, you may need\n"
"                                       to set noshm for this to do something.\n"
"                       noflipbyteorder disable -flipbyteorder mode.\n"
"                       onetile         enable  -onetile mode. (you may need to\n"
"                                       set shm for this to do something)\n"
"                       noonetile       disable -onetile mode.\n"
/* ext. cmd. */
"                       solid           enable  -solid mode\n"
"                       nosolid         disable -solid mode.\n"
"                       solid_color:color set -solid color (and apply it).\n"
"                       blackout:str    set -blackout \"str\" (empty to disable).\n"
"                                       See -blackout for the form of \"str\"\n"
"                                       (basically: WxH+X+Y,...)\n"
"                                       Use \"+WxH+X+Y\" to append a single\n"
"                                       rectangle use \"-WxH+X+Y\" to delete one\n"
"                       xinerama        enable  -xinerama mode. (if applicable)\n"
"                       noxinerama      disable -xinerama mode.\n"
"                       xtrap           enable  -xtrap input mode(if applicable)\n"
"                       noxtrap         disable -xtrap input mode.\n"
"                       xrandr          enable  -xrandr mode. (if applicable)\n"
"                       noxrandr        disable -xrandr mode.\n"
"                       xrandr_mode:mode set the -xrandr mode to \"mode\".\n"
"                       rotate:mode     set the -rotate mode to \"mode\".\n"
"                       padgeom:WxH     set -padgeom to WxH (empty to disable)\n"
"                                       If WxH is \"force\" or \"do\" the padded\n"
"                                       geometry fb is immediately applied.\n"
"                       quiet           enable  -quiet mode.\n"
"                       noquiet         disable -quiet mode.\n"
"                       modtweak        enable  -modtweak mode.\n"
"                       nomodtweak      enable  -nomodtweak mode.\n"
"                       xkb             enable  -xkb modtweak mode.\n"
"                       noxkb           disable -xkb modtweak mode.\n"
"                       capslock        enable  -capslock mode.\n"
"                       nocapslock      disable -capslock mode.\n"
"                       skip_lockkeys   enable  -skip_lockkeys mode.\n"
"                       noskip_lockkeys disable -skip_lockkeys mode.\n"
"                       skip_keycodes:str enable -xkb -skip_keycodes \"str\".\n"
"                       sloppy_keys     enable  -sloppy_keys mode.\n"
"                       nosloppy_keys   disable -sloppy_keys mode.\n"
"                       skip_dups       enable  -skip_dups mode.\n"
"                       noskip_dups     disable -skip_dups mode.\n"
"                       add_keysyms     enable -add_keysyms mode.\n"
"                       noadd_keysyms   stop adding keysyms. those added will\n"
"                                       still be removed at exit.\n"
"                       clear_mods      enable  -clear_mods mode and clear them.\n"
"                       noclear_mods    disable -clear_mods mode.\n"
"                       clear_keys      enable  -clear_keys mode and clear them.\n"
"                       noclear_keys    disable -clear_keys mode.\n"
"                       clear_locks     do the clear_locks action.\n"
"                       clear_all       do the clear_all action.\n"
"                       keystate        have x11vnc print current keystate.\n"
/* filename */
"                       remap:str       set -remap \"str\" (empty to disable).\n"
"                                       See -remap for the form of \"str\"\n"
"                                       (basically: key1-key2,key3-key4,...)\n"
"                                       Use \"+key1-key2\" to append a single\n"
"                                       keymapping, use \"-key1-key2\" to delete.\n"
"                       norepeat        enable  -norepeat mode.\n"
"                       repeat          disable -norepeat mode.\n"
"                       nofb            enable  -nofb mode.\n"
"                       fb              disable -nofb mode.\n"
"                       bell            enable  bell (if supported).\n"
"                       nobell          disable bell.\n"
"                       sendbell        ring the bell now.\n"
"                       nosel           enable  -nosel mode.\n"
"                       sel             disable -nosel mode.\n"
"                       noprimary       enable  -noprimary mode.\n"
"                       primary         disable -noprimary mode.\n"
"                       nosetprimary    enable  -nosetprimary mode.\n"
"                       setprimary      disable -nosetprimary mode.\n"
"                       noclipboard     enable  -noclipboard mode.\n"
"                       clipboard       disable -noclipboard mode.\n"
"                       nosetclipboard  enable  -nosetclipboard mode.\n"
"                       setclipboard    disable -nosetclipboard mode.\n"
"                       seldir:str      set -seldir to \"str\"\n"
"                       resend_cutbuffer resend the most recent CUTBUFFER0 copy\n"
"                       resend_clipboard resend the most recent CLIPBOARD copy\n"
"                       resend_primary   resend the most recent PRIMARY copy\n"
"                       cursor:mode     enable  -cursor \"mode\".\n"
"                       show_cursor     enable  showing a cursor.\n"
"                       noshow_cursor   disable showing a cursor. (same as\n"
"                                       \"nocursor\")\n"
"                       cursor_drag     enable  cursor changes during drag.\n"
"                       nocursor_drag   disable cursor changes during drag.\n"
"                       arrow:n         set -arrow to alternate n.\n"
"                       xfixes          enable  xfixes cursor shape mode.\n"
"                       noxfixes        disable xfixes cursor shape mode.\n"
"                       alphacut:n      set -alphacut to n.\n"
"                       alphafrac:f     set -alphafrac to f.\n"
"                       alpharemove     enable  -alpharemove mode.\n"
"                       noalpharemove   disable -alpharemove mode.\n"
"                       alphablend      disable -noalphablend mode.\n"
"                       noalphablend    enable  -noalphablend mode.\n"
"                       cursorshape     disable -nocursorshape mode.\n"
"                       nocursorshape   enable  -nocursorshape mode.\n"
"                       cursorpos       disable -nocursorpos mode.\n"
"                       nocursorpos     enable  -nocursorpos mode.\n"
"                       xwarp           enable  -xwarppointer mode.\n"
"                       noxwarp         disable -xwarppointer mode.\n"
"                       always_inject   enable  -always_inject mode.\n"
"                       noalways_inject disable -always_inject mode.\n"
"                       buttonmap:str   set -buttonmap \"str\", empty to disable\n"
"                       dragging        disable -nodragging mode.\n"
"                       nodragging      enable  -nodragging mode.\n"
"                       ncache          reenable -ncache mode.\n"
"                       noncache        disable  -ncache mode.\n"
"                       ncache_size:n   set -ncache size to n.\n"
"                       ncache_cr       enable  -ncache_cr mode.\n"
"                       noncache_cr     disable -ncache_cr mode.\n"
"                       ncache_no_moveraise     enable  no_moveraise mode.\n"
"                       noncache_no_moveraise   disable no_moveraise mode.\n"
"                       ncache_no_dtchange      enable  ncache_no_dtchange mode.\n"
"                       noncache_no_dtchange    disable ncache_no_dtchange mode.\n"
"                       ncache_old_wm           enable  ncache_old_wm mode.\n"
"                       noncache_old_wm         disable ncache_old_wm mode.\n"
"                       ncache_no_rootpixmap    enable  ncache_no_rootpixmap.\n"
"                       noncache_no_rootpixmap  disable ncache_no_rootpixmap.\n"
"                       ncache_reset_rootpixmap recheck the root pixmap, ncrp\n"
"                       ncache_keep_anims       enable  ncache_keep_anims.\n"
"                       noncache_keep_anims     disable ncache_keep_anims.\n"
"                       ncache_pad:n    set -ncache_pad to n.\n"
"                       wireframe       enable  -wireframe mode. same as \"wf\"\n"
"                       nowireframe     disable -wireframe mode. same as \"nowf\"\n"
"                       wireframe:str   enable  -wireframe mode string.\n"
"                       wireframe_mode:str enable  -wireframe mode string.\n"
"                       wireframelocal  enable  wireframelocal. same as \"wfl\"\n"
"                       nowireframe     disable wireframelocal. same as \"nowfl\"\n"
"                       wirecopyrect:str set -wirecopyrect string. same as \"wcr:\"\n"
"                       scrollcopyrect:str set -scrollcopyrect string. same \"scr\"\n"
"                       noscrollcopyrect disable -scrollcopyrect mode. \"noscr\"\n"
"                       scr_area:n      set -scr_area to n\n"
"                       scr_skip:list   set -scr_skip to \"list\"\n"
"                       scr_inc:list    set -scr_inc to \"list\"\n"
"                       scr_keys:list   set -scr_keys to \"list\"\n"
"                       scr_term:list   set -scr_term to \"list\"\n"
"                       scr_keyrepeat:str set -scr_keyrepeat to \"str\"\n"
"                       scr_parms:str   set -scr_parms parameters.\n"
"                       fixscreen:str   set -fixscreen to \"str\".\n"
"                       noxrecord       disable all use of RECORD extension.\n"
"                       xrecord         enable  use of RECORD extension.\n"
"                       reset_record    reset RECORD extension (if avail.)\n"
"                       pointer_mode:n  set -pointer_mode to n. same as \"pm\"\n"
"                       input_skip:n    set -input_skip to n.\n"
"                       allinput        enable  use of -allinput mode.\n"
"                       noallinput      disable use of -allinput mode.\n"
"                       input_eagerly   enable  use of -input_eagerly mode.\n"
"                       noinput_eagerly disable use of -input_eagerly mode.\n"
"                       ssltimeout:n    set -ssltimeout to n.\n"
"                       speeds:str      set -speeds to str.\n"
"                       wmdt:str        set -wmdt to str.\n"
"                       debug_pointer   enable  -debug_pointer, same as \"dp\"\n"
"                       nodebug_pointer disable -debug_pointer, same as \"nodp\"\n"
"                       debug_keyboard   enable  -debug_keyboard, same as \"dk\"\n"
"                       nodebug_keyboard disable -debug_keyboard, same as \"nodk\"\n"
"                       keycode:n       inject keystroke 'keycode' (xmodmap -pk)\n"
"                       keycode:n,down  inject 'keycode' (down=0,1)\n"
"                       keysym:str      inject keystroke 'keysym' (number/name)\n"
"                       keysym:str,down inject 'keysym' (down=0,1)\n"
"                       ptr:x,y,mask    inject pointer event x, y, button-mask\n"
"                       fakebuttonevent:button,down direct XTestFakeButtonEvent.\n"
"                       sleep:t         sleep floating point time t.\n"
"                       get_xprop:p     get X property named 'p'.\n"
"                       set_xprop:p:val set X property named 'p' to 'val'.\n"
"                                       p -> id=NNN:p for hex/dec window id.\n"
"                       wininfo:id      get info about X window id.  use 'root'\n"
"                                       for root window, use +id for children.\n"
"                       grab_state      get state of pointer and keyboard grab.\n"
"                       pointer_pos     print XQueryPointer x,y cursor position.\n"
"                       pointer_x       print XQueryPointer x cursor position.\n"
"                       pointer_y       print XQueryPointer y cursor position.\n"
"                       pointer_same    print XQueryPointer ptr on same screen.\n"
"                       pointer_root    print XQueryPointer curr ptr rootwin.\n"
"                       pointer_mask    print XQueryPointer button and mods mask\n"
"                       mouse_x         print x11vnc's idea of cursor position.\n"
"                       mouse_y         print x11vnc's idea of cursor position.\n"
"                       noop            do nothing.\n"
"                       defer:n         set -defer to n ms,same as deferupdate:n\n"
"                       wait:n          set -wait to n ms.\n"
"                       extra_fbur:n    set -extra_fbur to n.\n"
"                       wait_ui:f       set -wait_ui factor to f.\n"
"                       setdefer:n      set -setdefer to -2,-1,0,1, or 2.\n"
"                       wait_bog        disable -nowait_bog mode.\n"
"                       nowait_bog      enable  -nowait_bog mode.\n"
"                       slow_fb:f       set -slow_fb to f seconds.\n"
"                       xrefresh:f      set -xrefresh to f seconds.\n"
"                       readtimeout:n   set read timeout to n seconds.\n"
"                       nap             enable  -nap mode.\n"
"                       nonap           disable -nap mode.\n"
"                       sb:n            set -sb to n s, same as screen_blank:n\n"
"                       fbpm            disable -nofbpm mode.\n"
"                       nofbpm          enable  -nofbpm mode.\n"
"                       dpms            disable -nodpms mode.\n"
"                       nodpms          enable  -nodpms mode.\n"
"                       forcedpms       enable  -forcedpms mode.\n"
"                       noforcedpms     disable -forcedpms mode.\n"
"                       clientdpms      enable  -clientdpms mode.\n"
"                       noclientdpms    disable -clientdpms mode.\n"
"                       noserverdpms    enable  -noserverdpms mode.\n"
"                       serverdpms      disable -noserverdpms mode.\n"
"                       noultraext      enable  -noultraext mode.\n"
"                       ultraext        disable -noultraext mode.\n"
"                       chatwindow      enable  local chatwindow mode.\n"
"                       nochatwindow    disable local chatwindow mode.\n"
"                       chaton          begin chat using local window.\n"
"                       chatoff         end   chat using local window.\n"
"                       xdamage         enable  xdamage polling hints.\n"
"                       noxdamage       disable xdamage polling hints.\n"
"                       xd_area:A       set -xd_area max pixel area to \"A\"\n"
"                       xd_mem:f        set -xd_mem remembrance to \"f\"\n"
"                       fs:frac         set -fs fraction to \"frac\", e.g. 0.5\n"
"                       gaps:n          set -gaps to n.\n"
"                       grow:n          set -grow to n.\n"
"                       fuzz:n          set -fuzz to n.\n"
"                       snapfb          enable  -snapfb mode.\n"
"                       nosnapfb        disable -snapfb mode.\n"
"                       rawfb:str       set -rawfb mode to \"str\".\n"
"                       uinput_accel:f  set uinput_accel to f.\n"
"                       uinput_thresh:n set uinput_thresh to n.\n"
"                       uinput_reset:n  set uinput_reset to n ms.\n"
"                       uinput_always:n set uinput_always to 1/0.\n"
"                       progressive:n   set LibVNCServer -progressive slice\n"
"                                       height parameter to n.\n"
"                       desktop:str     set -desktop name to str for new clients.\n"
"                       rfbport:n       set -rfbport to n.\n"
"                       macnosaver      enable  -macnosaver mode.\n"
"                       macsaver        disable -macnosaver mode.\n"
"                       macnowait       enable  -macnowait  mode.\n"
"                       macwait         disable -macnowait  mode.\n"
"                       macwheel:n      set -macwheel to n.\n"
"                       macnoswap       enable  -macnoswap mouse button mode.\n"
"                       macswap         disable -macnoswap mouse button mode.\n"
"                       macnoresize     enable  -macnoresize mode.\n"
"                       macresize       disable -macnoresize mode.\n"
"                       maciconanim:n   set -maciconanim to n.\n"
"                       macmenu         enable  -macmenu  mode.\n"
"                       macnomenu       disable -macmenu  mode.\n"
"                       macuskbd        enable  -macuskbd mode.\n"
"                       macnouskbd      disable -macuskbd mode.\n"
/* access */
"                       httpport:n      set -httpport to n.\n"
"                       httpdir:dir     set -httpdir to dir (and enable http).\n"
"                       enablehttpproxy   enable  -enablehttpproxy mode.\n"
"                       noenablehttpproxy disable -enablehttpproxy mode.\n"
"                       alwaysshared     enable  -alwaysshared mode.\n"
"                       noalwaysshared   disable -alwaysshared mode.\n"
"                                        (may interfere with other options)\n"
"                       nevershared      enable  -nevershared mode.\n"
"                       nonevershared    disable -nevershared mode.\n"
"                                        (may interfere with other options)\n"
"                       dontdisconnect   enable  -dontdisconnect mode.\n"
"                       nodontdisconnect disable -dontdisconnect mode.\n"
"                                        (may interfere with other options)\n"
"                       debug_xevents   enable  debugging X events.\n"
"                       nodebug_xevents disable debugging X events.\n"
"                       debug_xdamage   enable  debugging X DAMAGE mechanism.\n"
"                       nodebug_xdamage disable debugging X DAMAGE mechanism.\n"
"                       debug_wireframe enable   debugging wireframe mechanism.\n"
"                       nodebug_wireframe disable debugging wireframe mechanism.\n"
"                       debug_scroll    enable  debugging scrollcopy mechanism.\n"
"                       nodebug_scroll  disable debugging scrollcopy mechanism.\n"
"                       debug_tiles     enable  -debug_tiles\n"
"                       nodebug_tiles   disable -debug_tiles\n"
"                       debug_grabs     enable  -debug_grabs\n"
"                       nodebug_grabs   disable -debug_grabs\n"
"                       debug_sel       enable  -debug_sel\n"
"                       nodebug_sel     disable -debug_sel\n"
"                       debug_ncache    enable  -debug_ncache\n"
"                       nodebug_ncache  disable -debug_ncache\n"
"                       dbg             enable  -dbg crash shell\n"
"                       nodbg           disable -dbg crash shell\n"
"\n"
"                       noremote        disable the -remote command processing,\n"
"                                       it cannot be turned back on.\n"
"\n"
"                       bcx_xattach:str  This remote control command is for\n"
"                       use with the BARCO xattach program or the x2x program.\n"
"                       Both of these programs are for 'pointer and keyboard'\n"
"                       sharing between separate X displays.  In general the\n"
"                       two displays are usually nearby, e.g. on the same desk,\n"
"                       and this allows the user to share a single pointer and\n"
"                       keyboard between them.  The user moves the mouse to\n"
"                       an edge and then the mouse pointer appears to 'jump'\n"
"                       to the other display screen.  Thus it emulates what a\n"
"                       single X server would do for two screens (e.g. :0.0 and\n"
"                       :0.1) The illusion of a single Xserver with multiple\n"
"                       screens is achieved by forwarding events to the 2nd\n"
"                       one via the XTEST extension.\n"
"\n"
"                       What the x11vnc bcx_xattach command does is to perform\n"
"                       some pointer movements to try to INDUCE xattach/x2x\n"
"                       to 'jump' to the other display.  In what follows the\n"
"                       'master' display refers to the one that when it has\n"
"                       'focus' it is basically doing nothing besides watching\n"
"                       for the mouse to go over an edge.  The 'slave'\n"
"                       display refers to the one to which the mouse and\n"
"                       keyboard is redirected to once an edge in the master\n"
"                       has been crossed.  Note that the x11vnc executing the\n"
"                       bcx_xattach command MUST be the one connected to the\n"
"                       *master* display.\n"
"\n"
"                       Also note that when input is being redirected (via\n"
"                       XTEST) from the master display to the slave display,\n"
"                       the master display's pointer and keyboard are *grabbed*\n"
"                       by xattach/x2x.  x11vnc can use this info to verify that\n"
"                       the master/slave mode change has taken place correctly.\n"
"                       If you specify the \"ifneeded\" option (see below)\n"
"                       and the initial grab state is that of the desired\n"
"                       final state, then no pointer movements are injected\n"
"                       and \"DONE,GRAB_OK\" is returned.\n"
"\n"
"                       \"str\" must contain one of \"up\", \"down\", \"left\",\n"
"                       or \"right\" to indicate the direction of the 'jump'.\n"
"                       \"str\" must also contain one of \"master_to_slave\"\n"
"                       or \"slave_to_master\" to indicate the type of mode\n"
"                       change induced by the jump.  Use \"M2S\" and \"S2M\"\n"
"                       as shorter aliases.\n"
"\n"
"                       \"str\" may be a \"+\" separated list of additional\n"
"                       tuning options.  The \"shift=n\" option indicates an\n"
"                       offset shift position away from (0,0) (default 20).\n"
"                       \"final=x+y\" specifies the final position of the cursor\n"
"                       at the end of the normal move sequence; default 30+30.\n"
"                       \"extra_move=x+y\" means to do one more pointer move\n"
"                       after \"final\" to x+y.  \"dt=n\" sets the sleep time\n"
"                       in milliseconds between pointer moves (default: 40ms)\n"
"                       \"retry=n\" specifies the maximum number of retries if\n"
"                       the grab state change fails. \"ifneeded\" means to not\n"
"                       apply the pointer movements if the initial grab state is\n"
"                       that of the desired final state. \"nograbcheck\" means\n"
"                       to not check if the grab state changed as expected and\n"
"                       only apply the pointer movements (default is to check\n"
"                       the grab states.)\n"
"\n"
"                       If you do not specify \"up\", etc., to bcx_xattach\n"
"                       nothing will be attempted and the command returns\n"
"                       the string FAIL,NO_DIRECTION_SPECIFIED.  If you do\n"
"                       not specify \"master_to_slave\" or \"M2S\", etc., to\n"
"                       bcx_xattach nothing will be attempted and the command\n"
"                       returns the string FAIL,NO_MODE_CHANGE_SPECIFIED.\n"
"\n"
"                       Otherwise, the returned string will contain \"DONE\".\n"
"                       It will be \"DONE,GRAB_OK\" if the grab state changed\n"
"                       as expected (or if \"ifneeded\" was supplied and\n"
"                       the initial grab state was already the desired\n"
"                       one.)  If the initial grab state was incorrect,\n"
"                       but the final grab state was correct then it is\n"
"                       \"DONE,GRAB_FAIL_INIT\".  If the initial grab state\n"
"                       was correct, but the final grab state was incorrect\n"
"                       then it is \"DONE,GRAB_FAIL_FINAL\".  If both are\n"
"                       incorrect it will be \"DONE,GRAB_FAIL\".  Under grab\n"
"                       failure the string will be followed by \":p1,k1-p2,k2\"\n"
"                       where  p1,k1 indicates the initial pointer and keyboard\n"
"                       grab states and p2,k2 the final ones. If GRAB_FAIL or\n"
"                       GRAB_FAIL_FINAL occurs, the action will be retried up\n"
"                       to 3 times; trying to reset the state and sleeping a\n"
"                       bit between each try.  Set retry=n to adjust the number\n"
"                       of retries, zero to disable retries.\n"
"\n"
"                       Examples:\n"
"                           -R bcx_xattach:down+M2S\n"
"                           -R bcx_xattach:up+S2M\n"
"                           -R bcx_xattach:up+S2M+nograbcheck+dt=30\n"
"                           -R bcx_xattach:down+M2S+extra_move=100+100\n"
"\n"
"                       or use -Q instead of -R to retrieve the result text.\n"
"\n"
"                       End of the bcx_xattach:str description.\n"
"\n"
"                       The vncconnect(1) command from standard VNC\n"
"                       distributions may also be used if string is prefixed\n"
"                       with \"cmd=\" E.g. 'vncconnect cmd=stop'.  Under some\n"
"                       circumstances xprop(1) can used if it supports -set\n"
"                       (see the FAQ).\n"
"\n"
"                       If \"-connect /path/to/file\" has been supplied to the\n"
"                       running x11vnc server then that file can be used as a\n"
"                       communication channel (this is the only way to remote\n"
"                       control one of many x11vnc's polling the same X display)\n"
"                       Simply run: 'x11vnc -connect /path/to/file -remote ...'\n"
"                       or you can directly write to the file via something\n"
"                       like: \"echo cmd=stop > /path/to/file\", etc.\n"
"\n"
"-query variable        Like -remote, except just query the value of\n"
"                       \"variable\".  \"-Q\" is an alias for \"-query\".\n"
"                       Multiple queries can be done by separating variables\n"
"                       by commas, e.g. -query var1,var2. The results come\n"
"                       back in the form ans=var1:value1,ans=var2:value2,...\n"
"                       to the standard output.  If a variable is read-only,\n"
"                       it comes back with prefix \"aro=\" instead of \"ans=\".\n"
"\n"
"                       Some -remote commands are pure actions that do not make\n"
"                       sense as variables, e.g. \"stop\" or \"disconnect\", in\n"
"                       these cases the value returned is \"N/A\".  To direct a\n"
"                       query straight to the X11VNC_REMOTE property or connect\n"
"                       file use \"qry=...\" instead of \"cmd=...\"\n"
"\n"
"                       ans= stop quit exit shutdown ping resend_cutbuffer\n"
"                       resend_clipboard resend_primary blacken zero refresh\n"
"                       reset close disconnect id_cmd id sid waitmapped\n"
"                       nowaitmapped clip flashcmap noflashcmap shiftcmap\n"
"                       truecolor notruecolor overlay nooverlay overlay_cursor\n"
"                       overlay_yescursor nooverlay_nocursor nooverlay_cursor\n"
"                       nooverlay_yescursor overlay_nocursor 8to24 no8to24\n"
"                       8to24_opts 24to32 no24to32 visual scale scale_cursor\n"
"                       viewonly noviewonly shared noshared forever noforever\n"
"                       once timeout tightfilexfer notightfilexfer ultrafilexfer\n"
"                       noultrafilexfer rfbversion deny lock nodeny unlock avahi\n"
"                       mdns zeroconf noavahi nomdns nozeroconf connect proxy\n"
"                       allowonce allow noipv6 ipv6 noipv4 ipv4 no6 6 localhost\n"
"                       nolocalhost listen lookup nolookup accept afteraccept\n"
"                       gone shm noshm flipbyteorder noflipbyteorder onetile\n"
"                       noonetile solid_color solid nosolid blackout xinerama\n"
"                       noxinerama xtrap noxtrap xrandr noxrandr xrandr_mode\n"
"                       rotate padgeom quiet q noquiet modtweak nomodtweak xkb\n"
"                       noxkb capslock nocapslock skip_lockkeys noskip_lockkeys\n"
"                       skip_keycodes sloppy_keys nosloppy_keys skip_dups\n"
"                       noskip_dups add_keysyms noadd_keysyms clear_mods\n"
"                       noclear_mods clear_keys noclear_keys clear_all\n"
"                       clear_locks keystate remap repeat norepeat fb nofb bell\n"
"                       nobell sendbell sel nosel primary noprimary setprimary\n"
"                       nosetprimary clipboard noclipboard setclipboard\n"
"                       nosetclipboard seldir cursorshape nocursorshape\n"
"                       cursorpos nocursorpos cursor_drag nocursor_drag cursor\n"
"                       show_cursor noshow_cursor nocursor arrow xfixes noxfixes\n"
"                       xdamage noxdamage xd_area xd_mem alphacut alphafrac\n"
"                       alpharemove noalpharemove alphablend noalphablend\n"
"                       xwarppointer xwarp noxwarppointer noxwarp always_inject\n"
"                       noalways_inject buttonmap dragging nodragging ncache_cr\n"
"                       noncache_cr ncache_no_moveraise noncache_no_moveraise\n"
"                       ncache_no_dtchange noncache_no_dtchange\n"
"                       ncache_no_rootpixmap noncache_no_rootpixmap\n"
"                       ncache_reset_rootpixmap ncrp ncache_keep_anims\n"
"                       noncache_keep_anims ncache_old_wm noncache_old_wm\n"
"                       ncache_pad ncache noncache ncache_size debug_ncache\n"
"                       nodebug_ncache wireframe_mode wireframe wf nowireframe\n"
"                       nowf wireframelocal wfl nowireframelocal nowfl\n"
"                       wirecopyrect wcr nowirecopyrect nowcr scr_area\n"
"                       scr_skip scr_inc scr_keys scr_term scr_keyrepeat\n"
"                       scr_parms scrollcopyrect scr noscrollcopyrect\n"
"                       noscr fixscreen noxrecord xrecord reset_record\n"
"                       pointer_mode pm input_skip allinput noallinput\n"
"                       input_eagerly noinput_eagerly input grabkbd nograbkbd\n"
"                       grabptr nograbptr grabalways nograbalways grablocal\n"
"                       client_input ssltimeout speeds wmdt debug_pointer dp\n"
"                       nodebug_pointer nodp debug_keyboard dk nodebug_keyboard\n"
"                       nodk keycode keysym ptr fakebuttonevent sleep get_xprop\n"
"                       set_xprop wininfo bcx_xattach deferupdate defer\n"
"                       setdefer extra_fbur wait_ui wait_bog nowait_bog\n"
"                       slow_fb xrefresh wait readtimeout nap nonap sb\n"
"                       screen_blank fbpm nofbpm dpms nodpms clientdpms\n"
"                       noclientdpms forcedpms noforcedpms noserverdpms\n"
"                       serverdpms noultraext ultraext chatwindow nochatwindow\n"
"                       chaton chatoff fs gaps grow fuzz snapfb nosnapfb\n"
"                       rawfb uinput_accel uinput_thresh uinput_reset\n"
"                       uinput_always progressive rfbport http nohttp httpport\n"
"                       httpdir enablehttpproxy noenablehttpproxy alwaysshared\n"
"                       noalwaysshared nevershared noalwaysshared dontdisconnect\n"
"                       nodontdisconnect desktop debug_xevents nodebug_xevents\n"
"                       debug_xevents debug_xdamage nodebug_xdamage\n"
"                       debug_xdamage debug_wireframe nodebug_wireframe\n"
"                       debug_wireframe debug_scroll nodebug_scroll debug_scroll\n"
"                       debug_tiles dbt nodebug_tiles nodbt debug_tiles\n"
"                       debug_grabs nodebug_grabs debug_sel nodebug_sel dbg\n"
"                       nodbg macnosaver macsaver nomacnosaver macnowait macwait\n"
"                       nomacnowait macwheel macnoswap macswap nomacnoswap\n"
"                       macnoresize macresize nomacnoresize maciconanim macmenu\n"
"                       macnomenu nomacmenu macuskbd nomacuskbd noremote\n"
"\n"
"                       aro=  noop display vncdisplay icon_mode autoport\n"
"                       loop loopbg desktopname guess_desktop guess_dbus\n"
"                       http_url auth xauth users rootshift clipshift scale_str\n"
"                       scaled_x scaled_y scale_numer scale_denom scale_fac_x\n"
"                       scale_fac_y scaling_blend scaling_nomult4 scaling_pad\n"
"                       scaling_interpolate inetd privremote unsafe safer nocmds\n"
"                       passwdfile unixpw unixpw_nis unixpw_list ssl ssl_pem\n"
"                       sslverify stunnel stunnel_pem https httpsredir usepw\n"
"                       using_shm logfile o flag rmflag rc norc h help V version\n"
"                       lastmod bg sigpipe threads readrate netrate netlatency\n"
"                       pipeinput clients client_count pid ext_xtest ext_xtrap\n"
"                       ext_xrecord ext_xkb ext_xshm ext_xinerama ext_overlay\n"
"                       ext_xfixes ext_xdamage ext_xrandr rootwin num_buttons\n"
"                       button_mask mouse_x mouse_y grab_state pointer_pos\n"
"                       pointer_x pointer_y pointer_same pointer_root\n"
"                       pointer_mask bpp depth indexed_color dpy_x dpy_y wdpy_x\n"
"                       wdpy_y off_x off_y cdpy_x cdpy_y coff_x coff_y rfbauth\n"
"                       passwd viewpasswd\n"
"\n"
"-QD variable           Just like -query variable, but returns the default\n"
"                       value for that parameter (no running x11vnc server\n"
"                       is consulted)\n"
"\n"
"-sync                  By default -remote commands are run asynchronously, that\n"
"                       is, the request is posted and the program immediately\n"
"                       exits.  Use -sync to have the program wait for an\n"
"                       acknowledgement from the x11vnc server that command was\n"
"                       processed (somehow).  On the other hand -query requests\n"
"                       are always processed synchronously because they have\n"
"                       to wait for the answer.\n"
"\n"
"                       Also note that if both -remote and -query requests are\n"
"                       supplied on the command line, the -remote is processed\n"
"                       first (synchronously: no need for -sync), and then\n"
"                       the -query request is processed in the normal way.\n"
"                       This allows for a reliable way to see if the -remote\n"
"                       command was processed by querying for any new settings.\n"
"                       Note however that there is timeout of a few seconds\n"
"                       (see the next paragraph) so if the x11vnc takes longer\n"
"                       than that to process the requests the requester will\n"
"                       think that a failure has taken place.\n"
"\n"
"                       The default is to wait 3.5 seconds.  Or if cmd=stop\n"
"                       only 1.0 seconds.  If cmd matches 'script:' then it\n"
"                       will wait up to 10.0 seconds.  Set X11VNC_SYNC_TIMEOUT\n"
"                       to the number of seconds you want it to wait.\n"
"\n"
"-query_retries str     If a query fails to get a response from an x11vnc\n"
"                       server, retry up to n times.  \"str\" is specified as\n"
"                       n[:t][/match]  Optionally the delay between tries may\n"
"                       be specified by \"t\" a floating point time (default\n"
"                       0.5 seconds.)  Note: the response is not checked for\n"
"                       validity or whether it corresponds to the query sent.\n"
"                       The query \"ping:mystring\" may be used to help uniquely\n"
"                       identify the query.  Optionally, a matching string after\n"
"                       a \"/\" will be used to check the result text.  Up to\n"
"                       n retries will take place until the matching string is\n"
"                       found in the output text.  If the match string is never\n"
"                       found the program's exit code is 1; if the match is\n"
"                       found it exits with 0.  Note that there may be stdout\n"
"                       printed for each retry (i.e. multiple lines printed\n"
"                       out to stdout.)\n"
"                       Example: -query_retries 4:1.5/grab_state\n"
"\n"
"-remote_prefix str     Enable a remote-control communication channel for\n"
"                       connected VNC clients.  str is a non-empty string. If a\n"
"                       VNC client sends rfbCutText having the prefix \"str\"\n"
"                       then the part after it is processed as though it were\n"
"                       sent via 'x11vnc -remote ...'.  If it begins with\n"
"                       neither 'cmd=' nor 'qry=' then 'qry=' is assumed.\n"
"                       Any corresponding output text for that remote control\n"
"                       command is sent back to all client as rfbCutText.\n"
"                       The returned output is also prefixed with \"str\".\n"
"                       Example: -remote_prefix DO_THIS:\n"
"\n"
"                       Note that enabling -remote_prefix allows the remote\n"
"                       VNC viewers to run x11vnc -remote commands.  Do not\n"
"                       use this option if they are not to be trusted.\n"
"\n"
"-noremote              Do not process any remote control commands or queries.\n"
"-yesremote             Do process remote control commands or queries.\n"
"                       Default: %s\n"
"\n"
"                       A note about security wrt remote control commands.\n"
"                       If someone can connect to the X display and change\n"
"                       the property X11VNC_REMOTE, then they can remotely\n"
"                       control x11vnc.  Normally access to the X display is\n"
"                       protected.  Note that if they can modify X11VNC_REMOTE\n"
"                       on the X server, they have enough permissions to also\n"
"                       run their own x11vnc and thus have complete control\n"
"                       of the desktop.  If the  \"-connect /path/to/file\"\n"
"                       channel is being used, obviously anyone who can write\n"
"                       to /path/to/file can remotely control x11vnc.  So be\n"
"                       sure to protect the X display and that file's write\n"
"                       permissions.  See -privremote below.\n"
"\n"
"                       If you are paranoid and do not think -noremote is\n"
"                       enough, to disable the X11VNC_REMOTE property channel\n"
"                       completely use -novncconnect, or use the -safer option\n"
"                       that shuts many things off.\n"
"\n"
"-unsafe                A few remote commands are disabled by default\n"
"                       (currently: id:pick, accept:<cmd>, gone:<cmd>, and\n"
"                       rawfb:setup:<cmd>) because they are associated with\n"
"                       running external programs.  If you specify -unsafe, then\n"
"                       these remote-control commands are allowed.  Note that\n"
"                       you can still specify these parameters on the command\n"
"                       line, they just cannot be invoked via remote-control.\n"
"-safer                 Equivalent to: -novncconnect -noremote and prohibiting\n"
"                       -gui and the -connect file. Shuts off communcation\n"
"                       channels.\n"
"-privremote            Perform some sanity checks and disable remote-control\n"
"                       commands if it appears that the X DISPLAY and/or\n"
"                       connectfile can be accessed by other users.  Once\n"
"                       remote-control is disabled it cannot be turned back on.\n"
"-nocmds                No external commands (e.g. system(3), popen(3), exec(3))\n"
"                       will be run at all.\n"
"-allowedcmds list      \"list\" contains a comma separated list of the only\n"
"                       external commands that can be run.  The full list of\n"
"                       associated options is:\n"
"\n"
"                        stunnel, ssl, unixpw, WAIT, zeroconf, id, accept,\n"
"                        afteraccept, gone, pipeinput, v4l-info, rawfb-setup,\n"
"                        dt, gui, ssh, storepasswd, passwdfile, custom_passwd,\n"
"                        findauth, crash.\n"
"\n"
"                       See each option's help to learn the associated external\n"
"                       command.  Note that the -nocmds option takes precedence\n"
"                       and disables all external commands.\n"
"\n"
"-deny_all              For use with -remote nodeny: start out denying all\n"
"                       incoming clients until \"-remote nodeny\" is used to\n"
"                       let them in.\n"
"\n"
"%s\n"
"\n"
"These options are passed to LibVNCServer:\n"
"\n"
;
	/* have both our help and rfbUsage to stdout for more(1), etc. */
	dup2(1, 2);

	/* register extension(s) to get their help output */
#ifdef LIBVNCSERVER_WITH_TIGHTVNC_FILETRANSFER
	rfbRegisterTightVNCFileTransferExtension();
#endif

	if (mode == 1) {
		char *p;	
		int l = 0;
		fprintf(stderr, "x11vnc: allow VNC connections to real "
		    "X11 displays. %s\n\nx11vnc options:\n", lastmod);
		p = strtok(help, "\n");
		while (p) {
			int w = 23;
			char tmp[100];
			if (p[0] == '-') {
				memset(tmp, 0, sizeof(tmp));
				strncpy(tmp, p, w);
				fprintf(stderr, "  %s", tmp);
				l++;
				if (l % 3 == 0) {
					fprintf(stderr, "\n");
				}
			}
			p = strtok(NULL, "\n");
		}
		fprintf(stderr, "\n\nLibVNCServer options:\n");
		rfbUsage();
		fprintf(stderr, "\n");
		exit(1);
	}
#if 1
	fprintf(stderr, help, lastmod,
		POLL_8TO24_DELAY,
		scaling_copyrect ? ":cr":":nocr",
		view_only ? "on":"off",
		shared ? "on":"off",
		vnc_connect ? "-vncconnect":"-novncconnect",
		xinerama ? "-xinerama":"-noxinerama",
		use_modifier_tweak ? "-modtweak":"-nomodtweak",
		skip_duplicate_key_events ? "-skip_dups":"-noskip_dups",
		add_keysyms ? "-add_keysyms":"-noadd_keysyms",
		no_autorepeat ? "-norepeat":"-repeat",
		alt_arrow_max, alt_arrow,
		alpha_threshold,
		alpha_frac,
		cursor_pos_updates ? "-cursorpos":"-nocursorpos",
		wireframe ? "-wireframe":"-nowireframe",
		WIREFRAME_PARMS,
		wireframe_copyrect_default,
		scroll_copyrect_default,
		scrollcopyrect_min_area,
		scroll_skip_str0 ? scroll_skip_str0 : "(empty)",
		scroll_term_str0,
		max_keyrepeat_str0,
		SCROLL_COPYRECT_PARMS,
		pointer_mode_max, pointer_mode,
		ui_skip,
		defer_update,
		waitms,
		wait_ui,
		take_naps ? "take naps":"no naps",
		screen_blank,
		rfbMaxClientWait/1000,
		watch_fbpm ? "-nofbpm":"-fbpm",
		watch_dpms ? "-nodpms":"-dpms",
		xdamage_max_area, NSCAN, xdamage_memory,
		use_threads ? "-threads":"-nothreads",
		fs_frac,
		gaps_fill,
		grow_fill,
		tile_fuzz,
		accept_remote_cmds ? "-yesremote":"-noremote",
		""
	);
#else
	fprintf(stderr, "%s", help);
#endif

	rfbUsage();
#endif
	exit(1);
}

void xopen_display_fail_message(char *disp) {
	fprintf(stderr, "\n");
	fprintf(stderr, "*** x11vnc was unable to open the X DISPLAY: \"%s\","
	    " it cannot continue.\n", disp);
	fprintf(stderr, "*** There may be \"Xlib:\" error messages above"
	    " with details about the failure.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "Some tips and guidelines:\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "** An X server (the one you wish to view) must"
	    " be running before x11vnc is\n");
	fprintf(stderr, "   started: x11vnc does not start the X server.  "
	    "(however, see the -create\n");
	fprintf(stderr, "   option if that is what you really want).\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "** You must use -display <disp>, -OR- set and"
	    " export your $DISPLAY\n");
	fprintf(stderr, "   environment variable to refer to the display of"
	    " the desired X server.\n");
	fprintf(stderr, " - Usually the display is simply \":0\" (in fact"
	    " x11vnc uses this if you forget\n");
	fprintf(stderr, "   to specify it), but in some multi-user"
	    " situations it could be \":1\", \":2\",\n"); 
	fprintf(stderr, "   or even \":137\".  Ask your administrator"
	    " or a guru if you are having\n");
	fprintf(stderr, "   difficulty determining what your X DISPLAY is.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "** Next, you need to have sufficient permissions"
	    " (Xauthority) \n");
	fprintf(stderr, "   to connect to the X DISPLAY.   Here are some"
	    " Tips:\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " - Often, you just need to run x11vnc as the user"
	    " logged into the X session.\n");
	fprintf(stderr, "   So make sure to be that user when you type"
	    " x11vnc.\n");
	fprintf(stderr, " - Being root is usually not enough because the"
	    " incorrect MIT-MAGIC-COOKIE\n");
	fprintf(stderr, "   file may be accessed.  The cookie file contains"
	    " the secret key that\n");
	fprintf(stderr, "   allows x11vnc to connect to the desired"
	    " X DISPLAY.\n");
	fprintf(stderr, " - You can explicitly indicate which MIT-MAGIC-COOKIE"
	    " file should be used\n");
	fprintf(stderr, "   by the -auth option, e.g.:\n");
	fprintf(stderr, "       x11vnc -auth /home/someuser/.Xauthority"
	    " -display :0\n");
	fprintf(stderr, "       x11vnc -auth /tmp/.gdmzndVlR"
	    " -display :0\n");
	fprintf(stderr, "   you must have read permission for the auth file.\n");
	fprintf(stderr, "   See also '-auth guess' and '-findauth' discussed below.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "** If NO ONE is logged into an X session yet, but"
	    " there is a greeter login\n");
	fprintf(stderr, "   program like \"gdm\", \"kdm\", \"xdm\", or"
	    " \"dtlogin\" running, you will need\n");
	fprintf(stderr, "   to find and use the raw display manager"
	    " MIT-MAGIC-COOKIE file.\n");
	fprintf(stderr, "   Some examples for various display managers:\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "     gdm:     -auth /var/gdm/:0.Xauth\n");
	fprintf(stderr, "              -auth /var/lib/gdm/:0.Xauth\n");
	fprintf(stderr, "     kdm:     -auth /var/lib/kdm/A:0-crWk72\n");
	fprintf(stderr, "              -auth /var/run/xauth/A:0-crWk72\n");
	fprintf(stderr, "     xdm:     -auth /var/lib/xdm/authdir/authfiles/A:0-XQvaJk\n");
	fprintf(stderr, "     dtlogin: -auth /var/dt/A:0-UgaaXa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "   Sometimes the command \"ps wwwwaux | grep auth\""
	    " can reveal the file location.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "   Starting with x11vnc 0.9.9 you can have it try to guess by using:\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "              -auth guess\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "   (see also the x11vnc -findauth option.)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "   Only root will have read permission for the"
	    " file, and so x11vnc must be run\n");
	fprintf(stderr, "   as root (or copy it).  The random characters in the filenames"
	    " will of course\n");
	fprintf(stderr, "   change and the directory the cookie file resides in"
	    " is system dependent.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "See also: http://www.karlrunge.com/x11vnc/faq.html\n");
}

void nopassword_warning_msg(int gotloc) {

	char str1[] =
"###############################################################\n"
"#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#\n"
"#@                                                           @#\n"
"#@  **  WARNING  **  WARNING  **  WARNING  **  WARNING  **   @#\n"
"#@                                                           @#\n"
"#@        YOU ARE RUNNING X11VNC WITHOUT A PASSWORD!!        @#\n"
"#@                                                           @#\n"
"#@  This means anyone with network access to this computer   @#\n"
"#@  may be able to view and control your desktop.            @#\n"
"#@                                                           @#\n"
"#@ >>> If you did not mean to do this Press CTRL-C now!! <<< @#\n"
"#@                                                           @#\n"
"#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#\n"
;
	char str2[] =
"#@                                                           @#\n"
"#@  You can create an x11vnc password file by running:       @#\n"
"#@                                                           @#\n"
"#@       x11vnc -storepasswd password /path/to/passfile      @#\n"
"#@  or   x11vnc -storepasswd /path/to/passfile               @#\n"
"#@  or   x11vnc -storepasswd                                 @#\n"
"#@                                                           @#\n"
"#@  (the last one will use ~/.vnc/passwd)                    @#\n"
"#@                                                           @#\n"
"#@  and then starting x11vnc via:                            @#\n"
"#@                                                           @#\n"
"#@      x11vnc -rfbauth /path/to/passfile                    @#\n"
"#@                                                           @#\n"
"#@  an existing ~/.vnc/passwd file from another VNC          @#\n"
"#@  application will work fine too.                          @#\n"
"#@                                                           @#\n"
"#@  You can also use the -passwdfile or -passwd options.     @#\n"
"#@  (note -passwd is unsafe if local users are not trusted)  @#\n"
"#@                                                           @#\n"
"#@  Make sure any -rfbauth and -passwdfile password files    @#\n"
"#@  cannot be read by untrusted users.                       @#\n"
"#@                                                           @#\n"
"#@  Use x11vnc -usepw to automatically use your              @#\n"
"#@  ~/.vnc/passwd or ~/.vnc/passwdfile password files.       @#\n"
"#@  (and prompt you to create ~/.vnc/passwd if neither       @#\n"
"#@  file exists.)  Under -usepw, x11vnc will exit if it      @#\n"
"#@  cannot find a password to use.                           @#\n"
"#@                                                           @#\n"
"#@                                                           @#\n"
"#@  Even with a password, the subsequent VNC traffic is      @#\n"
"#@  sent in the clear.  Consider tunnelling via ssh(1):      @#\n"
"#@                                                           @#\n"
"#@    http://www.karlrunge.com/x11vnc/#tunnelling            @#\n"
"#@                                                           @#\n"
"#@  Or using the x11vnc SSL options: -ssl and -stunnel       @#\n"
"#@                                                           @#\n"
"#@  Please Read the documention for more info about          @#\n"
"#@  passwords, security, and encryption.                     @#\n"
"#@                                                           @#\n"
"#@    http://www.karlrunge.com/x11vnc/faq.html#faq-passwd    @#\n"
;
	char str3[] =
"#@                                                           @#\n"
"#@  You are using the -localhost option and that is a good   @#\n"
"#@  thing!! Especially if you ssh(1) into this machine and   @#\n"
"#@  use port redirection.  Nevertheless, without a password  @#\n"
"#@  other users could possibly do redirection as well to     @#\n"
"#@  gain access to your desktop.                             @#\n"
;
	char str4[] =
"#@                                                           @#\n"
"#@  To disable this warning use the -nopw option, or put     @#\n"
"#@  'nopw' on a line in your ~/.x11vncrc file.               @#\n"
"#@                                                           @#\n"
"#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#\n"
"###############################################################\n"
;
	char str5[] =
"###############################################################\n\n"
;
	if (inetd) {
		return;
	}

	fprintf(stderr, "%s", str1);
	fflush(stderr);
#if !PASSWD_REQUIRED
	usleep(750 * 1000);
#endif
	if (!quiet) {
		fprintf(stderr, "%s", str2);
		if (gotloc) {
			fprintf(stderr, "%s", str3);
		}
		fprintf(stderr, "%s", str4);
	} else {
		fprintf(stderr, "%s", str5);
	}
	fflush(stderr);
#if !PASSWD_REQUIRED
	usleep(250 * 1000);
#endif
}

void print_license(void) {
	char license[] = 
#if !SKIP_HELP
"		    GNU GENERAL PUBLIC LICENSE\n"
"		       Version 2, June 1991\n"
"\n"
" Copyright (C) 1989, 1991 Free Software Foundation, Inc.\n"
"                          59 Temple Place - Suite 330, Boston, MA\n"
"                          02111-1307, USA.\n"
" Everyone is permitted to copy and distribute verbatim copies\n"
" of this license document, but changing it is not allowed.\n"
"\n"
"			    Preamble\n"
"\n"
"  The licenses for most software are designed to take away your\n"
"freedom to share and change it.  By contrast, the GNU General Public\n"
"License is intended to guarantee your freedom to share and change free\n"
"software--to make sure the software is free for all its users.  This\n"
"General Public License applies to most of the Free Software\n"
"Foundation's software and to any other program whose authors commit to\n"
"using it.  (Some other Free Software Foundation software is covered by\n"
"the GNU Library General Public License instead.)  You can apply it to\n"
"your programs, too.\n"
"\n"
"  When we speak of free software, we are referring to freedom, not\n"
"price.  Our General Public Licenses are designed to make sure that you\n"
"have the freedom to distribute copies of free software (and charge for\n"
"this service if you wish), that you receive source code or can get it\n"
"if you want it, that you can change the software or use pieces of it\n"
"in new free programs; and that you know you can do these things.\n"
"\n"
"  To protect your rights, we need to make restrictions that forbid\n"
"anyone to deny you these rights or to ask you to surrender the rights.\n"
"These restrictions translate to certain responsibilities for you if you\n"
"distribute copies of the software, or if you modify it.\n"
"\n"
"  For example, if you distribute copies of such a program, whether\n"
"gratis or for a fee, you must give the recipients all the rights that\n"
"you have.  You must make sure that they, too, receive or can get the\n"
"source code.  And you must show them these terms so they know their\n"
"rights.\n"
"\n"
"  We protect your rights with two steps: (1) copyright the software, and\n"
"(2) offer you this license which gives you legal permission to copy,\n"
"distribute and/or modify the software.\n"
"\n"
"  Also, for each author's protection and ours, we want to make certain\n"
"that everyone understands that there is no warranty for this free\n"
"software.  If the software is modified by someone else and passed on, we\n"
"want its recipients to know that what they have is not the original, so\n"
"that any problems introduced by others will not reflect on the original\n"
"authors' reputations.\n"
"\n"
"  Finally, any free program is threatened constantly by software\n"
"patents.  We wish to avoid the danger that redistributors of a free\n"
"program will individually obtain patent licenses, in effect making the\n"
"program proprietary.  To prevent this, we have made it clear that any\n"
"patent must be licensed for everyone's free use or not licensed at all.\n"
"\n"
"  The precise terms and conditions for copying, distribution and\n"
"modification follow.\n"
"\n"
"		    GNU GENERAL PUBLIC LICENSE\n"
"   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"
"\n"
"  0. This License applies to any program or other work which contains\n"
"a notice placed by the copyright holder saying it may be distributed\n"
"under the terms of this General Public License.  The \"Program\", below,\n"
"refers to any such program or work, and a \"work based on the Program\"\n"
"means either the Program or any derivative work under copyright law:\n"
"that is to say, a work containing the Program or a portion of it,\n"
"either verbatim or with modifications and/or translated into another\n"
"language.  (Hereinafter, translation is included without limitation in\n"
"the term \"modification\".)  Each licensee is addressed as \"you\".\n"
"\n"
"Activities other than copying, distribution and modification are not\n"
"covered by this License; they are outside its scope.  The act of\n"
"running the Program is not restricted, and the output from the Program\n"
"is covered only if its contents constitute a work based on the\n"
"Program (independent of having been made by running the Program).\n"
"Whether that is true depends on what the Program does.\n"
"\n"
"  1. You may copy and distribute verbatim copies of the Program's\n"
"source code as you receive it, in any medium, provided that you\n"
"conspicuously and appropriately publish on each copy an appropriate\n"
"copyright notice and disclaimer of warranty; keep intact all the\n"
"notices that refer to this License and to the absence of any warranty;\n"
"and give any other recipients of the Program a copy of this License\n"
"along with the Program.\n"
"\n"
"You may charge a fee for the physical act of transferring a copy, and\n"
"you may at your option offer warranty protection in exchange for a fee.\n"
"\n"
"  2. You may modify your copy or copies of the Program or any portion\n"
"of it, thus forming a work based on the Program, and copy and\n"
"distribute such modifications or work under the terms of Section 1\n"
"above, provided that you also meet all of these conditions:\n"
"\n"
"    a) You must cause the modified files to carry prominent notices\n"
"    stating that you changed the files and the date of any change.\n"
"\n"
"    b) You must cause any work that you distribute or publish, that in\n"
"    whole or in part contains or is derived from the Program or any\n"
"    part thereof, to be licensed as a whole at no charge to all third\n"
"    parties under the terms of this License.\n"
"\n"
"    c) If the modified program normally reads commands interactively\n"
"    when run, you must cause it, when started running for such\n"
"    interactive use in the most ordinary way, to print or display an\n"
"    announcement including an appropriate copyright notice and a\n"
"    notice that there is no warranty (or else, saying that you provide\n"
"    a warranty) and that users may redistribute the program under\n"
"    these conditions, and telling the user how to view a copy of this\n"
"    License.  (Exception: if the Program itself is interactive but\n"
"    does not normally print such an announcement, your work based on\n"
"    the Program is not required to print an announcement.)\n"
"\n"
"These requirements apply to the modified work as a whole.  If\n"
"identifiable sections of that work are not derived from the Program,\n"
"and can be reasonably considered independent and separate works in\n"
"themselves, then this License, and its terms, do not apply to those\n"
"sections when you distribute them as separate works.  But when you\n"
"distribute the same sections as part of a whole which is a work based\n"
"on the Program, the distribution of the whole must be on the terms of\n"
"this License, whose permissions for other licensees extend to the\n"
"entire whole, and thus to each and every part regardless of who wrote it.\n"
"\n"
"Thus, it is not the intent of this section to claim rights or contest\n"
"your rights to work written entirely by you; rather, the intent is to\n"
"exercise the right to control the distribution of derivative or\n"
"collective works based on the Program.\n"
"\n"
"In addition, mere aggregation of another work not based on the Program\n"
"with the Program (or with a work based on the Program) on a volume of\n"
"a storage or distribution medium does not bring the other work under\n"
"the scope of this License.\n"
"\n"
"  3. You may copy and distribute the Program (or a work based on it,\n"
"under Section 2) in object code or executable form under the terms of\n"
"Sections 1 and 2 above provided that you also do one of the following:\n"
"\n"
"    a) Accompany it with the complete corresponding machine-readable\n"
"    source code, which must be distributed under the terms of Sections\n"
"    1 and 2 above on a medium customarily used for software interchange; or,\n"
"\n"
"    b) Accompany it with a written offer, valid for at least three\n"
"    years, to give any third party, for a charge no more than your\n"
"    cost of physically performing source distribution, a complete\n"
"    machine-readable copy of the corresponding source code, to be\n"
"    distributed under the terms of Sections 1 and 2 above on a medium\n"
"    customarily used for software interchange; or,\n"
"\n"
"    c) Accompany it with the information you received as to the offer\n"
"    to distribute corresponding source code.  (This alternative is\n"
"    allowed only for noncommercial distribution and only if you\n"
"    received the program in object code or executable form with such\n"
"    an offer, in accord with Subsection b above.)\n"
"\n"
"The source code for a work means the preferred form of the work for\n"
"making modifications to it.  For an executable work, complete source\n"
"code means all the source code for all modules it contains, plus any\n"
"associated interface definition files, plus the scripts used to\n"
"control compilation and installation of the executable.  However, as a\n"
"special exception, the source code distributed need not include\n"
"anything that is normally distributed (in either source or binary\n"
"form) with the major components (compiler, kernel, and so on) of the\n"
"operating system on which the executable runs, unless that component\n"
"itself accompanies the executable.\n"
"\n"
"If distribution of executable or object code is made by offering\n"
"access to copy from a designated place, then offering equivalent\n"
"access to copy the source code from the same place counts as\n"
"distribution of the source code, even though third parties are not\n"
"compelled to copy the source along with the object code.\n"
"\n"
"  4. You may not copy, modify, sublicense, or distribute the Program\n"
"except as expressly provided under this License.  Any attempt\n"
"otherwise to copy, modify, sublicense or distribute the Program is\n"
"void, and will automatically terminate your rights under this License.\n"
"However, parties who have received copies, or rights, from you under\n"
"this License will not have their licenses terminated so long as such\n"
"parties remain in full compliance.\n"
"\n"
"  5. You are not required to accept this License, since you have not\n"
"signed it.  However, nothing else grants you permission to modify or\n"
"distribute the Program or its derivative works.  These actions are\n"
"prohibited by law if you do not accept this License.  Therefore, by\n"
"modifying or distributing the Program (or any work based on the\n"
"Program), you indicate your acceptance of this License to do so, and\n"
"all its terms and conditions for copying, distributing or modifying\n"
"the Program or works based on it.\n"
"\n"
"  6. Each time you redistribute the Program (or any work based on the\n"
"Program), the recipient automatically receives a license from the\n"
"original licensor to copy, distribute or modify the Program subject to\n"
"these terms and conditions.  You may not impose any further\n"
"restrictions on the recipients' exercise of the rights granted herein.\n"
"You are not responsible for enforcing compliance by third parties to\n"
"this License.\n"
"\n"
"  7. If, as a consequence of a court judgment or allegation of patent\n"
"infringement or for any other reason (not limited to patent issues),\n"
"conditions are imposed on you (whether by court order, agreement or\n"
"otherwise) that contradict the conditions of this License, they do not\n"
"excuse you from the conditions of this License.  If you cannot\n"
"distribute so as to satisfy simultaneously your obligations under this\n"
"License and any other pertinent obligations, then as a consequence you\n"
"may not distribute the Program at all.  For example, if a patent\n"
"license would not permit royalty-free redistribution of the Program by\n"
"all those who receive copies directly or indirectly through you, then\n"
"the only way you could satisfy both it and this License would be to\n"
"refrain entirely from distribution of the Program.\n"
"\n"
"If any portion of this section is held invalid or unenforceable under\n"
"any particular circumstance, the balance of the section is intended to\n"
"apply and the section as a whole is intended to apply in other\n"
"circumstances.\n"
"\n"
"It is not the purpose of this section to induce you to infringe any\n"
"patents or other property right claims or to contest validity of any\n"
"such claims; this section has the sole purpose of protecting the\n"
"integrity of the free software distribution system, which is\n"
"implemented by public license practices.  Many people have made\n"
"generous contributions to the wide range of software distributed\n"
"through that system in reliance on consistent application of that\n"
"system; it is up to the author/donor to decide if he or she is willing\n"
"to distribute software through any other system and a licensee cannot\n"
"impose that choice.\n"
"\n"
"This section is intended to make thoroughly clear what is believed to\n"
"be a consequence of the rest of this License.\n"
"\n"
"  8. If the distribution and/or use of the Program is restricted in\n"
"certain countries either by patents or by copyrighted interfaces, the\n"
"original copyright holder who places the Program under this License\n"
"may add an explicit geographical distribution limitation excluding\n"
"those countries, so that distribution is permitted only in or among\n"
"countries not thus excluded.  In such case, this License incorporates\n"
"the limitation as if written in the body of this License.\n"
"\n"
"  9. The Free Software Foundation may publish revised and/or new versions\n"
"of the General Public License from time to time.  Such new versions will\n"
"be similar in spirit to the present version, but may differ in detail to\n"
"address new problems or concerns.\n"
"\n"
"Each version is given a distinguishing version number.  If the Program\n"
"specifies a version number of this License which applies to it and \"any\n"
"later version\", you have the option of following the terms and conditions\n"
"either of that version or of any later version published by the Free\n"
"Software Foundation.  If the Program does not specify a version number of\n"
"this License, you may choose any version ever published by the Free Software\n"
"Foundation.\n"
"\n"
"  10. If you wish to incorporate parts of the Program into other free\n"
"programs whose distribution conditions are different, write to the author\n"
"to ask for permission.  For software which is copyrighted by the Free\n"
"Software Foundation, write to the Free Software Foundation; we sometimes\n"
"make exceptions for this.  Our decision will be guided by the two goals\n"
"of preserving the free status of all derivatives of our free software and\n"
"of promoting the sharing and reuse of software generally.\n"
"\n"
#endif
"			    NO WARRANTY\n"
"\n"
"  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\n"
"FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN\n"
"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\n"
"PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\n"
"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"
"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS\n"
"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE\n"
"PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\n"
"REPAIR OR CORRECTION.\n"
"\n"
"  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\n"
"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\n"
"REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\n"
"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\n"
"OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\n"
"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\n"
"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\n"
"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\n"
"POSSIBILITY OF SUCH DAMAGES.\n"
"\n"
#if !SKIP_HELP
"		     END OF TERMS AND CONDITIONS\n"
"\n"
"	Appendix: How to Apply These Terms to Your New Programs\n"
"\n"
"  If you develop a new program, and you want it to be of the greatest\n"
"possible use to the public, the best way to achieve this is to make it\n"
"free software which everyone can redistribute and change under these terms.\n"
"\n"
"  To do so, attach the following notices to the program.  It is safest\n"
"to attach them to the start of each source file to most effectively\n"
"convey the exclusion of warranty; and each file should have at least\n"
"the \"copyright\" line and a pointer to where the full notice is found.\n"
"\n"
"    <one line to give the program's name and a brief idea of what it does.>\n"
"    Copyright (C) 19yy  <name of author>\n"
"\n"
"    This program is free software; you can redistribute it and/or modify\n"
"    it under the terms of the GNU General Public License as published by\n"
"    the Free Software Foundation; either version 2 of the License, or\n"
"    (at your option) any later version.\n"
"\n"
"    This program is distributed in the hope that it will be useful,\n"
"    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"    GNU General Public License for more details.\n"
"\n"
"    You should have received a copy of the GNU General Public License\n"
"    along with this program; if not, write to the Free Software\n"
"    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n"
"\n"
"Also add information on how to contact you by electronic and paper mail.\n"
"\n"
"If the program is interactive, make it output a short notice like this\n"
"when it starts in an interactive mode:\n"
"\n"
"    Gnomovision version 69, Copyright (C) 19yy name of author\n"
"    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.\n"
"    This is free software, and you are welcome to redistribute it\n"
"    under certain conditions; type `show c' for details.\n"
"\n"
"The hypothetical commands `show w' and `show c' should show the appropriate\n"
"parts of the General Public License.  Of course, the commands you use may\n"
"be called something other than `show w' and `show c'; they could even be\n"
"mouse-clicks or menu items--whatever suits your program.\n"
"\n"
"You should also get your employer (if you work as a programmer) or your\n"
"school, if any, to sign a \"copyright disclaimer\" for the program, if\n"
"necessary.  Here is a sample; alter the names:\n"
"\n"
"  Yoyodyne, Inc., hereby disclaims all copyright interest in the program\n"
"  `Gnomovision' (which makes passes at compilers) written by James Hacker.\n"
"\n"
"  <signature of Ty Coon>, 1 April 1989\n"
"  Ty Coon, President of Vice\n"
"\n"
"This General Public License does not permit incorporating your program into\n"
"proprietary programs.  If your program is a subroutine library, you may\n"
"consider it more useful to permit linking proprietary applications with the\n"
"library.  If this is what you want to do, use the GNU Library General\n"
"Public License instead of this License.\n"
#endif
;

	char top[] =
"\n"
"x11vnc: a VNC server for X displays.  %s\n"
"\n"
"Copyright (C) 2002-2010 Karl J. Runge <runge@karlrunge.com>\n"
"All rights reserved.\n"
"\n"
;
	dup2(1, 2);
	fprintf(stderr, top, lastmod);
	fprintf(stderr, "%s", license);
	exit(1);
}

